/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.undo;

import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class TranslatePetriNetObjectEditCommand
implements Command {
    final PetriNetObject pnObject;
    final Integer transX;
    final Integer transY;
    final DrawingSurfaceImpl ds;

    public TranslatePetriNetObjectEditCommand(PetriNetObject _pnObject, Integer _transX, Integer _transY, DrawingSurfaceImpl drawingSurface) {
        this.pnObject = _pnObject;
        this.transX = Zoomer.getUnzoomedValue(_transX, this.pnObject.getZoom());
        this.transY = Zoomer.getUnzoomedValue(_transY, this.pnObject.getZoom());
        this.ds = drawingSurface;
    }

    @Override
    public void undo() {
        this.pnObject.translate(Zoomer.getZoomedValue(-this.transX.intValue(), this.pnObject.getZoom()), Zoomer.getZoomedValue(-this.transY.intValue(), this.pnObject.getZoom()));
        this.ds.updatePreferredSize();
    }

    @Override
    public void redo() {
        this.pnObject.translate(Zoomer.getZoomedValue(this.transX, this.pnObject.getZoom()), Zoomer.getZoomedValue(this.transY, this.pnObject.getZoom()));
        this.ds.updatePreferredSize();
    }

    public String toString() {
        return super.toString() + " " + this.pnObject.getName() + " (" + this.transX + "," + this.transY + ")";
    }
}

