/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.handler;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.tapaal.gui.petrinet.undo.UpdateNameLabelOffsetCommand;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.NameLabel;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;

public class LabelHandler
extends MouseInputAdapter
implements MouseWheelListener {
    private final PetriNetObjectWithLabel obj;
    private final NameLabel nl;
    protected Point dragInit = new Point();
    private int originalOffsetX;
    private int originalOffsetY;

    public LabelHandler(NameLabel _nl, PetriNetObjectWithLabel _obj) {
        this.obj = _obj;
        this.nl = _nl;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.obj.dispatchEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.obj instanceof Arc) {
            if (((Arc)this.obj).isPrototype()) {
                return;
            }
            if (TAPAALGUI.getAppGui().isEditionAllowed() && e.getClickCount() == 2) {
                Arc arc = (Arc)this.obj;
                ((TimedOutputArcComponent)arc).showTimeIntervalEditor();
            }
        }
        this.dragInit = e.getPoint();
        this.dragInit = SwingUtilities.convertPoint(this.nl, this.dragInit, this.obj);
        this.originalOffsetX = this.obj.getNameOffsetX();
        this.originalOffsetY = this.obj.getNameOffsetY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Point p = SwingUtilities.convertPoint(this.nl, e.getPoint(), this.obj);
        this.obj.translateNameOffsetX(p.x - this.dragInit.x);
        this.obj.translateNameOffsetY(p.y - this.dragInit.y);
        this.dragInit = p;
        this.obj.updateOnMoveOrZoom();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.originalOffsetX != this.obj.getNameOffsetX() && this.originalOffsetY != this.obj.getNameOffsetY()) {
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(new UpdateNameLabelOffsetCommand(this.obj.getNameOffsetX(), this.obj.getNameOffsetY(), this.originalOffsetX, this.originalOffsetY, this.obj));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.obj.dispatchEvent(e);
    }
}

