/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.tapn.ConstantProbability;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.event.TimedTransitionEvent;
import dk.aau.cs.model.tapn.event.TimedTransitionListener;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.editor.TAPNTransitionEditor;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.swingcomponents.EscapableDialog;

public class TimedTransitionComponent
extends Transition {
    private TimedTransition transition;
    private final TimedTransitionListener listener;
    private GeneralPath dashedOutline;
    Window dIntervalWindow = null;

    public TimedTransitionComponent(int positionXInput, int positionYInput, TimedTransition transition, TAPNLens lens) {
        super(positionXInput, positionYInput);
        this.transition = transition;
        this.listener = this.timedTransitionListener();
        transition.addTimedTransitionListener(this.listener);
        this.lens = lens;
    }

    public TimedTransitionComponent(int positionXInput, int positionYInput, String idInput, int nameOffsetXInput, int nameOffsetYInput, int angleInput, TAPNLens lens) {
        super(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput, angleInput);
        this.listener = this.timedTransitionListener();
        this.attributesVisible = true;
        this.lens = lens;
    }

    private TimedTransitionListener timedTransitionListener() {
        return new TimedTransitionListener(){

            @Override
            public void nameChanged(TimedTransitionEvent e) {
                TimedTransition source = e.source();
                TimedTransitionComponent.super.setName(source.name());
            }

            @Override
            public void sharedStateChanged(TimedTransitionEvent e) {
                TimedTransitionComponent.this.repaint();
            }
        };
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        JPopupMenu popup = super.getPopup(e);
        popup.add(new JPopupMenu.Separator());
        if (this.lens.isTimed()) {
            JCheckBoxMenuItem urgentAction = new JCheckBoxMenuItem();
            urgentAction.setSelected(this.isUrgent());
            urgentAction.setAction(new AbstractAction("Urgent"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TAPAALGUI.getCurrentTab().guiModelManager.toggleUrgentTrans();
                }
            });
            popup.add(urgentAction);
        }
        if (this.lens.isGame()) {
            JCheckBoxMenuItem uncontrollableAction = new JCheckBoxMenuItem();
            uncontrollableAction.setSelected(this.isUncontrollable());
            uncontrollableAction.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TAPAALGUI.getCurrentTab().guiModelManager.toggleUncontrollableTrans();
                }
            });
        }
        return popup;
    }

    @Override
    public void showEditor() {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Transition", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        contentPane.add(new TAPNTransitionEditor(guiDialog, this, new Context(TAPAALGUI.getCurrentTab())));
        guiDialog.setResizable(true);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
    }

    @Override
    public boolean isTransitionEnabled() {
        return this.transition.isEnabled();
    }

    @Override
    public boolean isDelayEnabled() {
        return this.transition.isDEnabled();
    }

    @Override
    public TimeInterval getDInterval() {
        return this.transition.getdInterval();
    }

    public TimedTransition underlyingTransition() {
        return this.transition;
    }

    public void setUnderlyingTransition(TimedTransition transition) {
        if (this.transition != null && this.listener != null) {
            transition.removeListener(this.listener);
        }
        transition.addTimedTransitionListener(this.listener);
        this.transition = transition;
        this.setName(transition.name());
        this.repaint();
    }

    @Override
    public void setName(String nameInput) {
        this.transition.setName(nameInput);
        super.setName(nameInput);
    }

    public GuardExpression getGuardExpression() {
        return this.transition.getGuard();
    }

    public void setGuardExpression(GuardExpression expression) {
        this.transition.setGuard(expression);
    }

    @Override
    public String getName() {
        return this.transition != null ? this.transition.name() : "";
    }

    public boolean isUrgent() {
        return this.transition.isUrgent();
    }

    public void setUrgent(boolean value) {
        this.transition.setUrgent(value);
    }

    public boolean isUncontrollable() {
        return this.transition.isUncontrollable();
    }

    public void setUncontrollable(boolean isUncontrollable) {
        this.transition.setUncontrollable(isUncontrollable);
    }

    public boolean hasUntimedPreset() {
        return this.transition.hasUntimedPreset();
    }

    @Override
    public void update(boolean displayConstantNames) {
        super.update(displayConstantNames);
        if (this.transition != null) {
            this.getNameLabel().setName(this.transition.name());
            this.getNameLabel().setVisible(this.attributesVisible);
            this.getNameLabel().zoomUpdate(this.getZoom());
            if (this.lens.isStochastic()) {
                this.getNameLabel().setText("\n" + this.underlyingTransition().getDistribution().summary() + (String)(this.underlyingTransition().getWeight() instanceof ConstantProbability || this.underlyingTransition().getWeight().value() != 1.0 ? "\nW=" + this.underlyingTransition().getWeight().toString() : "") + (String)(this.underlyingTransition().getFiringMode() instanceof RandomFiringMode ? "" : "\nM=" + this.underlyingTransition().getFiringMode().toString()));
            }
            if (this.underlyingTransition().getGuard() != null && this.lens.isColored()) {
                this.pnName.setText(this.pnName.getText() + "\n" + this.buildGuardString(this.underlyingTransition().getGuard().toString()));
            }
        }
        this.repaint();
    }

    private String buildGuardString(String str) {
        String[] strArray = str.split(" ");
        int counter = 0;
        StringBuilder builder = new StringBuilder();
        int maxAndOr = 5;
        for (String subStr : strArray) {
            if (subStr.equals("and") || subStr.equals("or")) {
                ++counter;
            }
            if (counter >= maxAndOr) {
                builder.append("\n");
                counter = 0;
            }
            builder.append(subStr + " ");
        }
        return builder.toString();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.transition.isShared()) {
            Graphics2D graphics = (Graphics2D)g;
            Stroke oldStroke = graphics.getStroke();
            BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
            graphics.setStroke(dashed);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.draw(this.dashedOutline);
            graphics.setStroke(oldStroke);
        }
        if (!this.isUncontrollable()) {
            super.fillTransition(g);
        }
        if (this.isUrgent()) {
            g.setColor(this.isUncontrollable() ? Color.BLACK : Color.WHITE);
            g.fillOval(11, 11, 8, 8);
        }
    }

    @Override
    protected void constructTransition() {
        super.constructTransition();
        double x = (this.componentWidth - 10.0 - 8.0) / 2.0;
        double y = -4.0;
        double width = 18.0;
        double height = 38.0;
        this.dashedOutline = new GeneralPath(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public Command rotate(int angleInc) {
        this.dashedOutline.transform(AffineTransform.getRotateInstance(Math.toRadians(angleInc), this.componentWidth / 2.0, this.componentHeight / 2.0));
        return super.rotate(angleInc);
    }

    public TimedTransitionComponent copy(TimedArcPetriNet tapn) {
        TimedTransitionComponent transitionComponent = new TimedTransitionComponent(this.getOriginalX(), this.getOriginalY(), this.id, this.getNameOffsetX(), this.getNameOffsetY(), this.getAngle(), this.lens);
        transitionComponent.setUnderlyingTransition(tapn.getTransitionByName(this.transition.name()));
        transitionComponent.setUncontrollable(this.isUncontrollable());
        return transitionComponent;
    }

    public void showDInterval(boolean show) {
        if (this.dIntervalWindow != null) {
            this.dIntervalWindow.dispose();
        }
        if (show && this.transition.getdInterval() != null && this.isTimed()) {
            this.dIntervalWindow = new Window(new Frame());
            this.dIntervalWindow.add(new JTextArea(this.transition.getdInterval().toString()));
            this.dIntervalWindow.getComponent(0).setBackground(Color.lightGray);
            this.dIntervalWindow.pack();
            this.dIntervalWindow.setLocationRelativeTo(this);
            this.dIntervalWindow.setLocation(this.dIntervalWindow.getLocation().x, this.dIntervalWindow.getLocation().y - 20);
            this.dIntervalWindow.setVisible(show);
        }
    }
}

