/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.Weight;
import java.awt.geom.Ellipse2D;
import java.util.Hashtable;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.undo.ArcTimeIntervalEditCommand;

public class TimedInhibitorArcComponent
extends TimedInputArcComponent {
    private TimedInhibitorArc inhibitorArc;

    public TimedInhibitorArcComponent(TimedOutputArcComponent arc) {
        super(arc);
    }

    @Deprecated
    public TimedInhibitorArcComponent(TimedOutputArcComponent arc, String guard) {
        this(arc);
    }

    public TimedInhibitorArcComponent(PlaceTransitionObject source) {
        super(source);
    }

    public TimedInhibitorArcComponent(TimedPlaceComponent source, TimedTransitionComponent target, TimedInhibitorArc modelArc) {
        super(source);
        this.setTarget(target);
        this.setUnderlyingArc(modelArc);
        this.updateLabel(true);
        this.sealArc();
    }

    public void setUnderlyingArc(TimedInhibitorArc arc) {
        this.inhibitorArc = arc;
        this.updateLabel(true);
    }

    public TimedInhibitorArc underlyingTimedInhibitorArc() {
        return this.inhibitorArc;
    }

    @Override
    protected void setHead() {
        this.setHead(new Ellipse2D.Double(-4.0, -8.0, 8.0, 8.0), false);
    }

    @Override
    public void updateLabel(boolean displayConstantNames) {
        this.getNameLabel().setText("");
        if (this.getWeight().value() > 1 || displayConstantNames) {
            this.getNameLabel().setText(this.getWeight().toString(displayConstantNames));
        }
        boolean focusedConstant = false;
        if (this.getWeight() instanceof ConstantWeight) {
            if (((ConstantWeight)this.getWeight()).constant().hasFocus()) {
                focusedConstant = true;
            }
            this.pnName.setVisible(((ConstantWeight)this.getWeight()).constant().getVisible());
        }
        if (focusedConstant) {
            this.getNameLabel().setForeground(Constants.SELECTION_TEXT_COLOUR);
        } else {
            this.getNameLabel().setForeground(Constants.ELEMENT_TEXT_COLOUR);
        }
        this.setLabelPosition();
    }

    @Override
    public Command setGuardAndWeight(TimeInterval guard, Weight weight) {
        TimeInterval oldTimeInterval = this.inhibitorArc.interval();
        this.inhibitorArc.setTimeInterval(guard);
        Weight oldWeight = this.getWeight();
        this.setWeight(weight);
        this.updateLabel(true);
        this.repaint();
        return new ArcTimeIntervalEditCommand(this, oldTimeInterval, this.inhibitorArc.interval(), oldWeight, weight);
    }

    @Override
    public TimeInterval getGuard() {
        return this.inhibitorArc.interval();
    }

    @Override
    public TimedInhibitorArcComponent copy(TimedArcPetriNet tapn, Hashtable<PlaceTransitionObject, PlaceTransitionObject> oldToNewMapping) {
        TimedInhibitorArcComponent arc = new TimedInhibitorArcComponent(this);
        arc.setSource(oldToNewMapping.get(this.getSource()));
        arc.setTarget(oldToNewMapping.get(this.getTarget()));
        arc.setUnderlyingArc(tapn.getInhibitorArcFromPlaceAndTransition(tapn.getPlaceByName(this.inhibitorArc.source().name()), tapn.getTransitionByName(this.inhibitorArc.destination().name())));
        return arc;
    }

    @Override
    public ArcExpression getExpression() {
        if (this.inhibitorArc == null) {
            return null;
        }
        return this.inhibitorArc.getArcExpression();
    }

    @Override
    public void setWeight(Weight weight) {
        this.inhibitorArc.setWeight(weight);
    }

    @Override
    public Weight getWeight() {
        if (this.inhibitorArc == null) {
            return new IntWeight(1);
        }
        return this.inhibitorArc.getWeight();
    }

    @Override
    public void setExpression(ArcExpression expr) {
        this.inhibitorArc.setExpression(expr);
    }
}

