/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import dk.aau.cs.model.tapn.TimeInterval;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.action.ShowHideInfoAction;
import pipe.gui.petrinet.animation.Animator;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.undo.TransitionRotationEditCommand;

public abstract class Transition
extends PlaceTransitionObject {
    private GeneralPath transition;
    private Shape proximityTransition;
    protected static final int TRANSITION_HEIGHT = 30;
    protected static final int TRANSITION_WIDTH = 10;
    protected int angle;
    protected boolean highlightedDelayEnabled = false;
    protected boolean highlightedEnabled = false;
    private Timer blinkTimer;
    private int blinkCount;
    private static final double rootThreeOverTwo = 0.5 * Math.sqrt(3.0);
    private final ArrayList<ArcAngleCompare> arcAngleList = new ArrayList();

    public Transition(int positionXInput, int positionYInput, String idInput, int nameOffsetXInput, int nameOffsetYInput, int angleInput) {
        super(30.0, 30.0, positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput);
        this.constructTransition();
        this.angle = 0;
        this.rotate(angleInput);
        this.updateBounds();
    }

    public Transition(int positionXInput, int positionYInput) {
        this(positionXInput, positionYInput, null, 0, 0, 0);
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        int index = 0;
        JPopupMenu popup = super.getPopup(e);
        JMenuItem menuItem = new JMenuItem("Edit Transition");
        menuItem.addActionListener(o -> this.showEditor());
        popup.insert(menuItem, index++);
        menuItem = new JMenuItem(new ShowHideInfoAction(this));
        if (this.getAttributesVisible()) {
            menuItem.setText("Hide Transition Name");
        } else {
            menuItem.setText("Show Transition Name");
        }
        popup.insert(menuItem, index++);
        popup.insert(new JPopupMenu.Separator(), index);
        return popup;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(2.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.selected) {
            g2.setColor(Constants.SELECTION_FILL_COLOUR);
        } else {
            g2.setColor(Constants.ELEMENT_FILL_COLOUR);
        }
        g2.fill(this.transition);
        if (this.highlightedEnabled) {
            g2.setPaint(Constants.ENABLED_TRANSITION_COLOUR);
        } else if (this.highlightedDelayEnabled && TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions() && !Animator.isUrgentTransitionEnabled()) {
            g2.setPaint(Constants.YELLOW_TRANSITION_COLOR);
        } else if (this.selected) {
            g2.setPaint(Constants.SELECTION_LINE_COLOUR);
        } else {
            g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
        }
        g2.draw(this.transition);
    }

    public Command rotate(int angleInc) {
        this.angle = (this.angle + angleInc) % 360;
        this.transition.transform(AffineTransform.getRotateInstance(Math.toRadians(angleInc), this.componentWidth / 2.0, this.componentHeight / 2.0));
        this.outlineTransition();
        for (ArcAngleCompare arcAngleCompare : this.arcAngleList) {
            arcAngleCompare.calcAngle();
        }
        Collections.sort(this.arcAngleList);
        this.updateEndPoints();
        this.repaint();
        return new TransitionRotationEditCommand(this, this.angle);
    }

    private void outlineTransition() {
        this.proximityTransition = new BasicStroke(25.0f).createStrokedShape(this.transition);
    }

    public void markTransitionEnabled(boolean b) {
        this.highlightedEnabled = b;
    }

    public void markTransitionDelayEnabled(boolean b) {
        this.highlightedDelayEnabled = b;
    }

    public abstract boolean isTransitionEnabled();

    public abstract boolean isDelayEnabled();

    public abstract TimeInterval getDInterval();

    public void disableHightlight() {
        this.highlightedEnabled = false;
        this.highlightedDelayEnabled = false;
    }

    public int getAngle() {
        return this.angle;
    }

    protected void constructTransition() {
        this.transition = new GeneralPath();
        this.transition.append(new Rectangle2D.Double((this.componentWidth - 10.0) / 2.0, 0.0, 10.0, 30.0), false);
        this.outlineTransition();
    }

    @Override
    public boolean contains(int x, int y) {
        int zoomPercentage = this.getZoom();
        double unZoomedX = (double)(x - 5) / ((double)zoomPercentage / 100.0);
        double unZoomedY = (double)(y - 5) / ((double)zoomPercentage / 100.0);
        if (TAPAALGUI.useExtendedBounds) {
            return this.proximityTransition.contains((int)unZoomedX, (int)unZoomedY) || this.transition.contains((int)unZoomedX, (int)unZoomedY);
        }
        return this.transition.contains((int)unZoomedX, (int)unZoomedY);
    }

    public void removeArcCompareObject(Arc a) {
        this.arcAngleList.removeIf(arcAngleCompare -> arcAngleCompare.arc == a);
    }

    @Override
    public void updateEndPoint(Arc arc) {
        boolean match = false;
        Iterator<ArcAngleCompare> arcIterator = this.arcAngleList.iterator();
        while (arcIterator.hasNext()) {
            ArcAngleCompare thisArc = arcIterator.next();
            if (thisArc.arc.getTarget() != this && thisArc.arc.getSource() != this || thisArc.arc.isPrototype) {
                arcIterator.remove();
                continue;
            }
            if (thisArc.arc != arc) continue;
            thisArc.calcAngle();
            match = true;
        }
        if (!match) {
            this.arcAngleList.add(new ArcAngleCompare(arc, this));
        }
        Collections.sort(this.arcAngleList);
        this.updateEndPoints();
    }

    public void updateEndPoints() {
        ArcAngleCompare thisArc;
        ArrayList<ArcAngleCompare> top = new ArrayList<ArcAngleCompare>();
        ArrayList<ArcAngleCompare> bottom = new ArrayList<ArcAngleCompare>();
        ArrayList<ArcAngleCompare> left = new ArrayList<ArcAngleCompare>();
        ArrayList<ArcAngleCompare> right = new ArrayList<ArcAngleCompare>();
        for (ArcAngleCompare thisArc2 : this.arcAngleList) {
            double thisAngle = thisArc2.angle - Math.toRadians(this.angle);
            if (Math.cos(thisAngle) > rootThreeOverTwo) {
                top.add(thisArc2);
                thisArc2.arc.setPathToTransitionAngle(this.angle + 90);
                continue;
            }
            if (Math.cos(thisAngle) < -rootThreeOverTwo) {
                bottom.add(thisArc2);
                thisArc2.arc.setPathToTransitionAngle(this.angle + 270);
                continue;
            }
            if (Math.sin(thisAngle) > 0.0) {
                left.add(thisArc2);
                thisArc2.arc.setPathToTransitionAngle(this.angle + 180);
                continue;
            }
            right.add(thisArc2);
            thisArc2.arc.setPathToTransitionAngle(this.angle);
        }
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians((double)this.angle + Math.PI));
        Point2D.Double transformed = new Point2D.Double();
        transform.concatenate(Zoomer.getTransform(this.getZoom()));
        Iterator<ArcAngleCompare> arcIterator = top.iterator();
        transform.transform(new Point2D.Double(1.0, 15.0), transformed);
        while (arcIterator.hasNext()) {
            thisArc = arcIterator.next();
            if (thisArc.sourceOrTarget()) {
                thisArc.arc.setTargetLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
                continue;
            }
            thisArc.arc.setSourceLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
        }
        arcIterator = bottom.iterator();
        transform.transform(new Point2D.Double(-1.0, -15.0), transformed);
        while (arcIterator.hasNext()) {
            thisArc = arcIterator.next();
            if (thisArc.sourceOrTarget()) {
                thisArc.arc.setTargetLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
                continue;
            }
            thisArc.arc.setSourceLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
        }
        arcIterator = left.iterator();
        double inc = 30 / (left.size() + 1);
        double current = 15.0 - inc;
        while (arcIterator.hasNext()) {
            ArcAngleCompare thisArc3 = arcIterator.next();
            transform.transform(new Point2D.Double(-5.0, current + 1.0), transformed);
            if (thisArc3.sourceOrTarget()) {
                thisArc3.arc.setTargetLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
            } else {
                thisArc3.arc.setSourceLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
            }
            current -= inc;
        }
        inc = 30 / (right.size() + 1);
        current = -15.0 + inc;
        for (ArcAngleCompare thisArc3 : right) {
            transform.transform(new Point2D.Double(5.0, current), transformed);
            if (thisArc3.sourceOrTarget()) {
                thisArc3.arc.setTargetLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
            } else {
                thisArc3.arc.setSourceLocation((double)(this.positionX + this.centreOffsetLeft()) + transformed.x, (double)(this.positionY + this.centreOffsetTop()) + transformed.y);
            }
            current += inc;
        }
    }

    private String getText() {
        return "";
    }

    @Override
    public void update(boolean displayConstantNames) {
        this.getNameLabel().setText(this.getText());
        super.update(displayConstantNames);
        this.repaint();
    }

    public void blink() {
        if (this.blinkTimer == null) {
            this.initBlinkTimer();
        }
        this.blinkCount = 0;
        this.blinkTimer.start();
    }

    private void initBlinkTimer() {
        this.blinkTimer = new Timer(150, evt -> {
            if (this.blinkCount <= 2) {
                this.setVisible(!this.isVisible());
                ++this.blinkCount;
            } else {
                this.setVisible(true);
                this.blinkTimer.stop();
            }
        });
    }

    public void fillTransition(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(this.transition);
    }

    class ArcAngleCompare
    implements Comparable<ArcAngleCompare> {
        private static final boolean SOURCE = false;
        private static final boolean TARGET = true;
        private final Arc arc;
        private final Transition transition;
        private double angle;

        public ArcAngleCompare(Arc _arc, Transition _transition) {
            this.arc = _arc;
            this.transition = _transition;
            this.calcAngle();
        }

        @Override
        public int compareTo(ArcAngleCompare arg0) {
            return Double.compare(this.angle, arg0.angle);
        }

        private void calcAngle() {
            int index = this.sourceOrTarget() ? this.arc.getArcPath().getEndIndex() - 1 : 1;
            Point2D.Double p1 = new Point2D.Double(Transition.this.positionX + Transition.this.centreOffsetLeft(), Transition.this.positionY + Transition.this.centreOffsetTop());
            Point2D.Double p2 = new Point2D.Double(this.arc.getArcPath().getPoint((int)index).x, this.arc.getArcPath().getPoint((int)index).y);
            this.angle = Math.atan2(p1.x - p2.x, p2.y - p1.y);
            if (this.angle < Math.toRadians(30 + this.transition.getAngle())) {
                this.angle += Math.PI * 2;
            }
        }

        private boolean sourceOrTarget() {
            return this.arc.getSource() != this.transition;
        }
    }
}

