/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import net.tapaal.TAPAAL;
import pipe.gui.Constants;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;

public abstract class PlaceTransitionObject
extends PetriNetObjectWithLabel {
    protected final double componentWidth;
    protected final double componentHeight;
    private final LinkedList<Arc> connectTo = new LinkedList();
    private final LinkedList<Arc> connectFrom = new LinkedList();
    protected boolean attributesVisible = true;

    public PlaceTransitionObject(double componentWidth, double componentHeight, int positionXInput, int positionYInput, String idInput, int nameOffsetXInput, int nameOffsetYInput) {
        super(idInput, positionXInput, positionYInput, nameOffsetXInput, nameOffsetYInput);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        JPopupMenu popup = super.getPopup(e);
        if (TAPAAL.IS_DEV) {
            JTextArea pane = new JTextArea();
            pane.setEditable(false);
            Object preset = "";
            for (Arc arc : this.getPreset()) {
                preset = (String)preset + "    " + arc.getId() + "\n";
            }
            Object postset = "";
            for (Arc arc : this.getPostset()) {
                postset = (String)postset + "    " + arc.getId() + "\n";
            }
            pane.setText("(Debug) \n  preset: \n" + (String)preset + "  postset: \n" + (String)postset);
            popup.insert(pane, 1);
        }
        return popup;
    }

    @Override
    public void setName(String nameInput) {
        this.getNameLabel().setName(nameInput);
    }

    @Override
    public void setId(String idInput) {
        this.id = idInput;
        this.setName(this.id);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getNameLabel() != null ? this.getNameLabel().getName() : "";
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(5, 5);
        g2.transform(Zoomer.getTransform(this.getZoom()));
    }

    public int centreOffsetTop() {
        return Zoomer.getZoomedValue(this.componentHeight / 2.0, this.getZoom());
    }

    public int centreOffsetLeft() {
        return Zoomer.getZoomedValue(this.componentWidth / 2.0, this.getZoom());
    }

    public void updateBounds() {
        double scaleFactor = Zoomer.getScaleFactor(this.getZoom());
        this.positionX = (int)Math.round((double)this.originalX * scaleFactor);
        this.positionY = (int)Math.round((double)this.originalY * scaleFactor);
        int width = (int)Math.round(this.componentWidth * scaleFactor);
        int height = (int)Math.round(this.componentHeight * scaleFactor);
        Rectangle bounds = new Rectangle(this.positionX, this.positionY, width, height);
        bounds.grow(5, 5);
        this.setBounds(bounds);
    }

    public void addConnectTo(Arc newArc) {
        this.connectTo.add(newArc);
    }

    public void addConnectFrom(Arc newArc) {
        this.connectFrom.add(newArc);
    }

    public void removeFromArc(Arc oldArc) {
        this.connectFrom.remove(oldArc);
    }

    public void removeToArc(Arc oldArc) {
        this.connectTo.remove(oldArc);
    }

    public void updateConnected() {
        for (Arc someArc : this.connectFrom) {
            this.updateEndPoint(someArc);
            someArc.updateArcPosition();
        }
        for (Arc someArc : this.connectTo) {
            this.updateEndPoint(someArc);
            someArc.updateArcPosition();
        }
    }

    @Override
    public void translate(int x, int y) {
        this.setPositionX(this.positionX + x);
        this.setPositionY(this.positionY + y);
        this.updateOnMoveOrZoom();
    }

    public void setCenter(int x, int y) {
        this.setPositionX((int)Math.round((double)x - this.componentWidth / 2.0));
        this.setPositionY((int)Math.round((double)y - this.componentHeight / 2.0));
        this.updateOnMoveOrZoom();
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double((double)this.positionX + this.componentWidth / 2.0, (double)this.positionY + this.componentHeight / 2.0);
    }

    public void update(boolean displayConstantNames) {
        this.update(displayConstantNames, true);
    }

    public void update(boolean displayConstantNames, boolean alignToGrid) {
        this.updateOnMoveOrZoom(alignToGrid);
    }

    @Override
    public void select() {
        if (this.selectable && !this.selected) {
            this.selected = true;
            if (this.getNameLabel() != null) {
                this.getNameLabel().setForeground(Constants.SELECTION_LINE_COLOUR);
            }
            for (Arc arc : this.getPostset()) {
                if (!arc.getTarget().isSelected()) continue;
                arc.select();
            }
            for (Arc arc : this.getPreset()) {
                if (!arc.getSource().isSelected()) continue;
                arc.select();
            }
            this.repaint();
        }
    }

    @Override
    public void addedToGui() {
        this.setDeleted(false);
        super.addedToGui();
        this.update(true);
        this.updateOnMoveOrZoom();
    }

    @Override
    public void updateOnMoveOrZoom() {
        this.updateOnMoveOrZoom(true);
    }

    public void updateOnMoveOrZoom(boolean alignToGrid) {
        this.updateBounds();
        this.updateConnected();
        this.updateLabelLocation(alignToGrid);
    }

    public boolean areNotSameType(PlaceTransitionObject o) {
        return this.getClass() != o.getClass();
    }

    public Iterable<Arc> getPreset() {
        return this.connectTo;
    }

    public Iterable<Arc> getPostset() {
        return this.connectFrom;
    }

    public abstract void updateEndPoint(Arc var1);

    public abstract void showEditor();

    public void setAttributesVisible(boolean flag) {
        this.attributesVisible = flag;
    }

    public boolean getAttributesVisible() {
        return this.attributesVisible;
    }

    @Override
    public int getLayerOffset() {
        return 30;
    }

    public void toggleAttributesVisible() {
        this.attributesVisible = !this.attributesVisible;
        this.update(true);
    }

    @Override
    public void zoomUpdate(int value) {
        super.zoomUpdate(value);
        this.update(true, false);
    }
}

