/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import net.tapaal.TAPAAL;
import net.tapaal.gui.petrinet.TAPNLens;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Drawable;
import pipe.gui.petrinet.graphicElements.GraphicalElement;

public abstract class PetriNetObject
extends GraphicalElement
implements Drawable {
    protected static final int COMPONENT_DRAW_OFFSET = 5;
    protected int positionX;
    protected int positionY;
    protected TAPNLens lens = TAPNLens.Default;
    protected int originalX;
    protected int originalY;
    protected String id = null;
    protected boolean selected = false;
    protected boolean selectable = true;
    protected boolean draggable = true;
    private boolean deleted = false;
    private int zoom = 100;
    private DataLayer guiModel;

    PetriNetObject(String idInput, int positionXInput, int positionYInput) {
        this.id = idInput;
        this.setOriginalX(positionXInput);
        this.setOriginalY(positionYInput);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PetriNetObject.this.requestFocusInWindow();
            }
        });
    }

    public JPopupMenu getPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(TAPAALGUI.getAppGui().deleteAction);
        menuItem.setText("Delete");
        popup.add(menuItem);
        if (TAPAAL.IS_DEV) {
            JTextArea pane = new JTextArea();
            pane.setEditable(false);
            pane.setText("(Debug) \n  org X:" + this.getOriginalX() + " Y:" + this.getOriginalY() + "\n  pos X:" + this.getPositionX() + " Y:" + this.getPositionY());
            popup.insert(pane, 1);
        }
        return popup;
    }

    public void setGuiModel(DataLayer guiModel) {
        this.guiModel = guiModel;
    }

    public DataLayer getGuiModel() {
        return this.guiModel;
    }

    public void setId(String idInput) {
        this.id = idInput;
        this.setName(idInput);
    }

    public void updateOnMoveOrZoom() {
    }

    public String getId() {
        return this.getName();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void select() {
        this.select(true);
    }

    public void select(boolean shouldRepaint) {
        if (this.selectable && !this.selected) {
            this.selected = true;
            if (shouldRepaint) {
                this.repaint();
            }
        }
    }

    public void deselect() {
        if (this.selected) {
            this.selected = false;
            this.repaint();
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean allow) {
        this.selectable = allow;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean allow) {
        this.draggable = allow;
    }

    @Override
    public abstract void addedToGui();

    @Override
    public abstract void removedFromGui();

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void select(Rectangle selectionRectangle) {
        if (selectionRectangle.intersects(this.getBounds())) {
            this.select();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public abstract int getLayerOffset();

    public int getZoom() {
        return this.zoom;
    }

    @Override
    public DrawingSurfaceImpl getParent() {
        return (DrawingSurfaceImpl)super.getParent();
    }

    public int getOriginalX() {
        return this.originalX;
    }

    public int getOriginalY() {
        return this.originalY;
    }

    @Override
    public void zoomUpdate(int zoom) {
        this.zoom = zoom;
        this.updateOnMoveOrZoom();
    }

    @Override
    public void translate(int x, int y) {
    }

    public void setOriginalX(int positionXInput) {
        this.originalX = Grid.align(positionXInput, 100);
        this.positionX = Zoomer.getZoomedValue(this.originalX, this.getZoom());
    }

    public void setPositionX(int positionXInput) {
        this.setOriginalX(Zoomer.getUnzoomedValue(positionXInput, this.getZoom()));
    }

    public void setOriginalY(int positionYInput) {
        this.originalY = Grid.align(positionYInput, 100);
        this.positionY = Zoomer.getZoomedValue(this.originalY, this.getZoom());
    }

    public void setPositionY(int positionYInput) {
        this.setOriginalY(Zoomer.getUnzoomedValue(positionYInput, this.getZoom()));
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public boolean isTimed() {
        return this.lens.isTimed();
    }

    public boolean isStochastic() {
        return this.lens.isStochastic();
    }

    public void setLens(TAPNLens lens) {
        this.lens = lens;
    }

    public boolean isColored() {
        return this.lens.isColored();
    }

    @Override
    public GraphicalElement getGraphicalElement() {
        return this;
    }
}

