/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Cursor;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import pipe.gui.Constants;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.graphicElements.Zoomable;

public class NameLabel
extends JTextArea
implements Zoomable {
    private int positionX;
    private int positionY;
    private String name = "";
    private String text = "";
    private final Font font = new Font("Dialog", 1, 10);

    public NameLabel() {
        this("");
    }

    public NameLabel(String nameInput) {
        super(nameInput);
        this.name = nameInput;
        this.setFont(this.font);
        this.setCursor(new Cursor(1));
        this.setEditable(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(Constants.BACKGROUND_COLOR);
        DefaultCaret c = new DefaultCaret();
        c.setUpdatePolicy(1);
        this.setCaret(c);
    }

    public void setPosition(int x, int y) {
        this.positionX = x;
        this.positionY = y;
        this.updatePosition();
    }

    private void updateSize() {
        this.setSize((int)((double)this.getPreferredSize().width * 1.2), (int)((double)this.getPreferredSize().height * 1.2));
        this.updatePosition();
    }

    public void updatePosition() {
        this.setLocation(this.positionX - this.getPreferredSize().width, this.positionY - 12);
    }

    public double getYPosition() {
        return this.positionY;
    }

    public double getXPosition() {
        return this.positionX;
    }

    @Override
    public void setName(String nameInput) {
        this.name = nameInput;
        this.setText(this.text);
        this.updateSize();
    }

    @Override
    public void setText(String s) {
        this.text = s;
        if (this.name != null) {
            super.setText(this.name + s);
        } else {
            super.setText(s);
        }
        this.updateSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void zoomUpdate(int value) {
        this.setFont(this.getFont().deriveFont((float)Zoomer.getZoomedValue(10, value)));
        this.updateSize();
    }

    public void displayName(boolean display) {
        if (display && this.name != null && this.text != null) {
            super.setText(this.name + this.text);
        } else if (!display && this.text != null) {
            super.setText(this.text);
        }
    }

    public int getLayerOffset() {
        return 15;
    }
}

