/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import net.tapaal.swinghelpers.DispatchEventsToParentHandler;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.action.EditAnnotationBackgroundAction;
import pipe.gui.petrinet.action.EditAnnotationBorderAction;
import pipe.gui.petrinet.action.EditNoteAction;
import pipe.gui.petrinet.editor.AnnotationPanel;
import pipe.gui.petrinet.graphicElements.Note;
import pipe.gui.petrinet.undo.AnnotationResizeCommand;
import pipe.gui.petrinet.undo.AnnotationTextEditCommand;
import pipe.gui.swingcomponents.EscapableDialog;

public class AnnotationNote
extends Note {
    private boolean fillNote = true;
    private final EnumMap<dragPoint, ResizePoint> dragPoints = new EnumMap(dragPoint.class);
    private AffineTransform prova = new AffineTransform();

    public AnnotationNote(int x, int y) {
        super(x, y);
        this.setDragPoints();
        this.getNote().addMouseListener(new DispatchEventsToParentHandler());
        this.getNote().addMouseMotionListener(new DispatchEventsToParentHandler());
    }

    public AnnotationNote(String text, int x, int y, int w, int h, boolean border) {
        super(text, x, y, w, h, border);
        this.setDragPoints();
        this.getNote().addMouseListener(new DispatchEventsToParentHandler());
        this.getNote().addMouseMotionListener(new DispatchEventsToParentHandler());
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        int popupIndex = 0;
        JPopupMenu popup = super.getPopup(e);
        JMenuItem menuItem = new JMenuItem(new EditNoteAction(this));
        menuItem.setText("Edit text");
        popup.insert(menuItem, popupIndex++);
        menuItem = new JMenuItem(new EditAnnotationBorderAction(this));
        if (this.isShowingBorder()) {
            menuItem.setText("Disable Border");
        } else {
            menuItem.setText("Enable Border");
        }
        popup.insert(menuItem, popupIndex++);
        menuItem = new JMenuItem(new EditAnnotationBackgroundAction(this));
        if (this.isFilled()) {
            menuItem.setText("Transparent");
        } else {
            menuItem.setText("Solid Background");
        }
        popup.insert(new JPopupMenu.Separator(), popupIndex++);
        popup.insert(menuItem, popupIndex);
        return popup;
    }

    private void setDragPoints() {
        this.dragPoints.put(dragPoint.TOP_LEFT, new ResizePoint(this, 5));
        this.dragPoints.put(dragPoint.TOP_MIDDLE, new ResizePoint(this, 1));
        this.dragPoints.put(dragPoint.TOP_RIGHT, new ResizePoint(this, 9));
        this.dragPoints.put(dragPoint.MIDDLE_RIGHT, new ResizePoint(this, 8));
        this.dragPoints.put(dragPoint.BOTTOM_RIGHT, new ResizePoint(this, 10));
        this.dragPoints.put(dragPoint.BOTTOM_MIDDLE, new ResizePoint(this, 2));
        this.dragPoints.put(dragPoint.BOTTOM_LEFT, new ResizePoint(this, 6));
        this.dragPoints.put(dragPoint.MIDDLE_LEFT, new ResizePoint(this, 4));
        for (ResizePoint p : this.dragPoints.values()) {
            ResizePointHandler handler = new ResizePointHandler(p);
            p.addMouseListener(handler);
            p.addMouseMotionListener(handler);
            this.add(p);
        }
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        if (this.dragPoints != null) {
            this.dragPoints.get((Object)dragPoint.TOP_LEFT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMinX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMinY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.TOP_MIDDLE).setLocation(Zoomer.getZoomedValue(this.noteRect.getCenterX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMinY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.TOP_RIGHT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMaxX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMinY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.MIDDLE_RIGHT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMaxX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getCenterY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.BOTTOM_RIGHT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMaxX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMaxY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.BOTTOM_MIDDLE).setLocation(Zoomer.getZoomedValue(this.noteRect.getCenterX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMaxY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.BOTTOM_LEFT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMinX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getMaxY(), this.getZoom()));
            this.dragPoints.get((Object)dragPoint.MIDDLE_LEFT).setLocation(Zoomer.getZoomedValue(this.noteRect.getMinX(), this.getZoom()), Zoomer.getZoomedValue(this.noteRect.getCenterY(), this.getZoom()));
        }
    }

    @Override
    public boolean contains(int x, int y) {
        boolean pointContains = false;
        for (ResizePoint p : this.dragPoints.values()) {
            pointContains |= p.contains(x - p.getX(), y - p.getY());
        }
        return super.contains(x, y) || pointContains;
    }

    @Override
    public void enableEditMode() {
        this.enableEditMode(false);
    }

    public boolean enableEditMode(boolean isFirstEdit) {
        String oldText = this.note.getText();
        JDialog.setDefaultLookAndFeelDecorated(true);
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Annotation", true);
        guiDialog.add(new AnnotationPanel(this));
        guiDialog.setMinimumSize(new Dimension(300, 200));
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setResizable(true);
        guiDialog.setVisible(true);
        guiDialog.dispose();
        String newText = this.note.getText();
        if (!isFirstEdit && !newText.equals(oldText)) {
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(new AnnotationTextEditCommand(this, oldText, newText));
            this.updateBounds();
            return true;
        }
        return isFirstEdit && !newText.isBlank();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.prova = g2.getTransform();
        g2.setStroke(new BasicStroke(1.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.transform(Zoomer.getTransform(this.getZoom()));
        if (this.selected) {
            g2.setPaint(Constants.SELECTION_FILL_COLOUR);
            g2.fill(this.noteRect);
            if (this.drawBorder) {
                g2.setPaint(Constants.SELECTION_LINE_COLOUR);
                g2.draw(this.noteRect);
            }
        } else {
            g2.setPaint(Constants.ELEMENT_FILL_COLOUR);
            if (this.fillNote) {
                g2.fill(this.noteRect);
            }
            if (this.drawBorder) {
                g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
                g2.draw(this.noteRect);
            }
        }
        this.dragPoints.forEach((dragPoint2, resizePoint) -> resizePoint.myPaintComponent(g));
        g2.transform(Zoomer.getTransform(this.getZoom()));
    }

    @Override
    public int getLayerOffset() {
        return 10;
    }

    public boolean isFilled() {
        return this.fillNote;
    }

    public void changeBackground() {
        this.fillNote = !this.fillNote;
        this.note.setOpaque(this.fillNote);
    }

    @Override
    public void zoomUpdate(int percent) {
        super.zoomUpdate(percent);
        for (ResizePoint p : this.dragPoints.values()) {
            p.setZoom();
        }
    }

    public AnnotationNote copy() {
        return new AnnotationNote(this.note.getText(), this.getOriginalX(), this.getOriginalY(), this.note.getWidth(), this.note.getHeight(), this.isShowingBorder());
    }

    static enum dragPoint {
        TOP_LEFT,
        TOP_MIDDLE,
        TOP_RIGHT,
        MIDDLE_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_MIDDLE,
        BOTTOM_LEFT,
        MIDDLE_LEFT;

    }

    public class ResizePoint
    extends JComponent {
        private int SIZE = 3;
        private static final int TOP = 1;
        private static final int BOTTOM = 2;
        private static final int LEFT = 4;
        private static final int RIGHT = 8;
        private Rectangle shape;
        private boolean isPressed = false;
        private final Note myNote;
        public final int typeMask;

        public ResizePoint(Note obj, int type) {
            this.myNote = obj;
            this.setOpaque(false);
            this.setBounds(-this.SIZE - 1, -this.SIZE - 1, 2 * this.SIZE + 4 + 1, 2 * this.SIZE + 4 + 1);
            this.typeMask = type;
        }

        public Note getNote() {
            return this.myNote;
        }

        @Override
        public void setLocation(int x, int y) {
            super.setLocation(x - this.SIZE, y - this.SIZE);
        }

        private void drag(int x, int y) {
            if ((this.typeMask & 1) == 1) {
                this.myNote.adjustTop(Zoomer.getUnzoomedValue(y, AnnotationNote.this.getZoom()));
            }
            if ((this.typeMask & 2) == 2) {
                this.myNote.adjustBottom(Zoomer.getUnzoomedValue(y, AnnotationNote.this.getZoom()));
            }
            if ((this.typeMask & 4) == 4) {
                this.myNote.adjustLeft(Zoomer.getUnzoomedValue(x, AnnotationNote.this.getZoom()));
            }
            if ((this.typeMask & 8) == 8) {
                this.myNote.adjustRight(Zoomer.getUnzoomedValue(x, AnnotationNote.this.getZoom()));
            }
            TAPAALGUI.getCurrentTab().setNetChanged(true);
        }

        public void myPaintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setTransform(AnnotationNote.this.prova);
            if (this.myNote.selected) {
                g2.translate(this.getLocation().x, this.getLocation().y);
                this.shape = new Rectangle(0, 0, 2 * this.SIZE, 2 * this.SIZE);
                g2.fill(this.shape);
                g2.setStroke(new BasicStroke(1.0f));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.isPressed) {
                    g2.setPaint(Constants.RESIZE_POINT_DOWN_COLOUR);
                } else {
                    g2.setPaint(Constants.ELEMENT_FILL_COLOUR);
                }
                g2.fill(this.shape);
                g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
                g2.draw(this.shape);
                g2.setTransform(AnnotationNote.this.prova);
            }
        }

        private void setZoom() {
            this.SIZE = AnnotationNote.this.getZoom() >= 220 ? 5 : (AnnotationNote.this.getZoom() >= 120 ? 4 : (AnnotationNote.this.getZoom() >= 60 ? 3 : 2));
        }
    }

    private class ResizePointHandler
    extends MouseInputAdapter {
        private final ResizePoint myPoint;
        private Point start;
        private Point noteStartPoint;
        private Dimension noteStartSize;

        public ResizePointHandler(ResizePoint point) {
            this.myPoint = point;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TAPAALGUI.getCurrentTab().isInAnimationMode()) {
                return;
            }
            this.myPoint.myNote.setDraggable(false);
            this.myPoint.isPressed = true;
            this.myPoint.repaint();
            this.start = e.getPoint();
            this.noteStartPoint = this.myPoint.myNote.getLocation();
            this.noteStartSize = this.myPoint.myNote.getNote().getSize();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TAPAALGUI.getCurrentTab().isInAnimationMode()) {
                return;
            }
            this.myPoint.drag(Grid.align(e.getX() - this.start.x, AnnotationNote.this.getZoom()), Grid.align(e.getY() - this.start.y, AnnotationNote.this.getZoom()));
            this.myPoint.myNote.updateBounds();
            this.myPoint.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TAPAALGUI.getCurrentTab().isInAnimationMode()) {
                return;
            }
            this.myPoint.myNote.setDraggable(true);
            this.myPoint.isPressed = false;
            AnnotationResizeCommand command = new AnnotationResizeCommand(this.myPoint, this.noteStartPoint, this.noteStartSize);
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(command);
            command.redo();
        }
    }
}

