/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.editor;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantProbability;
import dk.aau.cs.model.tapn.DoubleProbability;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.OldestFiringMode;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import dk.aau.cs.model.tapn.simulation.YoungestFiringMode;
import dk.aau.cs.util.RequireException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.ColoredTransitionGuardPanel;
import net.tapaal.gui.petrinet.editor.DistributionPanel;
import net.tapaal.gui.petrinet.undo.ChangeAllNamesVisibilityCommand;
import net.tapaal.gui.petrinet.undo.ChangeFiringModeCommand;
import net.tapaal.gui.petrinet.undo.ChangeProbabilityWeightCommand;
import net.tapaal.gui.petrinet.undo.ChangeTransitionDistributionCommand;
import net.tapaal.gui.petrinet.undo.MakeTransitionNewSharedCommand;
import net.tapaal.gui.petrinet.undo.MakeTransitionNewSharedMultiCommand;
import net.tapaal.gui.petrinet.undo.MakeTransitionSharedCommand;
import net.tapaal.gui.petrinet.undo.RenameTimedTransitionCommand;
import net.tapaal.gui.petrinet.undo.ToggleTransitionUncontrollableCommand;
import net.tapaal.gui.petrinet.undo.ToggleTransitionUrgentCommand;
import net.tapaal.gui.petrinet.undo.UnshareTransitionCommand;
import net.tapaal.swinghelpers.GridBagHelper;
import net.tapaal.swinghelpers.SwingHelper;
import net.tapaal.swinghelpers.WidthAdjustingComboBox;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.swingcomponents.EscapableDialog;

public class TAPNTransitionEditor
extends JPanel {
    private static final String untimed_preset_warning = "Incoming arcs to urgent transitions must have the interval [0,\u221e).";
    private static final String transport_destination_invariant_warning = "Transport arcs going through urgent transitions cannot have an invariant at the destination.";
    private final TimedTransitionComponent transition;
    private final EscapableDialog dialog;
    private final JRootPane rootPane;
    private final Context context;
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private boolean doOKChecked = false;
    private final int maxNumberOfTransitionsToShowAtOnce = 20;
    boolean doNewEdit = true;
    CaretListener caretListener = evt -> {
        JTextField textField = (JTextField)evt.getSource();
        textField.setBackground(new Color(255, 255, 255));
    };
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton okButton;
    private JButton makeSharedButton;
    private JComboBox<String> rotationComboBox;
    private JLabel rotationLabel;
    private JPanel transitionEditorPanel;
    private JCheckBox sharedCheckBox;
    private JComboBox<SharedTransition> sharedTransitionsComboBox;
    private JCheckBox urgentCheckBox;
    private Vector<SharedTransition> sharedTransitions;
    private JTextField weightField;
    private JCheckBox infiniteWeight;
    private JCheckBox useConstantWeight;
    private JComboBox<String> constantsComboBox;
    private JComboBox<FiringMode> firingModeComboBox;
    private DistributionPanel distributionPanel;
    private JCheckBox uncontrollableCheckBox;
    private boolean makeNewShared = false;
    private JCheckBox attributesCheckBox;
    private ColoredTransitionGuardPanel coloredTransitionGuardPanel;

    public TAPNTransitionEditor(EscapableDialog _dialog, TimedTransitionComponent _transition, Context context) {
        this.dialog = _dialog;
        this.rootPane = _dialog.getRootPane();
        this.transition = _transition;
        this.context = context;
        this.initComponents();
        this.hideIrrelevantInformation();
        this.rootPane.setDefaultButton(this.okButton);
    }

    private void hideIrrelevantInformation() {
        if (!this.transition.isTimed()) {
            this.urgentCheckBox.setVisible(false);
        }
        if (!this.transition.isColored() || !this.coloredTransitionGuardPanel.showGuardPanel()) {
            this.coloredTransitionGuardPanel.setVisible(false);
        }
        this.distributionPanel.setVisible(this.transition.isStochastic());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.transitionEditorPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        SwingHelper.setPreferredWidth(this.nameTextField, 290);
        this.rotationLabel = new JLabel();
        this.rotationComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.makeSharedButton = new JButton();
        this.okButton = new JButton();
        this.sharedCheckBox = new JCheckBox("Shared");
        this.urgentCheckBox = new JCheckBox("Urgent");
        this.uncontrollableCheckBox = new JCheckBox("Uncontrollable");
        this.attributesCheckBox = new JCheckBox("Show transition name");
        this.weightField = new JTextField();
        this.infiniteWeight = new JCheckBox("\u221e");
        this.useConstantWeight = new JCheckBox("Use constant");
        ArrayList<String> constants = new ArrayList<String>();
        for (Constant c : this.context.network().constants()) {
            constants.add(c.name());
        }
        this.constantsComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(constants.toArray(new String[0])));
        this.useConstantWeight.setEnabled(!constants.isEmpty());
        this.useConstantWeight.addActionListener(act -> this.displayWeight(this.parseWeight()));
        this.firingModeComboBox = new JComboBox<FiringMode>(new FiringMode[]{new OldestFiringMode(), new YoungestFiringMode(), new RandomFiringMode()});
        this.firingModeComboBox.setToolTipText("Determines what tokens are consumed during random runs");
        this.distributionPanel = new DistributionPanel(this.transition, this.dialog);
        this.sharedTransitionsComboBox = new WidthAdjustingComboBox<SharedTransition>(20);
        SwingHelper.setPreferredWidth(this.sharedTransitionsComboBox, 290);
        this.sharedTransitionsComboBox.addActionListener(e -> {
            if (((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).transitions().isEmpty()) {
                ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setUrgent(this.urgentCheckBox.isSelected());
                ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setUncontrollable(this.uncontrollableCheckBox.isSelected());
                ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setGuard(this.coloredTransitionGuardPanel.getExpression());
                ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setDistribution(this.distributionPanel.parseDistribution());
                ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setWeight(this.parseWeight());
            } else {
                this.urgentCheckBox.setSelected(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).isUrgent());
                this.uncontrollableCheckBox.setSelected(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).isUncontrollable());
                this.coloredTransitionGuardPanel.initExpr(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getGuard());
                this.distributionPanel.displayDistributionFields(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getDistribution());
                this.displayWeight(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getWeight());
            }
        });
        this.transitionEditorPanel.setLayout(new GridBagLayout());
        this.transitionEditorPanel.setBorder(BorderFactory.createTitledBorder("Transition Editor"));
        this.sharedCheckBox.addActionListener(arg0 -> {
            JCheckBox box = (JCheckBox)arg0.getSource();
            if (box.isSelected()) {
                this.switchToNameDropDown();
                this.makeSharedButton.setEnabled(false);
            } else {
                this.switchToNameTextField();
                this.nameTextField.setText(this.transition.underlyingTransition().isShared() ? this.context.nameGenerator().getNewTransitionName(this.context.activeModel()) : this.transition.getName());
                this.makeSharedButton.setEnabled(true);
            }
        });
        GridBagConstraints gridBagConstraints = GridBagHelper.as(2, 1, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.transitionEditorPanel.add((Component)this.sharedCheckBox, gridBagConstraints);
        this.makeSharedButton = new JButton();
        this.makeSharedButton.setText("Make shared");
        this.makeSharedButton.setMaximumSize(new Dimension(110, 25));
        this.makeSharedButton.setMinimumSize(new Dimension(110, 25));
        this.makeSharedButton.setPreferredSize(new Dimension(110, 25));
        this.makeSharedButton.addActionListener(evt -> {
            this.makeNewShared = true;
            this.makeSharedButton.setEnabled(false);
            if (this.okButtonHandler(evt)) {
                this.sharedCheckBox.setEnabled(true);
                this.sharedCheckBox.setSelected(true);
                this.setupInitialState();
            } else {
                this.makeSharedButton.setEnabled(true);
                this.doOKChecked = false;
            }
        });
        gridBagConstraints = GridBagHelper.as(3, 1, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        this.transitionEditorPanel.add((Component)this.makeSharedButton, gridBagConstraints);
        this.nameLabel.setText("Name:");
        gridBagConstraints = GridBagHelper.as(0, 1, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
        this.transitionEditorPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TAPNTransitionEditor.this.nameTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TAPNTransitionEditor.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = GridBagHelper.as(2, 2, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.transitionEditorPanel.add((Component)this.urgentCheckBox, gridBagConstraints);
        if (this.transition.isStochastic()) {
            this.urgentCheckBox.setToolTipText("Note: for SMC, it is recommended to prefer setting a constant(0) distribution instead of using urgent transitions");
        }
        this.urgentCheckBox.addActionListener(e -> {
            if (!this.isUrgencyOK()) {
                this.urgentCheckBox.setSelected(false);
            }
            this.distributionPanel.setUrgent(this.urgentCheckBox.isSelected());
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        if (this.context.tabContent().getLens().isGame()) {
            this.transitionEditorPanel.add((Component)this.uncontrollableCheckBox, gridBagConstraints);
            this.uncontrollableCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JCheckBox box = (JCheckBox)arg0.getSource();
                    TAPNTransitionEditor.this.uncontrollableCheckBox.setSelected(box.isSelected());
                }
            });
        }
        this.rotationLabel.setText("Rotate:");
        gridBagConstraints = GridBagHelper.as(0, 2, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
        this.transitionEditorPanel.add((Component)this.rotationLabel, gridBagConstraints);
        JPanel comboBoxAndCheckBoxPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        comboBoxAndCheckBoxPanel.add(this.rotationComboBox, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        comboBoxAndCheckBoxPanel.add((Component)this.attributesCheckBox, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(1, 2, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.transitionEditorPanel.add((Component)comboBoxAndCheckBoxPanel, gridBagConstraints);
        if (this.context.tabContent().getLens().isStochastic()) {
            String weightToolTip = "Probability mass of the transition in the event of a firing date collision";
            JLabel weightLabel = new JLabel("Weight:");
            weightLabel.setToolTipText(weightToolTip);
            this.weightField.setToolTipText(weightToolTip);
            this.infiniteWeight.setToolTipText("Selecting weight as an infinity gives an absolute priority of the transition firing in case of several transitions scheduled at the same time");
            this.infiniteWeight.addActionListener(act -> this.weightField.setEnabled(!this.infiniteWeight.isSelected()));
            String firingModeTooltip = "The firing mode of the transition";
            JLabel firingModeLabel = new JLabel("Firing mode:");
            firingModeLabel.setToolTipText(firingModeTooltip);
            gridBagConstraints = GridBagHelper.as(0, 0, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
            JPanel firingModePanel = new JPanel(new GridBagLayout());
            gridBagConstraints = GridBagHelper.as(0, 0, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
            firingModePanel.add((Component)firingModeLabel, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.5;
            firingModePanel.add(this.firingModeComboBox, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(2, 0, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            firingModePanel.add((Component)weightLabel, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(3, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 0));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            firingModePanel.add((Component)this.weightField, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(4, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 0));
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            firingModePanel.add(this.constantsComboBox, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(5, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            firingModePanel.add((Component)this.infiniteWeight, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(6, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            firingModePanel.add((Component)this.useConstantWeight, gridBagConstraints);
            gridBagConstraints = GridBagHelper.as(0, 4, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
            gridBagConstraints.gridwidth = 10;
            this.distributionPanel.add((Component)firingModePanel, gridBagConstraints);
        }
        gridBagConstraints = GridBagHelper.as(0, 3, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        gridBagConstraints.gridwidth = 4;
        this.transitionEditorPanel.add((Component)this.distributionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.transitionEditorPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.addActionListener(evt -> {
            if (this.okButtonHandler(evt)) {
                this.exit();
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.addActionListener(this::cancelButtonHandler);
        gridBagConstraints = GridBagHelper.as(0, 1, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(1, 1, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(0, 3, GridBagHelper.Anchor.EAST, new Insets(5, 0, 8, 3));
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(0, 1, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.coloredTransitionGuardPanel = new ColoredTransitionGuardPanel(this.transition, this.context, this);
        this.mainPanel.add((Component)this.coloredTransitionGuardPanel, gridBagConstraints);
        this.setupInitialState();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.mainPanel);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
    }

    private void setupInitialState() {
        this.sharedTransitions = new Vector<SharedTransition>(this.context.network().sharedTransitions());
        ArrayList<SharedTransition> usedTransitions = new ArrayList<SharedTransition>();
        for (TimedTransition tt : this.context.activeModel().transitions()) {
            if (!tt.isShared()) continue;
            usedTransitions.add(tt.sharedTransition());
        }
        this.sharedTransitions.removeAll(usedTransitions);
        if (this.transition.underlyingTransition().isShared()) {
            this.sharedTransitions.add(this.transition.underlyingTransition().sharedTransition());
        }
        this.sharedTransitions.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        this.rotationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0\u00b0", "+45\u00b0", "+90\u00b0", "-45\u00b0"}));
        this.nameTextField.setText(this.transition.getName());
        this.sharedTransitionsComboBox.setModel(new DefaultComboBoxModel<SharedTransition>(this.sharedTransitions));
        this.sharedCheckBox.setEnabled(this.sharedTransitions.size() > 0 && !this.hasArcsToSharedPlaces(this.transition.underlyingTransition()));
        this.urgentCheckBox.setSelected(this.transition.isUrgent());
        this.uncontrollableCheckBox.setSelected(this.transition.isUncontrollable());
        this.coloredTransitionGuardPanel.initExpr(this.transition.getGuardExpression());
        if (this.context.tabContent().getLens().isStochastic()) {
            this.distributionPanel.displayDistribution();
            this.displayWeight();
            if (this.transition.underlyingTransition().getFiringMode() == null) {
                this.firingModeComboBox.setSelectedIndex(0);
            } else {
                FiringMode firingMode = this.transition.underlyingTransition().getFiringMode();
                for (int i = 0; i < this.firingModeComboBox.getItemCount(); ++i) {
                    if (!this.firingModeComboBox.getItemAt(i).toString().equals(firingMode.toString())) continue;
                    this.firingModeComboBox.setSelectedIndex(i);
                    break;
                }
            }
        }
        if (this.transition.underlyingTransition().isShared()) {
            this.switchToNameDropDown();
            this.sharedCheckBox.setSelected(true);
            this.sharedTransitionsComboBox.setSelectedItem(this.transition.underlyingTransition().sharedTransition());
        } else {
            this.switchToNameTextField();
        }
        this.makeSharedButton.setEnabled(!this.sharedCheckBox.isSelected() && !this.hasArcsToSharedPlaces(this.transition.underlyingTransition()));
        this.attributesCheckBox.setSelected(this.transition.getAttributesVisible());
    }

    private boolean hasArcsToSharedPlaces(TimedTransition underlyingTransition) {
        for (TimedInputArc timedInputArc : this.context.activeModel().inputArcs()) {
            if (!timedInputArc.destination().equals(underlyingTransition) || !timedInputArc.source().isShared()) continue;
            return true;
        }
        for (TimedOutputArc timedOutputArc : this.context.activeModel().outputArcs()) {
            if (!timedOutputArc.source().equals(underlyingTransition) || !timedOutputArc.destination().isShared()) continue;
            return true;
        }
        for (TransportArc transportArc : this.context.activeModel().transportArcs()) {
            if (transportArc.transition().equals(underlyingTransition) && transportArc.source().isShared()) {
                return true;
            }
            if (!transportArc.transition().equals(underlyingTransition) || !transportArc.destination().isShared()) continue;
            return true;
        }
        for (TimedInhibitorArc timedInhibitorArc : this.context.activeModel().inhibitorArcs()) {
            if (!timedInhibitorArc.destination().equals(underlyingTransition) || !timedInhibitorArc.source().isShared()) continue;
            return true;
        }
        return false;
    }

    protected void switchToNameTextField() {
        this.transitionEditorPanel.remove(this.sharedTransitionsComboBox);
        GridBagConstraints gbc = GridBagHelper.as(1, 1, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.urgentCheckBox.setSelected(this.transition.isUrgent());
        this.uncontrollableCheckBox.setSelected(this.transition.isUncontrollable());
        this.distributionPanel.displayDistributionFields(this.transition.underlyingTransition().getDistribution());
        this.displayWeight(this.transition.underlyingTransition().getWeight());
        this.uncontrollableCheckBox.setSelected(this.transition.isUncontrollable());
        this.transitionEditorPanel.add((Component)this.nameTextField, gbc);
        this.transitionEditorPanel.validate();
        this.transitionEditorPanel.repaint();
    }

    protected void switchToNameDropDown() {
        this.transitionEditorPanel.remove(this.nameTextField);
        GridBagConstraints gbc = GridBagHelper.as(1, 1, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.transitionEditorPanel.add(this.sharedTransitionsComboBox, gbc);
        if (((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).transitions().isEmpty()) {
            ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setUrgent(this.urgentCheckBox.isSelected());
            ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setUncontrollable(this.uncontrollableCheckBox.isSelected());
            ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setGuard(this.coloredTransitionGuardPanel.getExpression());
            ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setDistribution(this.distributionPanel.parseDistribution());
            ((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).setWeight(this.parseWeight());
        } else {
            this.urgentCheckBox.setSelected(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).isUrgent());
            this.uncontrollableCheckBox.setSelected(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).isUncontrollable());
            this.coloredTransitionGuardPanel.initExpr(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getGuard());
            this.distributionPanel.displayDistributionFields(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getDistribution());
            this.displayWeight(((SharedTransition)this.sharedTransitionsComboBox.getSelectedItem()).getWeight());
        }
        this.transitionEditorPanel.validate();
        this.transitionEditorPanel.repaint();
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        this.focusLost(this.nameTextField);
    }

    private void nameTextFieldFocusGained(FocusEvent evt) {
        this.focusGained(this.nameTextField);
    }

    private void focusGained(JTextField textField) {
        textField.setCaretPosition(0);
        textField.moveCaretPosition(textField.getText().length());
    }

    private void focusLost(JTextField textField) {
        textField.setCaretPosition(0);
    }

    private boolean isUrgencyOK() {
        if (!this.transition.hasUntimedPreset()) {
            JOptionPane.showMessageDialog(this.transitionEditorPanel, untimed_preset_warning, "Error", 0);
            return false;
        }
        for (TransportArc arc : this.transition.underlyingTransition().getTransportArcsGoingThrough()) {
            if (arc.destination().invariant().upperBound() == Bound.Infinity) continue;
            JOptionPane.showMessageDialog(this.transitionEditorPanel, transport_destination_invariant_warning, "Error", 0);
            return false;
        }
        return true;
    }

    private boolean okButtonHandler(ActionEvent evt) {
        boolean wasShared;
        String newName = this.nameTextField.getText();
        if (this.urgentCheckBox.isSelected() && !this.isUrgencyOK()) {
            return false;
        }
        if (this.doNewEdit) {
            this.context.undoManager().newEdit();
            this.doNewEdit = false;
        }
        boolean bl = wasShared = this.transition.underlyingTransition().isShared() && !this.sharedCheckBox.isSelected();
        if (this.transition.underlyingTransition().isShared()) {
            this.context.undoManager().addEdit(new UnshareTransitionCommand(this.transition.underlyingTransition().sharedTransition(), this.transition.underlyingTransition()));
            this.transition.underlyingTransition().unshare();
        }
        if (this.sharedCheckBox.isSelected()) {
            SharedTransition selectedTransition = (SharedTransition)this.sharedTransitionsComboBox.getSelectedItem();
            MakeTransitionSharedCommand command = new MakeTransitionSharedCommand(this.context.activeModel(), selectedTransition, this.transition.underlyingTransition(), this.context.tabContent());
            this.context.undoManager().addEdit(command);
            try {
                command.redo();
            }
            catch (RequireException e) {
                this.context.undoManager().undo();
                this.doNewEdit = true;
                JOptionPane.showMessageDialog(this, "Another transition in the same component is already shared under that name", "Error", 0);
                return false;
            }
        }
        if (this.transition.underlyingTransition().model().isNameUsed(newName) && (wasShared || !this.transition.underlyingTransition().name().equals(newName))) {
            this.context.undoManager().undo();
            this.doNewEdit = true;
            JOptionPane.showMessageDialog(this, "The specified name is already used by another place or transition.", "Error", 0);
            return false;
        }
        try {
            String oldName = this.transition.underlyingTransition().name();
            if (!oldName.equals(newName)) {
                this.transition.underlyingTransition().setName(newName);
                RenameTimedTransitionCommand renameCommand = new RenameTimedTransitionCommand(this.context.tabContent(), this.transition.underlyingTransition(), oldName, newName);
                this.context.undoManager().addEdit(renameCommand);
                renameCommand.redo();
            }
        }
        catch (RequireException e) {
            this.context.undoManager().undo();
            this.doNewEdit = true;
            JOptionPane.showMessageDialog(this, "Acceptable names for transitions are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
            return false;
        }
        this.context.nameGenerator().updateIndices(this.transition.underlyingTransition().model(), newName);
        if (this.makeNewShared && !this.makeSharedButton.isEnabled()) {
            MakeTransitionNewSharedCommand command = new MakeTransitionNewSharedCommand(this.context.activeModel(), newName, this.transition.underlyingTransition(), this.context.tabContent(), false);
            this.context.undoManager().addEdit(command);
            try {
                command.redo();
            }
            catch (RequireException e) {
                this.context.undoManager().undo();
                this.doNewEdit = true;
                if (this.transition.underlyingTransition().model().parentNetwork().isNameUsedForTransitionsOnly(newName)) {
                    int dialogResult = JOptionPane.showConfirmDialog(this, "A transition with the specified name already exists in one or more components, or the specified name is invalid.\n\nAcceptable names for transitions are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nNote that \"true\" and \"false\" are reserved keywords. \n\nThis transition name will be changed into shared one also in all other components.", "Warning", 2);
                    if (dialogResult == 0) {
                        MakeTransitionNewSharedMultiCommand cmd = new MakeTransitionNewSharedMultiCommand(this.context, newName, this.transition);
                        cmd.redo();
                        this.context.undoManager().addEdit(cmd);
                    }
                    return false;
                }
                JOptionPane.showMessageDialog(this, "A place with the specified name already exists in one or more components, or the specified name is invalid.\n\nAcceptable names for places are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nNote that \"true\" and \"false\" are reserved keywords.", "Warning", 0);
                return false;
            }
            this.transition.setUrgent(this.urgentCheckBox.isSelected());
            this.transition.setUncontrollable(this.uncontrollableCheckBox.isSelected());
            this.transition.underlyingTransition().setDistribution(this.distributionPanel.parseDistribution());
            this.transition.underlyingTransition().setWeight(this.parseWeight());
        }
        if (this.transition.isUrgent() != this.urgentCheckBox.isSelected()) {
            this.context.undoManager().addEdit(new ToggleTransitionUrgentCommand(this.transition.underlyingTransition(), this.context.tabContent()));
            this.transition.setUrgent(this.urgentCheckBox.isSelected());
        }
        if (this.transition.isUncontrollable() != this.uncontrollableCheckBox.isSelected()) {
            this.context.undoManager().addEdit(new ToggleTransitionUncontrollableCommand(this.transition.underlyingTransition(), this.context.tabContent()));
            this.transition.setUncontrollable(this.uncontrollableCheckBox.isSelected());
        }
        SMCDistribution distribution = this.distributionPanel.parseDistribution();
        if (!this.transition.underlyingTransition().getDistribution().equals(distribution)) {
            this.context.undoManager().addEdit(new ChangeTransitionDistributionCommand(this.transition, this.transition.underlyingTransition(), distribution));
            this.transition.underlyingTransition().setDistribution(distribution);
        }
        Probability weight = this.parseWeight();
        if (!this.transition.underlyingTransition().getWeight().equals(weight)) {
            this.context.undoManager().addEdit(new ChangeProbabilityWeightCommand(this.transition, this.transition.underlyingTransition(), weight));
            this.transition.underlyingTransition().setWeight(weight);
        }
        FiringMode firingMode = (FiringMode)this.firingModeComboBox.getSelectedItem();
        if (!this.transition.underlyingTransition().getFiringMode().equals(firingMode)) {
            this.context.undoManager().addEdit(new ChangeFiringModeCommand(this.transition.underlyingTransition(), firingMode));
            this.transition.underlyingTransition().setFiringMode(firingMode);
        }
        this.context.network().buildConstraints();
        int rotationIndex = this.rotationComboBox.getSelectedIndex();
        if (rotationIndex > 0) {
            int angle = 0;
            switch (rotationIndex) {
                case 1: {
                    angle = 45;
                    break;
                }
                case 2: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 135;
                    break;
                }
            }
            if (angle != 0) {
                this.context.undoManager().addEdit(this.transition.rotate(angle));
            }
        }
        if (this.transition.getAttributesVisible() && !this.attributesCheckBox.isSelected() || !this.transition.getAttributesVisible() && this.attributesCheckBox.isSelected()) {
            this.transition.toggleAttributesVisible();
            HashMap<PetriNetObject, Boolean> map = new HashMap<PetriNetObject, Boolean>();
            map.put(this.transition, !this.transition.getAttributesVisible());
            ChangeAllNamesVisibilityCommand changeVisibility = new ChangeAllNamesVisibilityCommand(this.context.tabContent(), null, map, this.transition.getAttributesVisible());
            this.context.undoManager().addEdit(changeVisibility);
        }
        this.transition.update(true);
        this.coloredTransitionGuardPanel.onOK(this.context.undoManager());
        this.doOKChecked = true;
        return true;
    }

    public void enableOKButton(boolean enable) {
        this.okButton.setEnabled(enable);
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }

    private void cancelButtonHandler(ActionEvent evt) {
        if (this.doOKChecked) {
            this.context.undoManager().undo();
        }
        this.exit();
    }

    private Probability parseWeight() {
        if (this.useConstantWeight.isSelected()) {
            Constant constant = this.context.network().getConstant((String)this.constantsComboBox.getSelectedItem());
            return new ConstantProbability(constant);
        }
        if (this.infiniteWeight.isSelected()) {
            return new DoubleProbability(Double.POSITIVE_INFINITY);
        }
        try {
            return new DoubleProbability(Double.parseDouble(this.weightField.getText()));
        }
        catch (NumberFormatException e) {
            return new DoubleProbability(1.0);
        }
    }

    private void displayWeight() {
        this.displayWeight(this.transition.underlyingTransition().getWeight());
    }

    private void displayWeight(Probability weight) {
        if (weight instanceof ConstantProbability) {
            this.displayConstantWeight(weight);
        } else {
            this.displayDoubleWeight(weight);
        }
    }

    private void displayConstantWeight(Probability weight) {
        this.weightField.setVisible(false);
        this.infiniteWeight.setEnabled(false);
        this.constantsComboBox.setVisible(true);
        this.useConstantWeight.setSelected(true);
        ConstantProbability constWeight = (ConstantProbability)weight;
        this.constantsComboBox.setSelectedItem(constWeight.constant().name());
    }

    private void displayDoubleWeight(Probability weight) {
        this.weightField.setVisible(true);
        this.infiniteWeight.setEnabled(true);
        this.constantsComboBox.setVisible(false);
        this.useConstantWeight.setSelected(false);
        if (Double.isInfinite(weight.value())) {
            this.infiniteWeight.setSelected(true);
        } else {
            this.weightField.setText(String.valueOf(weight.value()));
        }
        this.weightField.setEnabled(!this.infiniteWeight.isSelected());
    }
}

