/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.dataLayer;

import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.RequireException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Set;
import pipe.gui.canvas.Canvas;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class DataLayer {
    private Canvas view;
    private final ArrayList<Place> placesArray = new ArrayList();
    private final ArrayList<Transition> transitionsArray = new ArrayList();
    private final ArrayList<Arc> arcsArray = new ArrayList();
    private final Set<ArcPathPoint> arcPathSet = Collections.newSetFromMap(new IdentityHashMap());
    private final ArrayList<AnnotationNote> labelsArray = new ArrayList();
    private ArrayList<? extends PetriNetObject> changeArrayList = null;
    private final Hashtable<PlaceTransitionObject, ArrayList<TimedOutputArcComponent>> arcsMap = new Hashtable();
    private final Hashtable<PlaceTransitionObject, ArrayList<TimedInhibitorArcComponent>> tapnInhibitorsMap = new Hashtable();
    private final ArrayList<PetriNetObject> petriNetObjects = new ArrayList();

    public void addedToView(Canvas view) {
        this.view = view;
    }

    public void removedFromView() {
        this.view = null;
    }

    private void removeFromViewIfConnected(PetriNetObject pno) {
        if (this.view != null) {
            this.view.removePetriNetObject(pno.getGraphicalElement());
        }
    }

    private void addToViewIfConnected(PetriNetObject pno) {
        if (this.view != null) {
            this.view.addNewPetriNetObject(pno.getGraphicalElement());
        }
    }

    public ArrayList<PetriNetObject> getPNObjects() {
        return this.petriNetObjects;
    }

    public ArrayList<PetriNetObject> getPlaceTransitionObjects() {
        ArrayList<PetriNetObject> result = new ArrayList<PetriNetObject>();
        for (PetriNetObject pnObject : this.petriNetObjects) {
            if (!(pnObject instanceof PlaceTransitionObject)) continue;
            result.add(pnObject);
        }
        return result;
    }

    private void addPlace(Place placeInput) {
        Require.that(placeInput != null, "input place was null");
        this.placesArray.add(placeInput);
    }

    private void addAnnotation(AnnotationNote labelInput) {
        this.labelsArray.add(labelInput);
    }

    private void addTransition(Transition transitionInput) {
        Require.that(transitionInput != null, "input transition was null");
        this.transitionsArray.add(transitionInput);
    }

    private void addArc(TimedOutputArcComponent arcInput) {
        boolean unique = true;
        if (arcInput.getSource() == null || arcInput.getTarget() == null) {
            System.err.println("Cant add arc" + String.valueOf(arcInput) + " where source: " + String.valueOf(arcInput.getSource()) + " or target: " + String.valueOf(arcInput.getTarget()) + " is null");
            return;
        }
        if (arcInput.getId() != null && arcInput.getId().length() > 0) {
            for (Arc arc : this.arcsArray) {
                if (!arcInput.getId().equals(arc.getId())) continue;
                unique = false;
            }
        } else {
            Object id = null;
            if (this.arcsArray.size() > 0) {
                int no = this.arcsArray.size();
                do {
                    for (Arc arc : this.arcsArray) {
                        id = "A" + no;
                        if (arc == null) continue;
                        if (((String)id).equals(arc.getId())) {
                            unique = false;
                            ++no;
                            continue;
                        }
                        unique = true;
                    }
                } while (!unique);
            } else {
                id = "A0";
            }
            arcInput.setId((String)id);
        }
        if (arcInput instanceof TimedTransportArcComponent) {
            TimedTransportArcComponent tmp = (TimedTransportArcComponent)arcInput;
            PlaceTransitionObject first = tmp.getSource();
            if (tmp.getConnectedTo() == null) {
                if (first instanceof TimedPlaceComponent) {
                    for (Arc o : tmp.getTarget().getPostset()) {
                        if (!(o instanceof TimedTransportArcComponent) || tmp.getGroupNr() != ((TimedTransportArcComponent)o).getGroupNr()) continue;
                        tmp.setConnectedTo((TimedTransportArcComponent)o);
                        ((TimedTransportArcComponent)o).setConnectedTo(tmp);
                        break;
                    }
                } else {
                    for (Arc o : tmp.getSource().getPreset()) {
                        if (!(o instanceof TimedTransportArcComponent) || tmp.getGroupNr() != ((TimedTransportArcComponent)o).getGroupNr()) continue;
                        tmp.setConnectedTo((TimedTransportArcComponent)o);
                        ((TimedTransportArcComponent)o).setConnectedTo(tmp);
                        break;
                    }
                }
            }
        }
        this.arcsArray.add(arcInput);
        this.addArcToArcsMap(arcInput);
    }

    private void addArc(TimedInhibitorArcComponent inhibitorArcInput) {
        boolean unique = true;
        if (inhibitorArcInput != null) {
            if (inhibitorArcInput.getId() != null && inhibitorArcInput.getId().length() > 0) {
                for (Arc arc : this.arcsArray) {
                    if (!inhibitorArcInput.getId().equals(arc.getId())) continue;
                    unique = false;
                }
            } else {
                Object id = null;
                if (this.arcsArray.size() > 0) {
                    int no = this.arcsArray.size();
                    do {
                        for (Arc arc : this.arcsArray) {
                            id = "I" + no;
                            if (arc == null) continue;
                            if (((String)id).equals(arc.getId())) {
                                unique = false;
                                ++no;
                                continue;
                            }
                            unique = true;
                        }
                    } while (!unique);
                } else {
                    id = "I0";
                }
                inhibitorArcInput.setId((String)id);
            }
            this.arcsArray.add(inhibitorArcInput);
            this.addInhibitorArcToInhibitorsMap(inhibitorArcInput);
        }
    }

    private void addArcToArcsMap(TimedOutputArcComponent arcInput) {
        PlaceTransitionObject source = arcInput.getSource();
        PlaceTransitionObject target = arcInput.getTarget();
        ArrayList<TimedOutputArcComponent> newList = null;
        if (source != null) {
            if (this.arcsMap.get(source) != null) {
                this.arcsMap.get(source).add(arcInput);
            } else {
                newList = new ArrayList<TimedOutputArcComponent>();
                newList.add(arcInput);
                this.arcsMap.put(source, newList);
            }
        }
        if (target != null) {
            if (this.arcsMap.get(target) != null) {
                this.arcsMap.get(target).add(arcInput);
            } else {
                newList = new ArrayList();
                newList.add(arcInput);
                this.arcsMap.put(target, newList);
            }
        }
    }

    private void addInhibitorArcToInhibitorsMap(TimedInhibitorArcComponent inhibitorArcInput) {
        PlaceTransitionObject source = inhibitorArcInput.getSource();
        PlaceTransitionObject target = inhibitorArcInput.getTarget();
        ArrayList<TimedInhibitorArcComponent> newList = null;
        if (source != null) {
            if (this.tapnInhibitorsMap.get(source) != null) {
                this.tapnInhibitorsMap.get(source).add(inhibitorArcInput);
            } else {
                newList = new ArrayList<TimedInhibitorArcComponent>();
                newList.add(inhibitorArcInput);
                this.tapnInhibitorsMap.put(source, newList);
            }
        }
        if (target != null) {
            if (this.tapnInhibitorsMap.get(target) != null) {
                this.tapnInhibitorsMap.get(target).add(inhibitorArcInput);
            } else {
                newList = new ArrayList();
                newList.add(inhibitorArcInput);
                this.tapnInhibitorsMap.put(target, newList);
            }
        }
    }

    public void addPetriNetObject(PetriNetObject pnObject) {
        pnObject.setGuiModel(this);
        this.addToViewIfConnected(pnObject);
        this.petriNetObjects.add(pnObject);
        pnObject.setDeleted(false);
        if (pnObject instanceof Arc) {
            Arc arc = (Arc)pnObject;
            arc.getSource().addConnectFrom(arc);
            arc.getTarget().addConnectTo(arc);
        }
        if (this.setPetriNetObjectArrayList(pnObject)) {
            if (pnObject instanceof TimedInhibitorArcComponent) {
                this.addArc((TimedInhibitorArcComponent)pnObject);
            } else if (pnObject instanceof TimedOutputArcComponent) {
                this.addArc((TimedOutputArcComponent)pnObject);
            } else if (pnObject instanceof Place) {
                this.addPlace((Place)pnObject);
            } else if (pnObject instanceof Transition) {
                this.addTransition((Transition)pnObject);
            } else if (pnObject instanceof AnnotationNote) {
                this.addAnnotation((AnnotationNote)pnObject);
            }
        } else if (pnObject instanceof ArcPathPoint) {
            this.arcPathSet.add((ArcPathPoint)pnObject);
        } else {
            throw new RuntimeException("Unknow element type added");
        }
        this.changeArrayList = null;
    }

    public void removePetriNetObject(PetriNetObject pnObject) {
        this.removeFromViewIfConnected(pnObject);
        this.petriNetObjects.remove(pnObject);
        pnObject.setDeleted(true);
        if (pnObject instanceof Arc) {
            Arc arc = (Arc)pnObject;
            arc.getSource().removeFromArc(arc);
            arc.getTarget().removeToArc(arc);
        } else if (pnObject instanceof ArcPathPoint) {
            this.arcPathSet.remove(pnObject);
        }
        boolean didSomething = false;
        ArrayList<TimedOutputArcComponent> attachedArcs = null;
        try {
            if (this.setPetriNetObjectArrayList(pnObject)) {
                didSomething = this.changeArrayList.remove(pnObject);
                if (pnObject instanceof PlaceTransitionObject) {
                    if (this.arcsMap.get(pnObject) != null) {
                        attachedArcs = this.arcsMap.get(pnObject);
                        if (attachedArcs.size() > 0) {
                            throw new RequireException("Arc to/from the object must be delete first");
                        }
                        this.arcsMap.remove(pnObject);
                    }
                    if (this.tapnInhibitorsMap.get(pnObject) != null) {
                        attachedArcs = this.tapnInhibitorsMap.get(pnObject);
                        if (attachedArcs.size() > 0) {
                            throw new RequireException("Arc to/from the object must be delete first");
                        }
                        this.tapnInhibitorsMap.remove(pnObject);
                    }
                } else if (pnObject instanceof TimedInhibitorArcComponent) {
                    PlaceTransitionObject attached = ((Arc)pnObject).getSource();
                    if (attached != null) {
                        ArrayList<TimedInhibitorArcComponent> a = this.tapnInhibitorsMap.get(attached);
                        if (a != null) {
                            a.remove(pnObject);
                        }
                        attached.removeFromArc((Arc)pnObject);
                        if (attached instanceof Transition) {
                            ((Transition)attached).removeArcCompareObject((Arc)pnObject);
                        }
                    }
                    if ((attached = ((Arc)pnObject).getTarget()) != null) {
                        if (this.tapnInhibitorsMap.get(attached) != null) {
                            this.tapnInhibitorsMap.get(attached).remove(pnObject);
                        }
                        attached.removeToArc((Arc)pnObject);
                        if (attached instanceof Transition) {
                            ((Transition)attached).removeArcCompareObject((Arc)pnObject);
                        }
                    }
                } else if (pnObject instanceof TimedOutputArcComponent) {
                    PlaceTransitionObject attached = ((Arc)pnObject).getSource();
                    if (attached != null) {
                        ArrayList<TimedOutputArcComponent> a = this.arcsMap.get(attached);
                        if (a != null) {
                            a.remove(pnObject);
                        }
                        attached.removeFromArc((Arc)pnObject);
                        if (attached instanceof Transition) {
                            ((Transition)attached).removeArcCompareObject((Arc)pnObject);
                            attached.updateConnected();
                        }
                    }
                    if ((attached = ((Arc)pnObject).getTarget()) != null) {
                        if (this.arcsMap.get(attached) != null) {
                            this.arcsMap.get(attached).remove(pnObject);
                        }
                        attached.removeToArc((Arc)pnObject);
                        if (attached instanceof Transition) {
                            ((Transition)attached).removeArcCompareObject((Arc)pnObject);
                            attached.updateConnected();
                        }
                    }
                }
            }
        }
        catch (NullPointerException npe) {
            System.out.println("NullPointerException [debug]\n" + npe.getMessage());
            throw npe;
        }
        this.changeArrayList = null;
    }

    public Iterable<Transition> transitions() {
        return this.transitionsArray;
    }

    private boolean setPetriNetObjectArrayList(PetriNetObject pnObject) {
        if (pnObject instanceof Transition) {
            this.changeArrayList = this.transitionsArray;
            return true;
        }
        if (pnObject instanceof Place) {
            this.changeArrayList = this.placesArray;
            return true;
        }
        if (pnObject instanceof TimedInhibitorArcComponent) {
            this.changeArrayList = this.arcsArray;
            return true;
        }
        if (pnObject instanceof TimedOutputArcComponent) {
            this.changeArrayList = this.arcsArray;
            return true;
        }
        if (pnObject instanceof AnnotationNote) {
            this.changeArrayList = this.labelsArray;
            return true;
        }
        return false;
    }

    public Iterable<PetriNetObject> getPetriNetObjects() {
        ArrayList<PetriNetObject> all = new ArrayList<PetriNetObject>(this.placesArray);
        all.addAll(this.transitionsArray);
        all.addAll(this.arcsArray);
        all.addAll(this.labelsArray);
        return all;
    }

    public Iterable<PetriNetObject> getPetriNetObjectsWithArcPathPoint() {
        ArrayList<PetriNetObject> all = new ArrayList<PetriNetObject>(this.placesArray);
        all.addAll(this.transitionsArray);
        all.addAll(this.arcsArray);
        all.addAll(this.labelsArray);
        all.addAll(this.arcPathSet);
        return all;
    }

    public Place[] getPlaces() {
        return this.placesArray.toArray(new Place[0]);
    }

    public AnnotationNote[] getLabels() {
        return this.labelsArray.toArray(new AnnotationNote[0]);
    }

    public Transition[] getTransitions() {
        return this.transitionsArray.toArray(new Transition[0]);
    }

    public Arc[] getArcs() {
        return this.arcsArray.toArray(new Arc[0]);
    }

    public Arc getArcByEndpoints(PlaceTransitionObject source, PlaceTransitionObject target) {
        Arc returnArc = null;
        for (Arc arc : this.arcsArray) {
            if (arc.getSource() != source || arc.getTarget() != target) continue;
            returnArc = arc;
        }
        return returnArc;
    }

    public Transition getTransitionById(String transitionID) {
        Transition returnTransition = null;
        if (transitionID != null) {
            for (Transition transition : this.transitionsArray) {
                if (!transitionID.equals(transition.getId())) continue;
                returnTransition = transition;
            }
        }
        return returnTransition;
    }

    public Transition getTransitionByName(String transitionName) {
        Transition returnTransition = null;
        if (transitionName != null) {
            for (Transition transition : this.transitionsArray) {
                if (!transitionName.equals(transition.getName())) continue;
                returnTransition = transition;
            }
        }
        return returnTransition;
    }

    public Place getPlaceById(String placeID) {
        Place returnPlace = null;
        if (placeID != null) {
            for (Place place : this.placesArray) {
                if (!placeID.equals(place.getId())) continue;
                returnPlace = place;
            }
        }
        return returnPlace;
    }

    public Place getPlaceByName(String placeName) {
        Place returnPlace = null;
        if (placeName != null) {
            for (Place place : this.placesArray) {
                if (!placeName.equals(place.getName())) continue;
                returnPlace = place;
            }
        }
        return returnPlace;
    }

    public PlaceTransitionObject getPlaceTransitionObject(String ptoId) {
        if (ptoId != null) {
            if (this.getPlaceById(ptoId) != null) {
                return this.getPlaceById(ptoId);
            }
            if (this.getTransitionById(ptoId) != null) {
                return this.getTransitionById(ptoId);
            }
        }
        throw new NullPointerException("One or more arcs are connected to a place/transition, which can not be found in the net");
    }

    public void redrawVisibleTokenLists() {
        for (Place place : this.placesArray) {
            TimedPlaceComponent tp;
            if (!(place instanceof TimedPlaceComponent) || !(tp = (TimedPlaceComponent)place).isAgeOfTokensShown()) continue;
            tp.showAgeOfTokens(true);
        }
    }

    public void repaintPlaces() {
        for (Place p : this.placesArray) {
            p.repaint();
        }
    }

    public void repaintPlaces(boolean displayConstantNames) {
        for (Place p : this.placesArray) {
            p.update(displayConstantNames);
            p.repaint();
        }
    }

    public void repaintAll(boolean displayConstantNames) {
        this.repaintPlaces(displayConstantNames);
        for (Transition t : this.transitionsArray) {
            t.updateOnMoveOrZoom();
            t.repaint();
            t.update(displayConstantNames);
        }
        for (Arc arc : this.arcsArray) {
            arc.updateLabel(displayConstantNames);
            arc.repaint();
        }
    }

    public DataLayer copy(TimedArcPetriNet tapn) {
        DataLayer guiModel = new DataLayer();
        Hashtable<PlaceTransitionObject, PlaceTransitionObject> oldToNewMapping = new Hashtable<PlaceTransitionObject, PlaceTransitionObject>();
        for (Place p : this.placesArray) {
            if (!(p instanceof TimedPlaceComponent)) continue;
            TimedPlaceComponent place = ((TimedPlaceComponent)p).copy(tapn);
            oldToNewMapping.put(p, place);
            guiModel.addPetriNetObject(place);
        }
        for (Transition t : this.transitionsArray) {
            if (!(t instanceof TimedTransitionComponent)) continue;
            TimedTransitionComponent trans = ((TimedTransitionComponent)t).copy(tapn);
            oldToNewMapping.put(t, trans);
            guiModel.addPetriNetObject(trans);
        }
        for (Arc arc : this.arcsArray) {
            if (arc instanceof TimedTransportArcComponent) {
                TimedInputArcComponent transArc = ((TimedTransportArcComponent)arc).copy(tapn, (Hashtable)oldToNewMapping);
                guiModel.addPetriNetObject(transArc);
                continue;
            }
            if (arc instanceof TimedInhibitorArcComponent) {
                TimedInputArcComponent inhibArc = ((TimedInhibitorArcComponent)arc).copy(tapn, (Hashtable)oldToNewMapping);
                guiModel.addPetriNetObject(inhibArc);
                continue;
            }
            if (arc instanceof TimedInputArcComponent) {
                TimedOutputArcComponent inputArc = ((TimedInputArcComponent)arc).copy(tapn, (Hashtable)oldToNewMapping);
                guiModel.addPetriNetObject(inputArc);
                continue;
            }
            if (arc instanceof TimedOutputArcComponent) {
                TimedOutputArcComponent outputArc = ((TimedOutputArcComponent)arc).copy(tapn, oldToNewMapping);
                guiModel.addPetriNetObject(outputArc);
                continue;
            }
            throw new RuntimeException("Arc was unknown type");
        }
        for (AnnotationNote note : this.labelsArray) {
            AnnotationNote annotation = note.copy();
            guiModel.addPetriNetObject(annotation);
        }
        return guiModel;
    }

    public PlaceTransitionObject getPlaceTransitionObjectByName(String name) {
        for (PetriNetObject object : this.getPlaceTransitionObjects()) {
            if (!object.getName().equals(name)) continue;
            return (PlaceTransitionObject)object;
        }
        return null;
    }
}

