/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.StringComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Random;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.tapaal.gui.petrinet.Template;
import org.jetbrains.annotations.NotNull;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.animation.Animator;
import pipe.gui.petrinet.animation.SimulationControl;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;

public class EnabledTransitionsList
extends JPanel {
    private Animator animator;
    final DefaultListModel<TransitionListItem> transitions = new DefaultListModel();
    final JList<TransitionListItem> transitionsList = new JList<TransitionListItem>(this.transitions);
    final JScrollPane scrollPane = new JScrollPane(this.transitionsList);
    TransitionListItem lastSelected;

    public EnabledTransitionsList(Animator animator) {
        super(new BorderLayout());
        this.animator = animator;
        this.setPreferredSize(new Dimension(0, 300));
        this.initPanel();
    }

    public void initPanel() {
        this.transitionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TransitionListItem highlightedItem;
                if (e.getClickCount() == 2) {
                    EnabledTransitionsList.this.fireSelectedTransition();
                }
                if (e.getClickCount() == 1 && (highlightedItem = EnabledTransitionsList.this.transitionsList.getSelectedValue()) != null) {
                    highlightedItem.getTransition().blink();
                }
            }
        });
        this.add((Component)this.scrollPane, "Center");
    }

    public void startReInit() {
        this.lastSelected = this.transitionsList.getSelectedValue();
        this.transitions.clear();
    }

    public void reInitDone() {
        if (SimulationControl.getInstance().isRandomTransitionMode()) {
            this.selectRandom();
            return;
        }
        Object[] temp = this.transitions.toArray();
        Arrays.sort(temp);
        this.transitions.clear();
        for (Object item : temp) {
            this.transitions.addElement((TransitionListItem)item);
        }
        if (this.transitions.contains(this.lastSelected)) {
            int i = this.transitions.indexOf(this.lastSelected);
            this.transitionsList.setSelectedIndex(i);
        } else if (this.transitions.size() > 0) {
            this.transitionsList.setSelectedIndex(0);
        }
    }

    private void selectRandom() {
        if (this.transitions.size() == 0) {
            return;
        }
        Random r = new Random();
        int randSelect = r.nextInt(this.transitions.size());
        this.transitionsList.setSelectedIndex(randSelect);
    }

    public void addTransition(Template template, Transition transition) {
        TransitionListItem item = new TransitionListItem(transition, template);
        if (!this.transitions.contains(item)) {
            this.transitions.addElement(item);
        }
    }

    public void fireSelectedTransition() {
        TransitionListItem item = this.transitionsList.getSelectedValue();
        if (item != null) {
            this.animator.dFireTransition(((TimedTransitionComponent)item.getTransition()).underlyingTransition());
        }
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    static class TransitionListItem
    implements ListItem {
        private final Transition transition;
        private final Template template;

        public TransitionListItem(Transition transition, Template template) {
            this.transition = transition;
            this.template = template;
        }

        public String toString(boolean showIntervals) {
            String interval = this.transition.getDInterval() == null || !showIntervals || !this.transition.isTimed() ? "" : this.transition.getDInterval().toString() + " ";
            Object transitionName = this.getTransition().getName();
            transitionName = this.isShared() ? (String)transitionName + " (shared)" : String.valueOf(this.getTemplate()) + "." + (String)transitionName;
            return interval + (String)transitionName;
        }

        public String toString() {
            if (TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions()) {
                return this.toString(true);
            }
            return this.toString(false);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransitionListItem)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public Transition getTransition() {
            return this.transition;
        }

        public Template getTemplate() {
            return this.template;
        }

        public boolean isShared() {
            return this.template.model().getTransitionByName(this.transition.getName()).isShared();
        }

        @Override
        public int compareTo(@NotNull ListItem o) {
            if (o instanceof TransitionListItem) {
                return this.compareTo((TransitionListItem)o);
            }
            return this.transition.isEnabled() ? -1 : 1;
        }

        @Override
        public int compareTo(TransitionListItem o) {
            BigDecimal otherLower;
            BigDecimal thisLower;
            int result = 0;
            if (this.transition.getDInterval() != null && o.transition.getDInterval() != null && (result = (thisLower = IntervalOperations.getRatBound(this.transition.getDInterval().lowerBound()).getBound()).compareTo(otherLower = IntervalOperations.getRatBound(o.transition.getDInterval().lowerBound()).getBound())) == 0 && this.transition.getDInterval().isLowerBoundNonStrict() != o.transition.getDInterval().isLowerBoundNonStrict()) {
                result = this.transition.getDInterval().isLowerBoundNonStrict() ? -1 : 1;
            }
            StringComparator s = new StringComparator();
            if (result == 0) {
                result = s.compare(this.template.model().name(), o.template.model().name());
            }
            if (result == 0) {
                result = s.compare(this.transition.getName(), o.transition.getName());
            }
            return result;
        }
    }

    static interface ListItem
    extends Comparable<ListItem> {
    }
}

