/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.OldestFiringMode;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkColoredTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimedTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.model.tapn.simulation.TimedTAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.YoungestFiringMode;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.RequireException;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerifyTAPN.ColorBindingParser;
import dk.aau.cs.verification.VerifyTAPN.ExportedVerifyTAPNModel;
import dk.aau.cs.verification.VerifyTAPN.TraceType;
import dk.aau.cs.verification.VerifyTAPN.VerifyCPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNInteractiveHandle;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.animation.AnimationTokenSelectDialog;
import net.tapaal.gui.petrinet.animation.TransitionFiringComponent;
import net.tapaal.gui.petrinet.dialog.ColoredBindingSelectionDialog;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.action.GuiAction;
import pipe.gui.petrinet.animation.AnimationHistoryList;
import pipe.gui.petrinet.animation.SimulationControl;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.swingcomponents.EscapableDialog;

public class Animator {
    private final ArrayList<TAPNNetworkTraceStep> actionHistory = new ArrayList();
    private int currentAction = -1;
    private final ArrayList<NetworkMarking> markings = new ArrayList();
    private int currentMarkingIndex = 0;
    private TAPNNetworkTrace trace = null;
    public FiringMode firingmode = new RandomFiringMode();
    private final PetriNetTab tab;
    private NetworkMarking initialMarking;
    private boolean isDisplayingUntimedTrace = false;
    private static boolean isUrgentTransitionEnabled = false;
    private Map<String, TAPNNetworkTrace> traceMap;
    private VerifyPNInteractiveHandle interactiveEngine;
    private boolean isUsingInteractiveEngine;
    private Map<TimedTransition, List<Map<Variable, Color>>> validBindingsMap;
    private Map<TimedPlace, Tuple<List<TimedToken>, ArcExpression>> storedTokenState = new HashMap<TimedPlace, Tuple<List<TimedToken>, ArcExpression>>();
    public static final String[] FIRINGMODES = new String[]{"Random", "Oldest", "Youngest", "Manual"};
    public final GuiAction stepforwardAction;
    public final GuiAction stepbackwardAction;

    public static boolean isUrgentTransitionEnabled() {
        return isUrgentTransitionEnabled;
    }

    public Animator(PetriNetTab tab) {
        this.stepforwardAction = TAPAALGUI.getAppGui().stepforwardAction;
        this.stepbackwardAction = TAPAALGUI.getAppGui().stepbackwardAction;
        this.tab = tab;
    }

    public void initializeInteractiveEngine() {
        if (!this.tab.getLens().isColored()) {
            return;
        }
        try {
            TAPNComposer composer = new TAPNComposer(new MessengerImpl(), this.tab.getGuiModels(), this.tab.getLens(), false, true);
            Tuple<TimedArcPetriNet, NameMapping> composedModel = composer.transformModel(this.tab.network());
            VerifyCPNExporter exporter = new VerifyCPNExporter();
            ExportedVerifyTAPNModel exportedModel = exporter.exportModel(composedModel, composer.getGuiModel());
            this.interactiveEngine = new VerifyPNInteractiveHandle(this.tab.network(), composer, composedModel.value2());
            this.isUsingInteractiveEngine = this.interactiveEngine.startInteractiveMode(exportedModel.modelFile());
            if (!this.isUsingInteractiveEngine) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Failed to start VerifyPN interactive mode", "Engine Error", 0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Error initializing interactive engine: " + e.getMessage(), "Engine Error", 0);
        }
    }

    private NetworkMarking currentMarking() {
        return this.markings.get(this.currentMarkingIndex);
    }

    public void setTrace(TAPNNetworkTrace trace, Map<String, TAPNNetworkTrace> traceMap) {
        this.traceMap = traceMap;
        this.setTrace(trace);
        this.tab.getAnimationController().updateTraceBox(traceMap);
    }

    public Map<String, TAPNNetworkTrace> getTraceMap() {
        return this.traceMap;
    }

    public void setTraceMap(Map<String, TAPNNetworkTrace> traceMap) {
        this.traceMap = traceMap;
    }

    public void changeTrace(TAPNNetworkTrace trace) {
        this.resetForTraceChange();
        this.setTrace(trace);
    }

    public void setTrace(TAPNNetworkTrace trace) {
        this.tab.setAnimationMode(true, this.tab.getLens().isColored());
        try {
            if (trace.isConcreteTrace()) {
                this.trace = trace;
                if (trace.isColoredTrace()) {
                    this.setColoredTrace(trace);
                } else {
                    this.setTimedTrace(trace);
                    TimedTAPNNetworkTrace timedTrace = (TimedTAPNNetworkTrace)trace;
                    if (timedTrace.getTraceType() != TraceType.NOT_EG) {
                        this.tab.getAnimationHistorySidePanel().setLastShown(timedTrace.getTraceType());
                    }
                }
            } else {
                this.setUntimedTrace(trace);
                this.isDisplayingUntimedTrace = true;
            }
            this.currentAction = -1;
            this.currentMarkingIndex = 0;
            this.tab.network().setMarking(this.markings.get(this.currentMarkingIndex));
            this.tab.getAnimationHistorySidePanel().setSelectedIndex(0);
            this.updateAnimationButtonsEnabled();
            this.updateFireableTransitions();
        }
        catch (RequireException e) {
            this.unhighlightDisabledTransitions();
            this.tab.setAnimationMode(false);
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There was an error in the trace. Reason: " + e.getMessage(), "Error", 0);
            return;
        }
    }

    private void setUntimedTrace(TAPNNetworkTrace trace) {
        this.tab.addAbstractAnimationPane();
        AnimationHistoryList untimedAnimationHistory = this.tab.getUntimedAnimationHistory();
        for (TAPNNetworkTraceStep step : trace) {
            untimedAnimationHistory.addHistoryItem(step.toString(), this.tab.getLens().isColored());
        }
        this.tab.getUntimedAnimationHistory().setSelectedIndex(0);
        this.setFiringmode("Random");
        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The verification process returned an untimed trace.\n\nThis means that with appropriate time delays the displayed\nsequence of discrete transitions can become a concrete trace.\nIn case of liveness properties (EG, AF) the untimed trace\neither ends in a deadlock, a time divergent computation without\nany discrete transitions, or it loops back to some earlier configuration.\nThe user may experiment in the simulator with different time delays\nin order to realize the suggested untimed trace in the model.", "Verification Information", 1);
    }

    private void setTimedTrace(TAPNNetworkTrace trace) {
        NetworkMarking previousMarking = this.initialMarking;
        TimedTransition previousTransition = null;
        for (TAPNNetworkTraceStep step : trace) {
            if (step instanceof TAPNNetworkTimedTransitionStep) {
                TimedTransition transition = ((TAPNNetworkTimedTransitionStep)step).getTransition();
                if (previousMarking != null && previousTransition != null) {
                    this.checkTokensRemoved(previousMarking, previousTransition);
                }
                previousMarking = this.currentMarking();
                previousTransition = transition;
            }
            this.addMarking(step, step.performStepFrom(this.currentMarking()));
        }
    }

    private void setColoredTrace(TAPNNetworkTrace trace) {
        for (TAPNNetworkTraceStep step : trace) {
            TAPNNetworkColoredTransitionStep coloredStep = (TAPNNetworkColoredTransitionStep)step;
            this.addMarking(step, coloredStep.getMarking());
        }
        this.updateBindings(0);
    }

    public boolean isColoredTrace() {
        return this.trace != null && this.trace.isColoredTrace();
    }

    private void checkTokensRemoved(NetworkMarking previousMarking, TimedTransition previousTransition) {
        if (this.tab.getLens().isStochastic()) {
            return;
        }
        for (TimedInputArc inputArc : previousTransition.getInputArcs()) {
            int tokensBefore = previousMarking.getTokensFor(inputArc.source()).size();
            int newTokens = 0;
            for (TimedOutputArc outputArc : previousTransition.getOutputArcs()) {
                if (!outputArc.destination().equals(inputArc.source())) continue;
                newTokens += outputArc.getWeight().value();
            }
            int tokensAfter = this.currentMarking().getTokensFor(inputArc.source()).size() + newTokens;
            int tokenDelta = Math.abs(tokensBefore - tokensAfter);
            if (tokenDelta == inputArc.getWeight().value()) continue;
            String errorStr = "Error executing trace: expected to have " + inputArc.getWeight().value();
            errorStr = errorStr + (inputArc.getWeight().value() == 1 ? " token" : " tokens");
            errorStr = errorStr + " in place " + inputArc.source().name() + ", but had " + tokenDelta;
            errorStr = errorStr + (tokenDelta == 1 ? " token" : " tokens");
            errorStr = errorStr + " in step number " + this.currentMarkingIndex;
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), errorStr, "Error", 0);
        }
    }

    private void addToTimedTrace(List<TAPNNetworkTraceStep> stepList) {
        for (TAPNNetworkTraceStep step : stepList) {
            this.addMarking(step, step.performStepFrom(this.currentMarking()));
        }
    }

    public NetworkMarking getInitialMarking() {
        return this.initialMarking;
    }

    private void unhighlightDisabledTransitions() {
        this.disableTransitions();
    }

    private void updateValidBindingsMap() {
        if (!this.isUsingInteractiveEngine) {
            return;
        }
        this.validBindingsMap = this.interactiveEngine.sendMarking(this.currentMarking());
    }

    private boolean isColoredTransitionEnabled(TimedTransition transition) {
        if (this.tab.getLens().isColored() && this.isUsingInteractiveEngine) {
            if (transition.isShared()) {
                for (TimedTransition t : transition.sharedTransition().transitions()) {
                    if (!this.validBindingsMap.keySet().contains(t)) continue;
                    return true;
                }
            } else if (this.validBindingsMap.keySet().contains(transition)) {
                return true;
            }
        }
        return false;
    }

    private void updateFireableTransitionsColored(TransitionFiringComponent transFireComponent) {
        boolean anyTransitionsEnabled = false;
        if (this.tab.getLens().isColored()) {
            this.updateValidBindingsMap();
            for (Template template : this.tab.activeTemplates()) {
                for (TimedTransition transition : template.model().transitions()) {
                    Transition guiTransition;
                    if (!this.isColoredTransitionEnabled(transition) || (guiTransition = template.guiModel().getTransitionByName(transition.name())) == null) continue;
                    guiTransition.markTransitionEnabled(true);
                    transFireComponent.addTransition(template, guiTransition);
                    anyTransitionsEnabled = true;
                }
            }
        }
        if (!anyTransitionsEnabled) {
            this.tab.getAnimationHistorySidePanel().setLastShown(TraceType.EG_DEADLOCK);
        }
    }

    public void updateFireableTransitions() {
        TransitionFiringComponent transFireComponent = this.tab.getTransitionFiringComponent();
        transFireComponent.startReInit();
        isUrgentTransitionEnabled = false;
        if (this.tab.getLens().isColored()) {
            this.updateFireableTransitionsColored(transFireComponent);
        } else {
            block0: for (Template template : this.tab.activeTemplates()) {
                for (TimedTransition timedTransition : template.model().transitions()) {
                    if (!timedTransition.isUrgent() || !timedTransition.isEnabled()) continue;
                    isUrgentTransitionEnabled = true;
                    break block0;
                }
            }
            for (Template template : this.tab.activeTemplates()) {
                for (Transition transition : template.guiModel().transitions()) {
                    if (transition.isTransitionEnabled()) {
                        transition.markTransitionEnabled(true);
                        transFireComponent.addTransition(template, transition);
                        continue;
                    }
                    if (!TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions() || !transition.isDelayEnabled() || isUrgentTransitionEnabled) continue;
                    transition.markTransitionDelayEnabled(true);
                    transFireComponent.addTransition(template, transition);
                }
            }
        }
        transFireComponent.reInitDone();
    }

    private void disableTransitions() {
        for (Template template : this.tab.allTemplates()) {
            for (Transition tempTransition : template.guiModel().transitions()) {
                tempTransition.disableHightlight();
                tempTransition.repaint();
            }
        }
    }

    public void storeModel() {
        this.initialMarking = this.tab.network().marking();
        this.resethistory();
        this.markings.add(this.initialMarking);
        this.storeTokenState();
        this.updateColoredMarking();
    }

    public void restoreModel() {
        if (this.tab != null) {
            this.disableTransitions();
            this.tab.network().setMarking(this.initialMarking);
            this.restoreTokenState();
            this.currentAction = -1;
            if (this.isUsingInteractiveEngine) {
                this.interactiveEngine.stopInteractiveMode();
                this.isUsingInteractiveEngine = false;
            }
        }
    }

    private void storeTokenState() {
        this.storedTokenState.clear();
        for (Place guiPlace : this.tab.currentTemplate().guiModel().getPlaces()) {
            TimedPlaceComponent placeComponent = (TimedPlaceComponent)guiPlace;
            TimedPlace place = placeComponent.underlyingPlace();
            NetworkMarking marking = this.tab.network().marking();
            List<TimedToken> tokens = marking.getTokensFor(place);
            ArcExpression expression = place.getTokensAsExpression();
            ArrayList<TimedToken> tokensCopy = new ArrayList<TimedToken>(tokens);
            this.storedTokenState.put(place, new Tuple<ArrayList<TimedToken>, ArcExpression>(tokensCopy, expression));
        }
    }

    private void restoreTokenState() {
        for (Place guiPlace : this.tab.currentTemplate().guiModel().getPlaces()) {
            TimedPlaceComponent placeComponent = (TimedPlaceComponent)guiPlace;
            TimedPlace place = placeComponent.underlyingPlace();
            Tuple<List<TimedToken>, ArcExpression> state = this.storedTokenState.get(place);
            if (state == null) continue;
            place.resetNumberOfTokensColor();
            List<TimedToken> tokens = state.value1();
            ArcExpression expression = state.value2();
            if (expression != null && this.containsAllExpression(expression)) {
                HashMap<String, ColorType> colorTypes = new HashMap<String, ColorType>();
                for (ColorType ct : this.tab.network().colorTypes()) {
                    colorTypes.put(ct.getName(), ct);
                }
                ExpressionContext context = new ExpressionContext(null, colorTypes);
                ColorMultiset multiset = expression.eval(context);
                if (multiset != null) {
                    tokens = new ArrayList<TimedToken>(multiset.getTokens(place));
                }
            }
            place.updateTokens(tokens, expression);
            placeComponent.setUnderlyingPlace(place);
        }
        this.activeGuiModel().repaintPlaces();
    }

    public void stepBack() {
        this.tab.getAnimationHistorySidePanel().stepBackwards();
        if (!this.actionHistory.isEmpty()) {
            AnimationHistoryList untimedAnimationHistory;
            String previousInUntimedTrace;
            TAPNNetworkTraceStep lastStep = this.actionHistory.get(this.currentAction);
            if (this.isDisplayingUntimedTrace && lastStep instanceof TAPNNetworkTimedTransitionStep && (previousInUntimedTrace = (untimedAnimationHistory = this.tab.getUntimedAnimationHistory()).getElement(untimedAnimationHistory.getSelectedIndex())).equals(lastStep.toString())) {
                untimedAnimationHistory.stepBackwards();
            }
            --this.currentAction;
            --this.currentMarkingIndex;
            this.updateBindings(this.currentAction + 1);
            this.tab.network().setMarking(this.markings.get(this.currentMarkingIndex));
            this.updateColoredMarking();
            this.activeGuiModel().repaintPlaces();
            this.unhighlightDisabledTransitions();
            this.updateFireableTransitions();
            this.updateAnimationButtonsEnabled();
            this.updateMouseOverInformation();
            this.reportBlockingPlaces();
        }
    }

    public void stepForward() {
        this.tab.getAnimationHistorySidePanel().stepForward();
        if (this.currentAction == this.actionHistory.size() - 1 && this.trace != null) {
            int selectedIndex = this.tab.getAnimationHistorySidePanel().getSelectedIndex();
            int action = this.currentAction;
            int markingIndex = this.currentMarkingIndex;
            TimedTAPNNetworkTrace timedTrace = (TimedTAPNNetworkTrace)this.trace;
            if (timedTrace.getTraceType() == TraceType.EG_DELAY_FOREVER) {
                this.addMarking(new TAPNNetworkTimeDelayStep(BigDecimal.ONE), this.currentMarking().delay(BigDecimal.ONE));
            }
            if (timedTrace.getLoopToIndex() != -1) {
                this.addToTimedTrace(timedTrace.getLoopSteps());
            }
            this.tab.getAnimationHistorySidePanel().setSelectedIndex(selectedIndex);
            this.currentAction = action;
            this.currentMarkingIndex = markingIndex;
        }
        if (this.currentAction < this.actionHistory.size() - 1) {
            AnimationHistoryList untimedAnimationHistory;
            String nextInUntimedTrace;
            TAPNNetworkTraceStep nextStep = this.actionHistory.get(this.currentAction + 1);
            if (this.isDisplayingUntimedTrace && nextStep instanceof TAPNNetworkTimedTransitionStep && (nextInUntimedTrace = (untimedAnimationHistory = this.tab.getUntimedAnimationHistory()).getElement(untimedAnimationHistory.getSelectedIndex() + 1)).equals(nextStep.toString())) {
                untimedAnimationHistory.stepForward();
            }
            ++this.currentAction;
            ++this.currentMarkingIndex;
            this.updateBindings(this.currentAction + 1);
            this.tab.network().setMarking(this.markings.get(this.currentMarkingIndex));
            this.updateColoredMarking();
            this.activeGuiModel().repaintPlaces();
            this.unhighlightDisabledTransitions();
            this.updateFireableTransitions();
            this.activeGuiModel().redrawVisibleTokenLists();
            this.updateAnimationButtonsEnabled();
            this.updateMouseOverInformation();
            this.reportBlockingPlaces();
        }
    }

    private void updateColoredMarking() {
        if (!this.tab.getLens().isColored()) {
            return;
        }
        NetworkMarking marking = this.tab.network().marking();
        Map<TimedArcPetriNet, LocalTimedMarking> markingMap = marking.getMarkingMap();
        for (Template template : this.tab.activeTemplates()) {
            LocalTimedMarking localMarking = markingMap.get(template.model());
            HashMap placesToTokensCopy = new HashMap();
            for (Map.Entry<TimedPlace, List<TimedToken>> entry : localMarking.getPlacesToTokensMap().entrySet()) {
                placesToTokensCopy.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            for (Map.Entry<TimedPlace, List<TimedToken>> entry : marking.getSharedPlacesTokens().entrySet()) {
                placesToTokensCopy.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            for (Place guiPlace : template.guiModel().getPlaces()) {
                TimedPlaceComponent placeComponent = (TimedPlaceComponent)guiPlace;
                TimedPlace place = placeComponent.underlyingPlace();
                place.resetNumberOfTokensColor();
                if (!placesToTokensCopy.containsKey(place) || ((List)placesToTokensCopy.get(place)).isEmpty()) {
                    place.updateTokens(new ArrayList<TimedToken>(), null);
                    placeComponent.setUnderlyingPlace(place);
                    continue;
                }
                List<TimedToken> tokens = (List<TimedToken>)placesToTokensCopy.get(place);
                ArcExpression existingExpression = place.getTokensAsExpression();
                Tuple<List<TimedToken>, ArcExpression> tup = this.rebuildExpressionPreservingAll(tokens, place, existingExpression);
                tokens = tup.value1();
                ArcExpression tokenExpression = tup.value2();
                place.updateTokens(tokens, tokenExpression);
                placeComponent.setUnderlyingPlace(place);
            }
        }
    }

    private Tuple<List<TimedToken>, ArcExpression> rebuildExpressionPreservingAll(List<TimedToken> tokens, TimedPlace place, ArcExpression existingExpression) {
        boolean hasAllExpression = existingExpression != null && this.containsAllExpression(existingExpression);
        Vector<ArcExpression> numberOfExpressions = new Vector<ArcExpression>();
        List<Object> newTokens = new ArrayList();
        if (hasAllExpression && existingExpression instanceof AddExpression) {
            AddExpression addExpr = (AddExpression)existingExpression;
            for (ArcExpression arcExpr : addExpr.getAddExpression()) {
                if (!(arcExpr instanceof NumberOfExpression)) continue;
                NumberOfExpression numOfExpr = (NumberOfExpression)arcExpr;
                Vector<NumberOfExpression> expandedExpressions = this.computeCrossProduct(numOfExpr.getNumberOfExpression());
                numberOfExpressions.addAll(expandedExpressions);
            }
            for (ArcExpression arcExpr : numberOfExpressions) {
                if (!(arcExpr instanceof NumberOfExpression)) continue;
                NumberOfExpression numExpr = (NumberOfExpression)arcExpr;
                for (ColorExpression ce : numExpr.getNumberOfExpression()) {
                    Color color = this.getColorFromExpression(ce, place.getColorType());
                    if (color == null) continue;
                    for (int i = 0; i < numExpr.getNumber(); ++i) {
                        newTokens.add(new TimedToken(place, BigDecimal.ZERO, color));
                    }
                }
            }
        } else {
            newTokens = tokens;
            HashMap<Color, Integer> numberOfMap = new HashMap<Color, Integer>();
            for (TimedToken token : tokens) {
                numberOfMap.merge(token.color(), 1, Integer::sum);
            }
            numberOfMap.entrySet().stream().sorted((e1, e2) -> ((Color)e1.getKey()).toString().compareTo(((Color)e2.getKey()).toString())).forEach(numberOfEntry -> {
                Color color = (Color)numberOfEntry.getKey();
                int number = (Integer)numberOfEntry.getValue();
                Vector<ColorExpression> colorExpressions = new Vector<ColorExpression>();
                if (color.getColorType().equals(ColorType.COLORTYPE_DOT)) {
                    colorExpressions.add(new DotConstantExpression());
                } else if (color.getColorType().isProductColorType()) {
                    ProductType pt = (ProductType)color.getColorType();
                    Vector<Color> subColors = color.getTuple();
                    Vector<ColorExpression> subColorExpressions = new Vector<ColorExpression>();
                    subColorExpressions.addAll(subColors.stream().map(UserOperatorExpression::new).collect(Collectors.toList()));
                    colorExpressions.add(new TupleExpression(subColorExpressions, pt));
                } else {
                    colorExpressions.add(new UserOperatorExpression(color));
                }
                numberOfExpressions.add(new NumberOfExpression(number, colorExpressions));
            });
        }
        return new Tuple<List<TimedToken>, ArcExpression>(newTokens, new AddExpression(numberOfExpressions));
    }

    private Color getColorFromExpression(ColorExpression expr, ColorType expectedType) {
        if (expr instanceof UserOperatorExpression) {
            return ((UserOperatorExpression)expr).getUserOperator();
        }
        if (expr instanceof TupleExpression) {
            TupleExpression tupleExpr = (TupleExpression)expr;
            Vector<Color> components = new Vector<Color>();
            if (expectedType != null && expectedType.isProductColorType()) {
                ProductType pt = (ProductType)expectedType;
                if (pt.getColorTypes().size() != tupleExpr.getColors().size()) {
                    return null;
                }
                int i = 0;
                for (ColorExpression ce : tupleExpr.getColors()) {
                    Color c = this.getColorFromExpression(ce, pt.getColorTypes().get(i));
                    if (c == null) {
                        return null;
                    }
                    components.add(c);
                    ++i;
                }
                return new Color(expectedType, (Integer)0, components);
            }
            for (ColorExpression ce : tupleExpr.getColors()) {
                Color c = this.getColorFromExpression(ce, null);
                if (c == null) {
                    return null;
                }
                components.add(c);
            }
            return new Color(tupleExpr.getColorType(), (Integer)0, components);
        }
        if (expr instanceof DotConstantExpression) {
            return ColorType.COLORTYPE_DOT.getFirstColor();
        }
        return null;
    }

    private Vector<NumberOfExpression> computeCrossProduct(Vector<ColorExpression> colorExprs) {
        Vector<NumberOfExpression> result = new Vector<NumberOfExpression>();
        if (colorExprs.isEmpty()) {
            return result;
        }
        ArrayList<List<ColorExpression>> allOptions = new ArrayList<List<ColorExpression>>();
        for (ColorExpression ce : colorExprs) {
            ArrayList<ColorExpression> options = new ArrayList<ColorExpression>();
            if (ce instanceof AllExpression) {
                AllExpression allExpr = (AllExpression)ce;
                for (Color color : allExpr.getColorType().getColors()) {
                    options.add(new UserOperatorExpression(color));
                }
            } else if (ce instanceof TupleExpression) {
                TupleExpression tupleExpr = (TupleExpression)ce;
                ArrayList<List<ColorExpression>> tupleOptions = new ArrayList<List<ColorExpression>>();
                for (ColorExpression subExpr : tupleExpr.getColors()) {
                    ArrayList<ColorExpression> subOptions = new ArrayList<ColorExpression>();
                    if (subExpr instanceof AllExpression) {
                        AllExpression allExpr = (AllExpression)subExpr;
                        for (Color c2 : allExpr.getColorType().getColors()) {
                            subOptions.add(new UserOperatorExpression(c2));
                        }
                    } else {
                        subOptions.add(subExpr);
                    }
                    tupleOptions.add(subOptions);
                }
                List<Vector<ColorExpression>> list = this.computeCrossProductHelper(tupleOptions);
                for (Vector<ColorExpression> combo : list) {
                    options.add(new TupleExpression(combo, (ProductType)tupleExpr.getColorType()));
                }
            } else {
                options.add(ce);
            }
            allOptions.add(options);
        }
        List<Vector<ColorExpression>> allCombinations = this.computeCrossProductHelper(allOptions);
        for (Vector<ColorExpression> combo : allCombinations) {
            result.add(new NumberOfExpression(1, combo));
        }
        return result;
    }

    private List<Vector<ColorExpression>> computeCrossProductHelper(List<List<ColorExpression>> options) {
        ArrayList<Vector<ColorExpression>> result = new ArrayList<Vector<ColorExpression>>();
        if (options.isEmpty()) {
            result.add(new Vector());
            return result;
        }
        this.computeCrossProductRecursive(options, 0, new Vector<ColorExpression>(), result);
        return result;
    }

    private void computeCrossProductRecursive(List<List<ColorExpression>> options, int index, Vector<ColorExpression> current, List<Vector<ColorExpression>> result) {
        if (index == options.size()) {
            result.add(new Vector<ColorExpression>(current));
            return;
        }
        for (ColorExpression option : options.get(index)) {
            current.add(option);
            this.computeCrossProductRecursive(options, index + 1, current, result);
            current.remove(current.size() - 1);
        }
    }

    private boolean containsAllExpression(Expression expr) {
        block5: {
            block6: {
                block4: {
                    if (expr instanceof AllExpression) {
                        return true;
                    }
                    if (!(expr instanceof AddExpression)) break block4;
                    for (ArcExpression arcExpr : ((AddExpression)expr).getAddExpression()) {
                        if (!this.containsAllExpression(arcExpr)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!(expr instanceof NumberOfExpression)) break block6;
                for (ColorExpression e : ((NumberOfExpression)expr).getNumberOfExpression()) {
                    if (!this.containsAllExpression(e)) continue;
                    return true;
                }
                break block5;
            }
            if (!(expr instanceof TupleExpression)) break block5;
            for (ColorExpression ce : ((TupleExpression)expr).getColors()) {
                if (!this.containsAllExpression(ce)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateBindings(int stepIdx) {
        TAPNNetworkTraceStep step;
        this.resetBindings();
        if (stepIdx < this.actionHistory.size() && stepIdx >= 0 && (step = this.actionHistory.get(stepIdx)).isColoredTransitionStep()) {
            Template template;
            TAPNNetworkColoredTransitionStep coloredStep = (TAPNNetworkColoredTransitionStep)step;
            TimedTransition transition = coloredStep.getTransition();
            JComponent guiTransition = null;
            Iterator<Template> iterator = this.tab.activeTemplates().iterator();
            while (iterator.hasNext() && (guiTransition = (template = iterator.next()).guiModel().getTransitionByName(transition.name())) == null) {
            }
            Map<Variable, Color> bindings = coloredStep.getBindings();
            guiTransition.setToolTipText(ColorBindingParser.createTooltip(bindings));
            this.reloadTooltip((Transition)guiTransition);
        }
    }

    private void resetBindings() {
        for (Template template : this.tab.activeTemplates()) {
            for (Transition guiTransition : template.guiModel().transitions()) {
                guiTransition.setToolTipText(null);
                this.reloadTooltip(guiTransition);
            }
        }
    }

    private void reloadTooltip(Transition transition) {
        boolean mouseOver;
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mousePos, transition);
        boolean bl = mouseOver = transition.contains(mousePos) && transition.isShowing() && transition.isVisible();
        if (mouseOver) {
            ToolTipManager manager = ToolTipManager.sharedInstance();
            long time = System.currentTimeMillis();
            manager.mouseMoved(new MouseEvent(transition, -1, time, 0, mousePos.x, mousePos.y, 0, false));
        }
    }

    public void blinkSelected(String label) {
        Transition t;
        if (label.contains(".")) {
            label = label.split("\\.")[1];
        }
        if ((t = this.activeGuiModel().getTransitionByName(label)) != null) {
            t.blink();
        }
    }

    public void dFireTransition(TimedTransition transition) {
        if (this.tab.getLens().isColored()) {
            this.fireColoredTransition(transition);
            return;
        }
        if (!TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions() || Animator.isUrgentTransitionEnabled()) {
            this.fireTransition(transition);
            return;
        }
        TimeInterval dInterval = transition.getdInterval();
        BigDecimal delayGranularity = this.tab.getDelayEnabledTransitionControl().getValue();
        BigDecimal lowerBound = IntervalOperations.getRatBound(dInterval.lowerBound()).getBound();
        if (!dInterval.isLowerBoundNonStrict() && !dInterval.isIncluded(lowerBound.add(delayGranularity))) {
            while ((delayGranularity = delayGranularity.divide(BigDecimal.TEN)).compareTo(new BigDecimal("0.00001")) >= 0 && !dInterval.isIncluded(lowerBound.add(delayGranularity))) {
            }
        }
        if (delayGranularity.compareTo(new BigDecimal("0.00001")) < 0) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "<html>Due to the limit of only five decimal points in the simulator</br> its not possible to fire the transition</html>");
        } else {
            BigDecimal delay = this.tab.getDelayEnabledTransitionControl().getDelayMode().GetDelay(transition, dInterval, delayGranularity);
            if (delay != null) {
                if (delay.compareTo(BigDecimal.ZERO) != 0 && !this.letTimePass(delay)) {
                    return;
                }
                this.fireTransition(transition);
            }
        }
    }

    private void fireColoredTransition(TimedTransition transition) {
        if (!this.validBindingsMap.containsKey(transition)) {
            return;
        }
        if (this.trace != null && this.trace.isColoredTrace()) {
            if (this.isColoredTransitionEnabled(transition)) {
                TAPNNetworkColoredTransitionStep coloredStep;
                TAPNNetworkTraceStep nextStep;
                if (this.currentAction < this.actionHistory.size() - 1 && (nextStep = this.actionHistory.get(this.currentAction + 1)).isColoredTransitionStep() && (coloredStep = (TAPNNetworkColoredTransitionStep)nextStep).getTransition().equals(transition)) {
                    this.stepForward();
                    return;
                }
                int fireTransition = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "Are you sure you want to fire a transition which does not follow the colored trace?\nFiring this transition will discard the colored trace and revert to standard simulation.", "Discarding Colored Trace", 0);
                if (fireTransition == 1) {
                    return;
                }
                this.removeSetTrace(false);
            } else {
                return;
            }
        }
        if (this.isUsingInteractiveEngine) {
            HashMap<Variable, Color> bindings = new HashMap();
            List<Map<Variable, Color>> validBindings = this.validBindingsMap.get(transition);
            if (SimulationControl.getInstance().randomSimulation() && !validBindings.isEmpty()) {
                Random random = new Random();
                int randomIndex = random.nextInt(validBindings.size());
                bindings = validBindings.get(randomIndex);
            } else if (validBindings.size() == 1) {
                bindings = this.validBindingsMap.get(transition).get(0);
            } else if (!validBindings.isEmpty() && (bindings = ColoredBindingSelectionDialog.showDialog(transition, validBindings)) == null) {
                return;
            }
            if (!this.clearStepsForward()) {
                return;
            }
            NetworkMarking newMarking = this.interactiveEngine.sendTransition(transition, bindings);
            this.addMarking(new TAPNNetworkColoredTransitionStep(transition, bindings, newMarking), newMarking);
            this.updateColoredMarking();
            this.activeGuiModel().repaintPlaces();
            this.unhighlightDisabledTransitions();
            this.updateFireableTransitions();
            this.updateAnimationButtonsEnabled();
        }
    }

    private void fireTransition(TimedTransition transition) {
        AnimationHistoryList untimedAnimationHistory;
        if (!this.clearStepsForward()) {
            return;
        }
        Tuple<TimedMarking, List<TimedToken>> next = null;
        List<TimedToken> tokensToConsume = null;
        try {
            if (this.getFiringmode() != null) {
                next = this.currentMarking().fireTransition(transition, this.getFiringmode());
            } else {
                tokensToConsume = this.getTokensToConsume(transition);
                if (tokensToConsume == null) {
                    return;
                }
                next = new Tuple<TimedMarking, List<TimedToken>>(this.currentMarking().fireTransition(transition, (List)tokensToConsume), tokensToConsume);
            }
        }
        catch (RequireException e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There was an error firing the transition. Reason: " + e.getMessage(), "Error", 0);
            return;
        }
        if (this.isDisplayingUntimedTrace && (untimedAnimationHistory = this.tab.getUntimedAnimationHistory()).isStepForwardAllowed()) {
            String nextFromUntimedTrace = untimedAnimationHistory.getElement(untimedAnimationHistory.getSelectedIndex() + 1);
            if (nextFromUntimedTrace.equals(transition.model().name() + "." + transition.name()) || transition.isShared() && nextFromUntimedTrace.equals(transition.name())) {
                untimedAnimationHistory.stepForward();
            } else {
                int fireTransition = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "Are you sure you want to fire a transition which does not follow the untimed trace?\nFiring this transition will discard the untimed trace and revert to standard simulation.", "Discarding Untimed Trace", 0);
                if (fireTransition == 1) {
                    return;
                }
                this.removeSetTrace(false);
            }
        }
        this.tab.network().setMarking(next.value1());
        this.activeGuiModel().repaintPlaces();
        this.unhighlightDisabledTransitions();
        this.updateFireableTransitions();
        this.addMarking(new TAPNNetworkTimedTransitionStep(transition, next.value2()), (NetworkMarking)next.value1());
        this.updateAnimationButtonsEnabled();
        this.updateMouseOverInformation();
        this.reportBlockingPlaces();
    }

    public boolean letTimePass(BigDecimal delay) {
        if (!this.clearStepsForward()) {
            return false;
        }
        boolean result = false;
        if (delay.compareTo(new BigDecimal(0)) == 0 || this.currentMarking().isDelayPossible(delay) && !isUrgentTransitionEnabled) {
            NetworkMarking delayedMarking = this.currentMarking().delay(delay);
            this.tab.network().setMarking(delayedMarking);
            this.addMarking(new TAPNNetworkTimeDelayStep(delay), delayedMarking);
            result = true;
        }
        this.activeGuiModel().repaintPlaces();
        this.unhighlightDisabledTransitions();
        this.updateFireableTransitions();
        this.updateAnimationButtonsEnabled();
        this.updateMouseOverInformation();
        this.reportBlockingPlaces();
        return result;
    }

    public void reportBlockingPlaces() {
        try {
            BigDecimal delay = this.tab.getAnimationController().getCurrentDelay();
            if (isUrgentTransitionEnabled && !delay.equals(BigDecimal.ZERO)) {
                this.tab.getAnimationController().getOkButton().setEnabled(false);
                StringBuilder sb = new StringBuilder();
                sb.append("<html>Time delay is disabled due to the<br /> following enabled urgent transitions:<br /><br />");
                for (Template template : this.tab.activeTemplates()) {
                    for (Transition t : template.guiModel().transitions()) {
                        if (!t.isTransitionEnabled() || !template.model().getTransitionByName(t.getName()).isUrgent()) continue;
                        sb.append(String.valueOf(template) + "." + t.getName() + "<br />");
                    }
                }
                sb.append("</html>");
                this.tab.getAnimationController().getOkButton().setToolTipText(sb.toString());
                return;
            }
            if (delay.compareTo(new BigDecimal(0)) < 0) {
                this.tab.getAnimationController().getOkButton().setEnabled(false);
                this.tab.getAnimationController().getOkButton().setToolTipText("Time delay is possible only for nonnegative rational numbers");
            } else {
                List<TimedPlace> blockingPlaces = this.currentMarking().getBlockingPlaces(delay);
                if (blockingPlaces.size() == 0) {
                    this.tab.getAnimationController().getOkButton().setEnabled(true);
                    this.tab.getAnimationController().getOkButton().setToolTipText("Press to add the delay");
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>Time delay of " + String.valueOf(delay) + " time unit(s) is disabled due to <br /> age invariants in the following places:<br /><br />");
                    for (TimedPlace t : blockingPlaces) {
                        sb.append(t.toString() + "<br />");
                    }
                    sb.append("</html>");
                    this.tab.getAnimationController().getOkButton().setEnabled(false);
                    this.tab.getAnimationController().getOkButton().setToolTipText(sb.toString());
                }
            }
        }
        catch (NumberFormatException | ParseException e) {
            this.tab.getAnimationController().getOkButton().setEnabled(false);
            this.tab.getAnimationController().getOkButton().setToolTipText("The text in the input field is not a number");
        }
    }

    private DataLayer activeGuiModel() {
        return this.tab.currentTemplate().guiModel();
    }

    private void resethistory() {
        this.actionHistory.clear();
        this.markings.clear();
        this.currentAction = -1;
        this.currentMarkingIndex = 0;
        this.tab.getAnimationHistorySidePanel().reset(this.tab.getLens().isColored());
        if (this.tab.getUntimedAnimationHistory() != null) {
            this.tab.getUntimedAnimationHistory().reset(this.tab.getLens().isColored());
        }
    }

    private void resetHistoryForTracechange() {
        this.actionHistory.clear();
        this.currentAction = -1;
        this.currentMarkingIndex = 0;
        this.tab.getAnimationHistorySidePanel().reset(this.tab.getLens().isColored());
        if (this.tab.getUntimedAnimationHistory() != null) {
            this.tab.getUntimedAnimationHistory().reset(this.tab.getLens().isColored());
        }
    }

    public FiringMode getFiringmode() {
        return this.firingmode;
    }

    private void removeStoredActions(int startWith) {
        int lastIndex = this.actionHistory.size() - 1;
        for (int i = startWith; i <= lastIndex; ++i) {
            this.removeLastHistoryStep();
        }
    }

    private void addMarking(TAPNNetworkTraceStep action, NetworkMarking marking) {
        if (this.currentAction < this.actionHistory.size() - 1) {
            this.removeStoredActions(this.currentAction + 1);
        }
        this.tab.network().setMarking(marking);
        this.tab.getAnimationHistorySidePanel().addHistoryItem(action.toString(), this.tab.getLens().isColored());
        if (action.isColoredTransitionStep()) {
            TAPNNetworkColoredTransitionStep coloredStep = (TAPNNetworkColoredTransitionStep)action;
            Map<Variable, Color> bindings = coloredStep.getBindings();
            this.tab.getAnimationHistorySidePanel().setTooltipForSelectedItem(ColorBindingParser.createTooltip(bindings));
        } else if (action.isTimedTransitionStep()) {
            TAPNNetworkTimedTransitionStep timedStep = (TAPNNetworkTimedTransitionStep)action;
            TimedTransition transition = timedStep.getTransition();
            JComponent guiTransition = null;
            for (Template template : this.tab.activeTemplates()) {
                if (!template.model().equals(transition.model())) continue;
                guiTransition = template.guiModel().getTransitionByName(transition.name());
                break;
            }
            if (guiTransition != null) {
                this.tab.getAnimationHistorySidePanel().setTooltipForSelectedItem(guiTransition.getToolTipText());
            }
        }
        this.actionHistory.add(action);
        this.markings.add(marking);
        ++this.currentAction;
        ++this.currentMarkingIndex;
    }

    private void removeLastHistoryStep() {
        this.actionHistory.remove(this.actionHistory.size() - 1);
        this.markings.remove(this.markings.size() - 1);
    }

    public void setFiringmode(String t) {
        switch (t) {
            case "Random": {
                this.firingmode = new RandomFiringMode();
                break;
            }
            case "Youngest": {
                this.firingmode = new YoungestFiringMode();
                break;
            }
            case "Oldest": {
                this.firingmode = new OldestFiringMode();
                break;
            }
            case "Manual": {
                this.firingmode = null;
                break;
            }
            default: {
                System.err.println("Illegal firing mode mode: " + t + " not found.");
            }
        }
        this.tab.getAnimationController().updateFiringModeComboBox();
        this.tab.getAnimationController().setToolTipText("Select a method for choosing tokens during transition firing");
    }

    public boolean hasNonZeroTrance() {
        return this.tab.getAnimationHistorySidePanel().getListModel().size() > 1;
    }

    private FillListStatus fillList(TimedTransition transition, List<TimedToken> listToFill) {
        List<TimedToken> elligibleTokens;
        for (TimedInputArc timedInputArc : transition.getInputArcs()) {
            elligibleTokens = timedInputArc.getElligibleTokens();
            if (elligibleTokens.size() < timedInputArc.getWeight().value()) {
                return FillListStatus.lessThanWeight;
            }
            if (elligibleTokens.size() == timedInputArc.getWeight().value()) {
                listToFill.addAll(elligibleTokens);
                continue;
            }
            return FillListStatus.moreThanWeight;
        }
        for (TransportArc transportArc : transition.getTransportArcsGoingThrough()) {
            elligibleTokens = transportArc.getElligibleTokens();
            if (elligibleTokens.size() < transportArc.getWeight().value()) {
                return FillListStatus.lessThanWeight;
            }
            if (elligibleTokens.size() == transportArc.getWeight().value()) {
                listToFill.addAll(elligibleTokens);
                continue;
            }
            return FillListStatus.moreThanWeight;
        }
        return FillListStatus.weight;
    }

    private List<TimedToken> getTokensToConsume(TimedTransition transition) {
        ArrayList<TimedToken> result = new ArrayList<TimedToken>();
        boolean userShouldChoose = false;
        if (transition.isShared()) {
            for (TimedTransition t : transition.sharedTransition().transitions()) {
                FillListStatus status = this.fillList(t, result);
                if (status == FillListStatus.lessThanWeight) {
                    return null;
                }
                if (status != FillListStatus.moreThanWeight) continue;
                userShouldChoose = true;
                break;
            }
        } else {
            FillListStatus status = this.fillList(transition, result);
            if (status == FillListStatus.lessThanWeight) {
                return null;
            }
            if (status == FillListStatus.moreThanWeight) {
                userShouldChoose = true;
            }
        }
        if (userShouldChoose) {
            return this.showSelectSimulatorDialogue(transition);
        }
        return result;
    }

    private List<TimedToken> showSelectSimulatorDialogue(TimedTransition transition) {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Select Tokens", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        AnimationTokenSelectDialog animationSelectmodeDialog = new AnimationTokenSelectDialog(transition);
        contentPane.add(animationSelectmodeDialog);
        guiDialog.setResizable(true);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
        return animationSelectmodeDialog.getTokens();
    }

    public void resetForTraceChange() {
        this.resetHistoryForTracechange();
        this.removeSetTrace(false);
        this.markings.clear();
        this.markings.add(this.initialMarking);
        this.currentAction = -1;
    }

    public void reset(boolean keepInitial) {
        this.resethistory();
        this.removeSetTrace(false);
        if (keepInitial && this.initialMarking != null) {
            this.markings.add(this.initialMarking);
            this.tab.network().setMarking(this.initialMarking);
            this.currentAction = -1;
            this.updateFireableTransitions();
        }
        if (this.traceMap != null) {
            this.tab.getAnimationController().resetTraceBox(true);
        }
    }

    public void resetTraceBox() {
        if (this.tab.getAnimationController().getTraceBox().getModel().getSize() > 0) {
            this.tab.getAnimationController().resetTraceBox(true);
        }
    }

    private boolean removeSetTrace(boolean askUser) {
        int answer;
        if (askUser && this.isShowingTrace() && (answer = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "You are about to remove the current trace.", "Removing Trace", 2, 2)) != 0) {
            return false;
        }
        if (this.isDisplayingUntimedTrace) {
            this.tab.removeAbstractAnimationPane();
        }
        this.isDisplayingUntimedTrace = false;
        this.trace = null;
        return true;
    }

    public TAPNNetworkTrace getTrace() {
        return this.trace;
    }

    private boolean clearStepsForward() {
        boolean answer = true;
        if (!this.isDisplayingUntimedTrace) {
            answer = this.removeSetTrace(true);
        }
        if (answer) {
            this.tab.getAnimationHistorySidePanel().clearStepsForward(this.tab.getLens().isColored());
        } else if (SimulationControl.getInstance().isRunning()) {
            SimulationControl.stopSimulation();
        }
        return answer;
    }

    private boolean isShowingTrace() {
        return this.isDisplayingUntimedTrace || this.trace != null;
    }

    public ArrayList<TAPNNetworkTraceStep> getActionHistory() {
        return this.actionHistory;
    }

    private void setEnabledStepbackwardAction(boolean b) {
        this.stepbackwardAction.setEnabled(b);
    }

    private void setEnabledStepforwardAction(boolean b) {
        this.stepforwardAction.setEnabled(b);
    }

    public void updateAnimationButtonsEnabled() {
        AnimationHistoryList animationHistory = this.tab.getAnimationHistorySidePanel();
        this.setEnabledStepforwardAction(animationHistory.isStepForwardAllowed());
        this.setEnabledStepbackwardAction(animationHistory.isStepBackAllowed());
    }

    private void updateMouseOverInformation() {
        for (Place p : this.tab.getModel().getPlaces()) {
            if (!((TimedPlaceComponent)p).isAgeOfTokensShown()) continue;
            ((TimedPlaceComponent)p).showAgeOfTokens(true);
        }
    }

    static enum FillListStatus {
        lessThanWeight,
        weight,
        moreThanWeight;

    }
}

