/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.animation.AnimationHistoryList;
import pipe.gui.petrinet.animation.Animator;

public class AnimationHistorySidePanel
extends JPanel {
    private AnimationHistoryList animBox;
    private Animator animator;

    public AnimationHistorySidePanel(Animator animator) {
        this.animator = animator;
        this.initComponents();
    }

    @Deprecated
    public AnimationHistoryList getAnimationHistoryList() {
        return this.animBox;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.animBox = new AnimationHistoryList();
        this.animBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int selected = AnimationHistorySidePanel.this.animBox.getSelectedIndex();
                    int clicked = AnimationHistorySidePanel.this.animBox.locationToIndex(e.getPoint());
                    if (clicked != -1) {
                        int steps = clicked - selected;
                        if (steps < 0) {
                            for (int i = 0; i < Math.abs(steps); ++i) {
                                AnimationHistorySidePanel.this.animator.stepBack();
                            }
                        } else {
                            for (int i = 0; i < Math.abs(steps); ++i) {
                                AnimationHistorySidePanel.this.animator.stepForward();
                            }
                        }
                        AnimationHistorySidePanel.this.animator.blinkSelected((String)AnimationHistorySidePanel.this.animBox.getSelectedValue());
                    }
                }
                TAPAALGUI.getAppGui().requestFocus();
            }
        });
        JScrollPane animationHistoryScrollPane = new JScrollPane(this.animBox);
        animationHistoryScrollPane.setMinimumSize(new Dimension(animationHistoryScrollPane.getMinimumSize().width, animationHistoryScrollPane.getMinimumSize().height + 20));
        this.add((Component)animationHistoryScrollPane, "Center");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Simulation History"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    }
}

