/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.action;

import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class GuiAction
extends AbstractAction {
    public GuiAction(String name, String tooltip) {
        this(name, tooltip, (KeyStroke)null);
    }

    public GuiAction(String name, String tooltip, String keystroke) {
        super(name);
        URL iconURL = null;
        iconURL = Thread.currentThread().getContextClassLoader().getResource("Images/" + name + ".png");
        if (iconURL != null) {
            this.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        if (tooltip != null) {
            this.putValue("ShortDescription", tooltip);
        }
        if (keystroke != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keystroke));
        }
    }

    private void setAsToggleable(boolean toggleable) {
        if (toggleable) {
            this.putValue("SwingSelectedKey", false);
        }
    }

    public GuiAction(String name, String tooltip, String keystroke, boolean toggleable) {
        this(name, tooltip, keystroke);
        this.setAsToggleable(toggleable);
    }

    public GuiAction(String name, String tooltip, KeyStroke keystroke, boolean toggleable) {
        this(name, tooltip, keystroke);
        this.setAsToggleable(toggleable);
    }

    public GuiAction(String name, String tooltip, boolean toggleable) {
        this(name, tooltip);
        this.setAsToggleable(toggleable);
    }

    public GuiAction(String name, String tooltip, KeyStroke keyStroke) {
        super(name);
        URL iconURL = null;
        iconURL = Thread.currentThread().getContextClassLoader().getResource("Images/" + name + ".png");
        if (iconURL != null) {
            this.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        if (tooltip != null) {
            this.putValue("ShortDescription", tooltip);
        }
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
    }

    public boolean isSelected() {
        Boolean b = (Boolean)this.getValue("SwingSelectedKey");
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setSelected(boolean selected) {
        if (this.getValue("SwingSelectedKey") != null) {
            this.putValue("SwingSelectedKey", selected);
        }
    }

    public void setName(String newName) {
        this.putValue("Name", newName);
    }

    public void setTooltip(String newTooltip) {
        this.putValue("ShortDescription", newTooltip);
    }
}

