/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet;

import dk.aau.cs.TCTL.Parsing.ParseException;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.ModelLoader;
import dk.aau.cs.io.PNMLoader;
import dk.aau.cs.io.TimedArcPetriNetNetworkWriter;
import dk.aau.cs.io.TraceImportExport;
import dk.aau.cs.io.queries.SUMOQueryLoader;
import dk.aau.cs.io.queries.XMLQueryLoader;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeListener;
import net.tapaal.Preferences;
import net.tapaal.copypaste.CopyPastImportExport;
import net.tapaal.gui.DrawingSurfaceManager.AbstractDrawingSurfaceManager;
import net.tapaal.gui.GuiFrameActions;
import net.tapaal.gui.GuiFrameControllerActions;
import net.tapaal.gui.SafeGuiFrameActions;
import net.tapaal.gui.TabActions;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.TabTransformer;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.animation.DelayEnabledTransitionControl;
import net.tapaal.gui.petrinet.animation.TransitionFiringComponent;
import net.tapaal.gui.petrinet.dialog.ColoredSimulationDialog;
import net.tapaal.gui.petrinet.dialog.NameVisibilityPanel;
import net.tapaal.gui.petrinet.dialog.StatisticsPanel;
import net.tapaal.gui.petrinet.dialog.WorkflowDialog;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.editor.TemplateExplorer;
import net.tapaal.gui.petrinet.model.GuiModelManager;
import net.tapaal.gui.petrinet.model.ModelViolation;
import net.tapaal.gui.petrinet.model.Result;
import net.tapaal.gui.petrinet.smartdraw.Quadtree;
import net.tapaal.gui.petrinet.undo.ChangeSpacingEditCommand;
import net.tapaal.gui.petrinet.undo.MovePetriNetObjectCommand;
import net.tapaal.gui.petrinet.verification.EngineSupportOptions;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UPPAALBroadcastDegree2Options;
import net.tapaal.gui.petrinet.verification.UPPAALBroadcastOptions;
import net.tapaal.gui.petrinet.verification.UPPAALCombiOptions;
import net.tapaal.gui.petrinet.verification.UPPAALOptimizedStandardOptions;
import net.tapaal.gui.petrinet.verification.UPPAALStandardOptions;
import net.tapaal.gui.petrinet.verification.VerifyDTAPNEngineOptions;
import net.tapaal.gui.petrinet.verification.VerifyPNEngineOptions;
import net.tapaal.gui.petrinet.verification.VerifyTAPNEngineOptions;
import net.tapaal.gui.petrinet.widgets.QueryPane;
import net.tapaal.gui.swingcomponents.BugHandledJXMultisplitPane;
import net.tapaal.helpers.Reference.MutableReference;
import net.tapaal.swinghelpers.JSplitPaneFix;
import org.jdesktop.swingx.MultiSplitLayout;
import pipe.gui.Constants;
import pipe.gui.GuiFrame;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.Export;
import pipe.gui.petrinet.SearchBar;
import pipe.gui.petrinet.Searcher;
import pipe.gui.petrinet.action.GuiAction;
import pipe.gui.petrinet.animation.AnimationControlSidePanel;
import pipe.gui.petrinet.animation.AnimationHistoryList;
import pipe.gui.petrinet.animation.AnimationHistorySidePanel;
import pipe.gui.petrinet.animation.Animator;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public class PetriNetTab
extends JSplitPane
implements TabActions {
    final AbstractDrawingSurfaceManager notingManager = new AbstractDrawingSurfaceManager(){

        @Override
        public void registerEvents() {
        }
    };
    private final MutableReference<GuiFrameControllerActions> guiFrameControllerActions = new MutableReference();
    public final TAPNLens lens;
    private final TimedArcPetriNetNetwork tapnNetwork;
    private final HashMap<TimedArcPetriNet, DataLayer> guiModels = new HashMap();
    public final HashMap<DataLayer, TimedArcPetriNet> guiModelToModel = new HashMap();
    private final HashMap<TimedArcPetriNet, Zoomer> zoomLevels = new HashMap();
    private boolean alreadyFitToScreen;
    final UndoManager undoManager = new UndoManager(this);
    private final MutableReference<GuiFrameActions> app = new MutableReference();
    private final MutableReference<SafeGuiFrameActions> safeApp = new MutableReference();
    final MutableReference<AbstractDrawingSurfaceManager> managerRef = new MutableReference<AbstractDrawingSurfaceManager>(this.notingManager);
    public final GuiModelManager guiModelManager = new GuiModelManager(this);
    private final Animator animator = new Animator(this);
    private boolean netChanged = false;
    private final NameGenerator nameGenerator = new NameGenerator();
    private final HashMap<TimedArcPetriNet, Boolean> hasPositionalInfos = new HashMap();
    private final JScrollPane drawingSurfaceScroller;
    private JScrollPane editorSplitPaneScroller;
    private JScrollPane animatorSplitPaneScroller;
    private final DrawingSurfaceImpl drawingSurface;
    private File appFile;
    private final JPanel drawingSurfaceDummy;
    private BugHandledJXMultisplitPane editorSplitPane;
    private static MultiSplitLayout.Split editorModelroot = null;
    private static MultiSplitLayout.Split simulatorModelRoot = null;
    private QueryPane queries;
    private ConstantsPane constantsPanel;
    private TemplateExplorer templateExplorer;
    private SharedPlacesAndTransitionsPanel sharedPTPanel;
    private static final String constantsName = "constants";
    private static final String queriesName = "queries";
    private static final String templateExplorerName = "templateExplorer";
    private static final String sharedPTName = "sharedPT";
    private AnimationControlSidePanel animControllerBox;
    private AnimationHistorySidePanel animationHistorySidePanel;
    private AnimationHistoryList abstractAnimationPane = null;
    private JPanel animationControlsPanel;
    private TransitionFiringComponent transitionFiring;
    private static final String transitionFiringName = "enabledTransitions";
    private static final String animControlName = "animControl";
    private JSplitPane animationHistorySplitter;
    private BugHandledJXMultisplitPane animatorSplitPane;
    private Integer selectedTemplate = 0;
    private Boolean selectedTemplateWasActive = false;
    private WorkflowDialog workflowDialog = null;
    private Boolean showNamesOption = null;
    private Boolean isSelectedComponentOption = null;
    private Boolean isPlaceOption = null;
    private Boolean isTransitionOption = null;
    private int newNameCounter = 1;
    String initialName = "";
    private boolean animationmode = false;
    private final GuiAction selectAction = new GuiAction("Select", "Select components (S)", "S", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.SELECT);
        }
    };
    private final GuiAction annotationAction = new GuiAction("Annotation", "Add an annotation (N)", "N", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.ANNOTATION);
        }
    };
    private final GuiAction inhibarcAction = new GuiAction("Inhibitor arc", "Add an inhibitor arc (I)", "I", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.INHIBITOR_ARC);
        }
    };
    private final GuiAction transAction = new GuiAction("Transition", "Add a transition (T)", "T", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.TRANSITION);
        }
    };
    private final GuiAction urgentTransAction = new GuiAction("Urgent transition", "Add an urgent transition (Y)", "Y", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.URGENT_TRANSITION);
        }
    };
    private final GuiAction uncontrollableTransAction = new GuiAction("Uncontrollable transition", "Add an uncontrollable transition (L)", "L", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.UNCONTROLLABLE_TRANSITION);
        }
    };
    private final GuiAction uncontrollableUrgentTransAction = new GuiAction("Uncontrollable urgent transition", "Add an uncontrollable urgent transition (O)", "O", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.URGENT_UNCONTROLLABLE_TRANSITION);
        }
    };
    private final GuiAction tokenAction = new GuiAction("Add token", "Add a token (+)", "typed +", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.ADD_TOKEN);
        }
    };
    private final GuiAction deleteTokenAction = new GuiAction("Delete token", "Delete a token (-)", "typed -", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.REMOVE_TOKEN);
        }
    };
    private final GuiAction timedPlaceAction = new GuiAction("Place", "Add a place (P)", "P", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.PLACE);
        }
    };
    private final GuiAction timedArcAction = new GuiAction("Arc", "Add an arc (A)", "A", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.ARC);
        }
    };
    private final GuiAction transportArcAction = new GuiAction("Transport arc", "Add a transport arc (R)", "R", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.setMode(DrawTool.TRANSPORT_ARC);
        }
    };
    private final GuiAction toggleUncontrollableAction = new GuiAction("Toggle uncontrollable transition", "Toggle between control/environment transition", "E", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.guiModelManager.toggleUncontrollableTrans();
        }
    };
    private final GuiAction toggleUrgentAction = new GuiAction("Toggle urgent transition", "Toggle between urgent/non-urgent transition", "U", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.guiModelManager.toggleUrgentTrans();
        }
    };
    private final GuiAction timeAction = new GuiAction("Delay one time unit", "Let time pass one time unit", "W"){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.getAnimator().letTimePass(BigDecimal.ONE);
        }
    };
    private final GuiAction delayFireAction = new GuiAction("Delay and fire", "Delay and fire selected transition", "F"){

        @Override
        public void actionPerformed(ActionEvent e) {
            PetriNetTab.this.getTransitionFiringComponent().fireSelectedTransition();
        }
    };
    private final GuiAction unfoldTabAction = new GuiAction("Unfold net", "Unfold the colors in the tab"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColoredSimulationDialog.showUnfoldDialog(PetriNetTab.this);
        }
    };
    public static final String textforDrawing = "Drawing Mode: Click on a button to start adding components to the Editor";
    public static final String textforTAPNPlace = "Place Mode: Right click on a place to see menu options ";
    public static final String textforTransition = "Transition Mode: Right click on a transition to see menu options [Mouse wheel -> rotate]";
    public static final String textforUncontrollableTrans = "Uncontrollable Transition Mode: Right click on a transition to see menu options [Mouse wheel -> rotate]";
    public static final String textforAddtoken = "Add Token Mode: Click on a place to add a token";
    public static final String textforDeltoken = "Delete Token Mode: Click on a place to delete a token ";
    public static final String textforAnimation = "Simulation Mode: Red transitions are enabled, click a transition to fire it";
    public static final String textforArc = "Arc Mode: Right click on an arc to see menu options ";
    public static final String textforTransportArc = "Transport Arc Mode: Right click on an arc to see menu options ";
    public static final String textforInhibArc = "Inhibitor Mode: Right click on an arc to see menu options ";
    public static final String textforMove = "Select Mode: Click/drag to select objects; drag to move them";
    public static final String textforAnnotation = "Annotation Mode: Right click on an annotation to see menu options; double click to edit";
    public static final String textforDrag = "Drag Mode";

    public void setGuiFrameControllerActions(GuiFrameControllerActions guiFrameControllerActions) {
        this.guiFrameControllerActions.setReference(guiFrameControllerActions);
    }

    @Override
    public boolean getNetChanged() {
        return this.netChanged;
    }

    public void setNetChanged(boolean _netChanged) {
        this.netChanged = _netChanged;
    }

    public NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public static PetriNetTab createNewTabFromInputStream(InputStream file, String name) throws Exception {
        try {
            ModelLoader loader = new ModelLoader();
            LoadedModel loadedModel = loader.load(file);
            if (loadedModel == null) {
                throw new Exception("Could not open the selected file, as it does not have the correct format.");
            }
            if (loadedModel.getMessages().size() != 0) {
                new Thread(() -> {
                    TAPAALGUI.getAppGui().setCursor(Cursor.getPredefinedCursor(0));
                    StringBuilder message = new StringBuilder("While loading the net we found one or more warnings: \n\n");
                    for (String s : loadedModel.getMessages()) {
                        message.append(s).append("\n\n");
                    }
                    new MessengerImpl().displayInfoMessage(message.toString(), "Warning");
                }).start();
            }
            PetriNetTab tab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), loadedModel.getLens());
            PetriNetTab.checkQueries(tab);
            tab.setInitialName(name);
            tab.selectFirstElements();
            tab.setFile(null);
            return tab;
        }
        catch (ParseException e) {
            throw new Exception("TAPAAL encountered an error while loading the file: " + name + "\n\nPossible explanations:\n  - " + e.getMessage(), e);
        }
    }

    public static TAPNLens getFileLens(InputStream file) throws Exception {
        ModelLoader loader = new ModelLoader();
        return loader.loadLens(file);
    }

    /*
     * WARNING - void declaration
     */
    public static void checkQueries(PetriNetTab tab) {
        ArrayList<void> queriesToRemove = new ArrayList<void>();
        boolean gameChanged = false;
        VerifyTAPNEngineOptions verifyTAPNOptions = new VerifyTAPNEngineOptions();
        UPPAALCombiOptions UPPAALCombiOptions2 = new UPPAALCombiOptions();
        UPPAALOptimizedStandardOptions UPPAALOptimizedStandardOptions2 = new UPPAALOptimizedStandardOptions();
        UPPAALStandardOptions UPPAALStandardOptions2 = new UPPAALStandardOptions();
        UPPAALBroadcastOptions UPPAALBroadcastOptions2 = new UPPAALBroadcastOptions();
        UPPAALBroadcastDegree2Options UPPAALBroadcastDegree2Options2 = new UPPAALBroadcastDegree2Options();
        VerifyDTAPNEngineOptions verifyDTAPNOptions = new VerifyDTAPNEngineOptions();
        VerifyPNEngineOptions verifyPNOptions = new VerifyPNEngineOptions();
        EngineSupportOptions[] engineSupportOptions = new EngineSupportOptions[]{verifyDTAPNOptions, verifyTAPNOptions, UPPAALCombiOptions2, UPPAALOptimizedStandardOptions2, UPPAALStandardOptions2, UPPAALBroadcastOptions2, UPPAALBroadcastDegree2Options2, verifyPNOptions};
        TimedArcPetriNetNetwork net = tab.network();
        for (TAPNQuery tAPNQuery : tab.queries()) {
            void var14_14;
            boolean bl = tAPNQuery.getCategory() == TAPNQuery.QueryCategory.SMC;
            boolean[] queryOptions = new boolean[]{tAPNQuery.getTraceOption() == TAPNQuery.TraceOption.FASTEST, tAPNQuery.getProperty() instanceof TCTLDeadlockNode && (tAPNQuery.getProperty() instanceof TCTLEFNode || tAPNQuery.getProperty() instanceof TCTLAGNode) && net.getHighestNetDegree() <= 2, tAPNQuery.getProperty() instanceof TCTLDeadlockNode && (tAPNQuery.getProperty() instanceof TCTLEGNode || tAPNQuery.getProperty() instanceof TCTLAFNode), tAPNQuery.getProperty() instanceof TCTLDeadlockNode && net.hasInhibitorArcs(), net.hasWeights(), net.hasInhibitorArcs(), net.hasUrgentTransitions(), tAPNQuery.getProperty() instanceof TCTLEGNode || tAPNQuery.getProperty() instanceof TCTLAFNode, !net.isNonStrict(), tab.lens.isTimed(), tAPNQuery.getProperty() instanceof TCTLDeadlockNode && net.getHighestNetDegree() > 2, tab.lens.isGame(), (tAPNQuery.getProperty() instanceof TCTLEGNode || tAPNQuery.getProperty() instanceof TCTLAFNode) && net.getHighestNetDegree() > 2, tAPNQuery.hasUntimedOnlyProperties(), tab.lens.isColored(), tab.lens.isColored() && !tab.lens.isTimed(), bl};
            boolean hasEngine = tab.checkCurrentEngine(tAPNQuery.getReductionOption(), queryOptions);
            if (!hasEngine) {
                for (EngineSupportOptions engine : engineSupportOptions) {
                    if (!engine.areOptionsSupported(queryOptions)) continue;
                    TAPNQuery tAPNQuery2 = tab.setQueryEngine(tAPNQuery, engine);
                    hasEngine = true;
                    break;
                }
            }
            if (!hasEngine) {
                queriesToRemove.add(var14_14);
                tab.removeQuery((TAPNQuery)var14_14);
                continue;
            }
            if (tab.lens.isGame()) {
                if (var14_14.getProperty() instanceof TCTLEFNode || var14_14.getProperty() instanceof TCTLEGNode) {
                    queriesToRemove.add(var14_14);
                    tab.removeQuery((TAPNQuery)var14_14);
                }
                if (var14_14.getSearchOption().equals((Object)TAPNQuery.SearchOption.HEURISTIC)) {
                    var14_14.setSearchOption(TAPNQuery.SearchOption.DFS);
                    gameChanged = true;
                }
                if (!var14_14.useGCD() && !var14_14.useTimeDarts() && !var14_14.getTraceOption().equals((Object)TAPNQuery.TraceOption.FASTEST) && !var14_14.isOverApproximationEnabled() && !var14_14.isUnderApproximationEnabled()) continue;
                var14_14.setUseGCD(false);
                var14_14.setUseTimeDarts(false);
                var14_14.setTraceOption(TAPNQuery.TraceOption.NONE);
                var14_14.setUseOverApproximationEnabled(false);
                var14_14.setUseUnderApproximationEnabled(false);
                gameChanged = true;
                continue;
            }
            if (!tab.lens.isTimed()) {
                var14_14.setReductionOption(ReductionOption.VerifyPN);
                var14_14.setUseOverApproximationEnabled(false);
                var14_14.setUseUnderApproximationEnabled(false);
                if (var14_14.getCategory() != TAPNQuery.QueryCategory.Default) continue;
                var14_14.setCategory(TAPNQuery.QueryCategory.CTL);
                continue;
            }
            if (var14_14.getCategory() != TAPNQuery.QueryCategory.LTL) continue;
            queriesToRemove.add(var14_14);
            tab.removeQuery((TAPNQuery)var14_14);
        }
        StringBuilder message = new StringBuilder();
        if (!queriesToRemove.isEmpty()) {
            message = new StringBuilder("The following queries will be removed in the conversion:");
            for (TAPNQuery tAPNQuery : queriesToRemove) {
                message.append("\n").append(tAPNQuery.getName());
            }
        }
        if (gameChanged) {
            message.append(message.length() == 0 ? "" : "\n\n");
            message.append("Some options may have been changed to make the query compatible with the net features.");
        }
        if (message.length() > 0) {
            String string = message.toString();
            new Thread(() -> {
                TAPAALGUI.getAppGui().setCursor(Cursor.getPredefinedCursor(0));
                new MessengerImpl().displayInfoMessage(fmessage, "Information");
            }).start();
        }
    }

    private boolean checkCurrentEngine(ReductionOption reductionOption, boolean[] queryOptions) {
        EngineSupportOptions engine;
        switch (reductionOption) {
            case VerifyDTAPN: {
                engine = new VerifyDTAPNEngineOptions();
                break;
            }
            case VerifyPN: {
                engine = new VerifyPNEngineOptions();
                break;
            }
            case VerifyTAPN: {
                engine = new VerifyTAPNEngineOptions();
                break;
            }
            case BROADCAST: {
                engine = new UPPAALBroadcastOptions();
                break;
            }
            case DEGREE2BROADCAST: {
                engine = new UPPAALBroadcastDegree2Options();
                break;
            }
            case COMBI: {
                engine = new UPPAALCombiOptions();
                break;
            }
            case STANDARD: {
                engine = new UPPAALStandardOptions();
                break;
            }
            case OPTIMIZEDSTANDARD: {
                engine = new UPPAALOptimizedStandardOptions();
                break;
            }
            default: {
                return false;
            }
        }
        return engine.areOptionsSupported(queryOptions);
    }

    private TAPNQuery setQueryEngine(TAPNQuery query, EngineSupportOptions engine) {
        if (engine instanceof VerifyDTAPNEngineOptions) {
            query.setReductionOption(ReductionOption.VerifyDTAPN);
        } else if (engine instanceof VerifyPNEngineOptions) {
            query.setReductionOption(ReductionOption.VerifyPN);
        } else if (engine instanceof VerifyTAPNEngineOptions) {
            query.setReductionOption(ReductionOption.VerifyTAPN);
        } else if (engine instanceof UPPAALBroadcastDegree2Options) {
            query.setReductionOption(ReductionOption.DEGREE2BROADCAST);
        } else if (engine instanceof UPPAALBroadcastOptions) {
            query.setReductionOption(ReductionOption.BROADCAST);
        } else if (engine instanceof UPPAALCombiOptions) {
            query.setReductionOption(ReductionOption.COMBI);
        } else if (engine instanceof UPPAALOptimizedStandardOptions) {
            query.setReductionOption(ReductionOption.OPTIMIZEDSTANDARD);
        } else if (engine instanceof UPPAALStandardOptions) {
            query.setReductionOption(ReductionOption.STANDARD);
        }
        return query;
    }

    public static PetriNetTab createNewEmptyTab(String name, boolean isTimed, boolean isGame, boolean isColored, boolean isStochastic) {
        PetriNetTab tab = new PetriNetTab(isTimed, isGame, isColored, isStochastic);
        tab.setInitialName(name);
        String templateName = tab.getNameGenerator().getNewTemplateName();
        Template template = new Template(new TimedArcPetriNet(templateName), new DataLayer(), new Zoomer());
        tab.addTemplate(template);
        return tab;
    }

    public static PetriNetTab createNewTabFromPNMLFile(File file) throws Exception {
        if (file != null) {
            try {
                PNMLoader loader = new PNMLoader();
                LoadedModel loadedModel = loader.load(file);
                if (loadedModel == null) {
                    return null;
                }
                PetriNetTab tab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), loadedModel.getLens());
                String name = file.getName().replaceAll(".pnml", ".tapn");
                tab.setInitialName(name);
                tab.selectFirstElements();
                tab.setMode(DrawTool.SELECT);
                return tab;
            }
            catch (Exception e) {
                throw new Exception("TAPAAL encountered an error while loading the file: " + file.getName() + "\n\nPossible explanations:\n  - " + String.valueOf(e));
            }
        }
        return null;
    }

    public static PetriNetTab createNewTabFromFile(File file) throws Exception {
        try {
            Object name = file.getName();
            boolean showFileEndingChangedMessage = false;
            if (((String)name).toLowerCase().endsWith(".xml")) {
                name = ((String)name).substring(0, ((String)name).lastIndexOf(46)) + ".tapn";
                showFileEndingChangedMessage = true;
            }
            FileInputStream stream = new FileInputStream(file);
            PetriNetTab tab = PetriNetTab.createNewTabFromInputStream(stream, (String)name);
            if (!showFileEndingChangedMessage) {
                tab.setFile(file);
            }
            PetriNetTab.showFileEndingChangedMessage(showFileEndingChangedMessage);
            return tab;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("TAPAAL encountered an error while loading the file: " + file.getName() + "\n\nFile not found:\n  - " + String.valueOf(e));
        }
    }

    private static void showFileEndingChangedMessage(boolean showMessage) {
        if (showMessage) {
            new Thread(() -> {
                TAPAALGUI.getAppGui().setCursor(Cursor.getPredefinedCursor(0));
                new MessengerImpl().displayInfoMessage("We have changed the ending of TAPAAL files from .xml to .tapn and the opened file was automatically renamed to end with .tapn.\nOnce you save the .tapn model, we recommend that you manually delete the .xml file.", "FILE CHANGED");
            }).start();
        }
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    private PetriNetTab(boolean isTimed, boolean isGame, boolean isColored, boolean isStochastic) {
        this(new TimedArcPetriNetNetwork(), new ArrayList<Template>(), new TAPNLens(isTimed, isGame, isColored, isStochastic));
    }

    private PetriNetTab(TimedArcPetriNetNetwork network, Collection<Template> templates, TAPNLens lens) {
        Require.that(network != null, "network cannot be null");
        Require.notNull((Object)lens, "Lens can't be null");
        this.tapnNetwork = network;
        this.lens = lens;
        this.guiModels.clear();
        for (Template template : templates) {
            TimedArcPetriNet net = template.model();
            DataLayer guiModel = template.guiModel();
            this.guiModels.put(net, guiModel);
            this.guiModelToModel.put(guiModel, net);
            this.zoomLevels.put(template.model(), template.zoomer());
            this.hasPositionalInfos.put(template.model(), template.getHasPositionalInfo());
            for (PetriNetObject o : template.guiModel().getPetriNetObjects()) {
                o.setLens(this.lens);
            }
        }
        this.drawingSurface = new DrawingSurfaceImpl(new DataLayer(), this, this.managerRef);
        this.drawingSurfaceScroller = new JScrollPane(this.drawingSurface);
        this.drawingSurfaceScroller.setBorder(new BevelBorder(1));
        this.drawingSurfaceScroller.setWheelScrollingEnabled(true);
        this.drawingSurfaceScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.drawingSurfaceScroller.getHorizontalScrollBar().setUnitIncrement(10);
        this.drawingSurface.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TAPAALGUI.getAppGui().requestFocus();
            }
        });
        this.drawingSurfaceDummy = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        this.drawingSurfaceDummy.add((Component)new JLabel("The net is too big to be drawn"), gc);
        this.createEditorLeftPane();
        this.createAnimatorSplitPane();
        this.setOrientation(1);
        this.setLeftComponent(this.editorSplitPaneScroller);
        this.setRightComponent(this.drawingSurfaceScroller);
        this.setContinuousLayout(true);
        this.setOneTouchExpandable(true);
        this.setBorder(null);
        this.setDividerSize(8);
    }

    public PetriNetTab(TimedArcPetriNetNetwork network, Collection<Template> templates, Iterable<TAPNQuery> tapnqueries, TAPNLens lens) {
        this(network, templates, lens);
        this.sharedPTPanel.setNetwork(network);
        this.templateExplorer.updateTemplateList();
        this.constantsPanel.setNetwork(this.tapnNetwork);
        if (network.paintNet()) {
            this.setRightComponent(this.drawingSurfaceScroller);
        } else {
            this.setRightComponent(this.drawingSurfaceDummy);
        }
        this.queries.setQueries(tapnqueries);
    }

    public SharedPlacesAndTransitionsPanel getSharedPlacesAndTransitionsPanel() {
        return this.sharedPTPanel;
    }

    public TemplateExplorer getTemplateExplorer() {
        return this.templateExplorer;
    }

    public void selectTemplate(Template template) {
        this.templateExplorer.selectTemplate(template);
    }

    public void createEditorLeftPane() {
        this.constantsPanel = new ConstantsPane(this);
        this.constantsPanel.setPreferredSize(new Dimension(this.constantsPanel.getPreferredSize().width, this.constantsPanel.getMinimumSize().height));
        this.queries = new QueryPane(this);
        this.queries.setPreferredSize(new Dimension(this.queries.getPreferredSize().width, this.queries.getMinimumSize().height));
        this.templateExplorer = new TemplateExplorer(this);
        this.templateExplorer.setPreferredSize(new Dimension(this.templateExplorer.getPreferredSize().width, this.templateExplorer.getMinimumSize().height));
        this.sharedPTPanel = new SharedPlacesAndTransitionsPanel(this);
        this.sharedPTPanel.setPreferredSize(new Dimension(this.sharedPTPanel.getPreferredSize().width, this.sharedPTPanel.getMinimumSize().height));
        boolean floatingDividers = false;
        if (editorModelroot == null) {
            MultiSplitLayout.Leaf constantsLeaf = new MultiSplitLayout.Leaf(constantsName);
            MultiSplitLayout.Leaf queriesLeaf = new MultiSplitLayout.Leaf(queriesName);
            MultiSplitLayout.Leaf templateExplorerLeaf = new MultiSplitLayout.Leaf(templateExplorerName);
            MultiSplitLayout.Leaf sharedPTLeaf = new MultiSplitLayout.Leaf(sharedPTName);
            constantsLeaf.setWeight(0.25);
            queriesLeaf.setWeight(0.25);
            templateExplorerLeaf.setWeight(0.25);
            sharedPTLeaf.setWeight(0.25);
            editorModelroot = new MultiSplitLayout.Split(new MultiSplitLayout.Node[]{templateExplorerLeaf, new MultiSplitLayout.Divider(), sharedPTLeaf, new MultiSplitLayout.Divider(), queriesLeaf, new MultiSplitLayout.Divider(), constantsLeaf});
            editorModelroot.setRowLayout(false);
            editorModelroot.setParent(new MultiSplitLayout.Split());
            floatingDividers = true;
        }
        this.editorSplitPane = new BugHandledJXMultisplitPane();
        this.editorSplitPane.getMultiSplitLayout().setFloatingDividers(floatingDividers);
        this.editorSplitPane.getMultiSplitLayout().setLayoutByWeight(false);
        this.editorSplitPane.setSize(PetriNetTab.editorModelroot.getBounds().width, PetriNetTab.editorModelroot.getBounds().height);
        this.editorSplitPane.getMultiSplitLayout().setModel((MultiSplitLayout.Node)editorModelroot);
        this.editorSplitPane.add(this.templateExplorer, templateExplorerName);
        this.editorSplitPane.add(this.sharedPTPanel, sharedPTName);
        this.editorSplitPane.add(this.queries, queriesName);
        this.editorSplitPane.add(this.constantsPanel, constantsName);
        this.editorSplitPaneScroller = this.createLeftScrollPane((JPanel)((Object)this.editorSplitPane));
        this.setLeftComponent(this.editorSplitPaneScroller);
        this.editorSplitPane.repaint();
    }

    private JScrollPane createLeftScrollPane(JPanel panel) {
        JScrollPane scroller = new JScrollPane(panel);
        scroller.setBorder(new BevelBorder(1));
        scroller.setWheelScrollingEnabled(true);
        scroller.getVerticalScrollBar().setUnitIncrement(10);
        scroller.getHorizontalScrollBar().setUnitIncrement(10);
        scroller.setBorder(null);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setMinimumSize(new Dimension(panel.getPreferredSize().width, panel.getMinimumSize().height));
        return scroller;
    }

    public void selectFirstActiveTemplate() {
        this.templateExplorer.selectFirst();
    }

    public Boolean templateWasActiveBeforeSimulationMode() {
        return this.selectedTemplateWasActive;
    }

    public void resetSelectedTemplateWasActive() {
        this.selectedTemplateWasActive = false;
    }

    public void setSelectedTemplateWasActive() {
        this.selectedTemplateWasActive = true;
    }

    public void rememberSelectedTemplate() {
        this.selectedTemplate = this.templateExplorer.indexOfSelectedTemplate();
    }

    public void restoreSelectedTemplate() {
        this.templateExplorer.restoreSelectedTemplate(this.selectedTemplate);
    }

    public void updateConstantsList() {
        this.constantsPanel.showConstants();
    }

    public void removeConstantHighlights() {
        this.constantsPanel.removeConstantHighlights();
    }

    public void updateQueryList() {
        this.queries.updateQueryButtons();
        this.queries.repaint();
    }

    public DataLayer getModel() {
        return this.drawingSurface.getGuiModel();
    }

    public HashMap<TimedArcPetriNet, DataLayer> getGuiModels() {
        return this.guiModels;
    }

    public void setInitialName(String name) {
        if (name == null || ((String)name).isEmpty()) {
            name = "New Petri net " + this.newNameCounter++ + ".tapn";
        } else if (!((String)name).toLowerCase().endsWith(".tapn")) {
            name = (String)name + ".tapn";
        }
        this.initialName = name;
        this.safeApp.ifPresent(tab -> tab.updatedTabName(this));
    }

    @Override
    public String getTabTitle() {
        if (this.getFile() != null) {
            return this.getFile().getName();
        }
        return this.initialName;
    }

    @Override
    public File getFile() {
        return this.appFile;
    }

    public void setFile(File file) {
        this.appFile = file;
        this.safeApp.ifPresent(tab -> tab.updatedTabName(this));
    }

    private void createAnimatorSplitPane() {
        this.animationHistorySidePanel = new AnimationHistorySidePanel(this.animator);
        if (this.animControllerBox == null) {
            this.animControllerBox = new AnimationControlSidePanel(this.animator, this.lens);
        }
        if (this.transitionFiring == null) {
            this.transitionFiring = new TransitionFiringComponent(TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions(), this.lens, this.animator);
        }
        boolean floatingDividers = false;
        if (simulatorModelRoot == null) {
            MultiSplitLayout.Leaf templateExplorerLeaf = new MultiSplitLayout.Leaf(templateExplorerName);
            MultiSplitLayout.Leaf enabledTransitionsListLeaf = new MultiSplitLayout.Leaf(transitionFiringName);
            MultiSplitLayout.Leaf animControlLeaf = new MultiSplitLayout.Leaf(animControlName);
            templateExplorerLeaf.setWeight(0.25);
            enabledTransitionsListLeaf.setWeight(0.25);
            animControlLeaf.setWeight(0.5);
            simulatorModelRoot = new MultiSplitLayout.Split(new MultiSplitLayout.Node[]{templateExplorerLeaf, new MultiSplitLayout.Divider(), enabledTransitionsListLeaf, new MultiSplitLayout.Divider(), animControlLeaf});
            simulatorModelRoot.setRowLayout(false);
            floatingDividers = true;
        }
        this.animatorSplitPane = new BugHandledJXMultisplitPane();
        this.animatorSplitPane.getMultiSplitLayout().setFloatingDividers(floatingDividers);
        this.animatorSplitPane.getMultiSplitLayout().setLayoutByWeight(false);
        this.animatorSplitPane.setSize(PetriNetTab.simulatorModelRoot.getBounds().width, PetriNetTab.simulatorModelRoot.getBounds().height);
        this.animatorSplitPane.getMultiSplitLayout().setModel((MultiSplitLayout.Node)simulatorModelRoot);
        this.animationControlsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.2;
        this.animationControlsPanel.add((Component)this.animControllerBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.animationControlsPanel.add((Component)this.animationHistorySidePanel, gbc);
        this.animationControlsPanel.setPreferredSize(new Dimension(this.animationControlsPanel.getPreferredSize().width, this.animationControlsPanel.getMinimumSize().height));
        this.transitionFiring.setPreferredSize(new Dimension(this.transitionFiring.getPreferredSize().width, this.transitionFiring.getMinimumSize().height));
        this.animatorSplitPane.add(new JPanel(), templateExplorerName);
        this.animatorSplitPane.add(this.animationControlsPanel, animControlName);
        this.animatorSplitPane.add(this.transitionFiring, transitionFiringName);
        this.animatorSplitPaneScroller = this.createLeftScrollPane((JPanel)((Object)this.animatorSplitPane));
        this.animatorSplitPane.repaint();
    }

    public void switchToAnimationComponents() {
        Component dummy = this.animatorSplitPane.getMultiSplitLayout().getComponentForNode(this.animatorSplitPane.getMultiSplitLayout().getNodeForName(templateExplorerName));
        if (dummy != null) {
            this.animatorSplitPane.remove(dummy);
        }
        TemplateExplorer t = new TemplateExplorer(this);
        t.switchToAnimationMode();
        this.animatorSplitPane.add(t, templateExplorerName);
        this.setLeftComponent(this.animatorSplitPaneScroller);
    }

    public AnimationHistoryList getUntimedAnimationHistory() {
        return this.abstractAnimationPane;
    }

    public AnimationControlSidePanel getAnimationController() {
        return this.animControllerBox;
    }

    public DelayEnabledTransitionControl getDelayEnabledTransitionControl() {
        return this.transitionFiring.getDelayEnabledTransitionControl();
    }

    public void addAbstractAnimationPane() {
        this.animationControlsPanel.remove(this.animationHistorySidePanel);
        this.abstractAnimationPane = new AnimationHistoryList();
        JScrollPane untimedAnimationHistoryScrollPane = new JScrollPane(this.abstractAnimationPane);
        untimedAnimationHistoryScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Untimed Trace"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.animationHistorySplitter = new JSplitPaneFix(1, this.animationHistorySidePanel, untimedAnimationHistoryScrollPane);
        this.animationHistorySplitter.setContinuousLayout(true);
        this.animationHistorySplitter.setOneTouchExpandable(true);
        this.animationHistorySplitter.setBorder(null);
        this.animationHistorySplitter.setDividerSize(8);
        this.animationHistorySplitter.setDividerLocation(0.5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.animationControlsPanel.add((Component)this.animationHistorySplitter, gbc);
    }

    public void removeAbstractAnimationPane() {
        this.animationControlsPanel.remove(this.animationHistorySplitter);
        this.abstractAnimationPane = null;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.animationControlsPanel.add((Component)this.animationHistorySidePanel, gbc);
        this.animatorSplitPane.validate();
    }

    public AnimationHistoryList getAnimationHistorySidePanel() {
        return this.animationHistorySidePanel.getAnimationHistoryList();
    }

    public TransitionFiringComponent getTransitionFiringComponent() {
        return this.transitionFiring;
    }

    public TimedArcPetriNetNetwork network() {
        return this.tapnNetwork;
    }

    public DrawingSurfaceImpl drawingSurface() {
        return this.drawingSurface;
    }

    public Iterable<Template> allTemplates() {
        ArrayList<Template> list = new ArrayList<Template>();
        for (TimedArcPetriNet net : this.tapnNetwork.allTemplates()) {
            Template template = new Template(net, this.guiModels.get(net), this.zoomLevels.get(net));
            template.setHasPositionalInfo(this.hasPositionalInfos.get(net));
            list.add(template);
        }
        return list;
    }

    public Iterable<Template> activeTemplates() {
        ArrayList<Template> list = new ArrayList<Template>();
        for (TimedArcPetriNet net : this.tapnNetwork.activeTemplates()) {
            Template template = new Template(net, this.guiModels.get(net), this.zoomLevels.get(net));
            template.setHasPositionalInfo(this.hasPositionalInfos.get(net));
            list.add(template);
        }
        return list;
    }

    public int numberOfActiveTemplates() {
        int count = 0;
        for (TimedArcPetriNet net : this.tapnNetwork.activeTemplates()) {
            if (!net.isActive()) continue;
            ++count;
        }
        return count;
    }

    public void addTemplate(Template template) {
        this.tapnNetwork.add(template.model());
        this.guiModels.put(template.model(), template.guiModel());
        this.guiModelToModel.put(template.guiModel(), template.model());
        this.zoomLevels.put(template.model(), template.zoomer());
        this.hasPositionalInfos.put(template.model(), template.getHasPositionalInfo());
        this.templateExplorer.updateTemplateList();
    }

    public void removeTemplate(Template template) {
        this.tapnNetwork.remove(template.model());
        this.guiModels.remove(template.model());
        this.guiModelToModel.remove(template.guiModel());
        this.zoomLevels.remove(template.model());
        this.hasPositionalInfos.remove(template.model());
        this.templateExplorer.updateTemplateList();
    }

    public Template currentTemplate() {
        return this.templateExplorer.selectedModel();
    }

    public Iterable<TAPNQuery> queries() {
        return this.queries.getQueries();
    }

    public QueryPane getQueryPane() {
        return this.queries;
    }

    public void removeQuery(TAPNQuery queryToRemove) {
        this.queries.removeQuery(queryToRemove);
    }

    public void addQuery(TAPNQuery query) {
        this.queries.addQuery(query);
    }

    public void swapTemplates(int currentIndex, int newIndex) {
        this.tapnNetwork.swapTemplates(currentIndex, newIndex);
    }

    public TimedArcPetriNet[] sortTemplates() {
        return this.tapnNetwork.sortTemplates();
    }

    public void undoSort(TimedArcPetriNet[] l) {
        this.tapnNetwork.undoSort(l);
    }

    public void swapConstants(int currentIndex, int newIndex) {
        this.tapnNetwork.swapConstants(currentIndex, newIndex);
    }

    public Constant[] sortConstants() {
        return this.tapnNetwork.sortConstants();
    }

    public void undoSort(Constant[] oldOrder) {
        this.tapnNetwork.undoSort(oldOrder);
    }

    @Override
    public void showComponents(boolean enable) {
        if (enable != this.templateExplorer.isVisible()) {
            this.editorSplitPane.getMultiSplitLayout().displayNode(templateExplorerName, enable);
            if (this.animatorSplitPane != null) {
                this.animatorSplitPane.getMultiSplitLayout().displayNode(templateExplorerName, enable);
            }
            this.makeSureEditorPanelIsVisible(this.templateExplorer);
        }
    }

    @Override
    public void showSharedPT(boolean enable) {
        if (enable != this.sharedPTPanel.isVisible()) {
            this.editorSplitPane.getMultiSplitLayout().displayNode(sharedPTName, enable);
            this.makeSureEditorPanelIsVisible(this.sharedPTPanel);
        }
    }

    @Override
    public void showQueries(boolean enable) {
        if (enable != this.queries.isVisible()) {
            this.editorSplitPane.getMultiSplitLayout().displayNode(queriesName, enable);
            this.makeSureEditorPanelIsVisible(this.queries);
            this.repaint();
        }
    }

    @Override
    public void repaintAll() {
        this.drawingSurface().repaintAll();
    }

    @Override
    public void showConstantsPanel(boolean enable) {
        if (enable != this.constantsPanel.isVisible()) {
            this.editorSplitPane.getMultiSplitLayout().displayNode(constantsName, enable);
            this.makeSureEditorPanelIsVisible(this.constantsPanel);
        }
    }

    @Override
    public void showEnabledTransitionsList(boolean enable) {
        if (this.transitionFiring.isVisible() != enable) {
            this.animatorSplitPane.getMultiSplitLayout().displayNode(transitionFiringName, enable);
        }
    }

    @Override
    public void showDelayEnabledTransitions(boolean enable) {
        this.transitionFiring.showDelayEnabledTransitions(enable);
        this.drawingSurface.repaint();
        if (this.getAnimator() != null && this.animationmode) {
            this.getAnimator().updateFireableTransitions();
        }
    }

    public void selectFirstElements() {
        this.templateExplorer.selectFirst();
        this.queries.selectFirst();
        this.constantsPanel.selectFirst();
    }

    public boolean isQueryPossible() {
        return this.queries.isQueryPossible();
    }

    @Override
    public void verifySelectedQuery() {
        this.queries.verifySelectedQuery();
    }

    @Override
    public void previousComponent() {
        this.getTemplateExplorer().selectPrevious();
    }

    @Override
    public void nextComponent() {
        this.getTemplateExplorer().selectNext();
    }

    @Override
    public void exportTrace() {
        TraceImportExport.exportTrace(this);
    }

    @Override
    public void importTrace() {
        TraceImportExport.importTrace(this.animator, this);
    }

    @Override
    public void zoomTo(int newZoomLevel) {
        boolean didZoom = this.drawingSurface().getZoomController().setZoom(newZoomLevel);
        if (didZoom) {
            this.app.ifPresent(gfa -> {
                ChangeListener[] listeners;
                JSlider zoomSlider = gfa.getZoomSlider();
                for (ChangeListener listener : listeners = zoomSlider.getChangeListeners()) {
                    zoomSlider.removeChangeListener(listener);
                }
                zoomSlider.setValue(newZoomLevel);
                for (ChangeListener listener : listeners) {
                    zoomSlider.addChangeListener(listener);
                }
            });
            this.drawingSurface().zoomToMidPoint();
        }
    }

    @Override
    public void search(String query) {
        if (query == null || query.isEmpty()) {
            return;
        }
        ArrayList<Tuple<Object, String>> searchableItems = new ArrayList<Tuple<Object, String>>();
        for (Template template : this.allTemplates()) {
            TimedArcPetriNet model = template.model();
            for (TimedPlace place : model.places()) {
                searchableItems.add(new Tuple<TimedPlace, String>(place, template.toString()));
            }
            for (TimedTransition transition : model.transitions()) {
                searchableItems.add(new Tuple<TimedTransition, String>(transition, template.toString()));
            }
        }
        Searcher<Tuple> searcher = new Searcher<Tuple>(searchableItems, obj -> {
            Object element = obj.value1();
            String name = element.toString();
            if (name.contains(".")) {
                name = name.split("\\.")[1];
            }
            return name;
        });
        List<Tuple> matches = searcher.findAllMatches(query);
        this.app.ifPresent(gfa -> {
            SearchBar searchBar = gfa.getSearchBar();
            if (searchBar != null) {
                searchBar.showResults(matches);
            }
        });
    }

    public void editSelectedQuery() {
        this.queries.showEditDialog();
    }

    public void makeSureEditorPanelIsVisible(Component c) {
        if (c.isVisible() && this.getDividerLocation() == 0) {
            this.setDividerLocation(c.getPreferredSize().width);
        }
    }

    @Override
    public void setResizeingDefault() {
        if (this.animatorSplitPane != null) {
            this.animatorSplitPane.getMultiSplitLayout().setFloatingDividers(true);
            this.animatorSplitPane.getMultiSplitLayout().layoutByWeight((Container)((Object)this.animatorSplitPane));
            this.animatorSplitPane.getMultiSplitLayout().setFloatingDividers(false);
        } else {
            simulatorModelRoot = null;
        }
        this.editorSplitPane.getMultiSplitLayout().setFloatingDividers(true);
        this.editorSplitPane.getMultiSplitLayout().layoutByWeight((Container)((Object)this.editorSplitPane));
        this.editorSplitPane.getMultiSplitLayout().setFloatingDividers(false);
    }

    private void createNewAndConvertUntimed() {
        PetriNetTab tab = this.duplicateTab(new TAPNLens(false, this.lens.isGame(), this.lens.isColored(), this.lens.isStochastic()), "-untimed");
        this.convertToUntimedTab(tab);
        this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
    }

    private void createNewAndConvertNonGame() {
        PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), false, this.lens.isColored(), this.lens.isStochastic()), "-nongame");
        TabTransformer.removeGameInformation(tab);
        this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
    }

    private void createNewAndConvertNonColor() {
        PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), this.lens.isGame(), false, this.lens.isStochastic()), "-noncolored");
        TabTransformer.removeColorInformation(tab);
        this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
    }

    private void createNewAndConvertColor() {
        PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), this.lens.isGame(), true, this.lens.isStochastic()), "-colored");
        TabTransformer.addColorInformation(tab);
        this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
    }

    private void createNewAndConvertNonStochastic() {
        PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), this.lens.isGame(), this.lens.isColored(), false), "-nonstochastic");
        TabTransformer.removeDistributionInformation(tab);
        TabTransformer.convertQueriesToOrFromSmc(tab.queries());
        this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
    }

    public void createNewAndUnfoldColor(boolean partition, boolean computeColorFixpoint, boolean useSymmetricVars) {
        TabTransformer.unfoldTab(this, partition, computeColorFixpoint, useSymmetricVars);
    }

    @Override
    public void changeTimeFeature(boolean isTime) {
        if (isTime != this.lens.isTimed()) {
            if (!isTime) {
                if (!this.network().isUntimed()) {
                    String removeTimeWarning = "The net contains time information, which will be removed. Do you still wish to make the net untimed?";
                    int choice = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), removeTimeWarning, "Remove time information", 0, 2, null, null, 0);
                    if (choice == 0) {
                        this.createNewAndConvertUntimed();
                    }
                } else {
                    this.createNewAndConvertUntimed();
                }
            } else {
                PetriNetTab tab = this.duplicateTab(new TAPNLens(true, this.lens.isGame(), this.lens.isColored(), this.lens.isStochastic()), "-timed");
                this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
            }
            this.updateFeatureText();
        }
    }

    @Override
    public void changeGameFeature(boolean isGame) {
        if (isGame != this.lens.isGame()) {
            if (!isGame) {
                if (this.network().hasUncontrollableTransitions()) {
                    String removeTimeWarning = "The net contains game information, which will be removed. Do you still wish to make to remove the game semantics?";
                    int choice = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), removeTimeWarning, "Remove game information", 0, 2, null, null, 0);
                    if (choice == 0) {
                        this.createNewAndConvertNonGame();
                    }
                } else {
                    this.createNewAndConvertNonGame();
                }
            } else {
                PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), true, this.lens.isColored(), this.lens.isStochastic()), "-game");
                this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
            }
            this.updateFeatureText();
        }
    }

    @Override
    public void changeColorFeature(boolean isColor) {
        if (isColor != this.lens.isColored()) {
            if (!isColor) {
                String removeTimeWarning = "The net contains color information, which will be removed. Do you still wish to make to remove the color semantics?";
                int choice = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), removeTimeWarning, "Remove color information", 0, 2, null, null, 0);
                if (choice == 0) {
                    this.createNewAndConvertNonColor();
                }
            } else {
                this.createNewAndConvertColor();
            }
            this.updateFeatureText();
        }
    }

    @Override
    public void changeStochasticFeature(boolean isStochastic) {
        if (isStochastic != this.lens.isStochastic()) {
            if (!isStochastic) {
                String removeStochasticWarning = "The net contains distribution informations, which will be removed. Do you still wish to make to remove the stochastic semantics ?";
                int choice = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), removeStochasticWarning, "Remove stochastic information", 0, 2, null, null, 0);
                if (choice == 0) {
                    this.createNewAndConvertNonStochastic();
                }
            } else {
                PetriNetTab tab = this.duplicateTab(new TAPNLens(this.lens.isTimed(), this.lens.isGame(), this.lens.isColored(), true), "-stochastic");
                TabTransformer.convertQueriesToOrFromSmc(tab.queries());
                this.guiFrameControllerActions.ifPresent(o -> o.openTab(tab));
            }
            this.updateFeatureText();
        }
    }

    @Override
    public Map<PetriNetObject, Boolean> showNames(boolean showNames, boolean placeNames, boolean selectedComponent) {
        HashMap<PetriNetObject, Boolean> map = new HashMap<PetriNetObject, Boolean>();
        ArrayList components = new ArrayList();
        if (selectedComponent) {
            Template template = this.currentTemplate();
            template.guiModel().getPetriNetObjects().forEach(components::add);
        } else {
            Iterable<Template> templates = this.allTemplates();
            for (Template template : templates) {
                template.guiModel().getPetriNetObjects().forEach(components::add);
            }
        }
        for (Component component : components) {
            if (placeNames && component instanceof TimedPlaceComponent) {
                TimedPlaceComponent place = (TimedPlaceComponent)component;
                map.put(place, place.getAttributesVisible());
                place.setAttributesVisible(showNames);
                place.update(true);
                this.repaint();
                continue;
            }
            if (placeNames || !(component instanceof TimedTransitionComponent)) continue;
            TimedTransitionComponent transition = (TimedTransitionComponent)component;
            map.put(transition, transition.getAttributesVisible());
            transition.setAttributesVisible(showNames);
            transition.update(true);
            this.repaint();
        }
        return map;
    }

    public static MultiSplitLayout.Split getEditorModelRoot() {
        return editorModelroot;
    }

    public static void setEditorModelRoot(MultiSplitLayout.Split model) {
        editorModelroot = model;
    }

    public static MultiSplitLayout.Split getSimulatorModelRoot() {
        return simulatorModelRoot;
    }

    public static void setSimulatorModelRoot(MultiSplitLayout.Split model) {
        simulatorModelRoot = model;
    }

    public void changeToTemplate(Template tapn) {
        Require.notNull((Object)tapn, "Can't change to a Template that is null");
        this.nameGenerator.add(tapn.model());
        this.drawingSurface.setModel(tapn.guiModel(), tapn.zoomer());
        this.app.ifPresent(gfa -> gfa.updateZoomSlider(tapn.zoomer().getPercent()));
        this.drawingSurface.getSelectionObject().clearSelection();
    }

    public void setAnimationMode(boolean on, boolean explicit) {
        if (this.animationmode != on) {
            this.toggleAnimationMode(explicit);
        }
    }

    public void setAnimationMode(boolean on) {
        this.setAnimationMode(on, false);
    }

    @Override
    public void toggleAnimationMode() {
        this.toggleAnimationMode(false);
    }

    @Override
    public void toggleAnimationMode(boolean explicit) {
        if (!this.animationmode) {
            if (this.numberOfActiveTemplates() > 0) {
                this.app.ifPresent(o -> o.setGUIMode(GuiFrame.GUIMode.animation));
                this.switchToAnimationComponents();
                this.drawingSurface().repaintAll();
                this.rememberSelectedTemplate();
                if (this.currentTemplate().isActive()) {
                    this.setSelectedTemplateWasActive();
                }
                this.getAnimator().resetTraceBox();
                this.getAnimator().reset(false);
                if (this.animControllerBox != null) {
                    this.animControllerBox.resetPlacementOfAnimationToolBar();
                }
                this.getAnimator().storeModel();
                if (explicit) {
                    this.getAnimator().initializeInteractiveEngine();
                }
                this.getAnimator().updateFireableTransitions();
                this.getAnimator().reportBlockingPlaces();
                this.getAnimator().setFiringmode("Random");
                this.drawingSurface().setBackground(Constants.ANIMATION_BACKGROUND_COLOR);
                this.getAnimationController().requestFocusInWindow();
                if (this.templateWasActiveBeforeSimulationMode().booleanValue()) {
                    this.restoreSelectedTemplate();
                    this.resetSelectedTemplateWasActive();
                } else {
                    this.selectFirstActiveTemplate();
                }
                this.drawingSurface().setCursor(Cursor.getPredefinedCursor(0));
                this.animationmode = true;
                this.getUndoManager().setUndoRedoStatus();
                this.setMode(DrawTool.SELECT);
                this.app.ifPresent(o -> o.setStatusBarText(textforAnimation));
                this.animator.updateAnimationButtonsEnabled();
            } else {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You need at least one active template to enter simulation mode", "Simulation Mode Error", 0);
                this.animationmode = false;
                this.app.ifPresent(o -> o.setGUIMode(GuiFrame.GUIMode.draw));
            }
        } else {
            this.getUndoManager().undoAll();
            this.getUndoManager().clear();
            this.drawingSurface().getSelectionObject().clearSelection();
            this.app.ifPresent(o -> o.setGUIMode(GuiFrame.GUIMode.draw));
            if (this.isInAnimationMode()) {
                this.getAnimator().restoreModel();
            }
            this.setLeftComponent(this.editorSplitPaneScroller);
            this.setManager(this.notingManager);
            this.drawingSurface().setBackground(Constants.ELEMENT_FILL_COLOUR);
            this.restoreSelectedTemplate();
            this.animationmode = false;
            this.getUndoManager().setUndoRedoStatus();
            this.setMode(DrawTool.SELECT);
            this.app.ifPresent(o -> o.setStatusBarText(textforDrawing));
            if (this.restoreWorkflowDialog()) {
                WorkflowDialog.showDialog(this);
            }
        }
    }

    @Override
    public void setMode(DrawTool mode) {
        this.changeStatusbarText(mode);
        this.drawingSurface().getSelectionObject().clearSelection();
        this.updateMode(mode);
        switch (mode.ordinal()) {
            case 9: {
                this.setManager(new AbstractDrawingSurfaceManager(){

                    @Override
                    public void registerEvents() {
                        this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed && !PetriNetTab.this.lens.isColored(), e -> this.guiModelManager.addToken(PetriNetTab.this.getModel(), (TimedPlaceComponent)e.pno, 1));
                        this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed && PetriNetTab.this.lens.isColored(), e -> ((TimedPlaceComponent)e.pno).showEditor());
                    }
                });
                break;
            }
            case 10: {
                this.setManager(new AbstractDrawingSurfaceManager(){

                    @Override
                    public void registerEvents() {
                        this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed && !PetriNetTab.this.lens.isColored(), e -> this.guiModelManager.removeToken(PetriNetTab.this.getModel(), (TimedPlaceComponent)e.pno, 1));
                        this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed && PetriNetTab.this.lens.isColored(), e -> ((TimedPlaceComponent)e.pno).showEditor());
                    }
                });
                break;
            }
            case 1: {
                this.setManager(new CanvasPlaceDrawController());
                break;
            }
            case 2: {
                this.setManager(new CanvasTransitionDrawController());
                break;
            }
            case 7: {
                this.setManager(new CanvasUrgentTransitionDrawController());
                break;
            }
            case 3: {
                this.setManager(new CanvasUncontrollableTransitionDrawController());
                break;
            }
            case 8: {
                this.setManager(new CanvasUncontrollableUrgentTransitionDrawController());
                break;
            }
            case 0: {
                this.setManager(new CanvasAnnotationNoteDrawController());
                break;
            }
            case 4: {
                this.setManager(new CanvasArcDrawController());
                break;
            }
            case 6: {
                this.setManager(new CanvasInhibitorarcDrawController());
                break;
            }
            case 5: {
                this.setManager(new CanvasTransportarcDrawController());
                break;
            }
            case 11: {
                this.setManager(new CanvasGeneralDrawController(this.lens));
                break;
            }
            default: {
                this.setManager(this.notingManager);
            }
        }
        if (mode == DrawTool.SELECT) {
            this.drawingSurface().setCursor(Cursor.getPredefinedCursor(0));
        } else if (mode == DrawTool.DRAG) {
            this.drawingSurface().setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.drawingSurface().setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    @Override
    public boolean searchBarHasFocus() {
        if (this.app == null || this.app.get() == null) {
            return false;
        }
        return ((GuiFrameActions)this.app.get()).getSearchBar().isFocusOwner();
    }

    @Override
    public void showStatistics() {
        StatisticsPanel.showStatisticsPanel(this.currentTemplate().model().getStatistics(), this);
    }

    @Override
    public void showChangeNameVisibility() {
        NameVisibilityPanel panel = new NameVisibilityPanel(this);
        if (this.showNamesOption != null && this.isSelectedComponentOption != null && this.isPlaceOption != null && this.isTransitionOption != null) {
            panel.showNameVisibilityPanel(this.showNamesOption, this.isPlaceOption, this.isTransitionOption, this.isSelectedComponentOption);
        } else {
            panel.showNameVisibilityPanel();
        }
        this.showNamesOption = panel.isShowNamesOption();
        this.isPlaceOption = panel.isPlaceOption();
        this.isTransitionOption = panel.isTransitionOption();
        this.isSelectedComponentOption = panel.isSelectedComponentOption();
    }

    @Override
    public void showColorTypesVariables() {
        StringBuilder buffer = new StringBuilder();
        Context context = new Context(TAPAALGUI.getCurrentTab());
        List<ColorType> listColorTypes = context.network().colorTypes();
        List<Variable> variableList = context.network().variables();
        ArrayList<Constant> constantsList = new ArrayList<Constant>(context.network().constants());
        this.getColorTypesFormattedString(listColorTypes, buffer);
        if (!variableList.isEmpty()) {
            buffer.append("<br>");
        }
        this.getVariablesFormattedString(variableList, buffer);
        if (!constantsList.isEmpty()) {
            buffer.append("<br><br>");
        }
        this.getConstantsFormattedString(constantsList, buffer);
        JLabel label = new JLabel("<html>" + String.valueOf(buffer) + "</html>");
        label.setFont(new Font(label.getFont().getName(), 0, label.getFont().getSize()));
        JOptionPane.showMessageDialog(null, label, "Global color types/variables", 1);
    }

    private String getColorTypesFormattedString(List<ColorType> listColorTypes, StringBuilder buffer) {
        Object stringColorList = "";
        for (int i = 0; i < listColorTypes.size(); ++i) {
            int x;
            if (i == 0) {
                buffer.append("Color Types:<br>");
            }
            buffer.append(listColorTypes.get(i).getName() + " <b>is</b> ");
            if (listColorTypes.get(i).isProductColorType()) {
                buffer.append("&lt;");
                for (x = 0; x < listColorTypes.get(i).getProductColorTypes().size(); ++x) {
                    stringColorList = (String)stringColorList + listColorTypes.get(i).getProductColorTypes().get(x).getName();
                    if (x == listColorTypes.get(i).getProductColorTypes().size() - 1) continue;
                    stringColorList = (String)stringColorList + ", ";
                }
                buffer.append((String)stringColorList + "&gt;<br>");
                stringColorList = "";
                continue;
            }
            if (listColorTypes.get(i).isIntegerRange()) {
                if (listColorTypes.get(i).size() > 1) {
                    int listSize = listColorTypes.get(i).size();
                    buffer.append("[" + listColorTypes.get(i).getColors().get(0).getColorName() + "," + listColorTypes.get(i).getColors().get(listSize - 1).getColorName() + "]");
                } else {
                    buffer.append("[" + listColorTypes.get(i).getFirstColor().getColorName() + "]");
                }
                buffer.append("<br>");
                continue;
            }
            buffer.append("[");
            for (x = 0; x < listColorTypes.get(i).getColors().size(); ++x) {
                stringColorList = (String)stringColorList + listColorTypes.get(i).getColors().get(x).getName();
                if (x == listColorTypes.get(i).getColors().size() - 1) continue;
                stringColorList = (String)stringColorList + ", ";
            }
            buffer.append((String)stringColorList + "]<br>");
            stringColorList = "";
        }
        return buffer.toString();
    }

    private String getVariablesFormattedString(List<Variable> variableList, StringBuilder buffer) {
        for (int i = 0; i < variableList.size(); ++i) {
            if (i == 0) {
                buffer.append("Variables:<br>");
            }
            buffer.append(variableList.get(i).getName() + " <b>in</b> " + variableList.get(i).getColorType().getName());
            if (i == variableList.size() - 1) continue;
            buffer.append("<br>");
        }
        return buffer.toString();
    }

    private String getConstantsFormattedString(List<Constant> constantsList, StringBuilder buffer) {
        for (int i = 0; i < constantsList.size(); ++i) {
            if (i == 0) {
                buffer.append("Constants:<br>");
            }
            buffer.append(constantsList.get(i).toString());
            if (i == constantsList.size() - 1) continue;
            buffer.append("<br>");
        }
        return buffer.toString();
    }

    @Override
    public void alignToGrid() {
        ArrayList<PetriNetObject> petriNetObjects = this.drawingSurface.getGuiModel().getPlaceTransitionObjects();
        this.undoManager.newEdit();
        Quadtree quadtree = new Quadtree();
        int minimumDistance = 45;
        for (PetriNetObject object : petriNetObjects) {
            int y;
            int x = Grid.align(object.getPositionX(), this.drawingSurface.getZoom());
            Point point = new Point(x, y = Grid.align(object.getPositionY(), this.drawingSurface.getZoom()));
            if (quadtree.containsWithin(point, 45)) {
                return;
            }
            quadtree.insert(point);
        }
        for (PetriNetObject object : petriNetObjects) {
            PlaceTransitionObject ptobject = (PlaceTransitionObject)object;
            int x = Grid.align(ptobject.getPositionX(), this.drawingSurface.getZoom());
            int y = Grid.align(ptobject.getPositionY(), this.drawingSurface.getZoom());
            Point point = new Point(x, y);
            MovePetriNetObjectCommand command = new MovePetriNetObjectCommand(ptobject, point, this.drawingSurface);
            command.redo();
            this.undoManager.addEdit(command);
            if (object instanceof Transition) {
                MovePetriNetObjectCommand pathCommand;
                for (Arc arc : ((PlaceTransitionObject)object).getPreset()) {
                    for (ArcPathPoint arcPathPoint : arc.getArcPath().getArcPathPoints()) {
                        x = Grid.align(arcPathPoint.getPositionX(), this.drawingSurface.getZoom());
                        y = Grid.align(arcPathPoint.getPositionY(), this.drawingSurface.getZoom());
                        point = new Point(x, y);
                        pathCommand = new MovePetriNetObjectCommand(arcPathPoint, point, this.drawingSurface);
                        pathCommand.redo();
                        this.undoManager.addEdit(pathCommand);
                    }
                }
                for (Arc arc : ((PlaceTransitionObject)object).getPostset()) {
                    for (ArcPathPoint arcPathPoint : arc.getArcPath().getArcPathPoints()) {
                        x = Grid.align(arcPathPoint.getPositionX(), this.drawingSurface.getZoom());
                        y = Grid.align(arcPathPoint.getPositionY(), this.drawingSurface.getZoom());
                        point = new Point(x, y);
                        pathCommand = new MovePetriNetObjectCommand(arcPathPoint, point, this.drawingSurface);
                        pathCommand.redo();
                        this.undoManager.addEdit(pathCommand);
                    }
                }
            }
            ptobject.updateOnMoveOrZoom();
        }
    }

    @Override
    public void copy() {
        String message = CopyPastImportExport.toXML(this.drawingSurface().getSelectionObject().getSelection());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(message), null);
    }

    @Override
    public void cut() {
        String message = CopyPastImportExport.toXML(this.drawingSurface().getSelectionObject().getSelection());
        this.deleteSelection();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(message), null);
    }

    @Override
    public void past() {
        boolean hasTransferableText;
        String s = "";
        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                s = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        CopyPastImportExport.past(s, this);
    }

    @Override
    public void print() {
        Export.exportGuiView(this.drawingSurface, 3, null, null, this);
    }

    @Override
    public void importSUMOQueries() {
        File[] files;
        for (File f : files = FileBrowser.constructor("Import SUMO", "txt", FileBrowser.userPath).openFiles()) {
            if (!f.exists() || !f.isFile() || !f.canRead()) continue;
            FileBrowser.userPath = f.getParent();
            SUMOQueryLoader.importQueries(f, this.network(), this);
        }
    }

    @Override
    public void importXMLQueries() {
        File[] files;
        for (File f : files = FileBrowser.constructor("Import XML queries", "xml", FileBrowser.userPath).openFiles()) {
            if (!f.exists() || !f.isFile() || !f.canRead()) continue;
            FileBrowser.userPath = f.getParent();
            XMLQueryLoader.importQueries(f, this.network(), this);
        }
    }

    public boolean isInAnimationMode() {
        return this.animationmode;
    }

    public Animator getAnimator() {
        return this.animator;
    }

    @Override
    public void mergeNetComponents() {
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
        boolean inlineConstants = false;
        if (!this.tapnNetwork.constants().isEmpty()) {
            Object[] options = new Object[]{"Yes", "No"};
            String optionText = "Do you want to replace constants with values?";
            int openCTLDialog = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), optionText, "Merge Net Components Dialog", 0, 3, null, options, options[0]);
            if (openCTLDialog == 0) {
                inlineConstants = true;
            } else if (openCTLDialog == 1) {
                network.setConstants(this.tapnNetwork.constants());
            }
        }
        network.setColorTypes(this.tapnNetwork.colorTypes());
        network.setVariables(this.tapnNetwork.variables());
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), this.guiModels, this.lens, true, inlineConstants);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
        ArrayList<Template> templates = new ArrayList<Template>(1);
        templates.add(new Template(transformedModel.value1(), composer.getGuiModel(), new Zoomer()));
        network.add(transformedModel.value1());
        TimedArcPetriNetNetworkWriter tapnWriter = new TimedArcPetriNetNetworkWriter(network, templates, new ArrayList<TAPNQuery>(0), network.constants(), this.lens);
        try {
            ByteArrayOutputStream outputStream = tapnWriter.savePNML();
            Object composedName = "composed-" + this.getTabTitle();
            composedName = ((String)composedName).replace(".tapn", "");
            TAPAALGUI.openNewTabFromStream(new ByteArrayInputStream(outputStream.toByteArray()), (String)composedName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setApp(GuiFrameActions newApp) {
        this.app.setReference(newApp);
        this.undoManager.setApp(this.app);
        this.updateFeatureText();
        this.updateZoom();
        if (this.isInAnimationMode()) {
            this.app.ifPresent(o -> o.setGUIMode(GuiFrame.GUIMode.animation));
            this.animator.updateAnimationButtonsEnabled();
        } else {
            this.app.ifPresent(o -> o.setGUIMode(GuiFrame.GUIMode.draw));
            this.app.ifPresent(o -> this.setMode(DrawTool.SELECT));
        }
        this.app.ifPresent(o -> o.registerDrawingActions(this.getAvailableDrawActions()));
        this.app.ifPresent(o -> o.registerAnimationActions(this.getAvailableSimActions()));
        this.app.ifPresent(o -> o.registerToolsActions(this.getAvailableToolActions()));
        this.app.ifPresent(o -> o.registerViewActions(List.of()));
    }

    @Override
    public void setSafeGuiFrameActions(SafeGuiFrameActions ref) {
        this.safeApp.setReference(ref);
    }

    @Override
    public void zoomOut() {
        boolean didZoom = this.drawingSurface().getZoomController().zoomOut();
        if (didZoom) {
            this.app.ifPresent(e -> e.updateZoomSlider(this.drawingSurface().getZoomController().getPercent()));
        }
    }

    @Override
    public void zoomIn() {
        boolean didZoom = this.drawingSurface().getZoomController().zoomIn();
        if (didZoom) {
            this.app.ifPresent(e -> e.updateZoomSlider(this.drawingSurface().getZoomController().getPercent()));
        }
    }

    @Override
    public void setIsAlreadyFitToScreen(boolean alreadyFitToScreen) {
        this.alreadyFitToScreen = alreadyFitToScreen;
    }

    @Override
    public boolean isAlreadyFitToScreen() {
        return this.alreadyFitToScreen;
    }

    @Override
    public void fitToScreen() {
        int margin = 50;
        Double prevZoom = null;
        while (true) {
            Iterable<PetriNetObject> petriNetObjects;
            if (!(petriNetObjects = this.currentTemplate().guiModel().getPetriNetObjects()).iterator().hasNext()) {
                this.alreadyFitToScreen = true;
                return;
            }
            int smallestX = Integer.MAX_VALUE;
            int smallestY = Integer.MAX_VALUE;
            int largestX = Integer.MIN_VALUE;
            int largestY = Integer.MIN_VALUE;
            JViewport viewport = (JViewport)this.drawingSurface().getParent();
            for (PetriNetObject pno : this.currentTemplate().guiModel().getPetriNetObjects()) {
                if (!(pno instanceof PlaceTransitionObject)) continue;
                if (pno.getOriginalX() < smallestX) {
                    smallestX = pno.getOriginalX();
                }
                if (pno.getOriginalY() < smallestY) {
                    smallestY = pno.getOriginalY();
                }
                if (pno.getOriginalX() + pno.getWidth() > largestX) {
                    largestX = pno.getOriginalX() + pno.getWidth();
                }
                if (pno.getOriginalY() + pno.getHeight() > largestY) {
                    largestY = pno.getOriginalY() + pno.getHeight();
                }
                if (!(pno instanceof Transition)) continue;
                Transition t = (Transition)pno;
                for (Arc arc : t.getPreset()) {
                    for (ArcPathPoint point : arc.getArcPath().getArcPathPoints()) {
                        if (point.getOriginalX() < smallestX) {
                            smallestX = point.getOriginalX();
                        }
                        if (point.getOriginalY() < smallestY) {
                            smallestY = point.getOriginalY();
                        }
                        if (point.getOriginalX() > largestX) {
                            largestX = point.getOriginalX();
                        }
                        if (point.getOriginalY() <= largestY) continue;
                        largestY = point.getOriginalY();
                    }
                }
                for (Arc arc : t.getPostset()) {
                    for (ArcPathPoint point : arc.getArcPath().getArcPathPoints()) {
                        if (point.getOriginalX() < smallestX) {
                            smallestX = point.getOriginalX();
                        }
                        if (point.getOriginalY() < smallestY) {
                            smallestY = point.getOriginalY();
                        }
                        if (point.getOriginalX() > largestX) {
                            largestX = point.getOriginalX();
                        }
                        if (point.getOriginalY() <= largestY) continue;
                        largestY = point.getOriginalY();
                    }
                }
            }
            smallestX = Math.max(0, smallestX - 50);
            smallestY = Math.max(0, smallestY - 50);
            int width = (largestX += 50) - smallestX;
            int height = (largestY += 50) - smallestY;
            double xZoomFactor = (double)viewport.getWidth() / (double)width;
            double yZoomFactor = (double)viewport.getHeight() / (double)height;
            double zoomFactor = Math.min(xZoomFactor, yZoomFactor);
            double zoomPercent = zoomFactor * 100.0;
            double currentZoomPercent = this.drawingSurface().getZoomController().getPercent();
            double zoomConvergence = 1.0;
            double current = Math.abs(currentZoomPercent - zoomPercent);
            if (current < 1.0 || prevZoom != null && current == prevZoom) {
                int x = (int)((double)smallestX * zoomFactor) - 50;
                int y = (int)((double)smallestY * zoomFactor) - 50;
                x = Math.max(0, x);
                y = Math.max(0, y);
                viewport.setViewPosition(new Point(x, y));
                this.alreadyFitToScreen = true;
                return;
            }
            prevZoom = current;
            this.app.ifPresent(e -> e.updateZoomSlider((int)zoomPercent));
        }
    }

    @Override
    public void selectAll() {
        this.drawingSurface().getSelectionObject().selectAll();
    }

    @Override
    public void deleteSelection() {
        this.guiModelManager.deleteSelection();
    }

    @Override
    public void stepBackwards() {
        this.getAnimator().stepBack();
    }

    @Override
    public void stepForward() {
        this.getAnimator().stepForward();
    }

    @Override
    public void undo() {
        this.getUndoManager().undo();
        this.network().buildConstraints();
    }

    @Override
    public void redo() {
        this.getUndoManager().redo();
        this.network().buildConstraints();
    }

    public void writeNetToFile(File outFile, List<TAPNQuery> queriesOverwrite, TAPNLens lens) {
        try {
            NetworkMarking currentMarking = null;
            if (this.isInAnimationMode()) {
                currentMarking = this.network().marking();
                this.network().setMarking(this.getAnimator().getInitialMarking());
            }
            TimedArcPetriNetNetworkWriter tapnWriter = new TimedArcPetriNetNetworkWriter(this.network(), this.allTemplates(), queriesOverwrite, this.network().constants(), lens);
            tapnWriter.savePNML(outFile);
            if (this.isInAnimationMode()) {
                this.network().setMarking(currentMarking);
            }
        }
        catch (Exception e) {
            Logger.log(e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e.toString(), "File Output Error", 0);
        }
    }

    public void writeNetToFile(File outFile) {
        this.writeNetToFile(outFile, (List)this.queries(), this.lens);
    }

    @Override
    public void saveNet(File outFile) {
        try {
            this.writeNetToFile(outFile);
            this.setFile(outFile);
            this.setNetChanged(false);
            this.getUndoManager().clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e.toString(), "File Output Error", 0);
        }
    }

    @Override
    public void increaseSpacing() {
        double factor = 1.25;
        this.changeSpacing(factor);
        this.getUndoManager().addNewEdit(new ChangeSpacingEditCommand(factor, this));
    }

    @Override
    public void decreaseSpacing() {
        double factor = 0.8;
        this.changeSpacing(factor);
        this.getUndoManager().addNewEdit(new ChangeSpacingEditCommand(factor, this));
    }

    public void changeSpacing(double factor) {
        if (factor < 1.0) {
            Quadtree quadtree = new Quadtree();
            int minimumDistance = 45;
            for (PetriNetObject obj : this.currentTemplate().guiModel().getPetriNetObjects()) {
                int newY;
                if (!(obj instanceof PlaceTransitionObject)) continue;
                int newX = (int)(((PlaceTransitionObject)obj).getCenter().getX() * factor);
                Point newLocation = new Point(newX, newY = (int)(((PlaceTransitionObject)obj).getCenter().getY() * factor));
                if (quadtree.containsWithin(newLocation, 45)) {
                    return;
                }
                quadtree.insert(newLocation);
            }
        }
        HashMap<PlaceTransitionObject, Point> locations = new HashMap<PlaceTransitionObject, Point>();
        for (PetriNetObject obj : this.currentTemplate().guiModel().getPetriNetObjects()) {
            if (obj instanceof PlaceTransitionObject) {
                PlaceTransitionObject pno = (PlaceTransitionObject)obj;
                Point2D.Double center = pno.getCenter();
                int newCenterX = (int)(((Point2D)center).getX() * factor);
                int newCenterY = (int)(((Point2D)center).getY() * factor);
                pno.setCenter(newCenterX, newCenterY);
                locations.put(pno, new Point(newCenterX, newCenterY));
                if (pno instanceof Transition) {
                    int newY;
                    int newX;
                    for (Arc arc : pno.getPreset()) {
                        for (ArcPathPoint point : arc.getArcPath().getArcPathPoints()) {
                            int offsetY;
                            newX = (int)(point.getPoint().x * factor);
                            newY = (int)(point.getPoint().y * factor);
                            int offsetX = point.getPoint().x - (double)newX > 0.0 ? Grid.getGridSpacing() : -Grid.getGridSpacing();
                            int n = offsetY = point.getPoint().y - (double)newY > 0.0 ? Grid.getGridSpacing() : -Grid.getGridSpacing();
                            while (locations.containsValue(new Point(newX, newY))) {
                                newX += offsetX;
                                newY += offsetY;
                            }
                            point.setPointLocation(newX, newY);
                        }
                    }
                    for (Arc arc : pno.getPostset()) {
                        for (ArcPathPoint point : arc.getArcPath().getArcPathPoints()) {
                            newX = (int)(point.getPoint().x * factor);
                            newY = (int)(point.getPoint().y * factor);
                            point.setPointLocation(newX, newY);
                        }
                    }
                }
                pno.update(true);
                continue;
            }
            int newX = (int)((double)obj.getLocation().x * factor);
            int newY = (int)((double)obj.getLocation().y * factor);
            obj.setLocation(newX, newY);
        }
        this.currentTemplate().guiModel().repaintAll(true);
        this.drawingSurface().updatePreferredSize();
    }

    public PetriNetTab duplicateTab(TAPNLens overwriteLens, String appendName) {
        TimedArcPetriNetNetworkWriter tapnWriter = new TimedArcPetriNetNetworkWriter(this.network(), this.allTemplates(), this.queries(), this.network().constants(), overwriteLens);
        try {
            ByteArrayOutputStream outputStream = tapnWriter.savePNML();
            Object composedName = this.getTabTitle();
            composedName = ((String)composedName).replace(".tapn", "");
            composedName = (String)composedName + appendName;
            return PetriNetTab.createNewTabFromInputStream(new ByteArrayInputStream(outputStream.toByteArray()), (String)composedName);
        }
        catch (Exception e1) {
            Logger.log("Could not load model");
            e1.printStackTrace();
            return null;
        }
    }

    private void setManager(AbstractDrawingSurfaceManager newManager) {
        ((AbstractDrawingSurfaceManager)this.managerRef.get()).deregisterManager();
        this.managerRef.setReference(newManager);
        ((AbstractDrawingSurfaceManager)this.managerRef.get()).registerManager(this.drawingSurface, this.guiModelManager);
    }

    public void updateZoom() {
        int zoom = this.drawingSurface().getZoom();
        this.zoomTo(zoom);
    }

    public void updateFeatureText() {
        boolean[] features = new boolean[]{this.lens.isTimed(), this.lens.isGame(), this.lens.isColored(), this.lens.isStochastic()};
        this.app.ifPresent(o -> o.setFeatureInfoText(features));
    }

    public TAPNLens getLens() {
        return this.lens;
    }

    private void convertToUntimedTab(PetriNetTab tab) {
        TabTransformer.removeTimingInformation(tab);
        if (this.lens.isStochastic()) {
            TabTransformer.removeDistributionInformation(tab);
        }
    }

    public List<GuiAction> getAvailableDrawActions() {
        ArrayList<GuiAction> actions = this.lens.isTimed() && !this.lens.isGame() ? new ArrayList<GuiAction>(Arrays.asList(this.selectAction, this.timedPlaceAction, this.transAction, this.urgentTransAction, this.timedArcAction, this.transportArcAction, this.inhibarcAction, this.tokenAction, this.deleteTokenAction, this.annotationAction, this.toggleUrgentAction)) : (this.lens.isTimed() ? new ArrayList<GuiAction>(Arrays.asList(this.selectAction, this.timedPlaceAction, this.transAction, this.urgentTransAction, this.uncontrollableTransAction, this.uncontrollableUrgentTransAction, this.timedArcAction, this.transportArcAction, this.inhibarcAction, this.tokenAction, this.deleteTokenAction, this.annotationAction, this.toggleUrgentAction, this.toggleUncontrollableAction)) : (this.lens.isGame() ? new ArrayList<GuiAction>(Arrays.asList(this.selectAction, this.timedPlaceAction, this.transAction, this.uncontrollableTransAction, this.timedArcAction, this.inhibarcAction, this.tokenAction, this.deleteTokenAction, this.annotationAction, this.toggleUncontrollableAction)) : new ArrayList<GuiAction>(Arrays.asList(this.selectAction, this.timedPlaceAction, this.transAction, this.timedArcAction, this.inhibarcAction, this.tokenAction, this.deleteTokenAction, this.annotationAction))));
        if (this.lens.isColored()) {
            actions.remove(this.tokenAction);
            actions.remove(this.deleteTokenAction);
        }
        return actions;
    }

    public List<GuiAction> getAvailableSimActions() {
        if (this.lens.isTimed()) {
            return new ArrayList<GuiAction>(Arrays.asList(this.timeAction, this.delayFireAction));
        }
        this.delayFireAction.setName("Fire");
        this.delayFireAction.setTooltip("Fire Selected Transition");
        return new ArrayList<GuiAction>(List.of(this.delayFireAction));
    }

    public List<GuiAction> getAvailableToolActions() {
        if (this.lens.isColored()) {
            return new ArrayList<GuiAction>(List.of(this.unfoldTabAction));
        }
        return new ArrayList<GuiAction>(List.of());
    }

    public void updateMode(DrawTool mode) {
        this.selectAction.setSelected(mode == DrawTool.SELECT);
        this.transAction.setSelected(mode == DrawTool.TRANSITION);
        this.urgentTransAction.setSelected(mode == DrawTool.URGENT_TRANSITION);
        this.uncontrollableTransAction.setSelected(mode == DrawTool.UNCONTROLLABLE_TRANSITION);
        this.uncontrollableUrgentTransAction.setSelected(mode == DrawTool.URGENT_UNCONTROLLABLE_TRANSITION);
        this.timedPlaceAction.setSelected(mode == DrawTool.PLACE);
        this.timedArcAction.setSelected(mode == DrawTool.ARC);
        this.transportArcAction.setSelected(mode == DrawTool.TRANSPORT_ARC);
        this.inhibarcAction.setSelected(mode == DrawTool.INHIBITOR_ARC);
        this.tokenAction.setSelected(mode == DrawTool.ADD_TOKEN);
        this.deleteTokenAction.setSelected(mode == DrawTool.REMOVE_TOKEN);
        this.annotationAction.setSelected(mode == DrawTool.ANNOTATION);
    }

    @Override
    public void updateEnabledActions(GuiFrame.GUIMode mode) {
        switch (mode) {
            case draw: {
                this.selectAction.setEnabled(true);
                this.transAction.setEnabled(true);
                this.urgentTransAction.setEnabled(true);
                this.uncontrollableTransAction.setEnabled(true);
                this.toggleUncontrollableAction.setEnabled(true);
                this.uncontrollableUrgentTransAction.setEnabled(true);
                this.toggleUrgentAction.setEnabled(true);
                this.timedPlaceAction.setEnabled(true);
                this.timedArcAction.setEnabled(true);
                this.transportArcAction.setEnabled(true);
                this.inhibarcAction.setEnabled(true);
                this.tokenAction.setEnabled(true);
                this.deleteTokenAction.setEnabled(true);
                this.annotationAction.setEnabled(true);
                this.delayFireAction.setEnabled(false);
                this.timeAction.setEnabled(false);
                break;
            }
            case noNet: {
                this.selectAction.setEnabled(false);
                this.transAction.setEnabled(false);
                this.urgentTransAction.setEnabled(false);
                this.uncontrollableTransAction.setEnabled(false);
                this.toggleUncontrollableAction.setEnabled(false);
                this.uncontrollableUrgentTransAction.setEnabled(false);
                this.toggleUrgentAction.setEnabled(false);
                this.timedPlaceAction.setEnabled(false);
                this.timedArcAction.setEnabled(false);
                this.transportArcAction.setEnabled(false);
                this.inhibarcAction.setEnabled(false);
                this.tokenAction.setEnabled(false);
                this.deleteTokenAction.setEnabled(false);
                this.annotationAction.setEnabled(false);
                this.delayFireAction.setEnabled(false);
                this.timeAction.setEnabled(false);
            }
            case animation: {
                this.selectAction.setEnabled(true);
                this.transAction.setEnabled(false);
                this.urgentTransAction.setEnabled(false);
                this.uncontrollableTransAction.setEnabled(false);
                this.toggleUncontrollableAction.setEnabled(false);
                this.uncontrollableUrgentTransAction.setEnabled(false);
                this.toggleUrgentAction.setEnabled(false);
                this.timedPlaceAction.setEnabled(false);
                this.timedArcAction.setEnabled(false);
                this.transportArcAction.setEnabled(false);
                this.inhibarcAction.setEnabled(false);
                this.tokenAction.setEnabled(false);
                this.deleteTokenAction.setEnabled(false);
                this.annotationAction.setEnabled(false);
                this.delayFireAction.setEnabled(true);
                if (!this.lens.isTimed()) break;
                this.timeAction.setEnabled(true);
            }
        }
    }

    @Override
    public void enableActionsForSearchBar(boolean enable) {
        this.selectAction.setEnabled(enable);
        this.transAction.setEnabled(enable);
        this.urgentTransAction.setEnabled(enable);
        this.uncontrollableTransAction.setEnabled(enable);
        this.uncontrollableUrgentTransAction.setEnabled(enable);
        this.timedPlaceAction.setEnabled(enable);
        this.timedArcAction.setEnabled(enable);
        this.transportArcAction.setEnabled(enable);
        this.inhibarcAction.setEnabled(enable);
        this.tokenAction.setEnabled(enable);
        this.deleteTokenAction.setEnabled(enable);
        this.annotationAction.setEnabled(enable);
    }

    public void changeStatusbarText(DrawTool type) {
        switch (type.ordinal()) {
            case 3: {
                this.app.ifPresent(o14 -> o14.setStatusBarText(textforUncontrollableTrans));
            }
            case 1: {
                this.app.ifPresent(o12 -> o12.setStatusBarText(textforTAPNPlace));
                break;
            }
            case 2: {
                this.app.ifPresent(o11 -> o11.setStatusBarText(textforTransition));
                break;
            }
            case 4: {
                this.app.ifPresent(o9 -> o9.setStatusBarText(textforArc));
                break;
            }
            case 5: {
                this.app.ifPresent(o8 -> o8.setStatusBarText(textforTransportArc));
                break;
            }
            case 6: {
                this.app.ifPresent(o7 -> o7.setStatusBarText(textforInhibArc));
                break;
            }
            case 9: {
                this.app.ifPresent(o6 -> o6.setStatusBarText(textforAddtoken));
                break;
            }
            case 10: {
                this.app.ifPresent(o5 -> o5.setStatusBarText(textforDeltoken));
                break;
            }
            case 11: {
                this.app.ifPresent(o4 -> o4.setStatusBarText(textforMove));
                break;
            }
            case 12: {
                this.app.ifPresent(o3 -> o3.setStatusBarText(textforDrawing));
                break;
            }
            case 0: {
                this.app.ifPresent(o2 -> o2.setStatusBarText(textforAnnotation));
                break;
            }
            case 13: {
                this.app.ifPresent(o1 -> o1.setStatusBarText(textforDrag));
                break;
            }
            default: {
                this.app.ifPresent(o -> o.setStatusBarText("To-do (textfor" + String.valueOf((Object)type)));
            }
        }
    }

    private boolean canNetBeSavedAndShowMessage() {
        if (this.network().paintNet()) {
            return true;
        }
        String message = "The net is too big and cannot be saved or exported.";
        Object[] dialogContent = new Object[]{message};
        JOptionPane.showMessageDialog(null, dialogContent, "Large net limitation", 2);
        return false;
    }

    @Override
    public void exportPNG() {
        if (this.canNetBeSavedAndShowMessage()) {
            Export.exportGuiView(this.drawingSurface(), 1, null, null, this);
        }
    }

    @Override
    public void exportPS() {
        if (this.canNetBeSavedAndShowMessage()) {
            Export.exportGuiView(this.drawingSurface(), 2, null, null, this);
        }
    }

    @Override
    public void exportTIKZ() {
        if (this.canNetBeSavedAndShowMessage()) {
            Export.exportGuiView(this.drawingSurface(), 5, this.drawingSurface().getGuiModel(), null, this);
        }
    }

    @Override
    public void exportPNML() {
        if (this.canNetBeSavedAndShowMessage()) {
            if (Preferences.getInstance().getShowPNMLWarning() && this.lens.isTimed()) {
                JCheckBox showAgain = new JCheckBox("Do not show this warning.");
                String message = "In the saved PNML all timing information will be lost\nand the components in the net will be merged into one big net.";
                Object[] dialogContent = new Object[]{message, showAgain};
                JOptionPane.showMessageDialog(null, dialogContent, "PNML loss of information", 2);
                Preferences.getInstance().setShowPNMLWarning(!showAgain.isSelected());
            }
            Export.exportGuiView(this.drawingSurface(), 6, null, null, this);
        }
    }

    @Override
    public void exportQueryXML() {
        if (this.canNetBeSavedAndShowMessage()) {
            Export.exportGuiView(this.drawingSurface(), 7, null, this.lens, this);
        }
    }

    @Override
    public void workflowAnalyse() {
        WorkflowDialog.showDialog(this);
    }

    public boolean restoreWorkflowDialog() {
        return this.workflowDialog != null && this.workflowDialog.restoreWindow();
    }

    public WorkflowDialog getWorkflowDialog() {
        return this.workflowDialog;
    }

    public void setWorkflowDialog(WorkflowDialog dialog) {
        this.workflowDialog = dialog;
    }

    public static enum DrawTool {
        ANNOTATION,
        PLACE,
        TRANSITION,
        UNCONTROLLABLE_TRANSITION,
        ARC,
        TRANSPORT_ARC,
        INHIBITOR_ARC,
        URGENT_TRANSITION,
        URGENT_UNCONTROLLABLE_TRANSITION,
        ADD_TOKEN,
        REMOVE_TOKEN,
        SELECT,
        DRAW,
        DRAG;

    }

    static final class CanvasPlaceDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasPlaceDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addNewTimedPlace(this.canvas.getGuiModel(), p);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasTransitionDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasTransitionDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addNewTimedTransitions(this.canvas.getGuiModel(), p, false, false);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasUrgentTransitionDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasUrgentTransitionDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addNewTimedTransitions(this.canvas.getGuiModel(), p, true, false);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasUncontrollableTransitionDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasUncontrollableTransitionDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addNewTimedTransitions(this.canvas.getGuiModel(), p, false, true);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasUncontrollableUrgentTransitionDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasUncontrollableUrgentTransitionDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addNewTimedTransitions(this.canvas.getGuiModel(), p, true, true);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasAnnotationNoteDrawController
    extends AbstractDrawingSurfaceManager {
        CanvasAnnotationNoteDrawController() {
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
            this.guiModelManager.addAnnotationNote(this.canvas.getGuiModel(), p);
        }

        @Override
        public void registerEvents() {
        }
    }

    static final class CanvasArcDrawController
    extends AbstractCanvasArcDrawController {
        private TimedTransitionComponent transition;
        private TimedPlaceComponent place;

        CanvasArcDrawController() {
        }

        @Override
        protected void transitionClicked(TimedTransitionComponent pno, MouseEvent e) {
            if (this.place == null && this.transition == null) {
                this.transition = pno;
                this.connectsTo = 1;
                this.arc = new TimedOutputArcComponent(pno);
                this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                this.canvas.addPrototype(this.arc);
                this.arc.requestFocusInWindow();
                this.arc.setSelectable(false);
                this.arc.enableDrawingKeyBindings(this::clearPendingArc);
            } else if (this.place != null && this.transition == null) {
                this.transition = pno;
                this.canvas.clearAllPrototype();
                Result<TimedInputArcComponent, ModelViolation> result = this.guiModelManager.addTimedInputArc(this.canvas.getGuiModel(), this.place, this.transition, this.arc.getArcPath());
                this.showPopupIfFailed(result);
                this.clearPendingArc();
                if (e != null && e.isControlDown()) {
                    this.transition = pno;
                    this.connectsTo = 1;
                    this.arc = new TimedOutputArcComponent(pno);
                    this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                    this.canvas.addPrototype(this.arc);
                    this.arc.requestFocusInWindow();
                    this.arc.setSelectable(false);
                    this.arc.enableDrawingKeyBindings(this::clearPendingArc);
                }
            }
        }

        @Override
        protected void placeClicked(TimedPlaceComponent pno, MouseEvent e) {
            if (this.place == null && this.transition == null) {
                this.place = pno;
                this.connectsTo = 2;
                this.arc = new TimedInputArcComponent(pno);
                this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                this.canvas.addPrototype(this.arc);
                this.arc.requestFocusInWindow();
                this.arc.setSelectable(false);
                this.arc.enableDrawingKeyBindings(this::clearPendingArc);
            } else if (this.transition != null && this.place == null) {
                this.place = pno;
                this.canvas.clearAllPrototype();
                Result<TimedOutputArcComponent, ModelViolation> result = this.guiModelManager.addTimedOutputArc(this.canvas.getGuiModel(), this.transition, this.place, this.arc.getArcPath());
                this.showPopupIfFailed(result);
                this.clearPendingArc();
                if (e != null && e.isControlDown()) {
                    this.place = pno;
                    this.connectsTo = 2;
                    this.arc = new TimedInputArcComponent(pno);
                    this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                    this.canvas.addPrototype(this.arc);
                    this.arc.requestFocusInWindow();
                    this.arc.setSelectable(false);
                    this.arc.enableDrawingKeyBindings(this::clearPendingArc);
                }
            }
        }

        @Override
        protected void clearPendingArc() {
            super.clearPendingArc();
            this.canvas.clearAllPrototype();
            this.place = null;
            this.transition = null;
            this.arc = null;
        }
    }

    static final class CanvasInhibitorarcDrawController
    extends AbstractCanvasArcDrawController {
        private TimedTransitionComponent transition;
        private TimedPlaceComponent place;

        CanvasInhibitorarcDrawController() {
        }

        @Override
        protected void transitionClicked(TimedTransitionComponent pno, MouseEvent e) {
            if (this.place != null && this.transition == null) {
                this.transition = pno;
                this.canvas.clearAllPrototype();
                Result<TimedInhibitorArcComponent, ModelViolation> result = this.guiModelManager.addInhibitorArc(this.canvas.getGuiModel(), this.place, this.transition, this.arc.getArcPath());
                this.showPopupIfFailed(result);
                this.clearPendingArc();
            }
        }

        @Override
        protected void placeClicked(TimedPlaceComponent pno, MouseEvent e) {
            if (this.place == null && this.transition == null) {
                this.place = pno;
                this.connectsTo = 2;
                this.arc = new TimedInhibitorArcComponent(pno);
                this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                this.canvas.addPrototype(this.arc);
                this.arc.requestFocusInWindow();
                this.arc.setSelectable(false);
                this.arc.enableDrawingKeyBindings(this::clearPendingArc);
            }
        }

        @Override
        protected void clearPendingArc() {
            super.clearPendingArc();
            this.canvas.clearAllPrototype();
            this.place = null;
            this.transition = null;
            this.arc = null;
        }
    }

    static final class CanvasTransportarcDrawController
    extends AbstractCanvasArcDrawController {
        private TimedTransitionComponent transition;
        private TimedPlaceComponent place1;
        private TimedPlaceComponent place2;
        private Arc arc1;
        private Arc arc2;

        CanvasTransportarcDrawController() {
        }

        @Override
        protected void placetranstionMouseExited(PlaceTransitionObject pto) {
            if (this.arc != null) {
                this.arc.setTarget(null);
                if (pto instanceof Transition) {
                    ((Transition)pto).removeArcCompareObject(this.arc);
                }
                this.arc.updateArcPosition();
            }
        }

        @Override
        protected void placetranstionMouseOver(PlaceTransitionObject pno) {
            if (this.arc != null && this.arc.getSource() != pno && this.arc.getSource().areNotSameType(pno)) {
                this.arc.setTarget(pno);
                this.arc.updateArcPosition();
            }
        }

        @Override
        protected void transitionClicked(TimedTransitionComponent pno, MouseEvent e) {
            if (this.place1 != null && this.transition == null) {
                this.transition = pno;
                this.connectsTo = 1;
                this.arc2 = this.arc = new TimedTransportArcComponent((PlaceTransitionObject)pno, -1, false);
                this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                this.canvas.addPrototype(this.arc);
                this.arc.requestFocusInWindow();
                this.arc.setSelectable(false);
                this.arc.enableDrawingKeyBindings(this::clearPendingArc);
            }
        }

        @Override
        protected void placeClicked(TimedPlaceComponent pno, MouseEvent e) {
            if (this.place1 == null && this.transition == null) {
                this.place1 = pno;
                this.connectsTo = 2;
                this.arc1 = this.arc = new TimedTransportArcComponent((PlaceTransitionObject)pno, -1, true);
                this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                this.canvas.addPrototype(this.arc);
                this.arc.requestFocusInWindow();
                this.arc.setSelectable(false);
                this.arc.enableDrawingKeyBindings(this::clearPendingArc);
            } else if (this.transition != null && this.place2 == null) {
                this.place2 = pno;
                this.canvas.clearAllPrototype();
                Result<TimedTransportArcComponent, ModelViolation> result = this.guiModelManager.addTimedTransportArc(this.canvas.getGuiModel(), this.place1, this.transition, this.place2, this.arc1.getArcPath(), this.arc2.getArcPath());
                this.showPopupIfFailed(result);
                this.clearPendingArc();
                if (e != null && e.isControlDown()) {
                    this.place1 = pno;
                    this.connectsTo = 2;
                    this.arc1 = this.arc = new TimedTransportArcComponent((PlaceTransitionObject)pno, -1, true);
                    this.arc.setEndPoint(pno.getPositionX(), pno.getPositionY(), false);
                    this.canvas.addPrototype(this.arc);
                    this.arc.requestFocusInWindow();
                    this.arc.setSelectable(false);
                    this.arc.enableDrawingKeyBindings(this::clearPendingArc);
                }
            }
        }

        @Override
        protected void clearPendingArc() {
            super.clearPendingArc();
            this.canvas.clearAllPrototype();
            this.place2 = null;
            this.place1 = null;
            this.transition = null;
            this.arc2 = null;
            this.arc1 = null;
            this.arc = null;
        }
    }

    final class CanvasGeneralDrawController
    extends AbstractDrawingSurfaceManager {
        final TAPNLens lens;
        boolean justSelected = false;
        boolean isDragging = false;
        Point dragInit = new Point();
        private int totalX = 0;
        private int totalY = 0;
        private Point dragStartPoint;

        public CanvasGeneralDrawController(TAPNLens lens) {
            this.lens = lens;
        }

        @Override
        public void registerEvents() {
            this.registerEvent(e -> e.pno instanceof PetriNetObject && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed, e -> this.pnoPressed((PetriNetObject)e.pno, e.e));
            this.registerEvent(e -> e.pno instanceof PetriNetObject && e.a == AbstractDrawingSurfaceManager.MouseAction.released, e -> this.pnoReleased((PetriNetObject)e.pno, e.e));
            this.registerEvent(e -> e.pno instanceof PetriNetObject && e.a == AbstractDrawingSurfaceManager.MouseAction.dragged, e -> this.pnoDragged((PetriNetObject)e.pno, e.e));
            if (!PetriNetTab.this.isInAnimationMode()) {
                this.registerEvent(e -> e.pno instanceof TimedTransitionComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.doubleClicked, e -> ((TimedTransitionComponent)e.pno).showEditor());
                this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.doubleClicked, e -> ((TimedPlaceComponent)e.pno).showEditor());
                this.registerEvent(e -> e.pno instanceof TimedTransitionComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.rightClicked, e -> ((TimedTransitionComponent)e.pno).getPopup(e.e).show(e.pno, e.e.getX(), e.e.getY()));
                this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.rightClicked, e -> ((TimedPlaceComponent)e.pno).getPopup(e.e).show(e.pno, e.e.getX(), e.e.getY()));
                this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.rightClicked, e -> ((Arc)e.pno).getPopup(e.e).show(e.pno, e.e.getX(), e.e.getY()));
                this.registerEvent(e -> e.pno instanceof ArcPathPoint && e.a == AbstractDrawingSurfaceManager.MouseAction.rightClicked, e -> ((ArcPathPoint)e.pno).getPopup(e.e).show(e.pno, e.e.getX(), e.e.getY()));
                this.registerEvent(e -> e.pno instanceof AnnotationNote && e.a == AbstractDrawingSurfaceManager.MouseAction.doubleClicked, e -> ((AnnotationNote)e.pno).enableEditMode());
                this.registerEvent(e -> e.pno instanceof AnnotationNote && e.a == AbstractDrawingSurfaceManager.MouseAction.rightClicked, e -> ((AnnotationNote)e.pno).getPopup(e.e).show(e.pno, e.e.getX(), e.e.getY()));
                this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.entered, e -> ((Arc)e.pno).getArcPath().showPoints());
                this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.exited, e -> ((Arc)e.pno).getArcPath().hidePoints());
                this.registerEvent(e -> e.pno instanceof TimedOutputArcComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.doubleClicked && !e.e.isControlDown(), e -> ((TimedOutputArcComponent)e.pno).showTimeIntervalEditor());
                this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.doubleClicked && e.e.isControlDown(), e -> this.arcDoubleClickedWithContrl((Arc)e.pno, e.e));
                this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> this.timedPlaceMouseWheelWithShift((TimedPlaceComponent)e.pno, (MouseWheelEvent)e.e));
                this.registerEvent(e -> e.pno instanceof TimedTransitionComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> this.timedTranstionMouseWheelWithShift((TimedTransitionComponent)e.pno, (MouseWheelEvent)e.e));
                this.registerEvent(e -> e.pno instanceof ArcPathPoint && e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> {
                    if (e.e.isShiftDown()) {
                        this.guiModelManager.toggleArcPathPointType((ArcPathPoint)e.pno);
                    }
                });
                this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> this.arcMouseWheel((PetriNetObject)e.pno, e.e));
                this.registerEvent(e -> e.pno instanceof ArcPathPoint && e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> this.arcMouseWheel((PetriNetObject)e.pno, e.e));
                ArrayList<PetriNetObject> pnObjects = PetriNetTab.this.drawingSurface.getGuiModel().getPNObjects();
                for (PetriNetObject pn : pnObjects) {
                    if (pn instanceof TimedPlaceComponent) {
                        TimedPlaceComponent place = (TimedPlaceComponent)pn;
                        place.showAgeOfTokens(false);
                        continue;
                    }
                    if (!(pn instanceof TimedTransitionComponent)) continue;
                    TimedTransitionComponent transition = (TimedTransitionComponent)pn;
                    transition.showDInterval(false);
                }
            } else {
                this.registerEvent(e -> e.a == AbstractDrawingSurfaceManager.MouseAction.pressed && e.pno instanceof TimedTransitionComponent && SwingUtilities.isLeftMouseButton(e.e), e -> this.transitionLeftClicked((TimedTransitionComponent)e.pno));
                this.registerEvent(e -> e.a == AbstractDrawingSurfaceManager.MouseAction.entered && e.pno instanceof PlaceTransitionObject, e -> this.mouseEnterPTO((PlaceTransitionObject)e.pno));
                this.registerEvent(e -> e.a == AbstractDrawingSurfaceManager.MouseAction.exited && e.pno instanceof PlaceTransitionObject, e -> this.mouseExitPTO((PlaceTransitionObject)e.pno));
                this.registerEvent(e -> e.a == AbstractDrawingSurfaceManager.MouseAction.wheel, e -> e.pno.getParent().dispatchEvent(e.e));
            }
        }

        private void pnoPressed(PetriNetObject pno, MouseEvent e) {
            if (PetriNetTab.this.isInAnimationMode() && pno instanceof TimedTransitionComponent) {
                this.dragInit = e.getPoint();
                this.justSelected = false;
                return;
            }
            if (!pno.isSelected()) {
                if (!e.isShiftDown()) {
                    this.canvas.getSelectionObject().clearSelection();
                }
                pno.select();
                this.justSelected = true;
            }
            this.dragInit = e.getPoint();
        }

        private void pnoReleased(PetriNetObject pno, MouseEvent e) {
            if (PetriNetTab.this.isInAnimationMode() && pno instanceof TimedTransitionComponent) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (!this.isDragging) {
                    TimedTransitionComponent t = (TimedTransitionComponent)pno;
                    TimedTransition transition = t.underlyingTransition();
                    if (transition.isDEnabled()) {
                        PetriNetTab.this.animator.dFireTransition(transition);
                    }
                } else {
                    this.canvas.translateSelection(this.totalX, this.totalY);
                }
                this.isDragging = false;
                this.totalX = 0;
                this.totalY = 0;
                this.justSelected = false;
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.isDragging) {
                this.isDragging = false;
                this.canvas.translateSelection(this.totalX, this.totalY);
                this.totalX = 0;
                this.totalY = 0;
            } else if (!this.justSelected) {
                if (e.isShiftDown()) {
                    pno.deselect();
                } else {
                    this.canvas.getSelectionObject().clearSelection();
                    pno.select();
                }
            }
            this.justSelected = false;
        }

        private void pnoDragged(PetriNetObject pno, MouseEvent e) {
            if (PetriNetTab.this.isInAnimationMode() && pno instanceof TimedTransitionComponent && !pno.isSelected()) {
                this.canvas.getSelectionObject().clearSelection();
                pno.select();
            }
            if (pno instanceof Arc || pno instanceof ArcPathPoint && ((ArcPathPoint)pno).isEndPoint()) {
                return;
            }
            int previousX = pno.getX();
            int previousY = pno.getY();
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (pno.isDraggable() && !this.isDragging) {
                this.isDragging = true;
            }
            int transX = Grid.align(e.getX() - this.dragInit.x, this.canvas.getZoom());
            int transY = Grid.align(e.getY() - this.dragInit.y, this.canvas.getZoom());
            this.canvas.getSelectionObject().translateSelection(transX, transY);
            this.totalX += pno.getX() - previousX;
            this.totalY += pno.getY() - previousY;
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            Point clickPoint = e.getPoint();
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.canvas.getSelectionObject().dispatchEvent(e);
            } else {
                this.canvas.setCursor(Cursor.getPredefinedCursor(13));
                this.dragStartPoint = new Point(clickPoint);
            }
            this.canvas.updatePreferredSize();
        }

        @Override
        public void drawingSurfaceMouseReleased(MouseEvent e) {
            if (this.dragStartPoint != null) {
                this.dragStartPoint = null;
                this.canvas.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.canvas.getSelectionObject().dispatchEvent(e);
        }

        @Override
        public void drawingSurfaceMouseDragged(MouseEvent e) {
            if (this.dragStartPoint != null) {
                this.canvas.drag(this.dragStartPoint, e.getPoint());
            } else {
                this.canvas.getSelectionObject().dispatchEvent(e);
            }
        }

        private void arcMouseWheel(PetriNetObject pno, MouseEvent e) {
            pno.getParent().dispatchEvent(e);
        }

        private void timedTranstionMouseWheelWithShift(TimedTransitionComponent p, MouseWheelEvent e) {
            if (p.isSelected()) {
                int rotation = e.getWheelRotation() < 0 ? -e.getWheelRotation() * 135 : e.getWheelRotation() * 45;
                TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(((Transition)p).rotate(rotation));
            } else {
                p.getParent().dispatchEvent(e);
            }
        }

        private void timedPlaceMouseWheelWithShift(TimedPlaceComponent p, MouseWheelEvent e) {
            if (!this.lens.isColored()) {
                if (p.isSelected()) {
                    if (e.getWheelRotation() < 0) {
                        this.guiModelManager.addToken(this.canvas.getGuiModel(), p, 1);
                    } else {
                        this.guiModelManager.removeToken(this.canvas.getGuiModel(), p, 1);
                    }
                } else {
                    p.getParent().dispatchEvent(e);
                }
            }
        }

        private void arcDoubleClickedWithContrl(Arc arc, MouseEvent e) {
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(arc.getArcPath().insertPoint(new Point2D.Double(Zoomer.getUnzoomedValue(arc.getX() + e.getX(), arc.getZoom()), Zoomer.getUnzoomedValue(arc.getY() + e.getY(), arc.getZoom())), e.isAltDown()));
        }

        void transitionLeftClicked(TimedTransitionComponent t) {
            TimedTransition transition = t.underlyingTransition();
            if (transition.isDEnabled()) {
                PetriNetTab.this.animator.dFireTransition(transition);
            }
        }

        void mouseEnterPTO(PlaceTransitionObject pto) {
            if (pto instanceof TimedPlaceComponent) {
                ((TimedPlaceComponent)pto).showAgeOfTokens(true);
            } else if (pto instanceof TimedTransitionComponent) {
                ((TimedTransitionComponent)pto).showDInterval(true);
            }
        }

        void mouseExitPTO(PlaceTransitionObject pto) {
            if (pto instanceof TimedPlaceComponent) {
                ((TimedPlaceComponent)pto).showAgeOfTokens(false);
            } else if (pto instanceof TimedTransitionComponent) {
                ((TimedTransitionComponent)pto).showDInterval(false);
            }
        }
    }

    static abstract class AbstractCanvasArcDrawController
    extends AbstractDrawingSurfaceManager {
        protected Arc arc;
        protected int connectsTo = 1;

        AbstractCanvasArcDrawController() {
        }

        @Override
        public void registerEvents() {
            this.registerEvent(e -> e.pno instanceof TimedPlaceComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed, e -> this.placeClicked((TimedPlaceComponent)e.pno, e.e));
            this.registerEvent(e -> e.pno instanceof TimedTransitionComponent && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed, e -> this.transitionClicked((TimedTransitionComponent)e.pno, e.e));
            this.registerEvent(e -> e.pno instanceof PlaceTransitionObject && e.a == AbstractDrawingSurfaceManager.MouseAction.entered, e -> this.placetranstionMouseOver((PlaceTransitionObject)e.pno));
            this.registerEvent(e -> e.pno instanceof PlaceTransitionObject && e.a == AbstractDrawingSurfaceManager.MouseAction.exited, e -> this.placetranstionMouseExited((PlaceTransitionObject)e.pno));
            this.registerEvent(e -> e.pno instanceof PlaceTransitionObject && e.a == AbstractDrawingSurfaceManager.MouseAction.moved, e -> this.placetransitionMouseMoved((PlaceTransitionObject)e.pno, e.e));
            this.registerEvent(e -> e.pno instanceof Arc && e.a == AbstractDrawingSurfaceManager.MouseAction.pressed, e -> this.arcClicked((Arc)e.pno, e.e));
        }

        private void arcClicked(Arc pno, MouseEvent e) {
            if (pno.isPrototype()) {
                e.translatePoint(pno.getX(), pno.getY());
                pno.getParent().dispatchEvent(e);
            }
        }

        protected abstract void transitionClicked(TimedTransitionComponent var1, MouseEvent var2);

        protected abstract void placeClicked(TimedPlaceComponent var1, MouseEvent var2);

        protected void clearPendingArc() {
            this.connectsTo = 0;
        }

        @Override
        public void setupManager() {
            TAPAALGUI.useExtendedBounds = true;
        }

        @Override
        public void teardownManager() {
            this.clearPendingArc();
            TAPAALGUI.useExtendedBounds = false;
        }

        @Override
        public void drawingSurfaceMouseMoved(MouseEvent e) {
            if (this.arc != null) {
                this.arc.setEndPoint(e.getX(), e.getY(), e.isShiftDown());
            }
        }

        @Override
        public void drawingSurfaceMousePressed(MouseEvent e) {
            if (this.arc != null) {
                if (!e.isControlDown()) {
                    Point p = e.getPoint();
                    int x = Zoomer.getUnzoomedValue(p.x, this.canvas.getZoom());
                    int y = Zoomer.getUnzoomedValue(p.y, this.canvas.getZoom());
                    boolean shiftDown = e.isShiftDown();
                    this.arc.getArcPath().addPoint(this.arc.getArcPath().getEndIndex(), x, y, shiftDown);
                } else if (this.connectsTo != 0) {
                    Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
                    if (this.connectsTo == 1) {
                        Result<TimedPlaceComponent, ModelViolation> r = this.guiModelManager.addNewTimedPlace(this.canvas.getGuiModel(), p);
                        this.placeClicked((TimedPlaceComponent)r.result, e);
                    } else {
                        Result<TimedTransitionComponent, ModelViolation> r = this.guiModelManager.addNewTimedTransitions(this.canvas.getGuiModel(), p, false, false);
                        this.transitionClicked((TimedTransitionComponent)r.result, e);
                    }
                }
            } else if (e.isControlDown()) {
                Point p = this.canvas.adjustPointToGridAndZoom(e.getPoint(), this.canvas.getZoom());
                Result<TimedPlaceComponent, ModelViolation> r = this.guiModelManager.addNewTimedPlace(this.canvas.getGuiModel(), p);
                this.placeClicked((TimedPlaceComponent)r.result, e);
            }
        }

        protected void showPopupIfFailed(Result<?, ModelViolation> result) {
            if (result.hasErrors) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("There was an error drawing the arc. Possible problems:");
                for (ModelViolation v : result.getErrors()) {
                    errorMessage.append("\n  - ").append(v.getErrorMessage());
                }
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), errorMessage, "Error", 0);
            }
        }

        protected void placetransitionMouseMoved(PlaceTransitionObject pno, MouseEvent e) {
            if (!(this.arc == null || this.arc.getSource() != pno && this.arc.getSource().areNotSameType(pno))) {
                e.translatePoint(pno.getX(), pno.getY());
                pno.getParent().dispatchEvent(e);
            }
        }

        protected void placetranstionMouseExited(PlaceTransitionObject pto) {
            if (this.arc != null) {
                this.arc.setTarget(null);
                if (pto instanceof Transition) {
                    ((Transition)pto).removeArcCompareObject(this.arc);
                    ((Transition)pto).updateEndPoints();
                }
                this.arc.updateArcPosition();
            }
        }

        protected void placetranstionMouseOver(PlaceTransitionObject pno) {
            if (this.arc != null && this.arc.getSource() != pno && this.arc.getSource().areNotSameType(pno)) {
                this.arc.setTarget(pno);
                this.arc.updateArcPosition();
            }
        }
    }
}

