/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.graph;

import dk.aau.cs.util.Require;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pipe.gui.TAPAALGUI;
import pipe.gui.graph.DraggableChartPanel;
import pipe.gui.graph.Graph;
import pipe.gui.graph.GraphDialog;
import pipe.gui.graph.GraphExporter;
import pipe.gui.graph.GraphPoint;
import pipe.gui.swingcomponents.EscapableDialog;

public class DefaultGraphDialog
extends EscapableDialog
implements GraphDialog {
    private final List<Graph> graphs;
    private boolean showLegend;
    private boolean piecewise;
    private boolean pointPlot;
    private boolean isStraight;
    private double distanceToOrigin;
    private Double mean;
    private boolean hasZeroPoint;
    private boolean hasZeroX;
    private boolean hasZeroY;
    private String currentCard = "";

    private DefaultGraphDialog(List<Graph> graphs, String title, boolean showLegend, boolean piecewise, boolean pointPlot) {
        super(TAPAALGUI.getAppGui(), title, true);
        this.graphs = graphs;
        this.showLegend = showLegend;
        this.piecewise = piecewise;
        this.pointPlot = pointPlot;
    }

    @Override
    public void display() {
        if (this.piecewise || this.graphs.size() < 2) {
            this.displayWithoutButtons();
        } else {
            this.displayWithButtons();
        }
        this.setupDialog();
    }

    private void displayWithoutButtons() {
        JFreeChart chart = this.createChart(this.graphs);
        DraggableChartPanel chartPanel = this.createChartPanel(chart);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)chartPanel), "Center");
        JPanel exportPanel = new JPanel(new BorderLayout());
        JButton exportButton = new JButton("Export to TikZ");
        exportButton.addActionListener(e -> {
            if (this.piecewise) {
                GraphExporter.exportPiecewiseToTikz(this.graphs, this);
            } else if (this.pointPlot) {
                GraphExporter.exportPointPlotToTikz(this.graphs.get(0), this);
            } else {
                GraphExporter.exportToTikz(this.graphs.get(0), this);
            }
        });
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        buttonWrapper.setBackground(Color.WHITE);
        buttonWrapper.add(exportButton);
        exportPanel.add((Component)buttonWrapper, "East");
        exportPanel.setBackground(Color.WHITE);
        this.add((Component)exportPanel, "South");
    }

    private void displayWithButtons() {
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        JPanel buttonPanel = new JPanel();
        for (Graph graph : this.graphs) {
            String buttonText;
            JFreeChart chart = this.createChart(Collections.singletonList(graph));
            DraggableChartPanel chartPanel = this.createChartPanel(chart);
            this.currentCard = buttonText = graph.getButtonText();
            cardPanel.add((Component)((Object)chartPanel), buttonText);
            JButton button = new JButton(buttonText);
            button.addActionListener(e -> {
                cardLayout.show(cardPanel, buttonText);
                this.currentCard = buttonText;
            });
            buttonPanel.add(button);
        }
        this.currentCard = this.graphs.get(0).getButtonText();
        JPanel exportPanel = new JPanel(new BorderLayout());
        JButton exportButton = new JButton("Export to TikZ");
        exportButton.addActionListener(e -> {
            Graph currentGraph = this.graphs.stream().filter(g -> g.getButtonText().equals(this.currentCard)).findFirst().orElseThrow(() -> new IllegalStateException("No graph found for current card: " + this.currentCard));
            GraphExporter.exportToTikz(currentGraph, this);
        });
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        buttonWrapper.setBackground(Color.WHITE);
        buttonWrapper.add(exportButton);
        exportPanel.add((Component)buttonWrapper, "East");
        exportPanel.setBackground(Color.WHITE);
        JPanel southPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(Color.WHITE);
        southPanel.add((Component)buttonPanel, "Center");
        southPanel.add((Component)exportPanel, "South");
        southPanel.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)cardPanel, "Center");
        this.add((Component)southPanel, "South");
    }

    private void setupDialog() {
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private DraggableChartPanel createChartPanel(JFreeChart chart) {
        DraggableChartPanel chartPanel = new DraggableChartPanel(chart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    private JFreeChart createChart(List<Graph> graphs) {
        ValueAxis rangeAxis;
        ValueAxis domainAxis;
        XYDataset dataset = this.constructDataset(graphs);
        JFreeChart chart = graphs.isEmpty() ? ChartFactory.createXYLineChart((String)"", (String)"X", (String)"Y", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false) : ChartFactory.createXYLineChart((String)graphs.get(0).getName(), (String)graphs.get(0).getXAxisLabel(), (String)graphs.get(0).getYAxisLabel(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (this.showLegend || this.mean != null ? 1 : 0) != 0, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        float lineThickness = 3.0f;
        double negativeMargin = -0.01;
        if (this.hasZeroPoint) {
            domainAxis = plot.getDomainAxis();
            domainAxis.setRange(-0.01, domainAxis.getUpperBound());
            ValueAxis rangeAxis2 = plot.getRangeAxis();
            rangeAxis2.setRange(-0.01, rangeAxis2.getUpperBound());
        } else if (this.hasZeroX) {
            domainAxis = plot.getDomainAxis();
            domainAxis.setRange(-0.01, domainAxis.getUpperBound());
        } else if (this.hasZeroY) {
            rangeAxis = plot.getRangeAxis();
            rangeAxis.setRange(-0.01, rangeAxis.getUpperBound());
        }
        if (this.isStraight) {
            domainAxis = plot.getDomainAxis();
            domainAxis.setRange(this.distanceToOrigin - 1.0, this.distanceToOrigin + 1.0);
        } else if (this.mean != null) {
            rangeAxis = plot.getRangeAxis();
            float[] dashPattern = new float[]{5.0f, 5.0f};
            BasicStroke dashed = new BasicStroke(lineThickness, 0, 0, 10.0f, dashPattern, 0.0f);
            XYLineAnnotation annotation = new XYLineAnnotation(this.mean.doubleValue(), rangeAxis.getLowerBound(), this.mean.doubleValue(), rangeAxis.getUpperBound(), (Stroke)dashed, (Paint)Color.BLACK);
            plot.addAnnotation((XYAnnotation)annotation);
            Line2D.Double lineShape = new Line2D.Double(0.0, 0.0, 30.0, 0.0);
            LegendItemCollection legendItems = this.showLegend ? plot.getLegendItems() : new LegendItemCollection();
            legendItems.add(new LegendItem("Mean", null, null, null, (Shape)lineShape, (Paint)Color.BLACK, (Stroke)dashed, (Paint)Color.BLACK));
            plot.setFixedLegendItems(legendItems);
        }
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        Color lineColor = Color.RED;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(lineThickness));
            renderer.setSeriesShapesVisible(i, this.pointPlot);
            renderer.setSeriesLinesVisible(i, !this.pointPlot);
            renderer.setSeriesPaint(i, (Paint)lineColor);
        }
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.setDomainGridlinePaint((Paint)Color.BLACK);
        return chart;
    }

    private XYDataset constructDataset(List<Graph> graphs) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        this.hasZeroPoint = false;
        this.hasZeroX = false;
        this.hasZeroY = false;
        for (Graph graph : graphs) {
            XYSeries series = new XYSeries((Comparable)((Object)graph.getName()));
            List<GraphPoint> points = graph.getPoints();
            double margin = 1.0E-5;
            if (!points.isEmpty()) {
                double last;
                double first = points.get(0).getX();
                this.isStraight = Math.abs(first - (last = points.get(points.size() - 1).getX())) < margin && !this.piecewise;
                this.distanceToOrigin = first;
            }
            if (graph.getMean() != null) {
                this.mean = graph.getMean();
            }
            for (GraphPoint point : points) {
                Require.that(point.getX() >= 0.0 && point.getY() >= 0.0, "Negative points are not supported");
                series.add(point.getX(), point.getY());
                this.hasZeroX = point.getX() < margin || this.hasZeroX;
                this.hasZeroY = point.getY() < margin || this.hasZeroY;
            }
            this.hasZeroPoint = this.hasZeroX && this.hasZeroY;
            dataset.addSeries(series);
        }
        return dataset;
    }

    public static class GraphDialogBuilder {
        private List<Graph> graphs = new ArrayList<Graph>();
        private String title;
        private boolean showLegend;
        private boolean piecewise;
        private boolean pointPlot;

        public GraphDialogBuilder addGraphs(List<Graph> graphs) {
            this.graphs.addAll(graphs);
            return this;
        }

        public GraphDialogBuilder addGraph(Graph graph) {
            this.graphs.add(graph);
            return this;
        }

        public GraphDialogBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public GraphDialogBuilder setShowLegend(boolean showLegend) {
            this.showLegend = showLegend;
            return this;
        }

        public GraphDialogBuilder setPiecewise(boolean piecewise) {
            this.piecewise = piecewise;
            return this;
        }

        public GraphDialogBuilder setPointPlot(boolean pointPlot) {
            this.pointPlot = pointPlot;
            return this;
        }

        public GraphDialog build() {
            DefaultGraphDialog dialog = new DefaultGraphDialog(this.graphs, this.title, this.showLegend, this.piecewise, this.pointPlot);
            return dialog;
        }
    }
}

