/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.canvas;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import pipe.gui.canvas.Zoomer;

public class Grid {
    private static double gridSpacing = 15.0;
    private static final Color gridColor = new Color(240, 240, 255);
    private static GeneralPath gridDisplay;
    private static boolean enabled;
    private static int gridHeight;
    private static int gridWidth;
    private static int gridCount;

    private static void createGrid() {
        double i;
        gridDisplay = new GeneralPath();
        for (i = gridSpacing; i <= (double)gridWidth; i += gridSpacing) {
            gridDisplay.moveTo(i, 2.0);
            gridDisplay.lineTo(i, (double)gridHeight);
        }
        for (i = gridSpacing; i <= (double)gridHeight; i += gridSpacing) {
            gridDisplay.moveTo(2.0, i);
            gridDisplay.lineTo((double)gridWidth, i);
        }
    }

    public static void enableGrid() {
        if (!enabled) {
            enabled = true;
        }
    }

    public static void increment() {
        ++gridCount;
        if ((gridCount %= 4) == 3) {
            Grid.disableGrid();
        } else {
            Grid.enableGrid();
            Grid.setGridSpacing(Math.pow(2.0, gridCount - 2));
        }
    }

    private static void setGridSpacing(double spacing) {
        gridSpacing = spacing * 30.0;
    }

    public static int getGridSpacing() {
        return (int)gridSpacing;
    }

    public static void disableGrid() {
        if (enabled) {
            enabled = false;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void updateSize(Container parent) {
        if (enabled) {
            gridHeight = parent.getHeight();
            gridWidth = parent.getWidth();
            Grid.createGrid();
        }
    }

    public static void drawGrid(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gridColor);
        g2d.draw(gridDisplay);
    }

    public static int align(int x, int zoom) {
        if (!enabled) {
            return x;
        }
        double unzoomed = Zoomer.getUnzoomedValue(x, zoom);
        double adjusted = (double)Math.round(unzoomed / gridSpacing) * gridSpacing;
        return Math.round(Zoomer.getZoomedValue(adjusted, zoom));
    }

    static {
        gridCount = 1;
    }
}

