/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.canvas;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.tapaal.gui.DrawingSurfaceManager.AbstractDrawingSurfaceManager;
import net.tapaal.helpers.Reference.Reference;
import pipe.gui.Constants;
import pipe.gui.canvas.Canvas;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.PrototypeCanvas;
import pipe.gui.canvas.SelectionManager;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.GraphicalElement;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;
import pipe.gui.petrinet.graphicElements.Zoomable;
import pipe.gui.petrinet.undo.TranslatePetriNetObjectEditCommand;

public class DrawingSurfaceImpl
extends JLayeredPane
implements Printable,
Canvas,
PrototypeCanvas {
    private static final int DRAWING_SURFACE_GROW = 100;
    private final SelectionManager selection;
    private Zoomer zoomControl;
    private DataLayer guiModel;
    private final PetriNetTab tabContent;
    private final Reference<AbstractDrawingSurfaceManager> managerRef;
    private static final boolean showDebugBounds = false;

    public DrawingSurfaceImpl(DataLayer dataLayer, PetriNetTab tabContent, Reference<AbstractDrawingSurfaceManager> managerRef) {
        this.guiModel = dataLayer;
        this.tabContent = tabContent;
        this.managerRef = managerRef;
        this.zoomControl = new Zoomer(100);
        this.selection = new SelectionManager(this);
        this.setLayout(null);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setAutoscrolls(true);
        this.setBackground(Constants.ELEMENT_FILL_COLOUR);
        this.setCursor(Cursor.getPredefinedCursor(1));
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addMouseWheelListener(mouseHandler);
    }

    public DataLayer getGuiModel() {
        return this.guiModel;
    }

    public void setModel(DataLayer guiModel, Zoomer zoomer) {
        this.guiModel.removedFromView();
        guiModel.addedToView(this);
        this.guiModel = guiModel;
        this.zoomControl = zoomer;
        this.removeAll();
        this.setPreferredSize(new Dimension(0, 0));
        for (PetriNetObject pnObject : guiModel.getPetriNetObjectsWithArcPathPoint()) {
            this.addNewPetriNetObject(pnObject);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void addNewPetriNetObject(GraphicalElement newObject) {
        this.setLayer(newObject, DEFAULT_LAYER + newObject.getLayerOffset());
        newObject.zoomUpdate(this.zoomControl.getPercent());
        newObject.setManagerRef(this.managerRef);
        super.add(newObject);
        newObject.addedToGui();
        this.calculateNewBoundsForScrollPane(newObject.getBounds());
        if (newObject instanceof PetriNetObjectWithLabel && ((PetriNetObjectWithLabel)newObject).getNameLabel() != null) {
            this.calculateNewBoundsForScrollPane(((PetriNetObjectWithLabel)newObject).getNameLabel().getBounds());
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void removePetriNetObject(GraphicalElement pno) {
        pno.removedFromGui();
        pno.setManagerRef(null);
        super.remove(pno);
        this.updatePreferredSize();
        this.validate();
        this.repaint();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2D = (Graphics2D)g;
        g2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2D.scale(0.5, 0.5);
        this.print(g2D);
        return 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (Grid.isEnabled()) {
            Grid.updateSize(this);
            Grid.drawGrid(g);
        }
    }

    public void updatePreferredSize() {
        Component[] components = this.getComponents();
        Dimension d = new Dimension(0, 0);
        for (Component component : components) {
            if (component.getClass() == SelectionManager.class) continue;
            Rectangle r = component.getBounds();
            int x = r.x + r.width + 100;
            int y = r.y + r.height + 100;
            if (x > d.width) {
                d.width = x;
            }
            if (y <= d.height) continue;
            d.height = y;
        }
        this.setPreferredSize(d);
        this.validate();
        this.repaint();
        Container parent = this.getParent();
        if (parent != null) {
            parent.validate();
        }
    }

    public Rectangle calculateBoundingRectangle() {
        Component[] components;
        Rectangle rect = new Rectangle(0, 0, -1, -1);
        for (Component component : components = this.getComponents()) {
            if (component.getClass() == SelectionManager.class) continue;
            rect.add(component.getBounds());
        }
        return rect;
    }

    public SelectionManager getSelectionObject() {
        return this.selection;
    }

    public Zoomer getZoomController() {
        return this.zoomControl;
    }

    private void calculateNewBoundsForScrollPane(Rectangle rect) {
        boolean changed = false;
        Dimension current = this.getPreferredSize();
        int this_width = rect.x + rect.width + 2;
        int this_height = rect.y + rect.height + 2;
        if (this_width > current.width) {
            current.width = this_width;
            changed = true;
        }
        if (this_height > current.height) {
            current.height = this_height;
            changed = true;
        }
        if (changed) {
            this.setPreferredSize(current);
            this.revalidate();
        }
    }

    public void drag(Point dragStart, Point dragEnd) {
        if (dragStart == null) {
            return;
        }
        JViewport viewer = (JViewport)this.getParent();
        Point offScreen = viewer.getViewPosition();
        if (dragStart.x > dragEnd.x) {
            offScreen.translate(viewer.getWidth(), 0);
        }
        if (dragStart.y > dragEnd.y) {
            offScreen.translate(0, viewer.getHeight());
        }
        offScreen.translate(dragStart.x - dragEnd.x, dragStart.y - dragEnd.y);
        Rectangle r = new Rectangle(offScreen.x, offScreen.y, 1, 1);
        this.scrollRectToVisible(r);
    }

    private Point midpoint(int zoom) {
        JViewport viewport = (JViewport)this.getParent();
        double midpointX = Zoomer.getUnzoomedValue((double)viewport.getViewPosition().x + (double)viewport.getWidth() * 0.5, zoom);
        double midpointY = Zoomer.getUnzoomedValue((double)viewport.getViewPosition().y + (double)viewport.getHeight() * 0.5, zoom);
        return new Point((int)midpointX, (int)midpointY);
    }

    public void zoomToMidPoint() {
        int newViewY;
        Component[] children;
        Point midpoint = this.midpoint(this.zoomControl.getPercent());
        int zoomPercent = this.getZoom();
        JViewport viewport = (JViewport)this.getParent();
        for (Component child : children = this.getComponents()) {
            if (!(child instanceof Zoomable)) continue;
            ((Zoomable)((Object)child)).zoomUpdate(zoomPercent);
        }
        double newZoomedX = Zoomer.getZoomedValue(midpoint.x, zoomPercent);
        double newZoomedY = Zoomer.getZoomedValue(midpoint.y, zoomPercent);
        int newViewX = (int)(newZoomedX - (double)viewport.getWidth() * 0.5);
        if (newViewX < 0) {
            newViewX = 0;
        }
        if ((newViewY = (int)(newZoomedY - (double)viewport.getHeight() * 0.5)) < 0) {
            newViewY = 0;
        }
        viewport.setViewPosition(new Point(newViewX, newViewY));
        this.updatePreferredSize();
    }

    public int getZoom() {
        return this.zoomControl.getPercent();
    }

    @Override
    public void addPrototype(GraphicalElement pno) {
        pno.zoomUpdate(this.getZoom());
        pno.setManagerRef(this.managerRef);
        this.add(pno);
        this.setLayer(pno, 80);
        this.validate();
        this.repaint();
    }

    @Override
    public void removePrototype(GraphicalElement pno) {
        this.remove(pno);
        pno.setManagerRef(null);
        if (pno instanceof Arc) {
            Arc a = (Arc)pno;
            a.setSource(null);
            a.setTarget(null);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void clearAllPrototype() {
        for (Component c : this.getComponentsInLayer(80)) {
            this.remove(c);
        }
        this.validate();
        this.repaint();
    }

    public Point adjustPointToZoom(Point p, int zoom) {
        int offset = (int)(Zoomer.getScaleFactor(zoom) * 30.0 / 2.0);
        int x = Zoomer.getUnzoomedValue(p.x - offset, zoom);
        int y = Zoomer.getUnzoomedValue(p.y - offset, zoom);
        p.setLocation(x, y);
        return p;
    }

    public Point adjustPointToGrid(Point p) {
        int x = Grid.align(p.x, this.getZoom());
        int y = Grid.align(p.y, this.getZoom());
        return new Point(x, y);
    }

    public Point adjustPointToGridAndZoom(Point p, int zoom) {
        Point newP = this.adjustPointToZoom(p, zoom);
        newP = this.adjustPointToGrid(newP);
        return newP;
    }

    public void repaintAll() {
        this.repaint();
        this.guiModel.repaintAll(!this.tabContent.isInAnimationMode());
    }

    public void translateSelection(int transX, int transY) {
        ArrayList<PetriNetObject> objects = this.getSelectionObject().getSelection();
        if (transX != 0 || transY != 0) {
            this.tabContent.getUndoManager().newEdit();
            for (PetriNetObject pnobject : objects) {
                this.tabContent.getUndoManager().addEdit(new TranslatePetriNetObjectEditCommand(pnobject, transX, transY, this));
            }
        }
    }

    @Override
    public void scrollToCenter(Component component) {
        int centerX = component.getX() + component.getWidth() / 2;
        int centerY = component.getY() + component.getHeight() / 2;
        JViewport viewport = (JViewport)this.getParent();
        int viewWidth = viewport.getWidth();
        int viewHeight = viewport.getHeight();
        int scrollX = Math.max(0, centerX - viewWidth / 2);
        int scrollY = Math.max(0, centerY - viewHeight / 2);
        viewport.setViewPosition(new Point(scrollX, scrollY));
        SwingUtilities.invokeLater(this::requestFocusInWindow);
    }

    final class MouseHandler
    extends MouseInputAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMouseReleased(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMouseMoved(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMouseDragged(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (DrawingSurfaceImpl.this.managerRef != null && DrawingSurfaceImpl.this.managerRef.get() != null) {
                DrawingSurfaceImpl.this.managerRef.get().drawingSurfaceMouseWheelMoved(e);
            }
            if (e.isControlDown()) {
                if (e.getWheelRotation() > 0) {
                    DrawingSurfaceImpl.this.tabContent.zoomIn();
                } else {
                    DrawingSurfaceImpl.this.tabContent.zoomOut();
                }
            } else {
                DrawingSurfaceImpl.this.getParent().dispatchEvent(e);
            }
        }
    }
}

