/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui;

import dk.aau.cs.Messenger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pipe.gui.TAPAALGUI;

public class MessengerImpl
implements Messenger {
    @Override
    public void displayInfoMessage(String message) {
        this.displayInfoMessage(message, "Message");
    }

    @Override
    public void displayInfoMessage(String message, String title) {
        this.showMessageBox(this.getTextArea(message), title, 1);
    }

    @Override
    public void displayErrorMessage(String message) {
        this.displayErrorMessage(message, "Error");
    }

    @Override
    public void displayErrorMessage(String message, String title) {
        this.showMessageBox(this.getTextArea(message), title, 0);
    }

    private void showMessageBox(Object message, String title, int messageType) {
        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, title, messageType);
    }

    @Override
    public void displayWrappedErrorMessage(String message, String title) {
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setEnabled(true);
        textArea.setDisabledTextColor(Color.BLACK);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 100));
        scrollPane.getViewport().setView(textArea);
        this.showMessageBox(scrollPane, title, 0);
    }

    private JTextArea getTextArea(String message) {
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setEnabled(true);
        textArea.setLineWrap(false);
        textArea.setDisabledTextColor(Color.BLACK);
        textArea.setBackground(Color.getColor("FFe0d0"));
        return textArea;
    }
}

