/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui;

import com.sun.jna.Platform;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.util.JavaUtil;
import dk.aau.cs.verification.UPPAAL.Verifyta;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.gui.FileDropTarget;
import net.tapaal.gui.GuiFrameActions;
import net.tapaal.gui.GuiFrameControllerActions;
import net.tapaal.gui.SafeGuiFrameActions;
import net.tapaal.gui.TabActions;
import net.tapaal.gui.debug.DEBUG;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.dialog.ColoredSimulationDialog;
import net.tapaal.gui.petrinet.dialog.ExportBatchDialog;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawDialog;
import net.tapaal.helpers.Reference.MutableReference;
import net.tapaal.helpers.Reference.Reference;
import net.tapaal.resourcemanager.ResourceManager;
import net.tapaal.swinghelpers.ExtendedJTabbedPane;
import net.tapaal.swinghelpers.SwingHelper;
import net.tapaal.swinghelpers.ToggleButtonWithoutText;
import org.jetbrains.annotations.NotNull;
import pipe.gui.StatusBar;
import pipe.gui.TAPAALGUI;
import pipe.gui.TabComponent;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.SelectionManager;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.SearchBar;
import pipe.gui.petrinet.action.GuiAction;
import pipe.gui.petrinet.animation.SimulatorFocusTraversalPolicy;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.editor.EditorFocusTraversalPolicy;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class GuiFrame
extends JFrame
implements GuiFrameActions,
SafeGuiFrameActions {
    private final String frameTitle;
    final MutableReference<GuiFrameControllerActions> guiFrameController = new MutableReference();
    private final ExtendedJTabbedPane<PetriNetTab> appTab;
    private final StatusBar statusBar;
    private JMenuBar menuBar;
    private JMenu drawMenu;
    private JMenu animateMenu;
    private JMenu viewMenu;
    private JMenu toolsMenu;
    private JToolBar drawingToolBar;
    private JToolBar searchToolBar;
    private SearchBar searchBar;
    private final JLabel featureInfoText = new JLabel();
    private final JComboBox<String> timeFeatureOptions = new JComboBox<String>(new String[]{"No", "Yes"});
    private final JComboBox<String> gameFeatureOptions = new JComboBox<String>(new String[]{"No", "Yes"});
    private final JComboBox<String> colorFeatureOptions = new JComboBox<String>(new String[]{"No", "Yes"});
    private final JComboBox<String> stochasticFeatureOptions = new JComboBox<String>(new String[]{"No", "Yes"});
    private static final String FIT_TO_SCREEN_NAME = "Fit to screen";
    private static final String FIT_TO_SCREEN_TOOLTIP = "Fit the net to the screen";
    private static final String FIT_TO_SCREEN_ICON = "Fit to screen.png";
    private JSlider zoomSlider;
    private static final int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private final GuiAction createAction = new GuiAction("New", "Create a new Petri net", KeyStroke.getKeyStroke(78, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showNewPNDialog);
        }
    };
    private final GuiAction openAction = new GuiAction("Open", "Open", KeyStroke.getKeyStroke(79, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::openTAPNFile);
        }
    };
    private final GuiAction closeAction = new GuiAction("Close", "Close the current tab", KeyStroke.getKeyStroke(87, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PetriNetTab index = (PetriNetTab)GuiFrame.this.appTab.getSelectedComponent();
            GuiFrame.this.guiFrameController.ifPresent(o -> o.closeTab(index));
        }
    };
    private final GuiAction saveAction = new GuiAction("Save", "Save", KeyStroke.getKeyStroke(83, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::save);
        }
    };
    private final GuiAction saveAsAction = new GuiAction("Save as", "Save as...", KeyStroke.getKeyStroke(83, shortcutkey + 1)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::saveAs);
        }
    };
    private final GuiAction exitAction = new GuiAction("Exit", "Close the program", KeyStroke.getKeyStroke(81, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::exit);
        }
    };
    private final GuiAction printAction = new GuiAction("Print", "Print", KeyStroke.getKeyStroke(80, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::print);
        }
    };
    private final GuiAction importPNMLAction = new GuiAction("PNML untimed net", "Import an untimed net in the PNML format", KeyStroke.getKeyStroke(88, 1)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::importPNMLFile);
        }
    };
    private final GuiAction importSUMOAction = new GuiAction("SUMO queries (.txt)", "Import SUMO queries in a plain text format"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::importSUMOQueries);
        }
    };
    private final GuiAction importXMLAction = new GuiAction("XML queries (.xml)", "Import MCC queries in XML format", KeyStroke.getKeyStroke(82, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::importXMLQueries);
        }
    };
    private final GuiAction exportPNGAction = new GuiAction("PNG", "Export the net to PNG format", KeyStroke.getKeyStroke(71, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportPNG);
        }
    };
    private final GuiAction exportPSAction = new GuiAction("PostScript", "Export the net to PostScript format", KeyStroke.getKeyStroke(84, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportPS);
        }
    };
    private final GuiAction exportToTikZAction = new GuiAction("TikZ", "Export the net to LaTex (TikZ) format", KeyStroke.getKeyStroke(76, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportTIKZ);
        }
    };
    private final GuiAction exportToPNMLAction = new GuiAction("PNML", "Export the net to PNML format", KeyStroke.getKeyStroke(68, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportPNML);
        }
    };
    private final GuiAction exportToXMLAction = new GuiAction("XML Queries", "Export the queries to XML format", KeyStroke.getKeyStroke(72, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportQueryXML);
        }
    };
    private final GuiAction exportTraceAction = new GuiAction("Export trace", "Export the current trace", ""){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::exportTrace);
        }
    };
    private final GuiAction importTraceAction = new GuiAction("Import trace", "Import trace to simulator", ""){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::importTrace);
        }
    };
    private final GuiAction exportBatchAction = new GuiAction("Batch Export of model and queries", "Export multiple nets and queries for the command line use with the verification engines.", KeyStroke.getKeyStroke(68, shortcutkey + 64)){

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportBatchDialog.ShowExportBatchDialog();
        }
    };
    private final GuiAction cutAction = new GuiAction("Cut", "Cut current selection", KeyStroke.getKeyStroke(88, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::cut);
        }
    };
    private final GuiAction copyAction = new GuiAction("Copy", "Copy current selection", KeyStroke.getKeyStroke(67, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::copy);
        }
    };
    private final GuiAction pasteAction = new GuiAction("Paste", "Paste", KeyStroke.getKeyStroke(86, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::past);
        }
    };
    private final GuiAction undoAction = new GuiAction("Undo", "Undo", KeyStroke.getKeyStroke(90, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::undo);
        }
    };
    private final GuiAction redoAction = new GuiAction("Redo", "Redo", KeyStroke.getKeyStroke(89, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::redo);
        }
    };
    private final GuiAction toggleGrid = new GuiAction("Cycle grid", "Change the grid size", "G"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Grid.increment();
            GuiFrame.this.repaint();
        }
    };
    private final GuiAction alignToGrid = new GuiAction("Align To Grid", "Align Petri net objects to current grid", KeyStroke.getKeyStroke("shift G")){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::alignToGrid);
        }
    };
    private final GuiAction netStatisticsAction = new GuiAction("Net statistics", "Shows information about the number of transitions, places, arcs, etc.", KeyStroke.getKeyStroke(73, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::showStatistics);
        }
    };
    private final GuiAction batchProcessingAction = new GuiAction("Batch processing", "Batch verification of multiple nets and queries", KeyStroke.getKeyStroke(66, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showBatchProcessingDialog);
        }
    };
    private final GuiAction engineSelectionAction = new GuiAction("Engine selection", "View and modify the location of verification engines", KeyStroke.getKeyStroke(69, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showEngineDialog);
        }
    };
    private final GuiAction clearPreferencesAction = new GuiAction("Clear all preferences", "Clear all custom preferences to default"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::clearPreferences);
        }
    };
    private final GuiAction showColorTypesVariables = new GuiAction("Show color types/variables/constants", "Opens a floating window showing the global color types/variables/constants for the net", KeyStroke.getKeyStroke("shift F")){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::showColorTypesVariables);
        }
    };
    private final GuiAction verifyAction = new GuiAction("Verify query", "Verifies the currently selected query", KeyStroke.getKeyStroke(77, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::verifySelectedQuery);
        }
    };
    private final GuiAction workflowDialogAction = new GuiAction("Workflow analysis", "Analyse net as a TAWFN", KeyStroke.getKeyStroke(87, shortcutkey | 0x40)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::workflowAnalyse);
        }
    };
    private final GuiAction smartDrawAction = new GuiAction("Automatic net layout", "Rearrange the Petri net objects", KeyStroke.getKeyStroke(68, 64)){

        @Override
        public void actionPerformed(ActionEvent e) {
            SmartDrawDialog.showSmartDrawDialog();
        }
    };
    private final GuiAction mergeComponentsDialogAction = new GuiAction("Merge net components", "Open a composed net in a new tab and use approximated net if enabled", KeyStroke.getKeyStroke(67, shortcutkey + 1)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::mergeNetComponents);
        }
    };
    private final GuiAction zoomOutAction = new GuiAction("Zoom out", "Zoom out by 10% ", KeyStroke.getKeyStroke(75, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::zoomOut);
        }
    };
    private final GuiAction zoomInAction = new GuiAction("Zoom in", "Zoom in by 10% ", KeyStroke.getKeyStroke(74, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::zoomIn);
        }
    };
    private final GuiAction fitToScreenAction = new GuiAction("Fit to screen", "Fit the net to the screen", KeyStroke.getKeyStroke(70, shortcutkey | 0x40)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(o -> {
                if (!o.isAlreadyFitToScreen()) {
                    o.fitToScreen();
                    this.putValue("Name", "Restore zoom");
                    this.putValue("ShortDescription", "Restore the zoom to 100%");
                    this.putValue("SmallIcon", ResourceManager.getIcon("Restore zoom.png"));
                } else {
                    GuiFrame.this.zoomSlider.setValue(100);
                    this.putValue("Name", GuiFrame.FIT_TO_SCREEN_NAME);
                    this.putValue("ShortDescription", GuiFrame.FIT_TO_SCREEN_TOOLTIP);
                    this.putValue("SmallIcon", ResourceManager.getIcon(GuiFrame.FIT_TO_SCREEN_ICON));
                    o.setIsAlreadyFitToScreen(false);
                }
            });
        }
    };
    private final GuiAction incSpacingAction = new GuiAction("Increase node spacing", "Increase spacing by 20% ", KeyStroke.getKeyStroke(85, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::increaseSpacing);
        }
    };
    private final GuiAction decSpacingAction = new GuiAction("Decrease node spacing", "Decrease spacing by 20% ", KeyStroke.getKeyStroke("shift U")){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::decreaseSpacing);
        }
    };
    public final GuiAction deleteAction = new GuiAction("Delete", "Delete selection", "DELETE"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.currentTab.ifPresent(TabActions::deleteSelection);
        }
    };
    private final GuiAction annotationAction = new GuiAction("Annotation", "Add an annotation (N)", "N", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(o -> o.setMode(PetriNetTab.DrawTool.ANNOTATION));
        }
    };
    private final GuiAction showTokenAgeAction = new GuiAction("Display token age", "Show/hide displaying the token age 0.0 (when hidden the age 0.0 is drawn as a dot)", KeyStroke.getKeyStroke(48, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleTokenAge);
        }
    };
    private final GuiAction showComponentsAction = new GuiAction("Display components", "Show/hide the list of components.", KeyStroke.getKeyStroke(49, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleComponents);
        }
    };
    private final GuiAction showSharedPTAction = new GuiAction("Display shared places/transitions", "Show/hide the list of shared places/transitions.", KeyStroke.getKeyStroke(50, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleSharedPT);
        }
    };
    private final GuiAction showQueriesAction = new GuiAction("Display queries", "Show/hide verification queries.", KeyStroke.getKeyStroke(51, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleQueries);
        }
    };
    private final GuiAction showConstantsAction = new GuiAction("Display constants", "Show/hide global constants.", KeyStroke.getKeyStroke(52, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleConstants);
        }
    };
    private final GuiAction showColoredTokensAction = new GuiAction("Display colored tokens", "Show/hide the colored tokens in each place.", KeyStroke.getKeyStroke(53, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleColorTokens);
        }
    };
    private final GuiAction showZeroToInfinityIntervalsAction = new GuiAction("Display intervals [0,\u221e)", "Show/hide intervals [0," + Character.toString('\u221e') + ") that do not restrict transition firing in any way.", KeyStroke.getKeyStroke(56, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleZeroToInfinityIntervals);
        }
    };
    private final GuiAction showEnabledTransitionsAction = new GuiAction("Display enabled transitions", "Show/hide the list of enabled transitions", KeyStroke.getKeyStroke(54, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleEnabledTransitionsList);
        }
    };
    private final GuiAction showDelayEnabledTransitionsAction = new GuiAction("Display future-enabled transitions", "Highlight transitions which can be enabled after a delay", KeyStroke.getKeyStroke(55, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleDelayEnabledTransitions);
        }
    };
    private final GuiAction showToolTipsAction = new GuiAction("Display tool tips", "Show/hide tool tips when mouse is over an element", KeyStroke.getKeyStroke(57, shortcutkey), true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::toggleDisplayToolTips);
        }
    };
    private final GuiAction changeNameVisibility = new GuiAction("Change visibility of transition/place names", "Executing this action will open a dialog where you can hide or show place and transition names", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::showChangeNameVisibility);
        }
    };
    private final GuiAction showAdvancedWorkspaceAction = new GuiAction("Show advanced workspace", "Show all panels", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showAdvancedWorkspace);
        }
    };
    private final GuiAction showSimpleWorkspaceAction = new GuiAction("Show simple workspace", "Show only the most important panels", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showSimpleWorkspace);
        }
    };
    private final GuiAction saveWorkSpaceAction = new GuiAction("Save workspace", "Save the current workspace as the default one", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::saveWorkspace);
        }
    };
    private final GuiAction showAboutAction = new GuiAction("About", "Show the About menu"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::showAbout);
        }
    };
    private final GuiAction showHomepage = new GuiAction("Visit TAPAAL home", "Visit the TAPAAL homepage"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("http://www.tapaal.net"));
        }
    };
    private final GuiAction showAskQuestionAction = new GuiAction("Ask a question", "Ask a question about TAPAAL"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("https://answers.launchpad.net/tapaal/+addquestion"));
        }
    };
    private final GuiAction showReportBugAction = new GuiAction("Report bug", "Report a bug in TAPAAL"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("https://bugs.launchpad.net/tapaal/+filebug"));
        }
    };
    private final GuiAction showFAQAction = new GuiAction("Show FAQ", "See TAPAAL frequently asked questions"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("https://answers.launchpad.net/tapaal/+faqs"));
        }
    };
    private final GuiAction showWiki = new GuiAction("Visit wiki page", "Visit the TAPAAL wiki page"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("https://github.com/TAPAAL/TAPAAL/wiki"));
        }
    };
    private final GuiAction showShortcuts = new GuiAction("Show shortcuts", "Visit the TAPAAL wiki page to find a list of shortcuts"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(o -> o.openURL("https://github.com/TAPAAL/TAPAAL/wiki/Shortcut-keys"));
        }
    };
    private final GuiAction checkUpdate = new GuiAction("Check for updates", "Check if there is a new version of TAPAAL"){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFrame.this.guiFrameController.ifPresent(GuiFrameControllerActions::checkForUpdate);
        }
    };
    private final GuiAction selectAllAction = new GuiAction("Select all", "Select all components", KeyStroke.getKeyStroke(65, shortcutkey)){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::selectAll);
        }
    };
    private final GuiAction startAction = new GuiAction("Simulation mode", "Toggle simulation mode (M)", "M", true){

        @Override
        public void actionPerformed(ActionEvent e) {
            TAPNLens lens = GuiFrame.this.getCurrentTab().getLens();
            if (lens.isColored() && !GuiFrame.this.getCurrentTab().isInAnimationMode()) {
                PetriNetTab oldTab = GuiFrame.this.getCurrentTab();
                boolean useExplicit = !lens.isGame() && !lens.isStochastic() && !lens.isTimed();
                ColoredSimulationDialog.showSimulationDialog(oldTab, useExplicit);
                if (!ColoredSimulationDialog.wasCancelled() && (oldTab != GuiFrame.this.getCurrentTab() || ColoredSimulationDialog.explicitSimulationMode())) {
                    GuiFrame.this.currentTab.ifPresent(tab -> tab.toggleAnimationMode(ColoredSimulationDialog.explicitSimulationMode()));
                } else {
                    this.setSelected(false);
                }
                ColoredSimulationDialog.resetFlags();
            } else {
                GuiFrame.this.currentTab.ifPresent(TabActions::toggleAnimationMode);
            }
        }
    };
    public final GuiAction stepforwardAction = new GuiAction("Step forward", "Step forward", "released RIGHT"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::stepForward);
        }
    };
    public final GuiAction stepbackwardAction = new GuiAction("Step backward", "Step backward", "released LEFT"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::stepBackwards);
        }
    };
    private final GuiAction prevcomponentAction = new GuiAction("Previous component", "Previous component", "pressed UP"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::previousComponent);
        }
    };
    private final GuiAction nextcomponentAction = new GuiAction("Next component", "Next component", "pressed DOWN"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFrame.this.currentTab.ifPresent(TabActions::nextComponent);
        }
    };
    private final GuiAction changeTimeFeatureAction = new GuiAction("Time", "Change time semantics"){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isTime = GuiFrame.this.timeFeatureOptions.getSelectedIndex() != 0;
            GuiFrame.this.currentTab.ifPresent(o -> o.changeTimeFeature(isTime));
            GuiFrame.this.refreshLensConstraints();
        }
    };
    private final GuiAction changeGameFeatureAction = new GuiAction("Game", "Change game semantics"){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isGame = GuiFrame.this.gameFeatureOptions.getSelectedIndex() != 0;
            GuiFrame.this.currentTab.ifPresent(o -> o.changeGameFeature(isGame));
            GuiFrame.this.refreshLensConstraints();
        }
    };
    private final GuiAction changeColorFeatureAction = new GuiAction("Color", "Change color semantics"){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isColor = GuiFrame.this.colorFeatureOptions.getSelectedIndex() != 0;
            GuiFrame.this.currentTab.ifPresent(o -> o.changeColorFeature(isColor));
            GuiFrame.this.refreshLensConstraints();
        }
    };
    private final GuiAction changeStochasticFeatureAction = new GuiAction("Stochastic", "Change stochastic semantics"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean isStochastic = GuiFrame.this.stochasticFeatureOptions.getSelectedIndex() != 0;
            GuiFrame.this.currentTab.ifPresent(o -> o.changeStochasticFeature(isStochastic));
            GuiFrame.this.refreshLensConstraints();
        }
    };
    private JCheckBoxMenuItem showZeroToInfinityIntervalsCheckBox;
    private JCheckBoxMenuItem showTokenAgeCheckBox;
    private JCheckBoxMenuItem showDelayEnabledTransitionsCheckbox;
    private JCheckBoxMenuItem showColoredTokensCheckbox;
    private final AbstractAction searchAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GuiFrame.this.searchBar != null && GuiFrame.this.searchBar.isEnabled()) {
                GuiFrame.this.searchBar.requestFocusInWindow();
            }
        }
    };
    Reference<TabActions> currentTab = null;

    public GuiFrame(String title) {
        this.checkJavaVersion();
        this.frameTitle = title;
        this.setTitle(null);
        this.trySetLookAndFeel();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width * 80 / 100, screenSize.height * 80 / 100);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(825, 480));
        this.setDefaultCloseOperation(0);
        this.appTab = new ExtendedJTabbedPane<PetriNetTab>(){

            @Override
            public Component generator() {
                return new TabComponent(this){

                    @Override
                    protected void closeTab(PetriNetTab tab) {
                        GuiFrame.this.guiFrameController.ifPresent(o -> o.closeTab(tab));
                    }
                };
            }
        };
        this.getContentPane().add(this.appTab);
        this.setChangeListenerOnTab();
        Grid.enableGrid();
        this.buildMenus();
        this.statusBar = new StatusBar();
        JPanel featurePanel = new JPanel();
        featurePanel.setLayout(new FlowLayout(2, 0, 0));
        featurePanel.add(new JLabel("Timed: "));
        featurePanel.add(this.timeFeatureOptions);
        featurePanel.add(new JLabel("   Game: "));
        featurePanel.add(this.gameFeatureOptions);
        featurePanel.add(new JLabel("   Color: "));
        featurePanel.add(this.colorFeatureOptions);
        featurePanel.add(new JLabel("   Stochastic: "));
        featurePanel.add(this.stochasticFeatureOptions);
        this.timeFeatureOptions.addActionListener(this.changeTimeFeatureAction);
        this.gameFeatureOptions.addActionListener(this.changeGameFeatureAction);
        this.colorFeatureOptions.addActionListener(this.changeColorFeatureAction);
        this.stochasticFeatureOptions.addActionListener(this.changeStochasticFeatureAction);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 2));
        bottomPanel.add(this.statusBar);
        bottomPanel.add(featurePanel);
        this.getContentPane().add((Component)bottomPanel, "Last");
        this.buildToolbar();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GuiFrame.this.exitAction.actionPerformed(null);
            }
        });
        this.setForeground(Color.BLACK);
        this.setGUIMode(GUIMode.noNet);
        Verifyta.trySetup();
        VerifyTAPN.trySetup();
        VerifyDTAPN.trySetup();
        VerifyPN.trySetup();
        this.setDropTarget(new FileDropTarget(){

            @Override
            public void onDrop(List<? extends File> files) {
                GuiFrame.this.guiFrameController.ifPresent(p -> p.openFiles(files));
            }
        });
    }

    private void checkJavaVersion() {
        int version = JavaUtil.getJREMajorVersion();
        if (version < 11) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You are using an older version of Java than 11. Some of the functionalities may not be shown correctly.");
            System.out.println("You are using an older version of Java than 11. Some of the functionalities may not be shown correctly.");
        }
    }

    private void trySetLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}));
            UIManager.put("OptionPane.informationIcon", ResourceManager.infoIcon());
            UIManager.put("Slider.paintValue", false);
        }
        catch (Exception exc) {
            Logger.log("Error loading L&F: " + String.valueOf(exc));
        }
        if (Platform.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "TAPAAL");
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            System.setProperty("apple.awt.showGrowBox", "true");
        }
        this.setIconImage(ResourceManager.getIcon("icon.png").getImage());
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
    }

    @Override
    public void setWindowSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.setSize(dimension);
    }

    private void buildMenus() {
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.buildMenuFiles());
        this.menuBar.add(this.buildMenuEdit());
        this.menuBar.add(this.buildMenuView());
        this.menuBar.add(this.buildMenuDraw());
        this.menuBar.add(this.buildMenuAnimation());
        this.menuBar.add(this.buildMenuTools());
        if (TAPAAL.IS_DEV) {
            this.menuBar.add(DEBUG.buildMenuDEBUG());
        }
        this.menuBar.add(this.buildMenuHelp());
        this.setJMenuBar(this.menuBar);
    }

    private JMenu buildMenuEdit() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        editMenu.add(this.undoAction);
        editMenu.add(this.redoAction);
        editMenu.addSeparator();
        editMenu.add(this.cutAction);
        editMenu.add(this.copyAction);
        editMenu.add(this.pasteAction);
        editMenu.addSeparator();
        editMenu.add(this.deleteAction);
        editMenu.getInputMap(2).put(KeyStroke.getKeyStroke("BACK_SPACE"), "Delete");
        editMenu.getActionMap().put("Delete", this.deleteAction);
        editMenu.addSeparator();
        editMenu.add(this.selectAllAction);
        editMenu.getInputMap(2).put(KeyStroke.getKeyStroke(65, shortcutkey), "SelectAll");
        editMenu.getActionMap().put("SelectAll", this.selectAllAction);
        return editMenu;
    }

    private JMenu buildMenuDraw() {
        this.drawMenu = new JMenu("Draw");
        this.drawMenu.setMnemonic('D');
        return this.drawMenu;
    }

    private JMenu buildMenuView() {
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.viewMenu.add(this.zoomInAction);
        this.viewMenu.add(this.zoomOutAction);
        this.viewMenu.add(this.fitToScreenAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.incSpacingAction);
        this.viewMenu.add(this.decSpacingAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.toggleGrid);
        this.viewMenu.add(this.alignToGrid);
        this.viewMenu.addSeparator();
        this.addCheckboxMenuItem(this.viewMenu, this.showComponentsAction);
        this.addCheckboxMenuItem(this.viewMenu, this.showSharedPTAction);
        this.addCheckboxMenuItem(this.viewMenu, this.showQueriesAction);
        this.addCheckboxMenuItem(this.viewMenu, this.showConstantsAction);
        this.showColoredTokensCheckbox = this.addCheckboxMenuItem(this.viewMenu, this.showColoredTokensAction);
        this.addCheckboxMenuItem(this.viewMenu, this.showEnabledTransitionsAction);
        this.showDelayEnabledTransitionsCheckbox = this.addCheckboxMenuItem(this.viewMenu, this.showDelayEnabledTransitionsAction);
        this.showZeroToInfinityIntervalsCheckBox = this.addCheckboxMenuItem(this.viewMenu, this.showZeroToInfinityIntervals(), this.showZeroToInfinityIntervalsAction);
        this.addCheckboxMenuItem(this.viewMenu, this.showToolTipsAction);
        this.showTokenAgeCheckBox = this.addCheckboxMenuItem(this.viewMenu, this.showTokenAge(), this.showTokenAgeAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.changeNameVisibility);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.showSimpleWorkspaceAction);
        this.viewMenu.add(this.showAdvancedWorkspaceAction);
        this.viewMenu.add(this.saveWorkSpaceAction);
        return this.viewMenu;
    }

    private JMenu buildMenuAnimation() {
        this.animateMenu = new JMenu("Simulator");
        this.animateMenu.setMnemonic('A');
        this.animateMenu.add(this.startAction);
        this.animateMenu.add(this.stepbackwardAction);
        this.animateMenu.add(this.stepforwardAction);
        this.animateMenu.add(this.prevcomponentAction);
        this.animateMenu.add(this.nextcomponentAction);
        this.animateMenu.addSeparator();
        this.animateMenu.add(this.exportTraceAction);
        this.animateMenu.add(this.importTraceAction);
        return this.animateMenu;
    }

    private JMenu buildMenuHelp() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        helpMenu.add(this.showHomepage);
        helpMenu.add(this.checkUpdate);
        helpMenu.addSeparator();
        helpMenu.add(this.showFAQAction);
        helpMenu.add(this.showAskQuestionAction);
        helpMenu.add(this.showReportBugAction);
        helpMenu.addSeparator();
        helpMenu.add(this.showWiki);
        helpMenu.add(this.showShortcuts);
        helpMenu.addSeparator();
        helpMenu.add(this.showAboutAction);
        return helpMenu;
    }

    private JMenu buildMenuTools() {
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic('t');
        this.toolsMenu.add(this.verifyAction).setMnemonic('m');
        this.toolsMenu.add(this.netStatisticsAction).setMnemonic('i');
        JMenuItem workflowDialog = new JMenuItem(this.workflowDialogAction);
        workflowDialog.setMnemonic('f');
        this.toolsMenu.add(workflowDialog);
        JMenuItem smartDrawDialog = new JMenuItem(this.smartDrawAction);
        smartDrawDialog.setMnemonic('D');
        this.toolsMenu.add(smartDrawDialog);
        JMenuItem mergeComponentsDialog = new JMenuItem(this.mergeComponentsDialogAction);
        mergeComponentsDialog.setMnemonic('c');
        this.toolsMenu.add(mergeComponentsDialog);
        this.toolsMenu.add(this.showColorTypesVariables);
        this.toolsMenu.addSeparator();
        JMenuItem batchProcessing = new JMenuItem(this.batchProcessingAction);
        batchProcessing.setMnemonic('b');
        this.toolsMenu.add(batchProcessing);
        this.toolsMenu.addSeparator();
        JMenuItem engineSelection = new JMenuItem(this.engineSelectionAction);
        this.toolsMenu.add(engineSelection);
        JMenuItem clearPreferences = new JMenuItem(this.clearPreferencesAction);
        this.toolsMenu.add(clearPreferences);
        return this.toolsMenu;
    }

    private void buildToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRequestFocusEnabled(false);
        toolBar.add(this.createAction).setRequestFocusEnabled(false);
        toolBar.add(this.openAction).setRequestFocusEnabled(false);
        toolBar.add(this.saveAction).setRequestFocusEnabled(false);
        toolBar.add(this.saveAsAction).setRequestFocusEnabled(false);
        toolBar.addSeparator();
        toolBar.add(this.printAction).setRequestFocusEnabled(false);
        toolBar.add(this.copyAction);
        toolBar.add(this.cutAction);
        toolBar.add(this.pasteAction);
        toolBar.addSeparator();
        toolBar.add(this.deleteAction).setRequestFocusEnabled(false);
        toolBar.add(this.undoAction).setRequestFocusEnabled(false);
        toolBar.add(this.redoAction).setRequestFocusEnabled(false);
        toolBar.addSeparator();
        toolBar.add(this.zoomOutAction).setRequestFocusEnabled(false);
        this.addZoomSlider(toolBar);
        toolBar.add(this.zoomInAction).setRequestFocusEnabled(false);
        toolBar.add(this.fitToScreenAction).setRequestFocusEnabled(false);
        toolBar.addSeparator();
        toolBar.add(this.toggleGrid).setRequestFocusEnabled(false);
        toolBar.add(new ToggleButtonWithoutText(this.startAction));
        this.drawingToolBar = new JToolBar();
        this.drawingToolBar.setFloatable(false);
        this.drawingToolBar.addSeparator();
        this.drawingToolBar.setRequestFocusEnabled(false);
        this.searchToolBar = new JToolBar();
        this.searchToolBar.setFloatable(false);
        this.searchToolBar.setRequestFocusEnabled(false);
        this.searchBar = new SearchBar("Search: ");
        JRootPane rootPane = this.getRootPane();
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(70, shortcutkey), "focusSearchBar");
        actionMap.put("focusSearchBar", this.searchAction);
        this.searchBar.setOnFocusGained(() -> {
            this.currentTab.ifPresent(o -> o.setMode(PetriNetTab.DrawTool.SELECT));
            this.enableActionsForSearchBar(false);
            if (!this.searchBar.getSearchText().isEmpty()) {
                String query = this.searchBar.getSearchText();
                this.currentTab.ifPresent(o -> o.search(query));
            }
        });
        this.searchBar.setOnFocusLost(() -> this.enableActionsForSearchBar(true));
        this.searchBar.setEnabled(false);
        this.searchToolBar.add(this.searchBar);
        this.searchBar.setOnSearchTextChanged(query -> {
            if (query == null || query.trim().isEmpty()) {
                this.searchBar.hideResults();
                return;
            }
            this.currentTab.ifPresent(o -> o.search((String)query));
        });
        this.searchBar.setOnResultSelected(result -> {
            String name;
            if (result == null) {
                return;
            }
            this.searchBar.clear();
            PetriNetObject selectedObject = null;
            PetriNetTab tab = (PetriNetTab)this.currentTab.get();
            String resultStr = result.value1().toString();
            String templateName = null;
            if (resultStr.contains(".")) {
                templateName = resultStr.split("\\.")[0];
                name = resultStr.split("\\.")[1];
            } else {
                templateName = (String)result.value2();
                name = resultStr;
            }
            Object resultObj = result.value1();
            for (Template template : tab.allTemplates()) {
                if (templateName != null && !template.toString().equals(templateName)) continue;
                DataLayer guiModel = template.guiModel();
                selectedObject = resultObj instanceof TimedPlace ? guiModel.getPlaceByName(name) : guiModel.getTransitionByName(name);
                if (selectedObject == null) continue;
                tab.selectTemplate(template);
                break;
            }
            if (selectedObject == null) {
                throw new IllegalStateException("Selected object is null");
            }
            DrawingSurfaceImpl drawingSurface = tab.drawingSurface();
            SelectionManager selectionObject = drawingSurface.getSelectionObject();
            selectionObject.clearSelection();
            selectedObject.select();
            drawingSurface.scrollToCenter(selectedObject);
        });
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(0, 0, 0));
        toolBarPanel.add(toolBar);
        toolBarPanel.add(this.drawingToolBar);
        JPanel toolBarPaneltmp = new JPanel();
        toolBarPaneltmp.setLayout(new BorderLayout());
        toolBarPaneltmp.add((Component)toolBarPanel, "West");
        JToolBar spacer = new JToolBar();
        spacer.setFloatable(false);
        toolBarPaneltmp.add((Component)this.searchToolBar, "Center");
        toolBarPaneltmp.add((Component)spacer, "East");
        this.getContentPane().add((Component)toolBarPaneltmp, "First");
    }

    private void enableActionsForSearchBar(boolean enable) {
        this.exportTraceAction.setEnabled(enable);
        this.importTraceAction.setEnabled(enable);
        this.verifyAction.setEnabled(enable);
        this.showColorTypesVariables.setEnabled(enable);
        this.annotationAction.setEnabled(enable);
        this.selectAllAction.setEnabled(enable);
        this.stepbackwardAction.setEnabled(enable);
        this.stepforwardAction.setEnabled(enable);
        this.deleteAction.setEnabled(enable);
        this.undoAction.setEnabled(enable);
        this.redoAction.setEnabled(enable);
        this.prevcomponentAction.setEnabled(enable);
        this.nextcomponentAction.setEnabled(enable);
        this.smartDrawAction.setEnabled(enable);
        this.mergeComponentsDialogAction.setEnabled(enable);
        this.workflowDialogAction.setEnabled(enable);
        this.timeFeatureOptions.setEnabled(enable);
        this.gameFeatureOptions.setEnabled(enable);
        this.colorFeatureOptions.setEnabled(enable);
        this.stochasticFeatureOptions.setEnabled(enable);
        this.enableAllActions(enable);
        this.currentTab.ifPresent(o -> o.enableActionsForSearchBar(enable));
    }

    private void addZoomSlider(JToolBar toolBar) {
        Dimension zoomSliderDimension = new Dimension(100, 28);
        this.zoomSlider = new JSlider(20, 300, 100);
        this.zoomSlider.setMajorTickSpacing(50);
        this.zoomSlider.setToolTipText("Zoom: " + this.zoomSlider.getValue() + "%");
        this.zoomSlider.addChangeListener(e -> {
            int newZoomLevel = this.zoomSlider.getValue();
            this.currentTab.ifPresent(o -> o.zoomTo(newZoomLevel));
            this.zoomSlider.setToolTipText("Zoom: " + newZoomLevel + "%");
            this.getCurrentTab().setIsAlreadyFitToScreen(false);
            this.fitToScreenAction.putValue("Name", FIT_TO_SCREEN_NAME);
            this.fitToScreenAction.putValue("ShortDescription", FIT_TO_SCREEN_TOOLTIP);
            this.fitToScreenAction.putValue("SmallIcon", ResourceManager.getIcon(FIT_TO_SCREEN_ICON));
        });
        SwingHelper.setPreferredWidth(this.zoomSlider, zoomSliderDimension.width);
        toolBar.add(this.zoomSlider);
    }

    @Override
    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    @Override
    public SearchBar getSearchBar() {
        return this.searchBar;
    }

    private JCheckBoxMenuItem addCheckboxMenuItem(JMenu menu, Action action) {
        return this.addCheckboxMenuItem(menu, true, action);
    }

    private JCheckBoxMenuItem addCheckboxMenuItem(JMenu menu, boolean selected, Action action) {
        JCheckBoxMenuItem checkBoxItem = new JCheckBoxMenuItem();
        checkBoxItem.setAction(action);
        checkBoxItem.setSelected(selected);
        JMenuItem item = menu.add(checkBoxItem);
        KeyStroke keystroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keystroke != null) {
            item.setAccelerator(keystroke);
        }
        return checkBoxItem;
    }

    private void enableGUIActions(GUIMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                this.enableAllActions(true);
                this.exportTraceAction.setEnabled(false);
                this.importTraceAction.setEnabled(false);
                this.annotationAction.setEnabled(true);
                this.deleteAction.setEnabled(true);
                this.selectAllAction.setEnabled(true);
                this.stepbackwardAction.setEnabled(false);
                this.stepforwardAction.setEnabled(false);
                this.prevcomponentAction.setEnabled(false);
                this.nextcomponentAction.setEnabled(false);
                this.deleteAction.setEnabled(true);
                this.showEnabledTransitionsAction.setEnabled(false);
                this.showDelayEnabledTransitionsAction.setEnabled(false);
                this.verifyAction.setEnabled(this.getCurrentTab().isQueryPossible());
                this.showColorTypesVariables.setEnabled(this.getCurrentTab().lens.isColored());
                this.smartDrawAction.setEnabled(true);
                this.mergeComponentsDialogAction.setEnabled(true);
                if (this.gameFeatureOptions.getSelectedIndex() == 1 || this.colorFeatureOptions.getSelectedIndex() == 1) {
                    this.workflowDialogAction.setEnabled(false);
                } else {
                    this.workflowDialogAction.setEnabled(true);
                }
                this.timeFeatureOptions.setEnabled(true);
                this.gameFeatureOptions.setEnabled(true);
                this.colorFeatureOptions.setEnabled(true);
                this.stochasticFeatureOptions.setEnabled(true);
                this.refreshLensConstraints();
                this.setFocusTraversalPolicy(new EditorFocusTraversalPolicy());
                this.fixBug812694GrayMenuAfterSimulationOnMac();
                this.searchBar.setEnabled(true);
                break;
            }
            case 1: {
                this.enableAllActions(true);
                this.annotationAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                this.selectAllAction.setEnabled(false);
                this.alignToGrid.setEnabled(false);
                this.showSharedPTAction.setEnabled(false);
                this.showConstantsAction.setEnabled(false);
                this.showColoredTokensAction.setEnabled(false);
                this.showQueriesAction.setEnabled(false);
                this.stepbackwardAction.setEnabled(true);
                this.stepforwardAction.setEnabled(true);
                this.prevcomponentAction.setEnabled(true);
                this.nextcomponentAction.setEnabled(true);
                this.deleteAction.setEnabled(false);
                this.undoAction.setEnabled(true);
                this.redoAction.setEnabled(true);
                this.verifyAction.setEnabled(false);
                this.showColorTypesVariables.setEnabled(this.getCurrentTab().lens.isColored());
                this.smartDrawAction.setEnabled(false);
                this.mergeComponentsDialogAction.setEnabled(false);
                this.workflowDialogAction.setEnabled(false);
                this.timeFeatureOptions.setEnabled(false);
                this.gameFeatureOptions.setEnabled(false);
                this.colorFeatureOptions.setEnabled(false);
                this.stochasticFeatureOptions.setEnabled(false);
                this.setFocusTraversalPolicy(new SimulatorFocusTraversalPolicy(this.getCurrentTab().getAnimationController().TimeDelayField));
                this.searchBar.setEnabled(false);
                break;
            }
            case 2: {
                this.exportTraceAction.setEnabled(false);
                this.importTraceAction.setEnabled(false);
                this.verifyAction.setEnabled(false);
                this.showColorTypesVariables.setEnabled(false);
                this.annotationAction.setEnabled(false);
                this.selectAllAction.setEnabled(false);
                this.stepbackwardAction.setEnabled(false);
                this.stepforwardAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                this.undoAction.setEnabled(false);
                this.redoAction.setEnabled(false);
                this.prevcomponentAction.setEnabled(false);
                this.nextcomponentAction.setEnabled(false);
                this.smartDrawAction.setEnabled(false);
                this.mergeComponentsDialogAction.setEnabled(false);
                this.workflowDialogAction.setEnabled(false);
                this.timeFeatureOptions.setEnabled(false);
                this.gameFeatureOptions.setEnabled(false);
                this.colorFeatureOptions.setEnabled(false);
                this.stochasticFeatureOptions.setEnabled(false);
                this.enableAllActions(false);
                this.statusBar.changeText("Open a net to start editing");
                this.setFocusTraversalPolicy(null);
                this.searchBar.setEnabled(false);
            }
        }
    }

    private void enableAllActions(boolean enable) {
        this.closeAction.setEnabled(enable);
        this.saveAction.setEnabled(enable);
        this.saveAsAction.setEnabled(enable);
        this.exportPNGAction.setEnabled(enable);
        this.exportPSAction.setEnabled(enable);
        this.exportToTikZAction.setEnabled(enable);
        this.exportToPNMLAction.setEnabled(enable);
        this.exportToXMLAction.setEnabled(enable);
        this.exportTraceAction.setEnabled(enable);
        this.importTraceAction.setEnabled(enable);
        this.printAction.setEnabled(enable);
        this.zoomInAction.setEnabled(enable);
        this.zoomOutAction.setEnabled(enable);
        this.zoomSlider.setEnabled(enable);
        this.fitToScreenAction.setEnabled(enable);
        this.decSpacingAction.setEnabled(enable);
        this.incSpacingAction.setEnabled(enable);
        this.toggleGrid.setEnabled(enable);
        this.alignToGrid.setEnabled(enable);
        this.showComponentsAction.setEnabled(enable);
        this.showSharedPTAction.setEnabled(enable);
        this.showConstantsAction.setEnabled(enable);
        this.showColoredTokensAction.setEnabled(enable);
        this.showQueriesAction.setEnabled(enable);
        this.showZeroToInfinityIntervalsAction.setEnabled(enable);
        this.showEnabledTransitionsAction.setEnabled(enable);
        this.showDelayEnabledTransitionsAction.setEnabled(enable);
        this.showToolTipsAction.setEnabled(enable);
        this.showTokenAgeAction.setEnabled(enable);
        this.changeNameVisibility.setEnabled(enable);
        this.showAdvancedWorkspaceAction.setEnabled(enable);
        this.showSimpleWorkspaceAction.setEnabled(enable);
        this.saveWorkSpaceAction.setEnabled(enable);
        this.startAction.setEnabled(enable);
        this.netStatisticsAction.setEnabled(enable);
    }

    @Override
    public void updateZoomSlider(int zoom) {
        this.zoomSlider.setValue(zoom);
    }

    public void setChangeListenerOnTab() {
        this.appTab.addChangeListener(e -> {
            PetriNetTab tab = (PetriNetTab)this.appTab.getSelectedComponent();
            if (tab != null) {
                this.guiFrameController.ifPresent(o -> o.changeToTab(tab));
            }
        });
    }

    @Override
    public void updatedTabName(PetriNetTab tab) {
        int index = this.appTab.indexOfComponent(tab);
        this.appTab.setTitleAt(index, tab.getTabTitle());
        this.appTab.getTabComponentAt(index).doLayout();
        if (index >= 0 && index == this.appTab.getSelectedIndex()) {
            this.setTitle(tab.getTabTitle());
        }
    }

    @Override
    public void attachTabToGuiFrame(PetriNetTab tab) {
        this.appTab.addTab(tab.getTabTitle(), tab);
    }

    @Override
    public void detachTabFromGuiFrame(PetriNetTab tab) {
        this.appTab.remove(tab);
        if (this.appTab.getTabCount() == 0) {
            for (GuiAction action : tab.getAvailableToolActions()) {
                action.setEnabled(false);
            }
            this.setGUIMode(GUIMode.noNet);
        }
    }

    @Override
    public void setGUIMode(GUIMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                this.startAction.setSelected(false);
                this.pasteAction.setEnabled(true);
                this.copyAction.setEnabled(true);
                this.cutAction.setEnabled(true);
                this.searchBar.setVisible(true);
                break;
            }
            case 1: {
                this.startAction.setSelected(true);
                this.pasteAction.setEnabled(false);
                this.copyAction.setEnabled(false);
                this.cutAction.setEnabled(false);
                this.searchBar.setVisible(false);
                break;
            }
            case 2: {
                this.setFeatureInfoText(null);
                this.registerDrawingActions(List.of());
                this.registerAnimationActions(List.of());
                this.pasteAction.setEnabled(false);
                this.copyAction.setEnabled(false);
                this.cutAction.setEnabled(false);
                this.searchBar.setVisible(false);
                break;
            }
        }
        this.enableGUIActions(mode);
        if (this.currentTab != null) {
            this.currentTab.ifPresent(o -> o.updateEnabledActions(mode));
        }
    }

    @Override
    public void registerDrawingActions(@NotNull List<GuiAction> drawActions) {
        this.drawingToolBar.removeAll();
        this.drawMenu.removeAll();
        if (drawActions.size() > 0) {
            this.drawMenu.setEnabled(true);
            this.drawingToolBar.addSeparator();
            for (GuiAction action : drawActions) {
                this.drawingToolBar.add(new ToggleButtonWithoutText(action));
                this.drawMenu.add(action);
            }
            this.drawingToolBar.add(this.featureInfoText);
        } else {
            this.drawMenu.setEnabled(false);
        }
    }

    @Override
    public void registerToolsActions(@NotNull List<GuiAction> toolsActions) {
        this.toolsMenu.removeAll();
        this.toolsMenu.setEnabled(true);
        this.toolsMenu.add(this.verifyAction).setMnemonic('m');
        this.toolsMenu.add(this.netStatisticsAction).setMnemonic('i');
        JMenuItem workflowDialog = new JMenuItem(this.workflowDialogAction);
        workflowDialog.setMnemonic('f');
        this.toolsMenu.add(workflowDialog);
        JMenuItem smartDrawDialog = new JMenuItem(this.smartDrawAction);
        smartDrawDialog.setMnemonic('D');
        this.toolsMenu.add(smartDrawDialog);
        JMenuItem mergeComponentsDialog = new JMenuItem(this.mergeComponentsDialogAction);
        mergeComponentsDialog.setMnemonic('c');
        this.toolsMenu.add(mergeComponentsDialog);
        this.toolsMenu.add(this.showColorTypesVariables);
        for (GuiAction action : toolsActions) {
            this.toolsMenu.add(action);
        }
        this.toolsMenu.addSeparator();
        JMenuItem batchProcessing = new JMenuItem(this.batchProcessingAction);
        batchProcessing.setMnemonic('b');
        this.toolsMenu.add(batchProcessing);
        this.toolsMenu.addSeparator();
        JMenuItem engineSelection = new JMenuItem(this.engineSelectionAction);
        this.toolsMenu.add(engineSelection);
        JMenuItem clearPreferences = new JMenuItem(this.clearPreferencesAction);
        this.toolsMenu.add(clearPreferences);
    }

    @Override
    public void registerAnimationActions(@NotNull List<GuiAction> animationActions) {
        this.animateMenu.removeAll();
        if (animationActions.size() > 0) {
            this.animateMenu.setEnabled(true);
            this.animateMenu.add(this.startAction);
            this.animateMenu.add(this.stepbackwardAction);
            this.animateMenu.add(this.stepforwardAction);
            for (GuiAction action : animationActions) {
                this.animateMenu.add(action);
            }
            this.animateMenu.add(this.prevcomponentAction);
            this.animateMenu.add(this.nextcomponentAction);
            this.animateMenu.addSeparator();
            this.animateMenu.add(this.exportTraceAction);
            this.animateMenu.add(this.importTraceAction);
        } else {
            this.animateMenu.setEnabled(false);
        }
    }

    @Override
    public void registerViewActions(@NotNull List<GuiAction> viewActions) {
        if (!this.getCurrentTab().getLens().isTimed()) {
            this.showZeroToInfinityIntervalsCheckBox.setVisible(false);
            this.showTokenAgeCheckBox.setVisible(false);
            this.showDelayEnabledTransitionsCheckbox.setVisible(false);
        } else {
            this.showZeroToInfinityIntervalsCheckBox.setVisible(true);
            this.showTokenAgeCheckBox.setVisible(true);
            this.showDelayEnabledTransitionsCheckbox.setVisible(true);
        }
        if (!this.getCurrentTab().getLens().isColored()) {
            this.showColoredTokensCheckbox.setVisible(false);
        } else {
            this.showColoredTokensCheckbox.setVisible(true);
        }
    }

    private void fixBug812694GrayMenuAfterSimulationOnMac() {
        JDialog a = new JDialog((Frame)this, false);
        a.setUndecorated(true);
        a.setVisible(true);
        a.dispose();
    }

    @Override
    public void setStatusBarText(String s) {
        this.statusBar.changeText(Objects.requireNonNullElse(s, ""));
    }

    @Override
    public void registerController(GuiFrameControllerActions guiFrameController, Reference<TabActions> currentTab) {
        this.guiFrameController.setReference(guiFrameController);
        this.currentTab = currentTab;
    }

    @Override
    public void changeToTab(PetriNetTab tab) {
        if (tab != null) {
            this.appTab.setSelectedComponent(tab);
        }
    }

    @Override
    public void setShowComponentsSelected(boolean b) {
        this.showComponentsAction.setSelected(b);
    }

    @Override
    public void setShowSharedPTSelected(boolean b) {
        this.showSharedPTAction.setSelected(b);
    }

    @Override
    public void setShowConstantsSelected(boolean b) {
        this.showConstantsAction.setSelected(b);
    }

    @Override
    public void setShowColoredTokensSelected(boolean b) {
        this.showColoredTokensAction.setSelected(b);
    }

    @Override
    public void setShowQueriesSelected(boolean b) {
        this.showQueriesAction.setSelected(b);
    }

    @Override
    public void setShowEnabledTransitionsSelected(boolean b) {
        this.showEnabledTransitionsAction.setSelected(b);
    }

    @Override
    public void setShowDelayEnabledTransitionsSelected(boolean b) {
        this.showDelayEnabledTransitionsAction.setSelected(b);
    }

    @Override
    public void setShowToolTipsSelected(boolean b) {
        this.showToolTipsAction.setSelected(b);
    }

    @Override
    public void setShowZeroToInfinityIntervalsSelected(boolean b) {
        this.showZeroToInfinityIntervalsAction.setSelected(b);
    }

    @Override
    public void setShowTokenAgeSelected(boolean b) {
        this.showTokenAgeAction.setSelected(b);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle((String)(title == null ? this.frameTitle : this.frameTitle + ": " + title));
    }

    @Deprecated
    public boolean isEditionAllowed() {
        return !this.getCurrentTab().isInAnimationMode();
    }

    @Override
    public void setUndoActionEnabled(boolean flag) {
        this.undoAction.setEnabled(flag);
    }

    @Override
    public void setRedoActionEnabled(boolean flag) {
        this.redoAction.setEnabled(flag);
    }

    private JMenu buildMenuFiles() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(this.createAction);
        fileMenu.add(this.openAction);
        fileMenu.add(this.closeAction);
        fileMenu.addSeparator();
        fileMenu.add(this.saveAction);
        fileMenu.add(this.saveAsAction);
        JMenu importMenu = new JMenu("Import");
        importMenu.setIcon(ResourceManager.getIcon("Export.png"));
        importMenu.add(this.importPNMLAction);
        importMenu.add(this.importSUMOAction);
        importMenu.add(this.importXMLAction);
        fileMenu.add(importMenu);
        JMenu exportMenu = new JMenu("Export");
        exportMenu.setIcon(ResourceManager.getIcon("Export.png"));
        exportMenu.add(this.exportPNGAction);
        exportMenu.add(this.exportPSAction);
        exportMenu.add(this.exportToTikZAction);
        exportMenu.add(this.exportToPNMLAction);
        exportMenu.add(this.exportToXMLAction);
        exportMenu.add(this.exportBatchAction);
        fileMenu.add(exportMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.printAction);
        fileMenu.addSeparator();
        JMenu exampleMenu = this.buildExampleMenu();
        if (exampleMenu != null) {
            fileMenu.add(exampleMenu);
            fileMenu.addSeparator();
        }
        fileMenu.add(this.exitAction);
        return fileMenu;
    }

    private JMenu buildExampleMenu() {
        String[] nets = this.loadTestNets();
        if (nets != null && nets.length > 0) {
            final TAPNLens untimedLens = new TAPNLens(false, false, false, false);
            final TAPNLens timedLens = new TAPNLens(true, false, false, false);
            final TAPNLens untimedGameLens = new TAPNLens(false, true, false, false);
            final TAPNLens timedGameLens = new TAPNLens(true, true, false, false);
            final TAPNLens untimedColorLens = new TAPNLens(false, false, true, false);
            final TAPNLens timedColorLens = new TAPNLens(true, false, true, false);
            final TAPNLens timedStochasticLens = new TAPNLens(true, false, false, true);
            final TAPNLens timedColorStochasticLens = new TAPNLens(true, false, true, true);
            HashMap<TAPNLens, List<String>> netMap = new HashMap<TAPNLens, List<String>>(this){
                final /* synthetic */ GuiFrame this$0;
                {
                    this.this$0 = this$0;
                    this.put(untimedLens, new ArrayList());
                    this.put(timedLens, new ArrayList());
                    this.put(untimedGameLens, new ArrayList());
                    this.put(timedGameLens, new ArrayList());
                    this.put(untimedColorLens, new ArrayList());
                    this.put(timedColorLens, new ArrayList());
                    this.put(timedStochasticLens, new ArrayList());
                    this.put(timedColorStochasticLens, new ArrayList());
                }
            };
            for (String filename : nets) {
                if (!filename.toLowerCase().endsWith(".tapn")) continue;
                String filenameFinal = filename;
                InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream("Example nets/" + filenameFinal);
                try {
                    TAPNLens lens = PetriNetTab.getFileLens(file);
                    if (lens == null) {
                        lens = new TAPNLens(true, false, false, false);
                    }
                    TAPNLens tmp = lens;
                    netMap.forEach((v, k) -> {
                        if (v.isTimed() == tmp.isTimed() && v.isGame() == tmp.isGame() && v.isColored() == tmp.isColored() && v.isStochastic() == tmp.isStochastic()) {
                            k.add(filename);
                        }
                    });
                }
                catch (Exception e) {
                    if (netMap.containsKey(timedLens)) {
                        ((List)netMap.get(timedLens)).add(filename);
                    }
                    e.printStackTrace();
                }
            }
            JMenu exampleMenu = new JMenu("Example nets");
            exampleMenu.setIcon(ResourceManager.getIcon("Example.png"));
            int charKey = 65;
            int modifier = 9;
            exampleMenu.add(this.addExampleNets((List)netMap.get(untimedLens), "P/T nets", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(untimedLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(untimedLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(timedLens), "Timed-Arc Petri nets", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(timedLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(timedLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(untimedGameLens), "P/T net games", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(untimedGameLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(untimedGameLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(timedGameLens), "Timed-Arc Petri net games", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(timedGameLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(timedGameLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(untimedColorLens), "Colored P/T nets", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(untimedColorLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(untimedColorLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(timedColorLens), "Timed-Arc Colored Petri nets", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(timedColorLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(timedColorLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(timedStochasticLens), "Timed-Arc Stochastic Petri nets", charKey, modifier));
            modifier = this.getModifier(modifier, charKey, ((List)netMap.get(timedStochasticLens)).size());
            charKey = this.countCharKey(charKey, ((List)netMap.get(timedStochasticLens)).size());
            exampleMenu.add(this.addExampleNets((List)netMap.get(timedColorStochasticLens), "Timed-Arc Stochastic Colored Petri nets", charKey, modifier));
            return exampleMenu;
        }
        return null;
    }

    private JMenu addExampleNets(List<String> fileNames, String menuName, int charKey, int modifier) {
        JMenu menu = new JMenu(menuName);
        for (String filename : fileNames) {
            if (!filename.toLowerCase().endsWith(".tapn")) continue;
            final String netname = filename.replace(".tapn", "");
            final String filenameFinal = filename;
            GuiAction tmp = new GuiAction(this, netname, "Open example file \"" + netname + "\"", KeyStroke.getKeyStroke(charKey, modifier)){
                final /* synthetic */ GuiFrame this$0;
                {
                    this.this$0 = this$0;
                    super(arg0, arg1, arg2);
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream("Example nets/" + filenameFinal);
                    try {
                        PetriNetTab net = PetriNetTab.createNewTabFromInputStream(file, netname);
                        this.this$0.guiFrameController.ifPresent(o -> o.setEnableSidepanel(net));
                        this.this$0.guiFrameController.ifPresent(o -> o.openTab(net));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            tmp.putValue("SmallIcon", ResourceManager.getIcon("Net.png"));
            menu.add(tmp);
            if (charKey == 90) {
                charKey = 48;
                continue;
            }
            if (charKey == 57) {
                charKey = 65;
                modifier = 8;
                continue;
            }
            ++charKey;
        }
        return menu;
    }

    private int countCharKey(int previousKey, int previousSize) {
        int currentKey = previousKey + previousSize;
        int addedSize = 0;
        int missingSize = 0;
        if (currentKey > 90) {
            addedSize = 90 - previousKey;
            missingSize = previousSize - addedSize;
            currentKey = 47 + missingSize;
            if (currentKey > 57) {
                currentKey = this.countCharKey(64, missingSize -= 10);
            }
        } else if (currentKey > 57 && currentKey < 65 && (currentKey = 64 + (missingSize = previousSize - (addedSize = 57 - previousKey))) > 90) {
            currentKey = this.countCharKey(47, missingSize -= 26);
        }
        return currentKey;
    }

    private int getModifier(int currentModifier, int charKey, int difference) {
        int used;
        if (currentModifier == 9 && (charKey + difference > 90 ? difference - (used = 90 - charKey) > 10 : charKey < 65 && charKey + difference > 57)) {
            return 8;
        }
        return currentModifier;
    }

    private String[] loadTestNets() {
        String[] nets = null;
        try {
            URL dirURL = Thread.currentThread().getContextClassLoader().getResource("Example nets/");
            if (dirURL != null && dirURL.getProtocol().equals("file")) {
                nets = new File(dirURL.toURI()).list();
            }
            if (dirURL == null) {
                String me = this.getName().replace(".", "/") + ".class";
                dirURL = Thread.currentThread().getContextClassLoader().getResource(me);
            }
            if (dirURL.getProtocol().equals("jar")) {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf(33));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith("Example nets/")) continue;
                    String entry = name.substring("Example nets/".length());
                    int checkSubdir = entry.indexOf(47);
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    result.add(entry);
                }
                nets = result.toArray(new String[0]);
                jar.close();
            }
            Arrays.sort(nets, (one, two) -> {
                int toReturn = one.compareTo((String)two);
                if (one.equals("intro-example.tapn")) {
                    toReturn = -1;
                } else if (one.equals("game-harddisk.tapn")) {
                    toReturn = 1;
                }
                if (two.equals("intro-example.tapn")) {
                    toReturn = 1;
                } else if (two.equals("game-harddisk.tapn")) {
                    toReturn = -1;
                }
                return toReturn;
            });
        }
        catch (Exception e) {
            Logger.log("Error getting example files:" + String.valueOf(e));
            e.printStackTrace();
        }
        return nets;
    }

    @Deprecated
    public String getCurrentTabName() {
        return this.appTab.getTitleAt(this.appTab.getSelectedIndex());
    }

    @Deprecated
    public boolean isShowingDelayEnabledTransitions() {
        return this.showDelayEnabledTransitionsAction.isSelected();
    }

    public boolean showZeroToInfinityIntervals() {
        return Preferences.getInstance().getShowZeroInfIntervals();
    }

    public boolean showTokenAge() {
        return Preferences.getInstance().getShowTokenAge();
    }

    public boolean showColoredTokens() {
        return Preferences.getInstance().getShowColoredTokens();
    }

    @Deprecated
    public int getSelectedTabIndex() {
        return this.appTab.getSelectedIndex();
    }

    @Deprecated
    private PetriNetTab getCurrentTab() {
        return TAPAALGUI.getCurrentTab();
    }

    @Override
    public void setFeatureInfoText(boolean[] features) {
        if (features != null) {
            this.timeFeatureOptions.setSelectedIndex(features[0] ? 1 : 0);
            this.gameFeatureOptions.setSelectedIndex(features[1] ? 1 : 0);
            this.colorFeatureOptions.setSelectedIndex(features[2] ? 1 : 0);
            this.stochasticFeatureOptions.setSelectedIndex(features[3] ? 1 : 0);
        }
        this.refreshLensConstraints();
    }

    public void refreshLensConstraints() {
        boolean stochasticEnabled = this.stochasticFeatureOptions.getSelectedIndex() != 0;
        this.timeFeatureOptions.setEnabled(!stochasticEnabled);
        this.gameFeatureOptions.setEnabled(!stochasticEnabled);
        this.stochasticFeatureOptions.setEnabled(this.timeFeatureOptions.getSelectedIndex() != 0 && this.gameFeatureOptions.getSelectedIndex() == 0);
    }

    public static enum GUIMode {
        draw,
        animation,
        noNet;

    }
}

