/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.swinghelpers;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBagHelper {
    public static GridBagConstraints as(int gridx, int gridy, Anchor anchor, Fill fill, Insets inset) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        if (anchor != null) {
            gridBagConstraints.anchor = anchor.value;
        }
        if (fill != null) {
            gridBagConstraints.fill = fill.value;
        }
        if (inset != null) {
            gridBagConstraints.insets = inset;
        }
        return gridBagConstraints;
    }

    public static GridBagConstraints as(int gridx, int gridy, Anchor anchor, Fill fill) {
        return GridBagHelper.as(gridx, gridy, anchor, fill, null);
    }

    public static GridBagConstraints as(int gridx, int gridy, Anchor anchor, Insets inset) {
        return GridBagHelper.as(gridx, gridy, anchor, null, inset);
    }

    public static GridBagConstraints as(int gridx, int gridy, Fill fill, Insets inset) {
        return GridBagHelper.as(gridx, gridy, null, fill, inset);
    }

    public static GridBagConstraints as(int gridx, int gridy, Anchor anchor) {
        return GridBagHelper.as(gridx, gridy, anchor, (Fill)null);
    }

    public static GridBagConstraints as(int gridx, int gridy, Insets inset) {
        return GridBagHelper.as(gridx, gridy, null, null, inset);
    }

    public static GridBagConstraints as(int gridx, int gridy) {
        return GridBagHelper.as(gridx, gridy, null, null, null);
    }

    public static GridBagConstraints as(int gridx, int gridy, int gridwidth, Anchor anchor) {
        return GridBagHelper.as(gridx, gridy, gridwidth, 1, anchor, null);
    }

    public static GridBagConstraints as(int gridx, int gridy, int gridwidth, Anchor anchor, Insets inset) {
        return GridBagHelper.as(gridx, gridy, gridwidth, 1, anchor, inset);
    }

    public static GridBagConstraints as(int gridx, int gridy, int gridwidth, int gridtheight, Anchor anchor, Insets inset) {
        GridBagConstraints r = GridBagHelper.as(gridx, gridy, anchor, null, inset);
        r.gridwidth = gridwidth;
        r.gridheight = gridtheight;
        return r;
    }

    public static enum Anchor {
        NORTH(11),
        EAST(13),
        WEST(17),
        NORTHWEST(18),
        SOUTH(15);

        public final int value;

        private Anchor(int value) {
            this.value = value;
        }
    }

    public static enum Fill {
        HORIZONTAL(2),
        BOTH(1);

        public final int value;

        private Fill(int value) {
            this.value = value;
        }
    }
}

