/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.resourcemanager;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ResourceManager {
    public static final String imgPath = "Images/";
    private static final ImageIcon satisfiedIcon = ResourceManager.loadIcon("satisfied.png");
    private static final ImageIcon notSatisfiedIcon = ResourceManager.loadIcon("notsatisfied.png");
    private static final ImageIcon inconclusiveIcon = ResourceManager.loadIcon("maybe1.png");
    private static final ImageIcon rerunIcon = ResourceManager.loadIcon("maybe.png");
    private static final ImageIcon infoIcon = ResourceManager.loadIcon("info.png");
    private static final ImageIcon appIcon = ResourceManager.loadIcon("tapaal-icon.png");

    private static ImageIcon loadIcon(String name) {
        try {
            return new ImageIcon(ImageIO.read(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(imgPath + name))).getScaledInstance(52, 52, 4));
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImageIcon getIcon(String name) {
        return Objects.requireNonNull(ResourceManager.getIconIfExists(name), "Icon " + name + " not found");
    }

    public static ImageIcon getIconIfExists(String name) {
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(imgPath + name);
        if (resourceURL == null) {
            return null;
        }
        return new ImageIcon(resourceURL);
    }

    public static ImageIcon satisfiedIcon() {
        return satisfiedIcon;
    }

    public static ImageIcon notSatisfiedIcon() {
        return notSatisfiedIcon;
    }

    public static ImageIcon inconclusiveIcon() {
        return inconclusiveIcon;
    }

    public static ImageIcon rerunIcon() {
        return rerunIcon;
    }

    public static ImageIcon infoIcon() {
        return infoIcon;
    }

    public static ImageIcon appIcon() {
        return appIcon;
    }
}

