/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.widgets;

import dk.aau.cs.Messenger;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.Require;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.dialog.BatchProcessingDialog;
import net.tapaal.gui.petrinet.dialog.QueryDialog;
import net.tapaal.gui.petrinet.undo.MoveElementDownCommand;
import net.tapaal.gui.petrinet.undo.MoveElementUpCommand;
import net.tapaal.gui.petrinet.undo.RemoveQueriesCommand;
import net.tapaal.gui.petrinet.undo.SortQueriesCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.Verifier;
import net.tapaal.gui.petrinet.widgets.SidePane;
import net.tapaal.gui.swingcomponents.NonsearchableJList;
import net.tapaal.resourcemanager.ResourceManager;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.undo.UndoManager;

public class QueryPane
extends JPanel
implements SidePane {
    private final JPanel queryCollectionPanel;
    private final JPanel buttonsPanel;
    private final DefaultListModel<TAPNQuery> listModel;
    private final JList<TAPNQuery> queryList;
    private JScrollPane queryScroller;
    private final Messenger messenger = new MessengerImpl();
    private JButton addQueryButton;
    private JButton editQueryButton;
    private JButton verifyButton;
    private JButton removeQueryButton;
    private final PetriNetTab tabContent;
    private final UndoManager undoManager;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton sortButton;
    private static File tempFile;
    private static final String toolTipNewQuery = "Create a new query";
    private static final String toolTipEditQuery = "Edit the selected query";
    private static final String toolTipRemoveQuery = "Remove the selected query";
    private static final String toolTipVerifyQuery = "Verify the selected query";
    private static final String toolTipSortQueries = "Sort the queries alphabetically";
    private static final String toolTipMoveUp = "Move the selected query up; only one query can be moved at a time";
    private static final String toolTipMoveDown = "Move the selected query down; only one query can be moved at a time";

    public QueryPane(PetriNetTab tabContent) {
        this.tabContent = tabContent;
        this.undoManager = tabContent.getUndoManager();
        this.queryCollectionPanel = new JPanel(new GridBagLayout());
        this.buttonsPanel = new JPanel(new GridBagLayout());
        this.listModel = new DefaultListModel();
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                QueryPane.this.queryList.setSelectedIndex(arg0.getIndex0());
                QueryPane.this.queryList.ensureIndexIsVisible(arg0.getIndex0());
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                QueryPane.this.queryList.setSelectedIndex(index);
                QueryPane.this.queryList.ensureIndexIsVisible(index);
            }
        });
        this.queryList = new NonsearchableJList<TAPNQuery>(this.listModel);
        this.queryList.setCellRenderer(new QueryCellRenderer());
        this.queryList.setSelectionMode(2);
        this.queryList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.queryList.ensureIndexIsVisible(this.queryList.getSelectedIndex());
                this.updateQueryButtons();
            }
        });
        this.queryList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!QueryPane.this.queryList.isSelectionEmpty() && arg0.getButton() == 1 && arg0.getClickCount() == 2) {
                    int index = QueryPane.this.queryList.locationToIndex(arg0.getPoint());
                    QueryPane.this.queryList.ensureIndexIsVisible(index);
                    QueryPane.this.showEditDialog();
                }
            }
        });
        this.addQueriesComponents();
        this.addButtons();
        this.setLayout(new BorderLayout());
        this.add((Component)this.queryCollectionPanel, "Center");
        this.add((Component)this.buttonsPanel, "Last");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Queries"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setToolTipText("List of verification queries (double click to edit)");
        this.addComponentListener(new ComponentListener(){
            final int minimumHegiht;
            {
                this.minimumHegiht = QueryPane.this.getMinimumSize().height;
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                QueryPane.this.sortButton.setVisible(QueryPane.this.getSize().height > this.minimumHegiht);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, this.getMinimumSize().height - this.sortButton.getMinimumSize().height));
    }

    public void updateQueryButtons() {
        TAPNQuery query = this.queryList.getSelectedValue();
        if (this.queryList.getSelectedIndex() == -1 || !query.isActive()) {
            this.editQueryButton.setEnabled(false);
            this.verifyButton.setEnabled(false);
            this.removeQueryButton.setEnabled(false);
            this.sortButton.setEnabled(false);
        } else {
            this.editQueryButton.setEnabled(true);
            this.verifyButton.setEnabled(true);
            this.removeQueryButton.setEnabled(true);
            this.sortButton.setEnabled(true);
        }
        if (this.queryList.getModel().getSize() >= 2) {
            this.sortButton.setEnabled(true);
        } else {
            this.sortButton.setEnabled(false);
        }
        int index = this.queryList.getSelectedIndex();
        if (index > 0 && this.queryList.getSelectedIndices().length == 1) {
            this.moveUpButton.setEnabled(true);
        } else {
            this.moveUpButton.setEnabled(false);
        }
        if (index < this.listModel.size() - 1 && this.queryList.getSelectedIndices().length == 1) {
            this.moveDownButton.setEnabled(true);
        } else {
            this.moveDownButton.setEnabled(false);
        }
    }

    private void addQueriesComponents() {
        this.queryScroller = new JScrollPane(this.queryList);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.queryCollectionPanel.add((Component)this.queryScroller, gbc);
        this.moveUpButton = new JButton(ResourceManager.getIcon("Up.png"));
        this.moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setToolTipText(toolTipMoveUp);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = QueryPane.this.queryList.getSelectedIndex();
                if (index > 0 && QueryPane.this.queryList.getSelectedIndices().length == 1) {
                    MoveElementUpCommand c = new MoveElementUpCommand(QueryPane.this, index, index - 1);
                    QueryPane.this.undoManager.addNewEdit(c);
                    c.redo();
                    QueryPane.this.queryList.setSelectedIndex(index - 1);
                } else {
                    QueryPane.this.moveUpButton.setEnabled(false);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 15;
        this.queryCollectionPanel.add((Component)this.moveUpButton, gbc);
        this.moveDownButton = new JButton(ResourceManager.getIcon("Down.png"));
        this.moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setToolTipText(toolTipMoveDown);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = QueryPane.this.queryList.getSelectedIndex();
                if (index < QueryPane.this.listModel.size() - 1 && QueryPane.this.queryList.getSelectedIndices().length == 1) {
                    MoveElementDownCommand c = new MoveElementDownCommand(QueryPane.this, index, index + 1);
                    QueryPane.this.undoManager.addNewEdit(c);
                    c.redo();
                    QueryPane.this.queryList.setSelectedIndex(index + 1);
                } else {
                    QueryPane.this.moveDownButton.setEnabled(false);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.queryCollectionPanel.add((Component)this.moveDownButton, gbc);
        this.sortButton = new JButton(ResourceManager.getIcon("Sort.png"));
        this.sortButton.setMargin(new Insets(2, 2, 2, 2));
        this.sortButton.setToolTipText(toolTipSortQueries);
        this.sortButton.setEnabled(false);
        this.sortButton.addActionListener(e -> {
            SortQueriesCommand c = new SortQueriesCommand(this.listModel);
            this.undoManager.addNewEdit(c);
            c.redo();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 11;
        this.queryCollectionPanel.add((Component)this.sortButton, gbc);
    }

    private void addButtons() {
        this.editQueryButton = new JButton("Edit");
        this.editQueryButton.setEnabled(false);
        this.editQueryButton.setToolTipText(toolTipEditQuery);
        Dimension dimension = new Dimension(82, 23);
        this.editQueryButton.setPreferredSize(dimension);
        this.editQueryButton.addActionListener(e -> {
            if (this.queryList.getSelectedIndices().length == 1) {
                this.showEditDialog();
            } else {
                this.messenger.displayErrorMessage("It is only possible to edit 1 query at a time. Only verification can be done with multiple queries.");
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.editQueryButton, gbc);
        this.verifyButton = new JButton("Verify");
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(toolTipVerifyQuery);
        this.verifyButton.setPreferredSize(dimension);
        this.verifyButton.addActionListener(e -> this.verifyQuery());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.verifyButton, gbc);
        this.removeQueryButton = new JButton("Remove");
        this.removeQueryButton.setEnabled(false);
        this.removeQueryButton.setToolTipText(toolTipRemoveQuery);
        this.removeQueryButton.setPreferredSize(dimension);
        this.removeQueryButton.addActionListener(e -> this.removeQueries());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.removeQueryButton, gbc);
        this.addQueryButton = new JButton("New");
        this.addQueryButton.setPreferredSize(dimension);
        this.addQueryButton.setToolTipText(toolTipNewQuery);
        this.addQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimedArcPetriNetNetwork network = QueryPane.this.tabContent.network();
                TAPNLens lens = QueryPane.this.tabContent.getLens();
                if (lens.isStochastic() && !network.isNonStrict()) {
                    JOptionPane.showMessageDialog(null, "SMC queries are only allowed for models with nonstrict intervals.", "Error", 0);
                    return;
                }
                QueryDialog.showQueryDialogue(QueryDialog.QueryDialogueOption.Save, null, network, QueryPane.this.tabContent.getGuiModels(), lens, QueryPane.this.tabContent);
                QueryPane.this.updateQueryButtons();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.addQueryButton, gbc);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    private void swapQueries(int currentIndex, int newIndex) {
        TAPNQuery temp = this.listModel.get(currentIndex);
        this.listModel.set(currentIndex, this.listModel.get(newIndex));
        this.listModel.set(newIndex, temp);
    }

    private void removeQueries() {
        this.undoManager.addNewEdit(new RemoveQueriesCommand(this.queryList.getSelectedValuesList(), this.tabContent));
        if (this.listModel.getSize() > 0 && this.isQueryPossible()) {
            for (TAPNQuery o : this.queryList.getSelectedValuesList()) {
                this.listModel.removeElement(o);
            }
            this.updateQueryButtons();
        }
    }

    public void showEditDialog() {
        TAPNQuery newQuery;
        TAPNQuery q = this.queryList.getSelectedValue();
        if (q.isActive() && (newQuery = QueryDialog.showQueryDialogue(QueryDialog.QueryDialogueOption.Save, q, this.tabContent.network(), this.tabContent.getGuiModels(), this.tabContent.getLens(), this.tabContent)) != null) {
            this.updateQuery(q, newQuery);
        }
    }

    public void addQuery(TAPNQuery query) {
        this.listModel.addElement(query);
    }

    private void updateQuery(TAPNQuery oldQuery, TAPNQuery newQuery) {
        newQuery.setActive(oldQuery.isActive());
        this.listModel.set(this.listModel.indexOf(oldQuery), newQuery);
    }

    public Iterable<TAPNQuery> getQueries() {
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        for (int i = 0; i < this.listModel.size(); ++i) {
            queries.add(this.listModel.get(i));
        }
        return queries;
    }

    public void setQueries(Iterable<TAPNQuery> queries) {
        Require.that(queries != null, "Queries cannot be null");
        this.listModel.removeAllElements();
        for (TAPNQuery query : queries) {
            this.listModel.addElement(query);
        }
    }

    public void removeQuery(TAPNQuery queryToRemove) {
        this.listModel.removeElement(queryToRemove);
    }

    public void selectFirst() {
        this.queryList.setSelectedIndex(0);
    }

    private void verifyQuery() {
        boolean isSmc;
        TAPNQuery query = this.queryList.getSelectedValue();
        int NumberOfSelectedElements = this.queryList.getSelectedIndices().length;
        boolean bl = isSmc = query.getCategory() == TAPNQuery.QueryCategory.SMC;
        if (isSmc && !this.tabContent.network().isNonStrict()) {
            JOptionPane.showMessageDialog(null, "The model has strict intervals and can therefore not be verified", "Error", 0);
            return;
        }
        if (NumberOfSelectedElements == 1) {
            if (query.getReductionOption() == ReductionOption.VerifyTAPN || query.getReductionOption() == ReductionOption.VerifyDTAPN || query.getReductionOption() == ReductionOption.VerifyPN) {
                Verifier.runVerifyTAPNVerification(this.tabContent.network(), query, null, this.tabContent.getGuiModels(), false, this.tabContent.lens);
            } else {
                Verifier.runUppaalVerification(this.tabContent.network(), query);
            }
        } else if (NumberOfSelectedElements > 1) {
            this.saveNetAndRunBatchProcessing();
        }
    }

    private void saveNetAndRunBatchProcessing() {
        List<TAPNQuery> selectedQueries = this.queryList.getSelectedValuesList();
        try {
            tempFile = File.createTempFile(this.tabContent.getTabTitle(), ".xml");
            this.tabContent.writeNetToFile(tempFile, selectedQueries, this.tabContent.getLens());
            BatchProcessingDialog.showBatchProcessingDialog(this.queryList);
            tempFile.deleteOnExit();
            if (tempFile == null) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            this.messenger.displayErrorMessage("Creation of temporary file needed for verification failed.");
        }
    }

    public static File getTemporaryFile() {
        return tempFile;
    }

    public boolean isQueryPossible() {
        return this.queryList.getModel().getSize() > 0;
    }

    public void verifySelectedQuery() {
        this.verifyQuery();
    }

    @Override
    public void moveUp(int index) {
        this.swapQueries(index, index - 1);
    }

    @Override
    public void moveDown(int index) {
        this.swapQueries(index, index + 1);
    }

    @Override
    public JList getJList() {
        return this.queryList;
    }

    private static class QueryCellRenderer
    extends DefaultListCellRenderer {
        private QueryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component superRenderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TAPNQuery) {
                this.setText(((TAPNQuery)value).getName());
            } else {
                this.setText("");
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled() && ((TAPNQuery)value).isActive());
            if (!this.isEnabled()) {
                this.setToolTipText("This query is disabled because it contains propositions involving places from a deactivated component");
            } else {
                String queryToolTipString = this.getFormattedQueryToolTipString(((TAPNQuery)value).getQuery());
                this.setToolTipText(queryToolTipString);
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            return superRenderer;
        }

        private String getFormattedQueryToolTipString(String qString) {
            int newLineAt;
            int stringLength = qString.length();
            if (stringLength > (newLineAt = 100)) {
                int numOfLineBreaks = (int)Math.floor(stringLength / newLineAt);
                StringBuilder sb = new StringBuilder(qString);
                sb.insert(0, "<html>");
                for (int i = 1; i <= numOfLineBreaks; ++i) {
                    int newLineIndex = sb.indexOf(" ", newLineAt * i);
                    if (newLineIndex <= 0) continue;
                    sb.insert(newLineIndex, "<br>");
                }
                sb.insert(sb.length(), "</html>");
                return sb.toString();
            }
            return qString;
        }
    }
}

