/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.SMCTraceType;
import java.util.ArrayList;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;

public class TAPNQuery {
    private String name;
    private int capacity;
    private Integer oldCapacity = null;
    private TraceOption traceOption;
    private SearchOption searchOption;
    private ReductionOption reductionOption;
    private boolean symmetry;
    private boolean gcd;
    private boolean pTrie;
    private boolean timeDart;
    private boolean overApproximation;
    private final boolean isColored;
    private HashTableSize hashTableSize;
    private ExtrapolationOption extrapolationOption;
    private InclusionPlaces inclusionPlaces;
    private WorkflowMode workflow;
    private long strongSoundnessBound;
    private boolean useReduction;
    private boolean useColoredReduction;
    private QueryCategory queryCategory = QueryCategory.Default;
    private AlgorithmOption algorithmOption = AlgorithmOption.CERTAIN_ZERO;
    private ArrayList<String> traceList;
    private boolean partitioning;
    private boolean colorFixpoint;
    private boolean symmetricVars;
    private boolean enableOverApproximation = false;
    private boolean enableUnderApproximation = false;
    private int denominator = 2;
    private boolean discreteInclusion = false;
    private TCTLAbstractProperty property = null;
    private boolean isActive = true;
    private boolean useSiphontrap = false;
    private boolean useQueryReduction = true;
    private boolean useStubbornReduction = true;
    private boolean useTarOption = false;
    private boolean useTarjan = false;
    private boolean useExplicitSearch = false;
    private boolean useRawVerification = false;
    private String rawVerificationPrompt;
    private SMCSettings smcSettings = SMCSettings.Default();
    private boolean benchmark = false;
    private int benchmarkRuns = 100;
    private boolean parallel = true;
    private int granularity = 500;
    private boolean maxGranularity = false;
    private VerificationType verificationType = VerificationType.QUANTITATIVE;
    private int numberOfTraces = 1;
    private SMCTraceType smcTraceType = new SMCTraceType();

    public void setName(String name) {
        this.name = name;
    }

    public void setTraceList(ArrayList<String> traces) {
        this.traceList = traces;
    }

    public ArrayList<String> getTraceList() {
        return this.traceList;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOverApproximationEnabled() {
        return this.enableOverApproximation;
    }

    public boolean isUnderApproximationEnabled() {
        return this.enableUnderApproximation;
    }

    public boolean isSiphontrapEnabled() {
        return this.useSiphontrap;
    }

    public boolean isQueryReductionEnabled() {
        return this.useQueryReduction;
    }

    public boolean isStubbornReductionEnabled() {
        return this.useStubbornReduction;
    }

    public boolean isTarOptionEnabled() {
        return this.useTarOption;
    }

    public void setUseTarOption(boolean useTarOption) {
        this.useTarOption = useTarOption;
    }

    public boolean isTarjan() {
        return this.useTarjan;
    }

    public void setUseTarjan(boolean useTarjan) {
        this.useTarjan = useTarjan;
    }

    public boolean useExplicitSearch() {
        return this.useExplicitSearch;
    }

    public void setUseExplicitSearch(boolean useExplicitSearch) {
        this.useExplicitSearch = useExplicitSearch;
    }

    public int approximationDenominator() {
        return this.denominator;
    }

    public void setApproximationDenominator(int denominator) {
        this.denominator = denominator;
    }

    public void setDiscreteInclusion(boolean value) {
        this.discreteInclusion = value;
    }

    public boolean discreteInclusion() {
        return this.discreteInclusion;
    }

    public boolean isColored() {
        return this.isColored;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setOldCapacity(int capacity) {
        this.oldCapacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Integer getOldCapacity() {
        return this.oldCapacity;
    }

    public String getQuery() {
        return this.property.toString();
    }

    public TCTLAbstractProperty getProperty() {
        return this.property;
    }

    public void setTraceOption(TraceOption traceOption) {
        this.traceOption = traceOption;
    }

    public TraceOption getTraceOption() {
        return this.traceOption;
    }

    public void setSearchOption(SearchOption searchOption) {
        this.searchOption = searchOption;
    }

    public SearchOption getSearchOption() {
        return this.searchOption;
    }

    public void setReductionOption(ReductionOption reductionOption) {
        this.reductionOption = reductionOption;
    }

    public ReductionOption getReductionOption() {
        return this.reductionOption;
    }

    public boolean useSymmetry() {
        return this.symmetry;
    }

    public boolean useGCD() {
        return this.gcd;
    }

    public void setUseGCD(boolean useGCD) {
        this.gcd = useGCD;
    }

    public boolean useTimeDarts() {
        return this.timeDart;
    }

    public void setUseTimeDarts(boolean useTimeDarts) {
        this.timeDart = useTimeDarts;
    }

    public boolean usePTrie() {
        return this.pTrie;
    }

    public void setUsePTrie(boolean usePTrie) {
        this.pTrie = usePTrie;
    }

    public boolean usePartitioning() {
        return this.partitioning;
    }

    public void setUsePartitioning(boolean usePartitioning) {
        this.partitioning = usePartitioning;
    }

    public boolean useSymmetricVars() {
        return this.symmetricVars;
    }

    public void setUseSymmetricVars(boolean useSymmetricVars) {
        this.symmetricVars = useSymmetricVars;
    }

    public boolean useColorFixpoint() {
        return this.colorFixpoint;
    }

    public void setUseColorFixpoint(boolean useColorFixpoint) {
        this.colorFixpoint = useColorFixpoint;
    }

    public void setUseOverApproximation(boolean useOverApproximation) {
        this.overApproximation = useOverApproximation;
    }

    public void setUseOverApproximationEnabled(boolean useOverApproximationEnabled) {
        this.enableOverApproximation = useOverApproximationEnabled;
    }

    public void setUseUnderApproximationEnabled(boolean useUnderApproximationEnabled) {
        this.enableUnderApproximation = useUnderApproximationEnabled;
    }

    public void setUseReduction(boolean useReduction) {
        this.useReduction = useReduction;
    }

    public void setUseColoredReduction(boolean useReduction) {
        this.useColoredReduction = useReduction;
    }

    public void setUseSiphontrap(boolean useSiphontrap) {
        this.useSiphontrap = useSiphontrap;
    }

    public void setUseQueryReduction(boolean useQueryReduction) {
        this.useQueryReduction = useQueryReduction;
    }

    public void setUseStubbornReduction(boolean useStubbornReduction) {
        this.useStubbornReduction = useStubbornReduction;
    }

    public boolean useReduction() {
        return this.useReduction;
    }

    public boolean useColoredReduction() {
        return this.useColoredReduction;
    }

    public boolean useOverApproximation() {
        return this.overApproximation;
    }

    public void setHashTableSize(HashTableSize hashTableSize) {
        this.hashTableSize = hashTableSize;
    }

    public HashTableSize getHashTableSize() {
        return this.hashTableSize;
    }

    public void setExtrapolationOption(ExtrapolationOption extrapolationOption) {
        this.extrapolationOption = extrapolationOption;
    }

    public ExtrapolationOption getExtrapolationOption() {
        return this.extrapolationOption;
    }

    public void setRawVerification(boolean useRawVerification) {
        this.useRawVerification = useRawVerification;
    }

    public boolean getRawVerification() {
        return this.useRawVerification;
    }

    public void setRawVerificationPrompt(String rawVerificationPrompt) {
        this.rawVerificationPrompt = rawVerificationPrompt;
    }

    public String getRawVerificationPrompt() {
        return this.rawVerificationPrompt;
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, boolean overApproximation, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, WorkflowMode workflow, boolean isColored) {
        this(name, capacity, property, traceOption, searchOption, reductionOption, symmetry, gcd, timeDart, pTrie, overApproximation, false, hashTabelSize, extrapolationOption, new InclusionPlaces(), isColored);
        this.setWorkflowMode(workflow);
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, boolean overApproximation, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, WorkflowMode workflow, long strongSoundnessBound, boolean isColored) {
        this(name, capacity, property, traceOption, searchOption, reductionOption, symmetry, gcd, timeDart, pTrie, overApproximation, hashTabelSize, extrapolationOption, workflow, isColored);
        this.setStrongSoundnessBound(strongSoundnessBound);
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, boolean isColored) {
        this(name, capacity, property, traceOption, searchOption, reductionOption, symmetry, gcd, timeDart, pTrie, false, false, hashTabelSize, extrapolationOption, new InclusionPlaces(), isColored);
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, boolean overApproximation, boolean reduction, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, InclusionPlaces inclusionPlaces, boolean isColored) {
        this(name, capacity, property, traceOption, searchOption, reductionOption, symmetry, gcd, timeDart, pTrie, overApproximation, reduction, hashTabelSize, extrapolationOption, new InclusionPlaces(), false, false, 0, true, true, true, isColored, false);
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, boolean overApproximation, boolean reduction, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, InclusionPlaces inclusionPlaces, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean partitioning, boolean colorFixpoint, boolean symmetricVars, boolean isColored, boolean coloredReduction) {
        this(name, capacity, property, traceOption, searchOption, reductionOption, symmetry, gcd, timeDart, pTrie, overApproximation, reduction, hashTabelSize, extrapolationOption, inclusionPlaces, enableOverApproximation, enableUnderApproximation, approximationDenominator, partitioning, colorFixpoint, symmetricVars, isColored, coloredReduction, false, "-x 1 ");
    }

    public TAPNQuery(String name, int capacity, TCTLAbstractProperty property, TraceOption traceOption, SearchOption searchOption, ReductionOption reductionOption, boolean symmetry, boolean gcd, boolean timeDart, boolean pTrie, boolean overApproximation, boolean reduction, HashTableSize hashTabelSize, ExtrapolationOption extrapolationOption, InclusionPlaces inclusionPlaces, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean partitioning, boolean colorFixpoint, boolean symmetricVars, boolean isColored, boolean coloredReduction, boolean useRawVerification, String rawVerificationPrompt) {
        this.setName(name);
        this.setCapacity(capacity);
        this.property = property;
        this.setTraceOption(traceOption);
        this.setSearchOption(searchOption);
        this.setReductionOption(reductionOption);
        this.symmetry = symmetry;
        this.gcd = gcd;
        this.timeDart = timeDart;
        this.pTrie = pTrie;
        this.overApproximation = overApproximation;
        this.setHashTableSize(hashTabelSize);
        this.setExtrapolationOption(extrapolationOption);
        this.inclusionPlaces = inclusionPlaces;
        this.useReduction = reduction;
        this.useColoredReduction = coloredReduction;
        this.enableOverApproximation = enableOverApproximation;
        this.enableUnderApproximation = enableUnderApproximation;
        this.denominator = approximationDenominator;
        this.partitioning = partitioning;
        this.colorFixpoint = colorFixpoint;
        this.symmetricVars = symmetricVars;
        this.isColored = isColored;
        this.useRawVerification = useRawVerification;
        this.rawVerificationPrompt = rawVerificationPrompt;
        this.useRawVerification = useRawVerification;
        this.rawVerificationPrompt = rawVerificationPrompt;
    }

    public String toString() {
        return this.getName();
    }

    public void set(TAPNQuery newQuery) {
        this.name = newQuery.getName();
        this.capacity = newQuery.getCapacity();
        this.oldCapacity = newQuery.getOldCapacity();
        this.property = newQuery.getProperty();
        this.traceOption = newQuery.getTraceOption();
        this.searchOption = newQuery.getSearchOption();
        this.reductionOption = newQuery.getReductionOption();
        this.symmetry = newQuery.useSymmetry();
        this.hashTableSize = newQuery.getHashTableSize();
        this.extrapolationOption = newQuery.getExtrapolationOption();
        this.discreteInclusion = newQuery.discreteInclusion();
        this.inclusionPlaces = newQuery.inclusionPlaces();
        this.useSiphontrap = newQuery.isSiphontrapEnabled();
        this.useQueryReduction = newQuery.isQueryReductionEnabled();
        this.useStubbornReduction = newQuery.isStubbornReductionEnabled();
        this.useTarOption = newQuery.isTarOptionEnabled();
        this.useExplicitSearch = newQuery.useExplicitSearch();
    }

    public void copyOptions(TAPNQuery query) {
        this.setUseOverApproximation(query.useOverApproximation());
        this.setUseUnderApproximationEnabled(query.isUnderApproximationEnabled());
        this.setUseSiphontrap(query.isSiphontrapEnabled());
        this.setUseQueryReduction(query.isQueryReductionEnabled());
        this.setUseStubbornReduction(query.isStubbornReductionEnabled());
        this.setUseTarOption(query.isTarOptionEnabled());
        this.setApproximationDenominator(query.approximationDenominator());
        this.setDiscreteInclusion(query.discreteInclusion());
        this.setCapacity(query.getCapacity());
        this.setTraceOption(query.getTraceOption());
        this.setSearchOption(query.getSearchOption());
        this.setReductionOption(query.getReductionOption());
        this.setUseSymmetricVars(query.useSymmetricVars());
        this.setUseColorFixpoint(query.useColorFixpoint());
        this.setUseGCD(query.useGCD());
        this.setUseTimeDarts(query.useTimeDarts());
        this.setUsePTrie(query.usePTrie());
        this.setUsePartitioning(query.usePartitioning());
        this.setUseOverApproximationEnabled(query.isOverApproximationEnabled());
        this.setUseReduction(query.useReduction());
        this.setExtrapolationOption(query.getExtrapolationOption());
        this.setUseColoredReduction(query.useColoredReduction());
        this.setUseTarjan(query.isTarjan());
        this.setRawVerification(query.getRawVerification());
        this.setRawVerificationPrompt(query.getRawVerificationPrompt());
        this.setSmcSettings(query.getSmcSettings());
        this.setBenchmarkMode(this.isBenchmarkMode());
        this.setBenchmarkRuns(this.getBenchmarkRuns());
        this.setParallel(this.isParallel());
        this.setGranularity(this.getGranularity());
        this.setMaxGranularity(this.isMaxGranularity());
        this.setUseExplicitSearch(query.useExplicitSearch());
    }

    public void setProperty(TCTLAbstractProperty property) {
        this.property = property;
    }

    public InclusionPlaces inclusionPlaces() {
        return this.inclusionPlaces;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public TAPNQuery copy() {
        TAPNQuery copy = new TAPNQuery(this.name, this.capacity, this.property.copy(), this.traceOption, this.searchOption, this.reductionOption, this.symmetry, this.gcd, this.timeDart, this.pTrie, this.overApproximation, this.useReduction, this.hashTableSize, this.extrapolationOption, this.inclusionPlaces, this.enableOverApproximation, this.enableUnderApproximation, this.denominator, this.partitioning, this.colorFixpoint, this.symmetricVars, this.isColored, this.useColoredReduction);
        copy.setDiscreteInclusion(this.discreteInclusion);
        copy.setActive(this.isActive);
        copy.setCategory(this.queryCategory);
        copy.setUseSiphontrap(this.isQueryReductionEnabled());
        copy.setUseQueryReduction(this.isQueryReductionEnabled());
        copy.setUseStubbornReduction(this.isStubbornReductionEnabled());
        copy.setUseTarOption(this.isTarOptionEnabled());
        copy.setSmcSettings(this.getSmcSettings());
        copy.setBenchmarkMode(this.isBenchmarkMode());
        copy.setBenchmarkRuns(this.getBenchmarkRuns());
        copy.setParallel(this.isParallel());
        copy.setUseExplicitSearch(this.useExplicitSearch());
        return copy;
    }

    public QueryType queryType() {
        if (this.property instanceof TCTLEFNode) {
            return QueryType.EF;
        }
        if (this.property instanceof TCTLEGNode) {
            return QueryType.EG;
        }
        if (this.property instanceof TCTLAFNode) {
            return QueryType.AF;
        }
        if (this.queryCategory == QueryCategory.SMC && this.property instanceof LTLFNode) {
            return QueryType.PF;
        }
        if (this.queryCategory == QueryCategory.SMC && this.property instanceof LTLGNode) {
            return QueryType.PG;
        }
        return QueryType.AG;
    }

    public WorkflowMode getWorkflowMode() {
        return this.workflow;
    }

    public void setWorkflowMode(WorkflowMode workflow) {
        this.workflow = workflow;
    }

    public long getStrongSoundnessBound() {
        return this.strongSoundnessBound;
    }

    public void setStrongSoundnessBound(long newval) {
        this.strongSoundnessBound = newval;
    }

    public void setCategory(QueryCategory category) {
        this.queryCategory = category;
    }

    public QueryCategory getCategory() {
        return this.queryCategory;
    }

    public void setAlgorithmOption(AlgorithmOption option) {
        this.algorithmOption = option;
    }

    public AlgorithmOption getAlgorithmOption() {
        return this.algorithmOption;
    }

    public SMCSettings getSmcSettings() {
        return this.smcSettings;
    }

    public void setSmcSettings(SMCSettings newSettings) {
        this.smcSettings = newSettings;
    }

    public boolean isBenchmarkMode() {
        return this.benchmark;
    }

    public void setBenchmarkMode(boolean mode) {
        this.benchmark = mode;
    }

    public int getBenchmarkRuns() {
        return this.benchmarkRuns;
    }

    public void setBenchmarkRuns(int runs) {
        this.benchmarkRuns = runs;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean value) {
        this.parallel = value;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public void setMaxGranularity(boolean maxGranularity) {
        this.maxGranularity = maxGranularity;
    }

    public boolean isMaxGranularity() {
        return this.maxGranularity;
    }

    public void setVerificationType(VerificationType verificationType) {
        this.verificationType = verificationType;
    }

    public VerificationType getVerificationType() {
        return this.verificationType;
    }

    public void setNumberOfTraces(int numberOfTraces) {
        this.numberOfTraces = numberOfTraces;
    }

    public int getNumberOfTraces() {
        return this.numberOfTraces;
    }

    public void setSmcTraceType(SMCTraceType traceType) {
        this.smcTraceType = traceType;
    }

    public SMCTraceType getSmcTraceType() {
        return this.smcTraceType;
    }

    public boolean isSimulate() {
        return this.verificationType.equals((Object)VerificationType.SIMULATE);
    }

    public boolean hasUntimedOnlyProperties() {
        if (!(this.property instanceof TCTLAFNode || this.property instanceof TCTLAGNode || this.property instanceof TCTLEFNode || this.property instanceof TCTLEGNode || this.queryType() == QueryType.PF || this.queryType() == QueryType.PG)) {
            return true;
        }
        return this.property.hasNestedPathQuantifiers();
    }

    public TAPNQuery convertPropertyForReducedNet(String templateName) {
        TAPNQuery convertedQuery = this.copy();
        convertedQuery.property.convertForReducedNet(templateName);
        return convertedQuery;
    }

    public static enum TraceOption {
        FASTEST,
        SOME,
        NONE;

    }

    public static enum SearchOption {
        BFS,
        DFS,
        RANDOM,
        BatchProcessingKeepQueryOption,
        HEURISTIC,
        OVERAPPROXIMATE,
        DEFAULT,
        RANDOMHEURISTIC;

    }

    public static enum HashTableSize {
        MB_4,
        MB_16,
        MB_64,
        MB_256,
        MB_512;

    }

    public static enum ExtrapolationOption {
        AUTOMATIC,
        NONE,
        DIFF,
        LOCAL,
        LOW_UP;

    }

    public static enum WorkflowMode {
        NOT_WORKFLOW,
        WORKFLOW_SOUNDNESS,
        WORKFLOW_STRONG_SOUNDNESS;

    }

    public static enum QueryCategory {
        Default,
        CTL,
        LTL,
        HyperLTL,
        SMC;

    }

    public static enum AlgorithmOption {
        CERTAIN_ZERO,
        LOCAL;

    }

    public static enum VerificationType {
        QUANTITATIVE,
        QUALITATIVE,
        SIMULATE;


        public static VerificationType fromOrdinal(int ordinal) {
            switch (ordinal) {
                case 1: {
                    return QUALITATIVE;
                }
                case 2: {
                    return SIMULATE;
                }
            }
            return QUANTITATIVE;
        }

        public static VerificationType fromString(String type) {
            switch (type) {
                case "Qualitative": {
                    return QUALITATIVE;
                }
                case "Simulate": {
                    return SIMULATE;
                }
            }
            return QUANTITATIVE;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "Qualitative";
                }
                case 2: {
                    return "Simulate";
                }
            }
            return "Quantitative";
        }
    }

    public static enum QueryReductionTime {
        NoTime,
        ShortestTime,
        UnlimitedTime;

    }
}

