/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.util.MemoryMonitor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class RunningVerificationDialog
extends JDialog {
    private final SwingWorker<?, ?> worker;
    private JButton okButton;
    private long startTimeMs = 0L;
    JLabel timerLabel;
    JLabel headLineLabel;
    JLabel progressLabel;
    JLabel resourcesLabel;
    JLabel usageLabel;
    private Timer timer;
    private final String processName;
    private int memoryTimerCount = 0;
    private int memoryTimerMode = 0;
    private int peakMemory = -1;
    private Timer memoryTimer;

    private void startMemoryTimer() {
        if (this.memoryTimer.isRunning()) {
            this.memoryTimer.stop();
        }
        this.peakMemory = -1;
        this.memoryTimer.setDelay(50);
        this.memoryTimerCount = 0;
        this.memoryTimerMode = 0;
        this.memoryTimer.start();
    }

    private void stopMemoryTimer() {
        if (this.memoryTimer.isRunning()) {
            this.memoryTimer.stop();
        }
    }

    public RunningVerificationDialog(JFrame owner, SwingWorker<?, ?> worker, String processName) {
        super(owner, processName + " in Progress", true);
        this.worker = worker;
        this.processName = processName;
        this.initComponents();
        this.initActions();
        this.pack();
    }

    public RunningVerificationDialog(JFrame owner, SwingWorker<?, ?> worker) {
        this(owner, worker, "Verification");
    }

    private void initActions() {
        this.okButton.addActionListener(evt -> {
            this.closeWindow();
            this.worker.cancel(true);
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RunningVerificationDialog.this.closeWindow();
                RunningVerificationDialog.this.worker.cancel(true);
            }
        });
        this.worker.addPropertyChangeListener(event -> {
            SwingWorker.StateValue stateValue;
            if (event.getPropertyName().equals("state") && (stateValue = (SwingWorker.StateValue)((Object)((Object)event.getNewValue()))).equals((Object)SwingWorker.StateValue.DONE)) {
                this.closeWindow();
            }
        });
    }

    private void closeWindow() {
        this.setVisible(false);
        this.timer.stop();
        this.stopMemoryTimer();
        this.dispose();
    }

    public void initComponents() {
        this.setLocationRelativeTo(null);
        this.setLayout(new GridBagLayout());
        this.timer = new Timer(1000, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningVerificationDialog.this.timerLabel.setText((System.currentTimeMillis() - RunningVerificationDialog.this.startTimeMs) / 1000L + " s");
                RunningVerificationDialog.this.usageLabel.setText((String)(RunningVerificationDialog.this.peakMemory >= 0 ? RunningVerificationDialog.this.peakMemory + " MB" : "N/A"));
            }
        });
        this.memoryTimer = new Timer(50, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MemoryMonitor.isAttached()) {
                    MemoryMonitor.getUsage();
                    RunningVerificationDialog.this.peakMemory = MemoryMonitor.getPeakMemoryValue();
                    if (RunningVerificationDialog.this.memoryTimerMode == 0 && RunningVerificationDialog.this.memoryTimerCount == 2) {
                        RunningVerificationDialog.this.memoryTimerCount = 0;
                        ++RunningVerificationDialog.this.memoryTimerMode;
                        RunningVerificationDialog.this.memoryTimer.setDelay(100);
                    } else if (RunningVerificationDialog.this.memoryTimerMode == 1 && RunningVerificationDialog.this.memoryTimerCount == 4) {
                        RunningVerificationDialog.this.memoryTimerCount = 0;
                        ++RunningVerificationDialog.this.memoryTimerMode;
                        RunningVerificationDialog.this.memoryTimer.setDelay(200);
                    } else if (RunningVerificationDialog.this.memoryTimerMode == 2 && RunningVerificationDialog.this.memoryTimerCount == 5) {
                        RunningVerificationDialog.this.memoryTimerCount = 0;
                        ++RunningVerificationDialog.this.memoryTimerMode;
                        RunningVerificationDialog.this.memoryTimer.setDelay(1000);
                    } else if (RunningVerificationDialog.this.memoryTimerMode < 3) {
                        ++RunningVerificationDialog.this.memoryTimerCount;
                    }
                }
            }
        });
        this.okButton = new JButton("Interrupt " + this.processName);
        this.headLineLabel = new JLabel();
        this.headLineLabel.setText(this.processName + " is running, please wait ...  ");
        this.progressLabel = new JLabel();
        this.progressLabel.setText("Elapsed time: ");
        this.resourcesLabel = new JLabel();
        this.resourcesLabel.setText("Memory usage: ");
        this.timerLabel = new JLabel();
        this.timerLabel.setText("0 s");
        this.usageLabel = new JLabel();
        this.usageLabel.setText("initializing...");
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        content.add((Component)this.headLineLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        content.add((Component)this.progressLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        content.add((Component)this.timerLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        content.add((Component)this.resourcesLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        content.add((Component)this.usageLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.insets = insets;
        content.add((Component)this.okButton, gbc);
        this.startTimeMs = System.currentTimeMillis();
        this.timer.start();
        this.memoryTimer.start();
    }
}

