/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import com.sun.jna.Platform;
import dk.aau.cs.verification.UPPAAL.Verifyta;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.tapaal.swinghelpers.RequestFocusListener;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class EngineDialogPanel {
    private EscapableDialog dialog;
    private JPanel enginePanel;
    private JPanel tapaalPanel;
    private JPanel tapaalDiscretePanel;
    private JPanel untimedPanel;
    private JPanel uppaalPanel;
    private JPanel javaPanel;
    JButton closeButton;
    final JLabel tapaalLocationLabel = new JLabel("Located: ");
    final JLabel tapaalVersionLabel = new JLabel("Version: ");
    final JLabel dtapaalLocationLabel = new JLabel("Located: ");
    final JLabel dtapaalVersionLabel = new JLabel("Version: ");
    final JLabel untimedLocationLabel = new JLabel("Located: ");
    final JLabel untimedVersionLabel = new JLabel("Version: ");
    final JLabel uppaalLocationLabel = new JLabel("Located: ");
    final JLabel uppaalVersionLabel = new JLabel("Version: ");
    final JLabel javaVersionLabel = new JLabel("Version: ");
    final JLabel tapaalLocationLabelVal = new JLabel("Not setup");
    final JLabel tapaalVersionLabelVal = new JLabel("N/A");
    final JLabel dtapaalLocationLabelVal = new JLabel("Not setup");
    final JLabel dtapaalVersionLabelVal = new JLabel("N/A");
    final JLabel untimedLocationLabelVal = new JLabel("Not setup");
    final JLabel untimedVersionLabelVal = new JLabel("N/A");
    final JLabel uppaalLocationLabelVal = new JLabel("Not setup");
    final JLabel uppaalVersionLabelVal = new JLabel("N/A");
    private final Dimension minimumSize = new Dimension(320, 1);
    private final Insets panelInsets = new Insets(5, 5, 5, 5);
    private final Insets smallPanelInsets = new Insets(0, 5, 0, 5);
    private final Insets buttonInsets = new Insets(0, 5, 0, 0);
    private final String toolTipSelect = "Select a path to the verification engine.";
    private final String toolTipReset = "Reset the path to the verification engine.";
    final String engineExstension = Platform.isWindows() ? "exe" : "";

    public EngineDialogPanel() {
        this.initComponents();
    }

    public void initComponents() {
        this.makeTapaalPanel();
        this.makeUppaalPanel();
        this.makeDiscreteTapaalPanel();
        this.makeUntimedPanel();
        this.makeJavaPanel();
        this.makeEnginePanel();
        this.setPathsAndVersionNumbers();
    }

    private void selectTapnEngine() {
        FileFinder fileFinder = new FileFinder();
        MessengerImpl messenger = new MessengerImpl();
        String verifytapnpath = null;
        try {
            File file = fileFinder.ShowFileBrowserDialog("Verifytapn", this.engineExstension, new VerifyTAPN(new FileFinder(), new MessengerImpl()).getPath());
            if (file != null) {
                if (file.getName().matches("^verifytapn.*(?:\\.exe)?$")) {
                    verifytapnpath = file.getAbsolutePath();
                } else {
                    messenger.displayErrorMessage("The selected executable does not seem to be verifytapn.");
                }
            }
        }
        catch (Exception e) {
            messenger.displayErrorMessage("There were errors performing the requested action:\n" + String.valueOf(e), "Error");
        }
        if (verifytapnpath != null) {
            try {
                VerifyTAPN verifyTapn = new VerifyTAPN(fileFinder, messenger);
                verifyTapn.setPath(verifytapnpath);
            }
            catch (IllegalArgumentException e) {
                messenger.displayErrorMessage(e.getMessage(), "Error selecting engine");
            }
            this.setPathsAndVersionNumbers();
            this.fitDialog();
        }
    }

    private void selectdTapnEngine() {
        FileFinder fileFinder = new FileFinder();
        MessengerImpl messenger = new MessengerImpl();
        String verifytapnpath = null;
        try {
            File file = fileFinder.ShowFileBrowserDialog("Verifydtapn", this.engineExstension, new VerifyDTAPN(new FileFinder(), new MessengerImpl()).getPath());
            if (file != null) {
                if (file.getName().matches("^verifydtapn.*(?:\\.exe)?$")) {
                    verifytapnpath = file.getAbsolutePath();
                } else {
                    messenger.displayErrorMessage("The selected executable does not seem to be verifydtapn.");
                }
            }
        }
        catch (Exception e) {
            messenger.displayErrorMessage("There were errors performing the requested action:\n" + String.valueOf(e), "Error");
        }
        if (verifytapnpath != null) {
            try {
                VerifyDTAPN verifyTapn = new VerifyDTAPN(fileFinder, messenger);
                verifyTapn.setPath(verifytapnpath);
            }
            catch (IllegalArgumentException e) {
                messenger.displayErrorMessage(e.getMessage(), "Error selecting engine");
            }
            this.setPathsAndVersionNumbers();
            this.fitDialog();
        }
    }

    private void selectVerifytaEngine() {
        FileFinder fileFinder = new FileFinder();
        MessengerImpl messenger = new MessengerImpl();
        String verifytapath = null;
        try {
            File file = fileFinder.ShowFileBrowserDialog("Verifyta", this.engineExstension, new Verifyta().getPath());
            if (file != null) {
                if (file.getName().matches("^verifyta(?:\\d.*)?(?:\\.exe)?$")) {
                    verifytapath = file.getAbsolutePath();
                } else {
                    messenger.displayErrorMessage("The selected executable does not seem to be verifyta.");
                }
            }
        }
        catch (Exception e) {
            messenger.displayErrorMessage("There were errors performing the requested action:\n" + String.valueOf(e), "Error");
        }
        if (verifytapath != null) {
            try {
                Verifyta verifyta = new Verifyta(fileFinder, messenger);
                verifyta.setPath(verifytapath);
            }
            catch (IllegalArgumentException e) {
                messenger.displayErrorMessage(e.getMessage(), "Error selecting engine");
            }
            this.setPathsAndVersionNumbers();
            this.fitDialog();
        }
    }

    private void selectVerifypnEngine() {
        FileFinder fileFinder = new FileFinder();
        MessengerImpl messenger = new MessengerImpl();
        String verifypnpath = null;
        try {
            File file = fileFinder.ShowFileBrowserDialog("Verifypn", this.engineExstension, new VerifyPN(new FileFinder(), new MessengerImpl()).getPath());
            if (file != null) {
                if (file.getName().matches("^verifypn.*(?:\\.exe)?$")) {
                    verifypnpath = file.getAbsolutePath();
                } else {
                    messenger.displayErrorMessage("The selected executable does not seem to be verifypn.");
                }
            }
        }
        catch (Exception e) {
            messenger.displayErrorMessage("There were errors performing the requested action:\n" + String.valueOf(e), "Error");
        }
        if (verifypnpath != null) {
            try {
                VerifyPN verifyPn = new VerifyPN(fileFinder, messenger);
                verifyPn.setPath(verifypnpath);
            }
            catch (IllegalArgumentException e) {
                messenger.displayErrorMessage(e.getMessage(), "Error selecting engine");
            }
            this.setPathsAndVersionNumbers();
            this.fitDialog();
        }
    }

    private void resetVerifytaEngine() {
        Verifyta.reset();
        this.setPathsAndVersionNumbers();
    }

    private void resetVerifytapnEngine() {
        VerifyTAPN.reset();
        this.setPathsAndVersionNumbers();
    }

    private void resetVerifydtapnEngine() {
        VerifyDTAPN.reset();
        this.setPathsAndVersionNumbers();
    }

    private void resetVerifypnEngine() {
        VerifyPN.reset();
        this.setPathsAndVersionNumbers();
    }

    private void fitDialog() {
        if (this.dialog != null) {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
        }
    }

    private void exit() {
        this.dialog.setVisible(false);
    }

    private void setPathsAndVersionNumbers() {
        Verifyta verifyta = new Verifyta();
        String verifytaPath = verifyta.getPath();
        String verifytaversion = "";
        if (verifytaPath == null || verifytaPath.isEmpty()) {
            verifytaPath = "Not setup";
            verifytaversion = "N/A";
        } else {
            verifytaversion = verifyta.getVersion();
        }
        VerifyTAPN verifyTAPN = new VerifyTAPN(new FileFinder(), new MessengerImpl());
        String verifytapnPath = verifyTAPN.getPath();
        String verifytapnversion = "";
        if (verifytapnPath == null || verifytapnPath.isEmpty()) {
            verifytapnPath = "Not setup";
            verifytapnversion = "N/A";
        } else {
            verifytapnversion = verifyTAPN.getVersion();
        }
        VerifyDTAPN verifydTAPN = new VerifyDTAPN(new FileFinder(), new MessengerImpl());
        String verifydtapnPath = verifydTAPN.getPath();
        String verifydtapnversion = "";
        if (verifydtapnPath == null || verifydtapnPath.isEmpty()) {
            verifydtapnPath = "Not setup";
            verifydtapnversion = "N/A";
        } else {
            verifydtapnversion = verifydTAPN.getVersion();
        }
        VerifyPN verifypn = new VerifyPN(new FileFinder(), new MessengerImpl());
        String verifypnpath = verifypn.getPath();
        String verifypnversion = "";
        if (verifypnpath == null || verifypnpath.isEmpty()) {
            verifypnpath = "Not setup";
            verifypnversion = "N/A";
        } else {
            verifypnversion = verifypn.getVersion();
        }
        this.tapaalLocationLabelVal.setText(verifytapnPath);
        this.tapaalVersionLabelVal.setText(verifytapnversion);
        this.dtapaalLocationLabelVal.setText(verifydtapnPath);
        this.dtapaalVersionLabelVal.setText(verifydtapnversion);
        this.untimedLocationLabelVal.setText(verifypnpath);
        this.untimedVersionLabelVal.setText(verifypnversion);
        this.uppaalLocationLabelVal.setText(verifytaPath);
        this.uppaalVersionLabelVal.setText(verifytaversion);
        this.fitDialog();
    }

    private void makeTapaalPanel() {
        this.tapaalPanel = new JPanel();
        this.tapaalPanel.setBorder(BorderFactory.createTitledBorder("TAPAAL Engine (verifytapn) Information"));
        this.tapaalPanel.setLayout(new GridBagLayout());
        JPanel tapaalInfoPanel = new JPanel();
        tapaalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.tapaalLocationLabel);
        p.add(this.tapaalLocationLabelVal);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        tapaalInfoPanel.add((Component)p, gbc);
        p = new JPanel(new FlowLayout());
        p.add(this.tapaalVersionLabel);
        p.add(this.tapaalVersionLabelVal);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        tapaalInfoPanel.add((Component)p, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.smallPanelInsets;
        this.tapaalPanel.add((Component)tapaalInfoPanel, gbc);
        JButton tapaalSelectButton = new JButton("Select");
        tapaalSelectButton.setMnemonic(69);
        tapaalSelectButton.setToolTipText("Select a path to the verification engine.");
        JButton tapaalResetButton = new JButton("Reset");
        tapaalResetButton.setToolTipText("Reset the path to the verification engine.");
        tapaalResetButton.setMnemonic(84);
        tapaalSelectButton.addActionListener(e -> this.selectTapnEngine());
        tapaalResetButton.addActionListener(e -> this.resetVerifytapnEngine());
        JPanel tapaalButtonPanel = new JPanel();
        tapaalButtonPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        tapaalButtonPanel.add((Component)tapaalSelectButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = this.buttonInsets;
        gbc.anchor = 13;
        tapaalButtonPanel.add((Component)tapaalResetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.tapaalPanel.add((Component)tapaalButtonPanel, gbc);
    }

    private void makeDiscreteTapaalPanel() {
        this.tapaalDiscretePanel = new JPanel();
        this.tapaalDiscretePanel.setBorder(BorderFactory.createTitledBorder("Discrete TAPAAL Engine (verifydtapn) Information"));
        this.tapaalDiscretePanel.setLayout(new GridBagLayout());
        JPanel tapaalDiscreteInfoPanel = new JPanel();
        tapaalDiscreteInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.dtapaalLocationLabel);
        p.add(this.dtapaalLocationLabelVal);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        tapaalDiscreteInfoPanel.add((Component)p, gbc);
        p = new JPanel(new FlowLayout());
        p.add(this.dtapaalVersionLabel);
        p.add(this.dtapaalVersionLabelVal);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        tapaalDiscreteInfoPanel.add((Component)p, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.smallPanelInsets;
        this.tapaalDiscretePanel.add((Component)tapaalDiscreteInfoPanel, gbc);
        JButton SelectButton = new JButton("Select");
        SelectButton.setMnemonic(69);
        SelectButton.setToolTipText("Select a path to the verification engine.");
        JButton ResetButton = new JButton("Reset");
        ResetButton.setToolTipText("Reset the path to the verification engine.");
        ResetButton.setMnemonic(84);
        SelectButton.addActionListener(e -> this.selectdTapnEngine());
        ResetButton.addActionListener(e -> this.resetVerifydtapnEngine());
        JPanel ButtonPanel = new JPanel();
        ButtonPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        ButtonPanel.add((Component)SelectButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = this.buttonInsets;
        gbc.anchor = 13;
        ButtonPanel.add((Component)ResetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.tapaalDiscretePanel.add((Component)ButtonPanel, gbc);
    }

    private void makeUntimedPanel() {
        this.untimedPanel = new JPanel();
        this.untimedPanel.setBorder(BorderFactory.createTitledBorder("Untimed TAPAAL Engine (verifypn) Information"));
        this.untimedPanel.setLayout(new GridBagLayout());
        JPanel untimedInfoPanel = new JPanel();
        untimedInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.untimedLocationLabel);
        p.add(this.untimedLocationLabelVal);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        untimedInfoPanel.add((Component)p, gbc);
        p = new JPanel(new FlowLayout());
        p.add(this.untimedVersionLabel);
        p.add(this.untimedVersionLabelVal);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        untimedInfoPanel.add((Component)p, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.smallPanelInsets;
        this.untimedPanel.add((Component)untimedInfoPanel, gbc);
        JButton SelectButton = new JButton("Select");
        SelectButton.setMnemonic(69);
        SelectButton.setToolTipText("Select a path to the verification engine.");
        JButton ResetButton = new JButton("Reset");
        ResetButton.setToolTipText("Reset the path to the verification engine.");
        ResetButton.setMnemonic(84);
        SelectButton.addActionListener(e -> this.selectVerifypnEngine());
        ResetButton.addActionListener(e -> this.resetVerifypnEngine());
        JPanel ButtonPanel = new JPanel();
        ButtonPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        ButtonPanel.add((Component)SelectButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = this.buttonInsets;
        gbc.anchor = 13;
        ButtonPanel.add((Component)ResetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.untimedPanel.add((Component)ButtonPanel, gbc);
    }

    private void makeUppaalPanel() {
        this.uppaalPanel = new JPanel();
        this.uppaalPanel.setBorder(BorderFactory.createTitledBorder("UPPAAL Engine (verifyta) Information"));
        this.uppaalPanel.setLayout(new GridBagLayout());
        JPanel uppaalInfoPanel = new JPanel();
        uppaalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.uppaalLocationLabel);
        p.add(this.uppaalLocationLabelVal);
        uppaalInfoPanel.add((Component)p, gbc);
        p = new JPanel(new FlowLayout());
        p.add(this.uppaalVersionLabel);
        p.add(this.uppaalVersionLabelVal);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        uppaalInfoPanel.add((Component)p, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.smallPanelInsets;
        this.uppaalPanel.add((Component)uppaalInfoPanel, gbc);
        JButton uppaalSelectButton = new JButton("Select");
        uppaalSelectButton.setMnemonic(83);
        uppaalSelectButton.setToolTipText("Select a path to the verification engine.");
        JButton uppaalResetButton = new JButton("Reset");
        uppaalResetButton.setMnemonic(82);
        uppaalResetButton.setToolTipText("Reset the path to the verification engine.");
        uppaalSelectButton.addActionListener(e -> this.selectVerifytaEngine());
        uppaalResetButton.addActionListener(arg0 -> this.resetVerifytaEngine());
        JPanel uppaalButtonPanel = new JPanel();
        uppaalButtonPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        uppaalButtonPanel.add((Component)uppaalSelectButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = this.buttonInsets;
        uppaalButtonPanel.add((Component)uppaalResetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.uppaalPanel.add((Component)uppaalButtonPanel, gbc);
    }

    private void makeJavaPanel() {
        String version = System.getProperty("java.version");
        this.javaPanel = new JPanel();
        this.javaPanel.setBorder(BorderFactory.createTitledBorder("Java"));
        this.javaPanel.setLayout(new GridBagLayout());
        JPanel javaInfoPanel = new JPanel();
        javaInfoPanel.setLayout(new GridBagLayout());
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.javaVersionLabel);
        p.add(new JLabel(version));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        javaInfoPanel.add((Component)p, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.javaPanel.add((Component)javaInfoPanel, gbc);
    }

    private void makeEnginePanel() {
        this.enginePanel = new JPanel();
        this.enginePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.enginePanel.add((Component)this.tapaalPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.enginePanel.add((Component)this.tapaalDiscretePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.enginePanel.add((Component)this.untimedPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.enginePanel.add((Component)this.uppaalPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = this.panelInsets;
        this.enginePanel.add((Component)this.javaPanel, gbc);
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.setLayout(new GridBagLayout());
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addAncestorListener(new RequestFocusListener());
        this.closeButton.addActionListener(e -> this.exit());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        closeButtonPanel.add((Component)this.closeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 2, 5);
        this.enginePanel.add((Component)closeButtonPanel, gbc);
    }

    public void showDialog() {
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Selection of Verification Engines", true);
        this.dialog.add(this.enginePanel);
        this.dialog.getRootPane().setDefaultButton(this.closeButton);
        this.dialog.setResizable(false);
        this.dialog.setMinimumSize(this.minimumSize);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }
}

