/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class ChooseInclusionPlacesDialog
extends JPanel {
    private final JRootPane rootPane;
    private JList placeList;
    private DefaultListModel listModel;
    private final TimedArcPetriNetNetwork tapnNetwork;
    private JCheckBox userSpecifiedCheckBox;
    private JCheckBox allPlacesCheckBox;
    private JButton clearSelection;
    private JButton selectAll;

    public ChooseInclusionPlacesDialog(JRootPane rootPane, TimedArcPetriNetNetwork tapnNetwork, InclusionPlaces inclusionPlaces) {
        this.rootPane = rootPane;
        this.tapnNetwork = tapnNetwork;
        this.initComponents();
        this.setupFromInput(inclusionPlaces);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel placesPanel = new JPanel(new BorderLayout());
        placesPanel.setBorder(BorderFactory.createTitledBorder("Choose the places eligible for discrete inclusion checking"));
        this.listModel = new DefaultListModel();
        this.placeList = new JList(this.listModel);
        this.placeList.setCellRenderer(new InclusionPlacesCellRenderer(this.placeList.getCellRenderer()));
        InclusionPlacesListManager manager = new InclusionPlacesListManager(this.placeList);
        this.placeList.addListSelectionListener(manager);
        this.placeList.addMouseListener(manager);
        this.placeList.setSelectionMode(0);
        this.placeList.setLayoutOrientation(2);
        this.placeList.setVisibleRowCount(0);
        this.placeList.setEnabled(false);
        JScrollPane scrollpane = new JScrollPane(this.placeList);
        scrollpane.setHorizontalScrollBarPolicy(30);
        scrollpane.setVerticalScrollBarPolicy(20);
        placesPanel.add((Component)scrollpane, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.add((Component)placesPanel, gbc);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JPanel checkboxPanel = new JPanel(new BorderLayout());
        this.allPlacesCheckBox = new JCheckBox("Use all places for inclusion checking");
        this.allPlacesCheckBox.setSelected(true);
        this.allPlacesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.setSelected(!ChooseInclusionPlacesDialog.this.allPlacesCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.placeList.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.clearSelection.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.selectAll.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
            }
        });
        this.userSpecifiedCheckBox = new JCheckBox("Manually select places eligible for inclusion checking");
        this.userSpecifiedCheckBox.setSelected(false);
        this.userSpecifiedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseInclusionPlacesDialog.this.allPlacesCheckBox.setSelected(!ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.placeList.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.clearSelection.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
                ChooseInclusionPlacesDialog.this.selectAll.setEnabled(ChooseInclusionPlacesDialog.this.userSpecifiedCheckBox.isSelected());
            }
        });
        checkboxPanel.add((Component)this.allPlacesCheckBox, "North");
        checkboxPanel.add((Component)this.userSpecifiedCheckBox, "South");
        buttonPanel.add(checkboxPanel);
        placesPanel.add((Component)buttonPanel, "North");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.selectAll = new JButton("Select All");
        this.selectAll.setEnabled(false);
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < ChooseInclusionPlacesDialog.this.listModel.size(); ++i) {
                    CheckBoxListItem item = (CheckBoxListItem)ChooseInclusionPlacesDialog.this.listModel.getElementAt(i);
                    item.setSelected(true);
                }
                ChooseInclusionPlacesDialog.this.placeList.repaint();
            }
        });
        panel.add(this.selectAll);
        this.clearSelection = new JButton("Clear Selection");
        this.clearSelection.setEnabled(false);
        this.clearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < ChooseInclusionPlacesDialog.this.listModel.size(); ++i) {
                    CheckBoxListItem item = (CheckBoxListItem)ChooseInclusionPlacesDialog.this.listModel.getElementAt(i);
                    item.setSelected(false);
                }
                ChooseInclusionPlacesDialog.this.placeList.repaint();
            }
        });
        panel.add(this.clearSelection);
        placesPanel.add((Component)panel, "South");
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChooseInclusionPlacesDialog.this.exit();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.add((Component)okButton, gbc);
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }

    private void setupFromInput(InclusionPlaces inclusionPlaces) {
        this.addPlacesToPlaceList(inclusionPlaces);
        boolean allPlaces = inclusionPlaces.inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces;
        this.allPlacesCheckBox.setSelected(allPlaces);
        this.userSpecifiedCheckBox.setSelected(!allPlaces);
        this.placeList.setEnabled(!allPlaces);
        this.clearSelection.setEnabled(!allPlaces);
        this.selectAll.setEnabled(!allPlaces);
    }

    private void addPlacesToPlaceList(InclusionPlaces inclusionPlaces) {
        List<TimedPlace> incPlaces = inclusionPlaces.inclusionPlaces();
        boolean allPlaces = inclusionPlaces.inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces;
        Collection<SharedPlace> sharedPlaces = this.tapnNetwork.sharedPlaces();
        Vector<TimedPlace> tempPlaces = new Vector<TimedPlace>(sharedPlaces);
        this.sortPlacesByName(tempPlaces);
        for (TimedPlace p : tempPlaces) {
            this.listModel.addElement(new CheckBoxListItem(p, allPlaces || incPlaces.contains(p)));
        }
        for (TimedArcPetriNet net : this.tapnNetwork.activeTemplates()) {
            tempPlaces = new Vector<TimedPlace>(net.places());
            this.sortPlacesByName(tempPlaces);
            for (TimedPlace place : tempPlaces) {
                if (place.isShared()) continue;
                this.listModel.addElement(new CheckBoxListItem(place, allPlaces || incPlaces.contains(place)));
            }
        }
    }

    private void sortPlacesByName(Vector<TimedPlace> tempPlaces) {
        tempPlaces.sort((p1, p2) -> p1.name().compareToIgnoreCase(p2.name()));
    }

    public static InclusionPlaces showInclusionPlacesDialog(TimedArcPetriNetNetwork tapnNetwork, InclusionPlaces inclusionPlaces) {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Choose Inclusion Places", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        ChooseInclusionPlacesDialog dialog = new ChooseInclusionPlacesDialog(guiDialog.getRootPane(), tapnNetwork, inclusionPlaces);
        contentPane.add(dialog);
        guiDialog.setResizable(true);
        guiDialog.setPreferredSize(new Dimension(550, 500));
        guiDialog.setMinimumSize(new Dimension(450, 400));
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
        return dialog.getInclusionPlaces();
    }

    private InclusionPlaces getInclusionPlaces() {
        if (this.allPlacesCheckBox.isSelected()) {
            return new InclusionPlaces();
        }
        ArrayList<TimedPlace> inclusionPlaces = new ArrayList<TimedPlace>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            CheckBoxListItem item = (CheckBoxListItem)this.listModel.getElementAt(i);
            if (!item.isSelected()) continue;
            inclusionPlaces.add(item.place());
        }
        return new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, inclusionPlaces);
    }

    private static class InclusionPlacesCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String UNCHECK_TO_DEACTIVATE = "Uncheck to exclude place from inclusion check.";
        private static final String CHECK_TO_ACTIVATE = "Check to make place eligible for inclusion check.";
        private final JCheckBox activeCheckbox = new JCheckBox();
        private final ListCellRenderer cellRenderer;

        public InclusionPlacesCellRenderer(ListCellRenderer renderer) {
            this.cellRenderer = renderer;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.activeCheckbox.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = this.cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.removeAll();
            boolean selected = ((CheckBoxListItem)value).isSelected();
            this.activeCheckbox.setSelected(selected);
            this.setToolTipText(selected ? UNCHECK_TO_DEACTIVATE : CHECK_TO_ACTIVATE);
            this.add((Component)this.activeCheckbox, "West");
            this.add(renderer, "Center");
            return this;
        }
    }

    private static class InclusionPlacesListManager
    extends MouseAdapter
    implements ListSelectionListener,
    ActionListener {
        private final ListSelectionModel selectionModel;
        private final JList list;

        public InclusionPlacesListManager(JList list) {
            this.list = list;
            this.selectionModel = list.getSelectionModel();
            this.list.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void toggleSelection(int index) {
            CheckBoxListItem item;
            if (index < 0 || !this.list.isEnabled()) {
                return;
            }
            if (!this.selectionModel.isSelectedIndex(index)) {
                this.selectionModel.addSelectionInterval(index, index);
            }
            item.setSelected(!(item = (CheckBoxListItem)this.list.getModel().getElementAt(index)).isSelected());
            this.list.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = this.list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            this.toggleSelection(index);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.toggleSelection(this.list.getSelectedIndex());
        }
    }

    private static class CheckBoxListItem {
        private final TimedPlace place;
        private boolean isSelected;

        public CheckBoxListItem(TimedPlace place, boolean selected) {
            this.place = place;
            this.isSelected = selected;
        }

        public TimedPlace place() {
            return this.place;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String toString() {
            return this.place.toString();
        }
    }
}

