/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.Require;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;

public class UnsharePlaceCommand
implements Command {
    private final SharedPlace sharedPlace;
    private final TimedPlace place;
    private final TimedArcPetriNet tapn;
    private final TimedPlaceComponent placeComponent;

    public UnsharePlaceCommand(TimedArcPetriNet tapn, SharedPlace sharedPlace, TimedPlace place, TimedPlaceComponent placeComponent) {
        Require.that(tapn != null, "tapn cannot be null");
        Require.that(sharedPlace != null, "sharedPlace cannot be null");
        Require.that(place != null, "timedPlace cannot be null");
        Require.that(placeComponent != null, "placeComponent cannot be null");
        this.tapn = tapn;
        this.sharedPlace = sharedPlace;
        this.place = place;
        this.placeComponent = placeComponent;
    }

    @Override
    public void redo() {
        this.updateArcs(this.sharedPlace, this.place);
        this.tapn.remove(this.sharedPlace);
        this.tapn.add(this.place);
        this.placeComponent.setUnderlyingPlace(this.place);
    }

    @Override
    public void undo() {
        this.updateArcs(this.place, this.sharedPlace);
        this.tapn.remove(this.place);
        this.tapn.add(this.sharedPlace);
        this.placeComponent.setUnderlyingPlace(this.sharedPlace);
    }

    private void updateArcs(TimedPlace toReplace, TimedPlace replacement) {
        for (TimedInputArc timedInputArc : this.tapn.inputArcs()) {
            if (!timedInputArc.source().equals(toReplace)) continue;
            timedInputArc.setSource(replacement);
        }
        for (TimedInhibitorArc timedInhibitorArc : this.tapn.inhibitorArcs()) {
            if (!timedInhibitorArc.source().equals(toReplace)) continue;
            timedInhibitorArc.setSource(replacement);
        }
        for (TransportArc transportArc : this.tapn.transportArcs()) {
            if (transportArc.source().equals(toReplace)) {
                transportArc.setSource(replacement);
            }
            if (!transportArc.destination().equals(toReplace)) continue;
            transportArc.setDestination(replacement);
        }
        for (TimedOutputArc timedOutputArc : this.tapn.outputArcs()) {
            if (!timedOutputArc.destination().equals(toReplace)) continue;
            timedOutputArc.setDestination(replacement);
        }
    }
}

