/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import java.util.Arrays;

public class UndoRedoBuffer<T> {
    public final int CAPACITY;
    private final T[] buffer;
    private int currentIndex;
    private int elements = 0;
    private int elementsOnTop = 0;

    UndoRedoBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must by larger than zero");
        }
        this.CAPACITY = capacity;
        this.currentIndex = this.CAPACITY - 1;
        this.buffer = new Object[this.CAPACITY];
    }

    private int nextIndex() {
        return (this.CAPACITY + this.currentIndex + 1) % this.CAPACITY;
    }

    private int previousIndex() {
        return (this.CAPACITY + this.currentIndex - 1) % this.CAPACITY;
    }

    public void add(T e) {
        this.elementsOnTop = 0;
        this.currentIndex = this.nextIndex();
        this.elements = Math.min(this.elements + 1, this.CAPACITY);
        this.buffer[this.currentIndex] = e;
    }

    public T rollback() {
        if (this.elements > 0) {
            T t = this.top();
            ++this.elementsOnTop;
            --this.elements;
            this.currentIndex = this.previousIndex();
            return t;
        }
        return null;
    }

    public T repeat() {
        if (this.elementsOnTop > 0) {
            --this.elementsOnTop;
            ++this.elements;
            this.currentIndex = this.nextIndex();
            return this.top();
        }
        return null;
    }

    public T top() {
        if (this.elements > 0) {
            return this.buffer[this.currentIndex];
        }
        return null;
    }

    public boolean canRepeat() {
        return this.elementsOnTop > 0;
    }

    public boolean canRollback() {
        return this.elements > 0;
    }

    public String toString() {
        return "UndoRedoBuffer{CAPACITY=" + this.CAPACITY + ", buffer=" + Arrays.toString(this.buffer) + ", currentIndex=" + this.currentIndex + ", elements=" + this.elements + ", elementsOnTop=" + this.elementsOnTop + "}";
    }

    public void print() {
        System.out.println(this);
    }
}

