/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;

public class TimedPlaceMarkingEditCommand
implements Command {
    private final int numberOfTokens;
    private final TimedPlaceComponent timedPlaceComponent;

    public TimedPlaceMarkingEditCommand(TimedPlaceComponent tpc, int numberOfTokens) {
        this.timedPlaceComponent = tpc;
        this.numberOfTokens = numberOfTokens;
    }

    @Override
    public void redo() {
        int oldNumberOfTokens = this.timedPlaceComponent.underlyingPlace().numberOfTokens();
        this.timedPlaceComponent.underlyingPlace().setNumberOfTokens(oldNumberOfTokens + this.numberOfTokens);
        if (this.numberOfTokens > 0) {
            this.timedPlaceComponent.underlyingPlace().addTokens(Math.abs(this.numberOfTokens));
        } else {
            this.timedPlaceComponent.underlyingPlace().removeTokens(Math.abs(this.numberOfTokens));
        }
        this.timedPlaceComponent.repaint();
    }

    @Override
    public void undo() {
        int oldNumberOfTokens = this.timedPlaceComponent.underlyingPlace().numberOfTokens();
        this.timedPlaceComponent.underlyingPlace().setNumberOfTokens(oldNumberOfTokens - this.numberOfTokens);
        if (this.numberOfTokens > 0) {
            this.timedPlaceComponent.underlyingPlace().removeTokens(Math.abs(this.numberOfTokens));
        } else {
            this.timedPlaceComponent.underlyingPlace().addTokens(Math.abs(this.numberOfTokens));
        }
        this.timedPlaceComponent.repaint();
    }
}

