/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.RenameTemplateVisitor;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import net.tapaal.gui.petrinet.editor.TemplateExplorer;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RenameTemplateCommand
implements Command {
    private final TemplateExplorer templateExplorer;
    private final TimedArcPetriNet tapn;
    private final String oldName;
    private final String newName;
    private final PetriNetTab tab;

    public RenameTemplateCommand(TemplateExplorer templateExplorer, PetriNetTab tab, TimedArcPetriNet tapn, String oldName, String newName) {
        this.templateExplorer = templateExplorer;
        this.tab = tab;
        this.tapn = tapn;
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void redo() {
        this.tapn.setName(this.newName);
        this.templateExplorer.repaint();
        this.updateQueries(this.oldName, this.newName);
    }

    private void updateQueries(String nameToFind, String nameToReplaceWith) {
        RenameTemplateVisitor visitor = new RenameTemplateVisitor(nameToFind, nameToReplaceWith);
        for (TAPNQuery query : this.tab.queries()) {
            query.getProperty().accept(visitor, null);
        }
    }

    @Override
    public void undo() {
        this.tapn.setName(this.oldName);
        this.templateExplorer.repaint();
        this.updateQueries(this.newName, this.oldName);
    }
}

