/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Tuple;
import java.util.Collection;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.editor.TemplateExplorer;
import net.tapaal.gui.petrinet.undo.AddTemplateCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RemoveTemplateCommand
extends AddTemplateCommand {
    private final Collection<TAPNQuery> queriesToDelete;
    private final PetriNetTab tabContent;
    private final Collection<Tuple<TimedTransition, SharedTransition>> transitionsToUnshare;

    public RemoveTemplateCommand(PetriNetTab tabContent, TemplateExplorer templateExplorer, Template template, int listIndex, Collection<TAPNQuery> queriesToDelete, Collection<Tuple<TimedTransition, SharedTransition>> transitionsToUnshare) {
        super(templateExplorer, template, listIndex);
        this.tabContent = tabContent;
        this.queriesToDelete = queriesToDelete;
        this.transitionsToUnshare = transitionsToUnshare;
    }

    @Override
    public void redo() {
        super.undo();
        for (TAPNQuery tAPNQuery : this.queriesToDelete) {
            this.tabContent.removeQuery(tAPNQuery);
        }
        for (Tuple tuple : this.transitionsToUnshare) {
            ((TimedTransition)tuple.value1()).unshare();
        }
        for (TimedPlace timedPlace : this.template.model().places()) {
            if (timedPlace.isShared()) continue;
            for (TAPNQuery q : this.tabContent.queries()) {
                q.inclusionPlaces().removePlace(timedPlace);
            }
        }
    }

    @Override
    public void undo() {
        super.redo();
        for (TAPNQuery tAPNQuery : this.queriesToDelete) {
            this.tabContent.addQuery(tAPNQuery);
        }
        for (Tuple tuple : this.transitionsToUnshare) {
            ((SharedTransition)tuple.value2()).makeShared((TimedTransition)tuple.value1());
        }
    }
}

