/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.BooleanResult;
import dk.aau.cs.TCTL.visitors.MakeTransitionSharedVisitor;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Require;
import java.util.Hashtable;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class MakeTransitionSharedCommand
implements Command {
    private final TimedArcPetriNet tapn;
    private final SharedTransition sharedTransition;
    private final TimedTransition timedTransition;
    private final String oldName;
    private final Hashtable<TAPNQuery, TAPNQuery> newQueryToOldQueryMapping;
    private final PetriNetTab currentTab;

    public MakeTransitionSharedCommand(TimedArcPetriNet tapn, SharedTransition sharedTransition, TimedTransition timedTransition, PetriNetTab currentTab) {
        Require.that(tapn != null, "tapn cannot be null");
        Require.that(sharedTransition != null, "sharedTransition cannot be null");
        Require.that(timedTransition != null, "timedTransition cannot be null");
        Require.that(currentTab != null, "currentTab cannot be null");
        this.tapn = tapn;
        this.sharedTransition = sharedTransition;
        this.timedTransition = timedTransition;
        this.currentTab = currentTab;
        this.oldName = timedTransition.name();
        this.newQueryToOldQueryMapping = new Hashtable();
    }

    @Override
    public void redo() {
        this.updateQueries(this.timedTransition, this.sharedTransition);
        this.sharedTransition.makeShared(this.timedTransition);
    }

    @Override
    public void undo() {
        this.undoQueryChanges(this.sharedTransition, this.timedTransition);
        this.timedTransition.unshare();
        this.timedTransition.setName(this.oldName);
    }

    private void updateQueries(TimedTransition toReplace, SharedTransition replacement) {
        MakeTransitionSharedVisitor visitor = new MakeTransitionSharedVisitor(this.tapn.name(), toReplace.name(), "", replacement.name());
        for (TAPNQuery query : this.currentTab.queries()) {
            TAPNQuery oldCopy = query.copy();
            BooleanResult isQueryAffected = new BooleanResult(false);
            query.getProperty().accept(visitor, isQueryAffected);
            if (!isQueryAffected.result()) continue;
            this.newQueryToOldQueryMapping.put(query, oldCopy);
        }
    }

    private void undoQueryChanges(SharedTransition toReplace, TimedTransition replacement) {
        for (TAPNQuery query : this.currentTab.queries()) {
            if (!this.newQueryToOldQueryMapping.containsKey(query)) continue;
            query.set(this.newQueryToOldQueryMapping.get(query));
        }
        this.newQueryToOldQueryMapping.clear();
    }
}

