/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.util.Require;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.MakeTransitionNewSharedCommand;
import net.tapaal.gui.petrinet.undo.MakeTransitionSharedCommand;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;

public class MakeTransitionNewSharedMultiCommand
implements Command {
    private final String newSharedName;
    private final Context context;
    private final Transition transition;
    private Command command;
    private final List<Command> commands = new ArrayList<Command>();

    public MakeTransitionNewSharedMultiCommand(Context context, String newSharedName, TimedTransitionComponent transition) {
        Require.that(context.network().allTemplates() != null, "tapns cannot be null");
        Require.that(newSharedName != null, "newSharedName cannot be null");
        Require.that(context.tabContent() != null, "currentTab cannot be null");
        this.transition = transition;
        this.context = context;
        this.newSharedName = newSharedName;
    }

    @Override
    public void redo() {
        this.commands.clear();
        SharedTransition sharedTransition = null;
        boolean first = true;
        for (Template template : this.context.tabContent().allTemplates()) {
            TimedTransitionComponent component = (TimedTransitionComponent)template.guiModel().getTransitionByName(this.transition.getName());
            if (component == null) continue;
            if (first) {
                this.command = new MakeTransitionNewSharedCommand(template.model(), this.newSharedName, component.underlyingTransition(), this.context.tabContent(), true);
                this.command.redo();
                sharedTransition = component.underlyingTransition().sharedTransition();
                this.commands.add(this.command);
                first = false;
                continue;
            }
            this.command = new MakeTransitionSharedCommand(this.context.activeModel(), sharedTransition, component.underlyingTransition(), this.context.tabContent());
            this.command.redo();
            this.commands.add(this.command);
        }
    }

    @Override
    public void undo() {
        for (Command command : this.commands) {
            command.undo();
        }
    }
}

