/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.util.Require;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.MakePlaceNewSharedCommand;
import net.tapaal.gui.petrinet.undo.MakePlaceSharedCommand;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;

public class MakePlaceNewSharedMultiCommand
implements Command {
    private final String newSharedName;
    private final Context context;
    private final Place place;
    private Command command;
    private final List<Command> commands = new ArrayList<Command>();

    public MakePlaceNewSharedMultiCommand(Context context, String newSharedName, TimedPlaceComponent place) {
        Require.that(context.network().allTemplates() != null, "tapns cannot be null");
        Require.that(newSharedName != null, "newSharedName cannot be null");
        Require.that(context.tabContent() != null, "currentTab cannot be null");
        this.place = place;
        this.context = context;
        this.newSharedName = newSharedName;
    }

    @Override
    public void redo() {
        this.commands.clear();
        SharedPlace sharedPlace = null;
        boolean first = true;
        for (Template template : this.context.tabContent().allTemplates()) {
            TimedPlaceComponent component = (TimedPlaceComponent)template.guiModel().getPlaceByName(this.place.getName());
            if (component == null) continue;
            if (first) {
                this.command = new MakePlaceNewSharedCommand(template.model(), this.newSharedName, component.underlyingPlace(), component, this.context.tabContent(), true);
                this.command.redo();
                sharedPlace = (SharedPlace)component.underlyingPlace();
                this.commands.add(this.command);
                first = false;
                continue;
            }
            this.command = new MakePlaceSharedCommand(this.context.activeModel(), sharedPlace, component.underlyingPlace(), component, this.context.tabContent(), true);
            this.command.redo();
            this.commands.add(this.command);
        }
    }

    @Override
    public void undo() {
        for (Command command : this.commands) {
            command.undo();
        }
    }
}

