/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo.Colored;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import java.util.ArrayList;
import java.util.Vector;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.Command;

public class UpdateColorTypeCommand
implements Command {
    private final TimedArcPetriNetNetwork network;
    private final ColorType oldColorType;
    private final ColorType newColorType;
    private final Integer index;
    private final ConstantsPane.ColorTypesListModel colorTypesListModel;

    public UpdateColorTypeCommand(TimedArcPetriNetNetwork network, ColorType oldColorType, ColorType newColorType, Integer index, ConstantsPane.ColorTypesListModel colorTypesListModel) {
        this.network = network;
        this.oldColorType = oldColorType;
        this.newColorType = newColorType;
        this.index = index;
        this.colorTypesListModel = colorTypesListModel;
    }

    @Override
    public void undo() {
        this.performUpdate(this.oldColorType, this.newColorType);
        this.network.colorTypes().set(this.index, this.oldColorType);
        this.colorTypesListModel.updateName();
    }

    @Override
    public void redo() {
        this.network.colorTypes().set(this.index, this.newColorType);
        this.performUpdate(this.newColorType, this.oldColorType);
        this.colorTypesListModel.updateName();
    }

    private void performUpdate(ColorType targetType, ColorType sourceType) {
        ArrayList<ProductType> modifiedProductTypes = new ArrayList<ProductType>();
        for (ColorType ct : this.network.colorTypes()) {
            ProductType pt;
            if (!ct.isProductColorType() || !(pt = (ProductType)ct).contains(sourceType)) continue;
            pt.replaceColorType(targetType, sourceType);
            modifiedProductTypes.add(pt);
        }
        for (TimedArcPetriNet tapn : this.network.allTemplates()) {
            for (TimedPlace timedPlace : tapn.places()) {
                ArrayList<TimedToken> oldTokens;
                boolean isModifiedProductType;
                boolean bl = isModifiedProductType = timedPlace.getColorType().isProductColorType() && modifiedProductTypes.contains((ProductType)timedPlace.getColorType());
                if (timedPlace.getColorType().equals(sourceType)) {
                    if (timedPlace.getTokensAsExpression() != null) {
                        timedPlace.setTokenExpression(timedPlace.getTokensAsExpression().getExprConverted(sourceType, targetType));
                    }
                    oldTokens = new ArrayList<TimedToken>(timedPlace.tokens());
                    timedPlace.setColorType(targetType);
                    for (TimedToken token : oldTokens) {
                        if (!targetType.contains(token.getColor())) continue;
                        timedPlace.addToken(new TimedToken(timedPlace, token.age(), targetType.getColorByName(token.getColor().getName())));
                    }
                    continue;
                }
                if (!isModifiedProductType) continue;
                if (timedPlace.getTokensAsExpression() != null) {
                    timedPlace.setTokenExpression(timedPlace.getTokensAsExpression().getExprConverted(sourceType, targetType));
                }
                oldTokens = new ArrayList<TimedToken>(timedPlace.tokens());
                ArrayList<TimedToken> newTokens = new ArrayList<TimedToken>();
                for (TimedToken token : oldTokens) {
                    Color oldColor = token.getColor();
                    Color newColor = this.updateColorRecursive(oldColor, sourceType, targetType);
                    newTokens.add(new TimedToken(timedPlace, token.age(), newColor));
                }
                timedPlace.updateTokens(newTokens, timedPlace.getTokensAsExpression());
            }
            for (TimedInputArc timedInputArc : tapn.inputArcs()) {
                if (timedInputArc.getArcExpression() == null) continue;
                timedInputArc.setExpression(timedInputArc.getArcExpression().getExprConverted(sourceType, targetType));
            }
            for (TimedOutputArc timedOutputArc : tapn.outputArcs()) {
                if (timedOutputArc.getExpression() == null) continue;
                timedOutputArc.setExpression(timedOutputArc.getExpression().getExprConverted(sourceType, targetType));
            }
            for (TimedTransition timedTransition : tapn.transitions()) {
                if (timedTransition.getGuard() == null) continue;
                Expression newGuardExpr = this.updateExpressionRecursively(timedTransition.getGuard(), sourceType, targetType);
                if (newGuardExpr instanceof GuardExpression) {
                    timedTransition.setGuard((GuardExpression)newGuardExpr);
                }
                timedTransition.getGuard().setColorType(targetType);
            }
        }
        this.eval(targetType);
        for (Variable var : this.network.variables()) {
            if (!var.getColorType().equals(sourceType)) continue;
            var.setColorType(targetType);
        }
    }

    private Color updateColorRecursive(Color color, ColorType sourceType, ColorType targetType) {
        if (color == null) {
            return null;
        }
        if (color.getColorType().equals(sourceType) && targetType.contains(color)) {
            return targetType.getColorByName(color.getName());
        }
        if (color.getTuple() != null) {
            Vector<Color> newTuple = new Vector<Color>();
            boolean changed = false;
            for (Color c : color.getTuple()) {
                Color newC = this.updateColorRecursive(c, sourceType, targetType);
                newTuple.add(newC);
                if (newC == c) continue;
                changed = true;
            }
            if (changed) {
                return new Color(color.getColorType(), color.getId(), newTuple);
            }
        }
        return color;
    }

    private Expression updateExpressionRecursively(Expression expr, ColorType oldCt, ColorType newCt) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof UserOperatorExpression) {
            UserOperatorExpression uoe = (UserOperatorExpression)expr;
            if (uoe.getUserOperator().getColorType().getName().equals(oldCt.getName())) {
                return uoe.getExprWithNewColorType(newCt);
            }
            return expr;
        }
        Expression result = expr;
        for (ExprStringPosition pos : expr.getChildren()) {
            Expression child = pos.getObject();
            Expression updatedChild = this.updateExpressionRecursively(child, oldCt, newCt);
            if (updatedChild == child) continue;
            result = result.replace(child, updatedChild);
        }
        return result;
    }

    private void eval(ColorType colorType) {
        for (TimedArcPetriNet tapn : this.network.allTemplates()) {
            for (TimedPlace place : tapn.places()) {
                ColorMultiset cm;
                ArcExpression expression = place.getExprWithNewColorType(colorType);
                if (expression != place.getTokensAsExpression() && (cm = expression.eval(this.network.getContext())) != null) {
                    ArrayList<TimedToken> tokensToAdd = new ArrayList<TimedToken>(place.tokens());
                    for (TimedToken token : cm.getTokens(place)) {
                        tapn.marking().remove(token);
                    }
                    place.updateTokens(tokensToAdd, expression);
                }
                ArrayList<ColoredTimeInvariant> invariantsToAdd = new ArrayList<ColoredTimeInvariant>();
                for (ColoredTimeInvariant invariant : place.getCtiList()) {
                    if (colorType.contains(invariant.getColor())) {
                        invariantsToAdd.add(new ColoredTimeInvariant(invariant.isUpperNonstrict(), invariant.upperBound(), colorType.getColorByName(invariant.getColor().getColorName())));
                        continue;
                    }
                    invariantsToAdd.add(invariant);
                }
                place.setCtiList(invariantsToAdd);
                if (!place.getColorType().getName().equals(colorType.getName())) continue;
                place.setColorType(colorType);
            }
        }
    }
}

