/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo.Colored;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.TimedToken;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;

public class ColoredPlaceMarkingEditCommand
implements Command {
    private final ArrayList<TimedToken> tokenList;
    private final ArrayList<TimedToken> newTokenList;
    private final Context context;
    private final TimedPlaceComponent place;
    private final List<ColoredTimeInvariant> ctiList;
    private final ColorType colorType;
    private final ColorType oldColorType;
    private final List<ColoredTimeInvariant> oldCtiList;
    private final ArcExpression oldExpression;
    private final ArcExpression newExpression;
    private final int oldTokenCount;
    private final int newTokenCount;

    public ColoredPlaceMarkingEditCommand(ArrayList<TimedToken> tokenList, ArrayList<TimedToken> newTokenList, ArcExpression oldExpression, ArcExpression newExpression, Context context, TimedPlaceComponent place, List<ColoredTimeInvariant> ctiList, ColorType colorType1, int oldTokenCount, int newTokenCount) {
        this.tokenList = tokenList;
        this.newTokenList = newTokenList;
        this.context = context;
        this.place = place;
        this.ctiList = ctiList;
        this.colorType = colorType1;
        this.oldExpression = oldExpression;
        this.newExpression = newExpression;
        this.oldColorType = place.underlyingPlace().getColorType();
        this.oldCtiList = place.underlyingPlace().getCtiList();
        this.oldTokenCount = oldTokenCount;
        this.newTokenCount = newTokenCount;
    }

    @Override
    public void undo() {
        for (TimedToken token : this.newTokenList) {
            this.context.activeModel().marking().remove(token);
        }
        this.place.underlyingPlace().setColorType(this.oldColorType);
        this.place.underlyingPlace().setCtiList(this.oldCtiList);
        this.place.underlyingPlace().updateTokens(this.tokenList, this.oldExpression);
        this.place.underlyingPlace().setNumberOfTokens(this.oldTokenCount);
        this.place.update(true);
        this.place.repaint();
    }

    @Override
    public void redo() {
        for (TimedToken token : this.tokenList) {
            this.context.activeModel().marking().remove(token);
        }
        this.place.underlyingPlace().setCtiList(this.ctiList);
        this.place.underlyingPlace().setColorType(this.colorType);
        this.place.underlyingPlace().updateTokens(this.newTokenList, this.newExpression);
        this.place.underlyingPlace().setNumberOfTokens(this.newTokenCount);
        this.place.update(true);
        this.place.repaint();
    }
}

