/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import java.util.Map;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;

public class ChangeAllNamesVisibilityCommand
implements Command {
    private final Map<PetriNetObject, Boolean> places;
    private final Map<PetriNetObject, Boolean> transitions;
    private final boolean isVisible;
    private final PetriNetTab tabContent;

    public ChangeAllNamesVisibilityCommand(PetriNetTab tabContent, Map<PetriNetObject, Boolean> places, Map<PetriNetObject, Boolean> transitions, boolean isVisible) {
        this.tabContent = tabContent;
        this.places = places;
        this.transitions = transitions;
        this.isVisible = isVisible;
    }

    @Override
    public void redo() {
        PlaceTransitionObject component;
        if (this.places != null) {
            for (PetriNetObject place : this.places.keySet()) {
                if (!(place instanceof TimedPlaceComponent)) continue;
                component = (TimedPlaceComponent)place;
                component.setAttributesVisible(this.isVisible);
                ((Place)component).update(true);
                this.tabContent.repaint();
            }
        }
        if (this.transitions != null) {
            for (PetriNetObject transition : this.transitions.keySet()) {
                if (!(transition instanceof TimedTransitionComponent)) continue;
                component = (TimedTransitionComponent)transition;
                component.setAttributesVisible(this.isVisible);
                ((TimedTransitionComponent)component).update(true);
                this.tabContent.repaint();
            }
        }
    }

    @Override
    public void undo() {
        PlaceTransitionObject component;
        if (this.places != null) {
            for (PetriNetObject place : this.places.keySet()) {
                if (!(place instanceof TimedPlaceComponent)) continue;
                component = (TimedPlaceComponent)place;
                component.setAttributesVisible(this.places.get(component));
                ((Place)component).update(true);
                this.tabContent.repaint();
            }
        }
        if (this.transitions != null) {
            for (PetriNetObject transition : this.transitions.keySet()) {
                if (!(transition instanceof TimedTransitionComponent)) continue;
                component = (TimedTransitionComponent)transition;
                component.setAttributesVisible(this.transitions.get(component));
                ((TimedTransitionComponent)component).update(true);
                this.tabContent.repaint();
            }
        }
    }
}

