/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.smartdraw;

import dk.aau.cs.util.Require;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.SwingWorker;
import net.tapaal.gui.petrinet.smartdraw.Quadtree;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawListener;
import net.tapaal.gui.petrinet.undo.MovePetriNetObjectCommand;
import net.tapaal.gui.petrinet.undo.UpdateNameLabelOffsetCommand;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.undo.DeleteArcPathPointEditCommand;
import pipe.gui.petrinet.undo.TransitionRotationEditCommand;
import pipe.gui.petrinet.undo.UndoManager;

public class SmartDrawWorker
extends SwingWorker<Void, Void> {
    final List<SmartDrawListener> listeners = new ArrayList<SmartDrawListener>();
    PlaceTransitionObject startingObject;
    final int xSpacing;
    final int ySpacing;
    final DrawingSurfaceImpl drawingSurface;
    final DataLayer model;
    final String searchOption;
    final int halfDimension = 10000;
    final int range = 45;
    Point rootPoint;
    Point rightMostPointUsed = new Point(0, 0);
    ArrayList<PlaceTransitionObject> objectsPlaced = new ArrayList();
    ArrayList<PlaceTransitionObject> placeTransitionObjects = new ArrayList();
    final Quadtree pointsReserved = new Quadtree();
    final UndoManager undoManager;
    final int diagonalWeight;
    final int straightWeight;
    final int distanceWeight;
    final int overlappingArcWeight;
    final int minimumIterations;
    final ArrayList<PlaceTransitionObject> newlyPlacedObjects = new ArrayList();
    ArrayList<PlaceTransitionObject> unfinishedObjects = new ArrayList();
    ArrayList<Arc> arcsVisited = new ArrayList();

    public SmartDrawWorker(DrawingSurfaceImpl drawingSurface, DataLayer model, UndoManager undoManager, int xSpacing, int ySpacing, String searchOption, int straightWeight, int diagonalWeight, int distanceWeight, int overlappingArcWeight, String startingObject, int minimumIterations) {
        this.drawingSurface = drawingSurface;
        this.model = model;
        this.undoManager = undoManager;
        this.xSpacing = xSpacing;
        this.ySpacing = ySpacing;
        this.searchOption = searchOption;
        this.straightWeight = straightWeight;
        this.diagonalWeight = diagonalWeight;
        this.distanceWeight = distanceWeight;
        this.overlappingArcWeight = overlappingArcWeight;
        this.minimumIterations = minimumIterations;
        this.getPlaceTransitionObjects();
        this.processStartingObject(startingObject);
    }

    private void processStartingObject(String startingObject) {
        if (!startingObject.equals("Random")) {
            this.startingObject = this.model.getPlaceTransitionObjectByName(startingObject);
        } else {
            try {
                this.startingObject = this.placeTransitionObjects.get(new Random().nextInt(this.placeTransitionObjects.size() - 1));
            }
            catch (IllegalArgumentException e) {
                this.startingObject = this.placeTransitionObjects.get(0);
            }
        }
    }

    @Override
    public Void doInBackground() throws Exception {
        this.undoManager.newEdit();
        this.arcsVisited = new ArrayList();
        this.objectsPlaced = new ArrayList();
        this.fireStartDraw();
        while (!this.objectsPlaced.containsAll(this.placeTransitionObjects)) {
            if (this.objectsPlaced.isEmpty()) {
                this.rootPoint = new Point(500, 350);
            } else {
                for (PlaceTransitionObject object : this.placeTransitionObjects) {
                    if (this.objectsPlaced.contains(object)) continue;
                    this.startingObject = object;
                    break;
                }
                this.rootPoint = new Point(this.rightMostPointUsed.x + 500, 350);
            }
            this.moveObject(this.startingObject, this.rootPoint);
            this.rightMostPointUsed = this.rootPoint;
            this.reservePoint(this.rootPoint);
            this.objectsPlaced.add(this.startingObject);
            if (this.searchOption.equals("DFS")) {
                this.unfinishedObjects = new ArrayList();
                this.unfinishedObjects.add(this.startingObject);
                while (!this.unfinishedObjects.isEmpty()) {
                    PlaceTransitionObject nextObject = this.unfinishedObjects.get(this.unfinishedObjects.size() - 1);
                    this.depthFirstDraw(nextObject);
                }
                continue;
            }
            this.newlyPlacedObjects.add(this.startingObject);
            while (!this.newlyPlacedObjects.isEmpty()) {
                PlaceTransitionObject newParent = this.newlyPlacedObjects.get(0);
                this.breadthFirstDraw(newParent);
            }
        }
        this.moveObjectsWithinScreenEdge();
        this.removeArcPathPoints();
        this.resetLabelsToDefault();
        return null;
    }

    private void depthFirstDraw(PlaceTransitionObject parentObject) {
        ArrayList<Arc> arcsForObject = this.getAllArcsFromObject(parentObject);
        boolean objectPlaced = false;
        Point parentPoint = new Point(parentObject.getOriginalX(), parentObject.getOriginalY());
        block0: for (Arc arc : arcsForObject) {
            if (this.arcsVisited.contains(arc)) continue;
            this.arcsVisited.add(arc);
            PlaceTransitionObject objectToPlace = arc.getTarget() != parentObject ? arc.getTarget() : arc.getSource();
            if (this.objectsPlaced.contains(objectToPlace)) continue;
            objectPlaced = false;
            int smallestWeight = Integer.MAX_VALUE;
            Point bestPoint = null;
            int layer = 0;
            while (!objectPlaced) {
                for (int x = parentPoint.x - this.xSpacing * ++layer; x <= parentPoint.x + this.xSpacing * layer; x += this.xSpacing) {
                    for (int y = parentPoint.y - this.ySpacing * layer; y <= parentPoint.y + this.ySpacing * layer; y += this.ySpacing) {
                        int weight;
                        Point possiblePoint = new Point(x, y);
                        if (this.pointsReserved.containsWithin(possiblePoint, 45) || (weight = this.calculateWeight(possiblePoint, layer, this.getObjectPositionAsPoint(parentObject), objectToPlace)) >= smallestWeight) continue;
                        smallestWeight = weight;
                        bestPoint = possiblePoint;
                    }
                }
                if (layer < this.minimumIterations || bestPoint == null) continue;
                this.fireStatusChanged(this.objectsPlaced.size());
                this.moveObject(objectToPlace, bestPoint);
                this.checkIfObjectIsNowRightmost(bestPoint);
                this.reservePoint(bestPoint);
                this.unfinishedObjects.add(objectToPlace);
                this.objectsPlaced.add(objectToPlace);
                objectPlaced = true;
                break block0;
            }
        }
        if (this.arcsVisited.containsAll(arcsForObject)) {
            this.unfinishedObjects.remove(parentObject);
        }
    }

    private ArrayList<Arc> getAllArcsFromObject(PlaceTransitionObject pno) {
        ArrayList<Arc> arcsForObject = new ArrayList<Arc>();
        for (Arc a : pno.getPreset()) {
            arcsForObject.add(a);
        }
        for (Arc a : pno.getPostset()) {
            arcsForObject.add(a);
        }
        return arcsForObject;
    }

    private void moveObject(PlaceTransitionObject object, Point point) {
        MovePetriNetObjectCommand command = new MovePetriNetObjectCommand(object, point, this.drawingSurface);
        this.undoManager.addEdit(command);
        command.redo();
    }

    private void reservePoint(Point point) {
        this.pointsReserved.insert(point);
    }

    private void breadthFirstDraw(PlaceTransitionObject parentObject) {
        ArrayList<Arc> arcsForObject = this.getAllArcsFromObject(parentObject);
        boolean objectPlaced = false;
        Point parentPoint = new Point(parentObject.getOriginalX(), parentObject.getOriginalY());
        for (Arc arc : arcsForObject) {
            PlaceTransitionObject objectToPlace = arc.getTarget() != parentObject ? arc.getTarget() : arc.getSource();
            this.arcsVisited.add(arc);
            if (this.objectsPlaced.contains(objectToPlace)) continue;
            objectPlaced = false;
            int smallestWeight = Integer.MAX_VALUE;
            Point bestPoint = null;
            int layer = 0;
            while (!objectPlaced) {
                for (int x = parentPoint.x - this.xSpacing * ++layer; x <= parentPoint.x + this.xSpacing * layer; x += this.xSpacing) {
                    for (int y = parentPoint.y - this.ySpacing * layer; y <= parentPoint.y + this.ySpacing * layer; y += this.ySpacing) {
                        int weight;
                        Point possiblePoint = new Point(x, y);
                        if (this.pointsReserved.containsWithin(possiblePoint, 45) || (weight = this.calculateWeight(possiblePoint, layer, this.getObjectPositionAsPoint(parentObject), objectToPlace)) >= smallestWeight) continue;
                        smallestWeight = weight;
                        bestPoint = possiblePoint;
                    }
                }
                if (layer < this.minimumIterations || bestPoint == null) continue;
                this.fireStatusChanged(this.objectsPlaced.size());
                this.moveObject(objectToPlace, bestPoint);
                this.checkIfObjectIsNowRightmost(bestPoint);
                this.reservePoint(bestPoint);
                this.newlyPlacedObjects.add(objectToPlace);
                this.objectsPlaced.add(objectToPlace);
                objectPlaced = true;
            }
        }
        this.newlyPlacedObjects.remove(parentObject);
    }

    private int calculateWeight(Point candidatePoint, int layer, Point parentPoint, PlaceTransitionObject objectToPlace) {
        int weight = 0;
        weight = candidatePoint.x == parentPoint.x || candidatePoint.y == parentPoint.y ? (weight += this.straightWeight * layer) : (weight += this.diagonalWeight * layer);
        weight += this.distanceWeight * ((Math.abs(candidatePoint.x - this.rootPoint.x) + Math.abs(candidatePoint.y - this.rootPoint.y)) / 1000);
        return weight += this.calculateNumberOfOverlappingArcs(candidatePoint, objectToPlace) * this.overlappingArcWeight;
    }

    private int calculateNumberOfOverlappingArcs(Point candidatePoint, PlaceTransitionObject objectToPlace) {
        int number = 0;
        for (PlaceTransitionObject object : this.objectsPlaced) {
            for (Arc placedArc : this.getAllArcsFromObject(object)) {
                Arc arc;
                Point source = this.getObjectPositionAsPoint(placedArc.getSource());
                Point target = this.getObjectPositionAsPoint(placedArc.getTarget());
                double distanceTargetSource = Point.distance(source.x, source.y, target.x, target.y);
                double distanceTargetPoint = Point.distance(candidatePoint.x, candidatePoint.y, target.x, target.y);
                double distancePointSource = Point.distance(candidatePoint.x, candidatePoint.y, source.x, source.y);
                if (distancePointSource + distanceTargetPoint == distanceTargetSource) {
                    ++number;
                    continue;
                }
                if (distancePointSource + distanceTargetSource == distanceTargetPoint) {
                    for (PetriNetObject pNetObject : this.model.getPNObjects()) {
                        if (!(pNetObject instanceof Arc) || ((arc = (Arc)pNetObject).getSource() != objectToPlace || arc.getTarget() != placedArc.getTarget()) && (arc.getTarget() != objectToPlace || arc.getSource() != placedArc.getTarget())) continue;
                        ++number;
                    }
                    continue;
                }
                if (distanceTargetSource + distanceTargetPoint != distancePointSource) continue;
                for (PetriNetObject pNetObject : this.model.getPNObjects()) {
                    if (!(pNetObject instanceof Arc) || ((arc = (Arc)pNetObject).getSource() != objectToPlace || arc.getTarget() != placedArc.getSource()) && (arc.getTarget() != objectToPlace || arc.getSource() != placedArc.getSource())) continue;
                    ++number;
                }
            }
        }
        return number;
    }

    public Point getObjectPositionAsPoint(PlaceTransitionObject object) {
        return new Point(object.getOriginalX(), object.getOriginalY());
    }

    private void checkIfObjectIsNowRightmost(Point newPoint) {
        if (newPoint.x > this.rightMostPointUsed.x) {
            this.rightMostPointUsed = newPoint;
        }
    }

    private void moveObjectsWithinScreenEdge() {
        Point newPosition;
        int lowestY = 50;
        int lowestX = 50;
        for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
            if (ptObject.getOriginalX() < lowestX) {
                lowestX = ptObject.getOriginalX();
            }
            if (ptObject.getOriginalY() >= lowestY) continue;
            lowestY = ptObject.getOriginalY();
        }
        if (lowestX < 50) {
            for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
                int newX = ptObject.getOriginalX() + Math.abs(lowestX) + 50;
                newPosition = new Point(newX, ptObject.getOriginalY());
                this.moveObject(ptObject, newPosition);
            }
        }
        if (lowestY < 50) {
            for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
                int newY = ptObject.getOriginalY() + Math.abs(lowestY) + 50;
                newPosition = new Point(ptObject.getOriginalX(), newY);
                this.moveObject(ptObject, newPosition);
            }
        }
    }

    private void removeArcPathPoints() {
        ArrayList<ArcPathPoint> toRemove = new ArrayList<ArcPathPoint>();
        for (PetriNetObject object : this.model.getPNObjects()) {
            ArcPathPoint arcPathPoint;
            if (!(object instanceof ArcPathPoint) || (arcPathPoint = (ArcPathPoint)object).isEndPoint()) continue;
            toRemove.add(arcPathPoint);
        }
        for (ArcPathPoint p : toRemove) {
            DeleteArcPathPointEditCommand command = new DeleteArcPathPointEditCommand(p.getArcPath().getArc(), p, p.getIndex(), this.model);
            command.redo();
            this.undoManager.addEdit(command);
        }
    }

    public void setTransitionsToUpright() {
        for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
            if (!(ptObject instanceof Transition)) continue;
            Transition transition = (Transition)ptObject;
            int newAngle = -transition.getAngle();
            TransitionRotationEditCommand command = new TransitionRotationEditCommand(transition, newAngle);
            command.redo();
            this.undoManager.addEdit(command);
        }
    }

    public void doOffsetForLoops() {
        for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
            if (!(ptObject instanceof Place)) continue;
            Place place = (Place)ptObject;
            for (Arc arcOne : place.getPostset()) {
                Transition transition = (Transition)arcOne.getTarget();
                for (Arc arcTwo : transition.getPostset()) {
                    if (arcTwo.getTarget() != place) continue;
                    this.offsetArcPointsFromMiddlepoint(arcOne, arcTwo, place, transition);
                }
            }
        }
    }

    private double unzoom(double pos) {
        return Zoomer.getUnzoomedValue(pos, this.drawingSurface.getZoom());
    }

    private double zoom(double pos) {
        return Zoomer.getZoomedValue(pos, this.drawingSurface.getZoom());
    }

    private void offsetArcPointsFromMiddlepoint(Arc arcOne, Arc arcTwo, Place place, Transition transition) {
        Point2D.Double pointForArcTwo;
        Point2D.Double pointForArcOne;
        if (transition.getOriginalX() == place.getOriginalX()) {
            pointForArcOne = new Point2D.Double(this.unzoom(arcOne.getArcPath().midPoint.x) + 30.0, this.unzoom(arcOne.getArcPath().midPoint.y));
            pointForArcTwo = new Point2D.Double(this.unzoom(arcTwo.getArcPath().midPoint.x) - 30.0, this.unzoom(arcTwo.getArcPath().midPoint.y));
        } else if (transition.getOriginalY() == place.getOriginalY()) {
            pointForArcOne = new Point2D.Double(this.unzoom(arcOne.getArcPath().midPoint.x), this.unzoom(arcOne.getArcPath().midPoint.y) + 30.0);
            pointForArcTwo = new Point2D.Double(this.unzoom(arcTwo.getArcPath().midPoint.x), this.unzoom(arcTwo.getArcPath().midPoint.y) - 30.0);
        } else {
            pointForArcOne = new Point2D.Double(this.unzoom(arcOne.getArcPath().midPoint.x) + 15.0, this.unzoom(arcOne.getArcPath().midPoint.y) + 15.0);
            pointForArcTwo = new Point2D.Double(this.unzoom(arcTwo.getArcPath().midPoint.x) - 15.0, this.unzoom(arcTwo.getArcPath().midPoint.y) - 15.0);
        }
        this.undoManager.addEdit(arcOne.getArcPath().insertPoint(pointForArcOne, false));
        this.undoManager.addEdit(arcTwo.getArcPath().insertPoint(pointForArcTwo, false));
    }

    private void getPlaceTransitionObjects() {
        this.placeTransitionObjects = new ArrayList();
        for (PetriNetObject object : this.model.getPlaceTransitionObjects()) {
            if (!(object instanceof PlaceTransitionObject)) continue;
            PlaceTransitionObject ptObject = (PlaceTransitionObject)object;
            this.placeTransitionObjects.add(ptObject);
        }
    }

    public void resetLabelsToDefault() {
        for (PetriNetObject pNetObject : this.model.getPNObjects()) {
            UpdateNameLabelOffsetCommand cmd;
            if (pNetObject instanceof PlaceTransitionObject) {
                cmd = new UpdateNameLabelOffsetCommand((int)this.zoom(-5.0), (int)this.zoom(35.0), ((PlaceTransitionObject)pNetObject).getNameOffsetX(), ((PlaceTransitionObject)pNetObject).getNameOffsetY(), (PetriNetObjectWithLabel)pNetObject);
                cmd.redo();
                this.undoManager.addEdit(cmd);
                continue;
            }
            if (!(pNetObject instanceof Arc)) continue;
            cmd = new UpdateNameLabelOffsetCommand(0, 0, ((Arc)pNetObject).getNameOffsetX(), ((Arc)pNetObject).getNameOffsetY(), (PetriNetObjectWithLabel)pNetObject);
            cmd.redo();
            this.undoManager.addEdit(cmd);
        }
    }

    public void addSmartDrawListener(SmartDrawListener listener) {
        Require.that(listener != null, "Listener cannot be null");
        this.listeners.add(listener);
    }

    public void removeSmartDrawListener(SmartDrawListener listener) {
        Require.that(listener != null, "Listener cannot be null");
        this.listeners.remove(listener);
    }

    void fireStatusChanged(int objectsPlaced) {
        for (SmartDrawListener listener : this.listeners) {
            listener.fireStatusChanged(objectsPlaced);
        }
    }

    void fireStartDraw() {
        for (SmartDrawListener listener : this.listeners) {
            listener.fireStartDraw();
        }
    }

    void fireDone(boolean cancelled) {
        for (SmartDrawListener listener : this.listeners) {
            listener.fireDone(cancelled);
        }
    }

    @Override
    protected void done() {
        if (this.objectsPlaced.size() == this.model.getPlaceTransitionObjects().size()) {
            this.setTransitionsToUpright();
            this.doOffsetForLoops();
            this.model.repaintAll(true);
            this.drawingSurface.updatePreferredSize();
            this.fireDone(false);
        } else {
            this.fireDone(true);
        }
    }

    private void printPTObjectsAndPositions() {
        for (PlaceTransitionObject ptObject : this.placeTransitionObjects) {
            System.out.println("Name: " + ptObject.getName() + " X: " + ptObject.getOriginalX() + " Y: " + ptObject.getOriginalY());
        }
    }
}

