/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.model;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.Require;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.tapaal.gui.petrinet.model.ModelViolation;
import net.tapaal.gui.petrinet.model.RequirementChecker;
import net.tapaal.gui.petrinet.model.Result;
import net.tapaal.gui.petrinet.undo.AddTimedInhibitorArcCommand;
import net.tapaal.gui.petrinet.undo.AddTimedInputArcCommand;
import net.tapaal.gui.petrinet.undo.AddTimedOutputArcCommand;
import net.tapaal.gui.petrinet.undo.AddTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.AddTimedTransitionCommand;
import net.tapaal.gui.petrinet.undo.AddTransportArcCommand;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.DeleteQueriesCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedInhibitorArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedInputArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedOutputArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedTransitionCommand;
import net.tapaal.gui.petrinet.undo.DeleteTransportArcCommand;
import net.tapaal.gui.petrinet.undo.TimedPlaceMarkingEditCommand;
import net.tapaal.gui.petrinet.undo.ToggleTransitionUncontrollableCommand;
import net.tapaal.gui.petrinet.undo.ToggleTransitionUrgentCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.jetbrains.annotations.NotNull;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPath;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.petrinet.undo.AddAnnotationNoteCommand;
import pipe.gui.petrinet.undo.CompundCommand;
import pipe.gui.petrinet.undo.DeleteAnnotationNoteCommand;
import pipe.gui.petrinet.undo.DeleteArcPathPointEditCommand;

public class GuiModelManager {
    private final PetriNetTab tabContent;
    private List<Command> pendingEdits = null;

    public void startTransaction() {
        if (this.pendingEdits != null) {
            throw new RuntimeException("Transaction already in progress");
        }
        this.pendingEdits = new ArrayList<Command>();
    }

    public void commit() {
        if (this.pendingEdits != null && this.pendingEdits.size() > 0) {
            this.tabContent.getUndoManager().addNewEdit(new CompundCommand(this.pendingEdits));
            this.pendingEdits = null;
        }
    }

    public void abort() {
        this.pendingEdits = null;
    }

    private void addCommand(Command c) {
        if (this.pendingEdits == null) {
            this.tabContent.getUndoManager().addNewEdit(c);
        } else {
            this.pendingEdits.add(c);
        }
    }

    public GuiModelManager(PetriNetTab tabContent) {
        this.tabContent = tabContent;
    }

    public Result<TimedPlaceComponent, ModelViolation> addNewTimedPlace(DataLayer c, Point p) {
        Require.notNull((Object)c, "datalyer can't be null");
        Require.notNull((Object)p, "Point can't be null");
        LocalTimedPlace tp = new LocalTimedPlace(this.tabContent.getNameGenerator().getNewPlaceName(this.tabContent.guiModelToModel.get(c)), ColorType.COLORTYPE_DOT);
        TimedPlaceComponent pnObject = new TimedPlaceComponent(p.x, p.y, tp, this.tabContent.lens);
        this.tabContent.guiModelToModel.get(c).add(tp);
        c.addPetriNetObject(pnObject);
        this.addCommand(new AddTimedPlaceCommand(pnObject, this.tabContent.guiModelToModel.get(c), c));
        return new Result<TimedPlaceComponent, ModelViolation>(pnObject);
    }

    public Result<TimedTransitionComponent, ModelViolation> addNewTimedTransitions(DataLayer c, Point p, boolean isUrgent, boolean isUncontrollable) {
        TimedTransition transition = new TimedTransition(this.tabContent.getNameGenerator().getNewTransitionName(this.tabContent.guiModelToModel.get(c)));
        transition.setUrgent(isUrgent);
        transition.setUncontrollable(isUncontrollable);
        transition.setUrgent(isUrgent);
        TimedTransitionComponent pnObject = new TimedTransitionComponent(p.x, p.y, transition, this.tabContent.lens);
        this.tabContent.guiModelToModel.get(c).add(transition);
        c.addPetriNetObject(pnObject);
        this.addCommand(new AddTimedTransitionCommand(pnObject, this.tabContent.guiModelToModel.get(c), c));
        return new Result<TimedTransitionComponent, ModelViolation>(pnObject);
    }

    public void addAnnotationNote(DataLayer c, Point p) {
        AnnotationNote pnObject = new AnnotationNote(p.x, p.y);
        if (pnObject.enableEditMode(true)) {
            c.addPetriNetObject(pnObject);
            this.addCommand(new AddAnnotationNoteCommand(pnObject, c));
        }
    }

    public Result<TimedInputArcComponent, ModelViolation> addTimedInputArc(@NotNull DataLayer c, @NotNull TimedPlaceComponent p, @NotNull TimedTransitionComponent t, ArcPath path) {
        Require.notNull((Object)c, "DataLayer can't be null");
        Require.notNull((Object)p, "Place can't be null");
        Require.notNull((Object)t, "Transitions can't be null");
        RequirementChecker<ModelViolation> require = new RequirementChecker<ModelViolation>();
        require.Not(this.tabContent.guiModelToModel.get(c).hasArcFromPlaceToTransition(p.underlyingPlace(), t.underlyingTransition()), ModelViolation.MaxOneArcBetweenPlaceAndTransition);
        require.Not(p.underlyingPlace().isShared() && t.underlyingTransition().isShared(), ModelViolation.CantHaveArcBetweenSharedPlaceAndTransition);
        if (require.failed()) {
            return new Result<TimedInputArcComponent, ModelViolation>(require.getErrors());
        }
        TimedArcPetriNet modelNet = this.tabContent.guiModelToModel.get(c);
        ColorType ct = p.underlyingPlace().getColorType();
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(ct.createColorExpressionForFirstColor());
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        TimedInputArc tia = new TimedInputArc(p.underlyingPlace(), t.underlyingTransition(), TimeInterval.ZERO_INF, numbExpr);
        TimedInputArcComponent tiac = new TimedInputArcComponent((PlaceTransitionObject)p, (PlaceTransitionObject)t, tia, this.tabContent.lens);
        if (path != null) {
            tiac.setArcPath(new ArcPath((Arc)tiac, path));
        }
        AddTimedInputArcCommand edit = new AddTimedInputArcCommand(tiac, modelNet, c);
        edit.redo();
        this.addCommand(edit);
        return new Result<TimedInputArcComponent, ModelViolation>(tiac);
    }

    public Result<TimedOutputArcComponent, ModelViolation> addTimedOutputArc(DataLayer c, TimedTransitionComponent t, TimedPlaceComponent p, ArcPath path) {
        Require.notNull((Object)c, "DataLayer can't be null");
        Require.notNull((Object)p, "Place can't be null");
        Require.notNull((Object)t, "Transitions can't be null");
        RequirementChecker<ModelViolation> require = new RequirementChecker<ModelViolation>();
        require.Not(this.tabContent.guiModelToModel.get(c).hasArcFromTransitionToPlace(t.underlyingTransition(), p.underlyingPlace()), ModelViolation.MaxOneArcBetweenTransitionAndPlace);
        require.Not(p.underlyingPlace().isShared() && t.underlyingTransition().isShared(), ModelViolation.CantHaveArcBetweenSharedPlaceAndTransition);
        if (require.failed()) {
            return new Result<TimedOutputArcComponent, ModelViolation>(require.getErrors());
        }
        TimedArcPetriNet modelNet = this.tabContent.guiModelToModel.get(c);
        ColorType ct = p.underlyingPlace().getColorType();
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(ct.createColorExpressionForFirstColor());
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        TimedOutputArc toa = new TimedOutputArc(t.underlyingTransition(), p.underlyingPlace(), numbExpr);
        TimedOutputArcComponent toac = new TimedOutputArcComponent((PlaceTransitionObject)t, (PlaceTransitionObject)p, toa, this.tabContent.lens);
        if (path != null) {
            toac.setArcPath(new ArcPath((Arc)toac, path));
        }
        AddTimedOutputArcCommand edit = new AddTimedOutputArcCommand(toac, modelNet, c);
        edit.redo();
        this.addCommand(edit);
        return new Result<TimedOutputArcComponent, ModelViolation>(toac);
    }

    public Result<TimedInhibitorArcComponent, ModelViolation> addInhibitorArc(DataLayer c, TimedPlaceComponent p, TimedTransitionComponent t, ArcPath path) {
        Require.notNull((Object)c, "DataLayer can't be null");
        Require.notNull((Object)p, "Place can't be null");
        Require.notNull((Object)t, "Transitions can't be null");
        TimedArcPetriNet modelNet = this.tabContent.guiModelToModel.get(c);
        RequirementChecker<ModelViolation> require = new RequirementChecker<ModelViolation>();
        require.Not(modelNet.hasArcFromPlaceToTransition(p.underlyingPlace(), t.underlyingTransition()), ModelViolation.MaxOneArcBetweenPlaceAndTransition);
        require.Not(p.underlyingPlace().isShared() && t.underlyingTransition().isShared(), ModelViolation.CantHaveArcBetweenSharedPlaceAndTransition);
        if (require.failed()) {
            return new Result<TimedInhibitorArcComponent, ModelViolation>(require.getErrors());
        }
        TimedInhibitorArc tiha = new TimedInhibitorArc(p.underlyingPlace(), t.underlyingTransition());
        ColorType ct = tiha.source().getColorType();
        AllExpression allExpression = new AllExpression(ct);
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(allExpression);
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        tiha.setExpression(numbExpr);
        TimedInhibitorArcComponent tihac = new TimedInhibitorArcComponent(p, t, tiha);
        if (path != null) {
            tihac.setArcPath(new ArcPath((Arc)tihac, path));
        }
        AddTimedInhibitorArcCommand edit = new AddTimedInhibitorArcCommand(tihac, modelNet, c);
        edit.redo();
        this.addCommand(edit);
        return new Result<TimedInhibitorArcComponent, ModelViolation>(tihac);
    }

    public Result<TimedTransportArcComponent, ModelViolation> addTimedTransportArc(DataLayer c, TimedPlaceComponent p1, TimedTransitionComponent t, TimedPlaceComponent p2, ArcPath path1, ArcPath path2) {
        Require.notNull((Object)c, "DataLayer can't be null");
        Require.notNull((Object)p1, "Place1 can't be null");
        Require.notNull((Object)t, "Transitions can't be null");
        Require.notNull((Object)p2, "Place2 can't be null");
        TimedArcPetriNet modelNet = this.tabContent.guiModelToModel.get(c);
        RequirementChecker<ModelViolation> require = new RequirementChecker<ModelViolation>();
        require.Not(modelNet.hasArcFromPlaceToTransition(p1.underlyingPlace(), t.underlyingTransition()), ModelViolation.MaxOneArcBetweenPlaceAndTransition);
        require.Not(modelNet.hasArcFromTransitionToPlace(t.underlyingTransition(), p2.underlyingPlace()), ModelViolation.MaxOneArcBetweenTransitionAndPlace);
        require.Not(p1.underlyingPlace().isShared() && t.underlyingTransition().isShared(), ModelViolation.CantHaveArcBetweenSharedPlaceAndTransition);
        require.Not(p2.underlyingPlace().isShared() && t.underlyingTransition().isShared(), ModelViolation.CantHaveArcBetweenSharedPlaceAndTransition);
        boolean hasInvariant = p2.hasInvariant() || p2.hasAnyColorInvariant();
        require.Not(t.underlyingTransition().isUrgent() && hasInvariant, ModelViolation.TransportArcUrgentTransitionAndInvariant);
        if (require.failed()) {
            return new Result<TimedTransportArcComponent, ModelViolation>(require.getErrors());
        }
        int groupNr = this.getNextTransportArcMaxGroupNumber(p1, t);
        TransportArc tta = new TransportArc(p1.underlyingPlace(), t.underlyingTransition(), p2.underlyingPlace());
        this.instantiateArcExpressions(p1, t, p2, tta);
        TimedTransportArcComponent ttac1 = new TimedTransportArcComponent(p1, t, tta, groupNr, this.tabContent.lens);
        TimedTransportArcComponent ttac2 = new TimedTransportArcComponent(t, p2, tta, groupNr, this.tabContent.lens);
        ttac1.setConnectedTo(ttac2);
        ttac2.setConnectedTo(ttac1);
        if (path1 != null) {
            ttac1.setArcPath(new ArcPath((Arc)ttac1, path1));
        }
        if (path2 != null) {
            ttac2.setArcPath(new ArcPath((Arc)ttac2, path2));
        }
        AddTransportArcCommand edit = new AddTransportArcCommand(ttac2, tta, modelNet, c);
        edit.redo();
        this.addCommand(edit);
        return new Result<TimedTransportArcComponent, ModelViolation>(ttac1);
    }

    private void instantiateArcExpressions(TimedPlaceComponent p1, Transition t, TimedPlaceComponent p2, TransportArc tta) {
        ColorType ctin = p1.underlyingPlace().getColorType();
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(ctin.createColorExpressionForFirstColor());
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        tta.setInputExpression(numbExpr);
        ColorType ctout = p2.underlyingPlace().getColorType();
        vecColorExpr = new Vector();
        vecColorExpr.add(ctout.createColorExpressionForFirstColor());
        numbExpr = new NumberOfExpression(1, vecColorExpr);
        tta.setOutputExpression(numbExpr);
    }

    private int getNextTransportArcMaxGroupNumber(TimedPlaceComponent p, TimedTransitionComponent t) {
        int groupMaxCounter = 0;
        for (Arc a : t.getPreset()) {
            if (!(a instanceof TimedTransportArcComponent) || !a.getTarget().equals(t) || ((TimedTransportArcComponent)a).getGroupNr() <= groupMaxCounter) continue;
            groupMaxCounter = ((TimedTransportArcComponent)a).getGroupNr();
        }
        return groupMaxCounter + 1;
    }

    public void addToken(DataLayer d, TimedPlaceComponent p, int numberOfTokens) {
        Require.notNull((Object)d, "Datalayer can't be null");
        Require.notNull((Object)p, "TimedPlaceComponent can't be null");
        Require.that(numberOfTokens > 0, "Number of tokens to add must be strictly greater than 0");
        TimedPlaceMarkingEditCommand command = new TimedPlaceMarkingEditCommand(p, numberOfTokens);
        command.redo();
        this.addCommand(command);
    }

    public void removeToken(DataLayer d, TimedPlaceComponent p, int numberOfTokens) {
        Require.notNull((Object)d, "Datalayer can't be null");
        Require.notNull((Object)p, "TimedPlaceComponent can't be null");
        Require.that(numberOfTokens > 0, "Number of tokens to remove must be strictly greater than 0");
        int tokensToRemove = Math.min(numberOfTokens, p.getNumberOfTokens());
        if (tokensToRemove > 0) {
            TimedPlaceMarkingEditCommand command = new TimedPlaceMarkingEditCommand(p, -tokensToRemove);
            command.redo();
            this.addCommand(command);
        }
    }

    public void deleteSelection() {
        int n;
        ArrayList<PetriNetObject> selection = this.tabContent.drawingSurface().getSelectionObject().getSelection();
        Iterable<TAPNQuery> queries = this.tabContent.queries();
        HashSet<TAPNQuery> queriesToDelete = new HashSet<TAPNQuery>();
        boolean queriesAffected = false;
        for (PetriNetObject petriNetObject : selection) {
            TimedTransitionComponent transition;
            if (petriNetObject instanceof TimedPlaceComponent) {
                TimedPlaceComponent place = (TimedPlaceComponent)petriNetObject;
                if (place.underlyingPlace().isShared()) continue;
                for (TAPNQuery q : queries) {
                    if (!q.getProperty().containsAtomicPropositionWithSpecificPlaceInTemplate(((LocalTimedPlace)place.underlyingPlace()).model().name(), place.underlyingPlace().name())) continue;
                    queriesAffected = true;
                    queriesToDelete.add(q);
                }
                continue;
            }
            if (!(petriNetObject instanceof TimedTransitionComponent) || (transition = (TimedTransitionComponent)petriNetObject).underlyingTransition().isShared()) continue;
            for (TAPNQuery q : queries) {
                if (!q.getProperty().containsAtomicPropositionWithSpecificTransitionInTemplate(transition.underlyingTransition().model().name(), transition.underlyingTransition().name())) continue;
                queriesAffected = true;
                queriesToDelete.add(q);
            }
        }
        StringBuilder s = new StringBuilder();
        s.append("The following queries are associated with the currently selected objects:\n\n");
        for (TAPNQuery q : queriesToDelete) {
            s.append(q.getName());
            s.append('\n');
        }
        s.append("\nAre you sure you want to remove the current selection and all associated queries?");
        int n2 = n = queriesAffected ? JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), s.toString(), "Warning", 0, 3) : 0;
        if (n == 0) {
            this.tabContent.getUndoManager().newEdit();
            if (queriesAffected) {
                for (TAPNQuery q : queriesToDelete) {
                    DeleteQueriesCommand cmd = new DeleteQueriesCommand(this.tabContent, List.of(q));
                    cmd.redo();
                    this.tabContent.getUndoManager().addEdit(cmd);
                }
            }
            this.deleteSelection(selection);
            this.tabContent.network().buildConstraints();
        }
    }

    private void deleteObject(PetriNetObject pnObject) {
        if (pnObject instanceof ArcPathPoint) {
            ArcPathPoint arcPathPoint = (ArcPathPoint)pnObject;
            if (!arcPathPoint.getArcPath().getArc().isSelected() && arcPathPoint.isDeleteable()) {
                DeleteArcPathPointEditCommand cmd = new DeleteArcPathPointEditCommand(arcPathPoint.getArcPath().getArc(), arcPathPoint, arcPathPoint.getIndex(), this.tabContent.getModel());
                cmd.redo();
                this.tabContent.getUndoManager().addEdit(cmd);
            }
        } else if (!pnObject.isDeleted()) {
            Command cmd = null;
            if (pnObject instanceof TimedPlaceComponent) {
                TimedPlaceComponent tp = (TimedPlaceComponent)pnObject;
                cmd = new DeleteTimedPlaceCommand(tp, this.tabContent.guiModelToModel.get(this.tabContent.getModel()), this.tabContent.getModel());
            } else if (pnObject instanceof TimedTransitionComponent) {
                TimedTransitionComponent transition = (TimedTransitionComponent)pnObject;
                cmd = new DeleteTimedTransitionCommand(transition, transition.underlyingTransition().model(), this.tabContent.getModel());
            } else if (pnObject instanceof TimedTransportArcComponent) {
                TimedTransportArcComponent transportArc = (TimedTransportArcComponent)pnObject;
                cmd = new DeleteTransportArcCommand(transportArc, transportArc.underlyingTransportArc(), transportArc.underlyingTransportArc().model(), this.tabContent.getModel());
            } else if (pnObject instanceof TimedInhibitorArcComponent) {
                TimedInhibitorArcComponent tia = (TimedInhibitorArcComponent)pnObject;
                cmd = new DeleteTimedInhibitorArcCommand(tia, tia.underlyingTimedInhibitorArc().model(), this.tabContent.getModel());
            } else if (pnObject instanceof TimedInputArcComponent) {
                TimedInputArcComponent tia = (TimedInputArcComponent)pnObject;
                cmd = new DeleteTimedInputArcCommand(tia, tia.underlyingTimedInputArc().model(), this.tabContent.getModel());
            } else if (pnObject instanceof TimedOutputArcComponent) {
                TimedOutputArcComponent toa = (TimedOutputArcComponent)pnObject;
                cmd = new DeleteTimedOutputArcCommand(toa, toa.underlyingArc().model(), this.tabContent.getModel());
            } else if (pnObject instanceof AnnotationNote) {
                cmd = new DeleteAnnotationNoteCommand((AnnotationNote)pnObject, this.tabContent.getModel());
            } else {
                throw new RuntimeException("This should not be possible");
            }
            cmd.redo();
            this.tabContent.getUndoManager().addEdit(cmd);
        }
    }

    private void deleteSelection(PetriNetObject pnObject) {
        if (pnObject instanceof PlaceTransitionObject) {
            PlaceTransitionObject pto = (PlaceTransitionObject)pnObject;
            ArrayList<Arc> arcsToDelete = new ArrayList<Arc>();
            for (Arc arc : pto.getPreset()) {
                arcsToDelete.add(arc);
            }
            for (Arc arc : pto.getPostset()) {
                arcsToDelete.add(arc);
            }
            arcsToDelete.forEach(this::deleteObject);
        }
        this.deleteObject(pnObject);
    }

    public void deleteSelection(ArrayList<PetriNetObject> selection) {
        for (PetriNetObject pnObject : selection) {
            this.deleteSelection(pnObject);
        }
    }

    public void toggleUncontrollableTrans() {
        ArrayList<PetriNetObject> selection = this.tabContent.drawingSurface().getSelectionObject().getSelection();
        this.tabContent.getUndoManager().newEdit();
        for (PetriNetObject o : selection) {
            if (!(o instanceof TimedTransitionComponent)) continue;
            TimedTransitionComponent transition = (TimedTransitionComponent)o;
            ToggleTransitionUncontrollableCommand cmd = new ToggleTransitionUncontrollableCommand(transition.underlyingTransition(), this.tabContent);
            cmd.redo();
            this.tabContent.getUndoManager().addEdit(cmd);
        }
        this.tabContent.repaint();
    }

    public void toggleUrgentTrans() {
        ArrayList<PetriNetObject> selection = this.tabContent.drawingSurface().getSelectionObject().getSelection();
        this.tabContent.getUndoManager().newEdit();
        for (PetriNetObject o : selection) {
            if (!(o instanceof TimedTransitionComponent)) continue;
            TimedTransitionComponent transition = (TimedTransitionComponent)o;
            if (!transition.underlyingTransition().hasUntimedPreset()) {
                JOptionPane.showMessageDialog(null, "Incoming arcs to urgent transitions must have the interval [0,\u221e).", "Error", 0);
                return;
            }
            ToggleTransitionUrgentCommand cmd = new ToggleTransitionUrgentCommand(transition.underlyingTransition(), this.tabContent);
            cmd.redo();
            this.tabContent.getUndoManager().addEdit(cmd);
        }
        this.tabContent.repaint();
    }

    public void toggleArcPathPointType(ArcPathPoint pno) {
        this.addCommand(pno.togglePointType());
    }
}

