/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.tapaal.gui.petrinet.editor.ColorComboBoxRenderer;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.Colored.AddVariableCommand;
import net.tapaal.gui.petrinet.undo.Colored.UpdateVariableCommand;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.EscapableDialog;

public class VariablesDialogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final TimedArcPetriNetNetwork network;
    private EscapableDialog dialog;
    private Variable variable;
    private List<ColorType> colorTypes;
    private final ConstantsPane.VariablesListModel listModel;
    private final String oldName;
    JTextField nameTextField;
    Dimension size;
    JLabel nameLabel;
    JComboBox<ColorType> colorTypeComboBox;
    JLabel colorTypeLabel;
    JPanel container;
    JPanel buttonContainer;
    JButton okButton;
    JButton cancelButton;
    private JScrollPane scrollPane;
    private final UndoManager undoManager;

    public VariablesDialogPanel(JRootPane pane, ConstantsPane.VariablesListModel listModel, TimedArcPetriNetNetwork network, UndoManager undoManager) throws IOException {
        this.oldName = "";
        this.network = network;
        this.listModel = listModel;
        this.initComponents();
        this.nameTextField.setText(this.oldName);
        this.undoManager = undoManager;
    }

    public VariablesDialogPanel(JRootPane pane, ConstantsPane.VariablesListModel listModel, TimedArcPetriNetNetwork network, Variable variable, UndoManager undoManager) throws IOException {
        this.variable = variable;
        this.oldName = variable.getName();
        this.network = network;
        this.listModel = listModel;
        this.initComponents();
        this.nameTextField.setText(this.oldName);
        this.undoManager = undoManager;
    }

    public void showDialog() {
        if (this.colorTypeComboBox.getItemCount() <= 0) {
            return;
        }
        String panelHeader = this.variable != null ? "Edit Variable" : "Create Variable";
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), panelHeader, true);
        this.scrollPane.setBorder(null);
        this.dialog.add((Component)this.scrollPane, "Center");
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    private void initComponents() {
        this.container = new JPanel();
        this.buttonContainer = new JPanel();
        this.container.setLayout(new GridBagLayout());
        this.size = new Dimension(330, 30);
        this.createCancelButton();
        this.createColorTypeLabel();
        this.createColorTypesComboBox();
        this.createNameLabel();
        this.createNameTextField();
        this.createOKButton();
        this.okButton.addActionListener(e -> this.onOK());
        this.cancelButton.addActionListener(e -> this.exit());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.container.add((Component)this.buttonContainer, gbc);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.container);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
    }

    private void createNameTextField() {
        this.nameTextField = new JTextField();
        this.nameTextField.setPreferredSize(this.size);
        this.nameTextField.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                1 al = this;
                SwingUtilities.invokeLater(() -> {
                    JComponent component = ancestorEvent.getComponent();
                    component.requestFocusInWindow();
                    component.removeAncestorListener(al);
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 2, 4);
        this.container.add((Component)this.nameTextField, gbc);
    }

    private void createNameLabel() {
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Name: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 2, 4);
        gbc.anchor = 17;
        this.container.add((Component)this.nameLabel, gbc);
    }

    private void createColorTypeLabel() {
        this.colorTypeLabel = new JLabel();
        this.colorTypeLabel.setText("Color type: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.container.add((Component)this.colorTypeLabel, gbc);
    }

    private void createColorTypesComboBox() {
        this.colorTypes = new ArrayList<ColorType>();
        this.colorTypes = this.network.colorTypes().stream().filter(f -> !f.isProductColorType() && f != ColorType.COLORTYPE_DOT).collect(Collectors.toList());
        this.colorTypeComboBox = new JComboBox();
        this.colorTypeComboBox.setPreferredSize(new Dimension(330, 30));
        this.colorTypeComboBox.setRenderer(new ColorComboBoxRenderer(this.colorTypeComboBox, -4));
        int selectedVariableIndex = 0;
        int index = 0;
        for (ColorType element : this.colorTypes) {
            this.colorTypeComboBox.addItem(element);
            if (this.variable != null && element.getName().equals(this.variable.getColorType().getName())) {
                selectedVariableIndex = index;
            }
            ++index;
        }
        if (this.colorTypeComboBox.getItemCount() <= 0) {
            JOptionPane.showMessageDialog(this, "No valid color types available for variables", "", 1);
            return;
        }
        this.colorTypeComboBox.setSelectedIndex(selectedVariableIndex);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.container.add(this.colorTypeComboBox, gbc);
    }

    private void createOKButton() {
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.buttonContainer.add((Component)this.okButton, gbc);
    }

    private void createCancelButton() {
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        this.buttonContainer.add((Component)this.cancelButton, gbc);
    }

    private void exit() {
        this.dialog.setVisible(false);
    }

    private void onOK() {
        if (this.colorTypeComboBox.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You have to choose a color type for the variable. If none are present you have to create one first under variables.", "Error", 0);
            this.colorTypeComboBox.requestFocusInWindow();
            return;
        }
        String newName = this.nameTextField.getText();
        if (newName.trim().isEmpty()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You have to enter a name in the textfield in order to create a new variable", "Error", 0);
            this.colorTypeComboBox.requestFocusInWindow();
            return;
        }
        if (!Pattern.matches("[a-zA-Z]([\\_a-zA-Z0-9])*", newName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Acceptable names for variables are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        if ((this.variable == null || !this.variable.getName().equals(newName)) && this.network.isNameUsedForVariable(newName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another variable with the same name.\n\nChoose a different name for the variable.", "Error", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        if (!this.oldName.equals("") && !this.oldName.equals(newName) && this.network.isNameUsedForVariable(newName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another variable with the same name.\n\nChoose a different name for the variable.", "Error", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        if (this.network.isNameUsedForConstant(newName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already a constant with this name.\n\nChoose a different name for the variable.", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForColorType(newName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already a Color Type with this name.\n\nChoose a different name for the variable.", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForColor(newName, null)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already a Color with this name.\n\nChoose a different name for the variable.", "Error", 0);
            return;
        }
        Command cmd = !this.oldName.equals("") ? new UpdateVariableCommand(this.variable, this.nameTextField.getText(), this.colorTypes.get(this.colorTypeComboBox.getSelectedIndex()), this.listModel) : new AddVariableCommand(new Variable(this.nameTextField.getText(), this.nameTextField.getText(), (ColorType)this.colorTypeComboBox.getSelectedItem()), this.network, this.listModel, this.network.variables().size());
        this.undoManager.addNewEdit(cmd);
        cmd.redo();
        this.exit();
    }
}

