/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.event.ConstantChangedEvent;
import dk.aau.cs.model.tapn.event.ConstantEvent;
import dk.aau.cs.model.tapn.event.ConstantsListener;
import javax.swing.AbstractListModel;

public class ConstantsListModel
extends AbstractListModel {
    private TimedArcPetriNetNetwork network;
    private final ConstantsListener listener = new ConstantsListener(){

        @Override
        public void constantRemoved(ConstantEvent e) {
            ConstantsListModel.this.fireIntervalRemoved(this, e.index(), e.index());
        }

        @Override
        public void constantChanged(ConstantChangedEvent e) {
            ConstantsListModel.this.fireContentsChanged(this, e.index(), e.index());
        }

        @Override
        public void constantAdded(ConstantEvent e) {
            ConstantsListModel.this.fireIntervalAdded(this, e.index(), e.index());
        }
    };

    public ConstantsListModel(TimedArcPetriNetNetwork network) {
        this.setNetwork(network);
    }

    public void setNetwork(TimedArcPetriNetNetwork newNetwork) {
        if (this.network != null) {
            this.network.removeConstantsListener(this.listener);
        }
        this.network = newNetwork;
        this.network.addConstantsListener(this.listener);
        this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
    }

    @Override
    public Constant getElementAt(int index) {
        return this.network.getConstant(index);
    }

    @Override
    public int getSize() {
        return this.network.constants().size();
    }

    public void updateAll() {
        this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
    }
}

