/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.swinghelpers.CustomJSpinner;
import net.tapaal.swinghelpers.RequestFocusListener;
import net.tapaal.swinghelpers.SwingHelper;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class ConstantsDialogPanel
extends JPanel {
    private final TimedArcPetriNetNetwork model;
    private int lowerBound;
    private int upperBound;
    private int initialValue = 0;
    private EscapableDialog dialog;
    JTextField nameTextField;
    JLabel nameLabel;
    JLabel valueLabel;
    CustomJSpinner valueSpinner;
    JPanel container;
    JPanel buttonContainer;
    JButton okButton;
    JButton cancelButton;
    private final String oldName;

    public ConstantsDialogPanel(TimedArcPetriNetNetwork model, Constant constant) {
        this.model = model;
        if (constant != null) {
            this.initialValue = constant.value();
            this.oldName = constant.name();
            this.lowerBound = constant.lowerBound();
            this.upperBound = constant.upperBound();
        } else {
            this.oldName = "";
        }
        this.initComponents();
        this.nameTextField.setText(this.oldName);
    }

    public void showDialog() {
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Constant", true);
        this.dialog.add(this.container);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    private void initComponents() {
        this.container = new JPanel();
        this.container.setLayout(new GridBagLayout());
        this.nameTextField = new JTextField();
        SwingHelper.setPreferredWidth(this.nameTextField, 330);
        this.nameTextField.addAncestorListener(new RequestFocusListener());
        this.nameTextField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 2, 4);
        this.container.add((Component)this.nameTextField, gbc);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Name: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 4, 2, 4);
        gbc.anchor = 17;
        this.container.add((Component)this.nameLabel, gbc);
        this.valueLabel = new JLabel();
        this.valueLabel.setText("Value: ");
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.container.add((Component)this.valueLabel, gbc);
        this.buttonContainer = new JPanel();
        this.buttonContainer.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.buttonContainer.add((Component)this.okButton, gbc);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setMnemonic(67);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        this.buttonContainer.add((Component)this.cancelButton, gbc);
        this.valueSpinner = new CustomJSpinner(this.initialValue, this.okButton);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.container.add((Component)this.valueSpinner, gbc);
        this.okButton.addActionListener(e -> this.onOK());
        this.cancelButton.addActionListener(e -> this.exit());
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.container.add((Component)this.buttonContainer, gbc);
    }

    private void exit() {
        this.dialog.setVisible(false);
    }

    private void onOK() {
        if (((JSpinner.NumberEditor)this.valueSpinner.getEditor()).getTextField().getText().equals("")) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The specified value is invalid for the current net.\nUpdating the constant to the specified value invalidates the guard\non one or more arcs, or it sets the weight of an arc to 0.", "Constant value invalid for current net", 0);
            this.valueSpinner.requestFocusInWindow();
            return;
        }
        String newName = this.nameTextField.getText();
        if (!Pattern.matches("[a-zA-Z]([\\_a-zA-Z0-9])*", newName)) {
            System.err.println("Acceptable names for constants are defined by the regular expression:\n[a-zA-Z][_a-zA-Z]*");
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Acceptable names for constants are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        if (this.model.isNameUsedForColorType(newName) || this.model.isNameUsedForVariable(newName) || this.model.isNameUsedForColor(newName, null)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another Color, Color Type or Variable with the same name.\n\nChoose a different name for the constant.", "Error", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        if (newName.trim().isEmpty()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You must specify a name.", "Missing name", 0);
            this.nameTextField.requestFocusInWindow();
            return;
        }
        int val = (Integer)this.valueSpinner.getValue();
        if (!this.oldName.equals("")) {
            if (!this.oldName.equals(newName) && this.model.isNameUsedForConstant(newName)) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another constant with the same name.\n\nChoose a different name for the constant.", "Error", 0);
                this.nameTextField.requestFocusInWindow();
                return;
            }
            if (this.lowerBound > val || val > this.upperBound) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The specified value is invalid for the current net.\nUpdating the constant to the specified value invalidates the guard\non one or more arcs, or it sets the weight of an arc to 0.", "Constant value invalid for current net", 0);
                this.valueSpinner.requestFocusInWindow();
                return;
            }
            Command edit = this.model.updateConstant(this.oldName, new Constant(newName, val));
            if (edit == null) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The specified value is invalid for the current net.\nUpdating the constant to the specified value invalidates the guard\non one or more arcs, or it sets the weight of an arc to 0.", "Constant value invalid for current net", 0);
                this.valueSpinner.requestFocusInWindow();
                return;
            }
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(edit);
            TAPAALGUI.getCurrentTab().drawingSurface().repaintAll();
            this.exit();
        } else {
            Command edit = this.model.addConstant(newName, val);
            if (edit == null) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "A constant with the specified name already exists.", "Constant exists", 0);
                this.nameTextField.requestFocusInWindow();
                return;
            }
            TAPAALGUI.getCurrentTab().getUndoManager().addNewEdit(edit);
            this.exit();
        }
        this.model.buildConstraints();
    }
}

