/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ProductType;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ColortypeListCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private static final int MAXIMUM_TO_DISPLAY = 5;

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof ColorType && !(value instanceof ProductType)) {
            ColorType ct = (ColorType)value;
            if (ct.getColors().size() <= 5) {
                this.setText(ct.toString());
            } else {
                Object out = "<html>" + ct.getName() + "<b> is </b>[";
                int i = 0;
                for (Color element : ct.getColors()) {
                    out = (String)out + element.getColorName() + ", ";
                    if (++i <= 4 || i >= ct.getColors().size() - 1) continue;
                    out = (String)out + "... ,";
                    break;
                }
                out = i < ct.getColors().size() - 1 ? (String)out + String.valueOf(ct.getColors().get(ct.getColors().size() - 1)) : ((String)out).substring(0, ((String)out).length() - 2);
                out = (String)out + "]</html>";
                this.setText((String)out);
            }
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return this;
    }
}

