/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.AndExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.EqualityExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.GreaterThanEqExpression;
import dk.aau.cs.model.CPN.Expressions.GreaterThanExpression;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.InequalityExpression;
import dk.aau.cs.model.CPN.Expressions.LeftRightGuardExpression;
import dk.aau.cs.model.CPN.Expressions.LessThanEqExpression;
import dk.aau.cs.model.CPN.Expressions.LessThanExpression;
import dk.aau.cs.model.CPN.Expressions.NotExpression;
import dk.aau.cs.model.CPN.Expressions.OrExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderColorExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderGuardExpression;
import dk.aau.cs.model.CPN.Expressions.PredecessorExpression;
import dk.aau.cs.model.CPN.Expressions.SuccessorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Expressions.VariableExpression;
import dk.aau.cs.model.CPN.GuardExpressionParser.GuardExpressionParser;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import kotlin.Pair;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.ColorComboBoxRenderer;
import net.tapaal.gui.petrinet.editor.ColorComboboxPanel;
import net.tapaal.gui.petrinet.undo.Colored.SetTransitionExpressionCommand;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.editor.TAPNTransitionEditor;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.undo.UndoManager;

public class ColoredTransitionGuardPanel
extends JPanel {
    private JButton resetExprButton;
    private JButton deleteExprSelectionButton;
    private JButton editExprButton;
    private JButton undoButton;
    private JButton redoButton;
    JComboBox<ColorType> colorTypeCombobox;
    JPanel comparisonButtonsPanel;
    private JButton andButton;
    private JButton orButton;
    private JButton notButton;
    private JButton equalityButton;
    private JButton greaterThanEqButton;
    private JButton greaterThanButton;
    private JButton inequalityButton;
    private JButton lessThanEqButton;
    private JButton lessThanButton;
    JPanel colorExpressionPanel;
    JPanel colorExpressionButtons;
    JButton predButton;
    JButton succButton;
    JLabel colorTypeLabel;
    ColorComboboxPanel colorCombobox;
    JLabel colorLabel;
    private JTextPane exprField;
    private final Context context;
    private final TimedTransitionComponent transition;
    private GuardExpression newProperty;
    private GuardExpression previousExpr;
    private GuardExpression nextExpr;
    final TAPNTransitionEditor parent;
    final ExpressionConstructionUndoManager undoManager;
    final UndoableEditSupport undoSupport;
    private boolean doColorTypeUndo = true;
    private boolean updatingColorSelection = false;
    private ExprStringPosition currentSelection = null;

    public ColoredTransitionGuardPanel(TimedTransitionComponent transition, Context context, TAPNTransitionEditor parent) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Guard Expression"));
        this.transition = transition;
        this.context = context;
        this.parent = parent;
        this.initExprField();
        this.initComparisonPanel();
        this.initLogicPanel();
        this.initColorExpressionPanel();
        this.initExprEditPanel();
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoManager = new ExpressionConstructionUndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedo();
        this.makeShortcuts();
    }

    private void initColorExpressionPanel() {
        this.colorExpressionPanel = new JPanel(new GridBagLayout());
        this.colorExpressionPanel.setBorder(BorderFactory.createTitledBorder("Variables and Colors"));
        this.colorExpressionButtons = new JPanel(new GridBagLayout());
        ButtonGroup expressionButtonsGroup = new ButtonGroup();
        this.predButton = new JButton("Add Pred");
        this.succButton = new JButton("Add Succ");
        this.predButton.setPreferredSize(new Dimension(130, 27));
        this.predButton.setMinimumSize(new Dimension(130, 27));
        this.predButton.setMaximumSize(new Dimension(130, 27));
        this.succButton.setPreferredSize(new Dimension(130, 27));
        this.succButton.setMinimumSize(new Dimension(130, 27));
        this.succButton.setMaximumSize(new Dimension(130, 27));
        expressionButtonsGroup.add(this.predButton);
        expressionButtonsGroup.add(this.succButton);
        this.predButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ColorExpression) {
                Expression bottomExpression = this.getBottomExpression(this.newProperty);
                PredecessorExpression predExpr = new PredecessorExpression((ColorExpression)bottomExpression);
                this.replaceAndAddToUndo(bottomExpression, predExpr);
            }
        });
        this.succButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ColorExpression) {
                Expression bottomExpression = this.getBottomExpression(this.newProperty);
                SuccessorExpression succExpr = new SuccessorExpression((ColorExpression)bottomExpression);
                this.replaceAndAddToUndo(bottomExpression, succExpr);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.colorExpressionButtons.add((Component)this.predButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        this.colorExpressionButtons.add((Component)this.succButton, gbc);
        this.colorLabel = new JLabel("Color: ");
        this.colorCombobox = new ColorComboboxPanel((ColorType)this.colorTypeCombobox.getSelectedItem(), false){

            @Override
            public void changedColor(JComboBox[] comboBoxes) {
                if (!ColoredTransitionGuardPanel.this.updatingColorSelection) {
                    ColoredTransitionGuardPanel.this.addColor();
                }
            }
        };
        this.colorCombobox.removeScrollPaneBorder();
        this.colorCombobox.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.colorExpressionPanel.add((Component)this.colorCombobox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.colorExpressionPanel.add((Component)this.colorExpressionButtons, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.colorExpressionPanel, gbc);
    }

    private Expression getBottomExpression(Expression parent) {
        for (ExprStringPosition child : parent.getChildren()) {
            if (child.getObject() == this.currentSelection.getObject()) {
                if (parent instanceof GuardExpression || parent instanceof TupleExpression) {
                    return child.getObject();
                }
                return parent;
            }
            Expression possibleExpr = this.getBottomExpression(child.getObject());
            if (possibleExpr == null) continue;
            return possibleExpr;
        }
        return this.currentSelection.getObject();
    }

    private void initLogicPanel() {
        JPanel logicPanel = new JPanel(new GridBagLayout());
        logicPanel.setBorder(BorderFactory.createTitledBorder("Logic"));
        Dimension d = new Dimension(100, 150);
        logicPanel.setPreferredSize(d);
        logicPanel.setMinimumSize(d);
        ButtonGroup logicButtonGroup = new ButtonGroup();
        this.andButton = new JButton("and");
        this.orButton = new JButton("or");
        this.notButton = new JButton("not");
        logicButtonGroup.add(this.andButton);
        logicButtonGroup.add(this.orButton);
        logicButtonGroup.add(this.notButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 5);
        logicPanel.add((Component)this.andButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        logicPanel.add((Component)this.orButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 0, 5, 5);
        logicPanel.add((Component)this.notButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        this.add((Component)logicPanel, gbc);
        this.andButton.addActionListener(actionEvent -> {
            AndExpression andExpr = null;
            if (this.currentSelection.getObject() instanceof OrExpression) {
                andExpr = new AndExpression(((OrExpression)this.currentSelection.getObject()).getLeftExpression(), ((OrExpression)this.currentSelection.getObject()).getRightExpression());
                andExpr.setSimpleProperty(true);
            } else if (this.currentSelection.getObject() instanceof GuardExpression) {
                andExpr = new AndExpression((GuardExpression)this.currentSelection.getObject(), new PlaceHolderGuardExpression());
                this.updatePreviousExpr();
                this.updateNextExpr();
                boolean isFirstExpr = this.exprField.getText().equals(new PlaceHolderGuardExpression().toString());
                if (this.nextExpr instanceof AndExpression || isFirstExpr) {
                    andExpr.setSimpleProperty(true);
                }
            }
            this.previousExpr = andExpr;
            this.replaceAndAddToUndo(this.currentSelection.getObject(), andExpr);
        });
        this.orButton.addActionListener(actionEvent -> {
            OrExpression orExpr = null;
            if (this.currentSelection.getObject() instanceof AndExpression) {
                orExpr = new OrExpression(((AndExpression)this.currentSelection.getObject()).getLeftExpression(), ((AndExpression)this.currentSelection.getObject()).getRightExpression());
                orExpr.setSimpleProperty(true);
            } else if (this.currentSelection.getObject() instanceof GuardExpression) {
                orExpr = new OrExpression((GuardExpression)this.currentSelection.getObject(), new PlaceHolderGuardExpression());
                this.updatePreviousExpr();
                this.updateNextExpr();
                boolean isFirstExpr = this.exprField.getText().equals(new PlaceHolderGuardExpression().toString());
                if (this.nextExpr instanceof OrExpression || isFirstExpr) {
                    orExpr.setSimpleProperty(true);
                }
            }
            this.previousExpr = orExpr;
            this.replaceAndAddToUndo(this.currentSelection.getObject(), orExpr);
        });
        this.notButton.addActionListener(actionEvent -> {
            NotExpression notExpr = new NotExpression((GuardExpression)this.currentSelection.getObject());
            this.replaceAndAddToUndo(this.currentSelection.getObject(), notExpr);
        });
    }

    private void updatePreviousExpr() {
        int secondLastSpace;
        String exprText = this.exprField.getText();
        int lastSpace = exprText.lastIndexOf(32, this.currentSelection.getStart() - 1);
        if (lastSpace != -1 && (secondLastSpace = exprText.lastIndexOf(32, lastSpace - 1)) != -1) {
            String word = exprText.substring(secondLastSpace + 1, lastSpace);
            OrExpression tmpOrExpression = new OrExpression(null, null);
            AndExpression tmpAndExpression = new AndExpression(null, null);
            if (word.equals(tmpOrExpression.getWord())) {
                this.previousExpr = tmpOrExpression;
            } else if (word.equals(tmpAndExpression.getWord())) {
                this.previousExpr = tmpAndExpression;
            }
        }
    }

    private void updateNextExpr() {
        String exprText = this.exprField.getText();
        if (exprText.length() > this.currentSelection.getEnd() && exprText.charAt(this.currentSelection.getEnd()) == ')' || exprText.length() == this.currentSelection.getEnd()) {
            this.nextExpr = this.previousExpr;
            return;
        }
        int nextSpace = exprText.indexOf(32, this.currentSelection.getEnd() + 1);
        if (nextSpace != -1) {
            String word = exprText.substring(this.currentSelection.getEnd() + 1, nextSpace);
            OrExpression tmpOrExpression = new OrExpression(null, null);
            AndExpression tmpAndExpression = new AndExpression(null, null);
            if (word.equals(tmpOrExpression.getWord())) {
                this.nextExpr = tmpOrExpression;
            } else if (word.equals(tmpAndExpression.getWord())) {
                this.nextExpr = tmpAndExpression;
            }
        }
    }

    private void initComparisonPanel() {
        JPanel comparisonPanel = new JPanel(new GridBagLayout());
        comparisonPanel.setBorder(BorderFactory.createTitledBorder("Comparison"));
        this.colorTypeLabel = new JLabel("Color Type: ");
        this.colorTypeCombobox = new JComboBox();
        this.colorTypeCombobox.setPreferredSize(new Dimension(300, 25));
        this.colorTypeCombobox.setRenderer(new ColorComboBoxRenderer(this.colorTypeCombobox));
        this.addColorTypesToCombobox(this.context.network().colorTypes());
        if (this.colorTypeCombobox.getItemCount() != 0) {
            this.colorTypeCombobox.setSelectedIndex(0);
        }
        this.colorTypeCombobox.addActionListener(actionEvent -> this.updateColorType());
        ButtonGroup comparisonButtons = new ButtonGroup();
        this.equalityButton = new JButton("=");
        this.greaterThanEqButton = new JButton(">=");
        this.greaterThanButton = new JButton(">");
        this.inequalityButton = new JButton("!=");
        this.lessThanEqButton = new JButton("<=");
        this.lessThanButton = new JButton("<");
        comparisonButtons.add(this.equalityButton);
        comparisonButtons.add(this.greaterThanEqButton);
        comparisonButtons.add(this.greaterThanButton);
        comparisonButtons.add(this.inequalityButton);
        comparisonButtons.add(this.lessThanEqButton);
        comparisonButtons.add(this.lessThanButton);
        Dimension comparisonButtonsSize = new Dimension(75, 30);
        this.equalityButton.setPreferredSize(comparisonButtonsSize);
        this.greaterThanEqButton.setPreferredSize(comparisonButtonsSize);
        this.greaterThanButton.setPreferredSize(comparisonButtonsSize);
        this.inequalityButton.setPreferredSize(comparisonButtonsSize);
        this.lessThanEqButton.setPreferredSize(comparisonButtonsSize);
        this.lessThanButton.setPreferredSize(comparisonButtonsSize);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        comparisonPanel.add(this.colorTypeCombobox, gbc);
        this.comparisonButtonsPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.comparisonButtonsPanel.add((Component)this.equalityButton, gbc);
        gbc.gridx = 1;
        this.comparisonButtonsPanel.add((Component)this.inequalityButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.comparisonButtonsPanel.add((Component)this.greaterThanButton, gbc);
        gbc.gridx = 1;
        this.comparisonButtonsPanel.add((Component)this.greaterThanEqButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.comparisonButtonsPanel.add((Component)this.lessThanButton, gbc);
        gbc.gridx = 1;
        this.comparisonButtonsPanel.add((Component)this.lessThanEqButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.fill = 2;
        comparisonPanel.add((Component)this.comparisonButtonsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        this.add((Component)comparisonPanel, gbc);
        this.equalityButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new EqualityExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
        this.greaterThanEqButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new GreaterThanEqExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
        this.greaterThanButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new GreaterThanExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
        this.inequalityButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new InequalityExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
        this.lessThanButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new LessThanExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
        this.lessThanEqButton.addActionListener(actionEvent -> {
            Pair<ColorExpression, ColorExpression> pair = this.getLeftRightExpression(this.currentSelection.getObject());
            ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
            this.replaceAndAddToUndo(this.currentSelection.getObject(), new LessThanEqExpression((ColorExpression)pair.component1(), (ColorExpression)pair.component2(), type));
        });
    }

    private Vector<ColorExpression> createPlaceholderVectors(int size) {
        Vector<ColorExpression> colorExpressions = new Vector<ColorExpression>();
        ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
        for (int i = 0; i < size; ++i) {
            colorExpressions.add(new PlaceHolderColorExpression(type));
        }
        return colorExpressions;
    }

    private Pair<ColorExpression, ColorExpression> getLeftRightExpression(Expression currentSelection) {
        if (currentSelection instanceof LeftRightGuardExpression) {
            return new Pair((Object)((LeftRightGuardExpression)((Object)currentSelection)).getLeftExpression(), (Object)((LeftRightGuardExpression)((Object)currentSelection)).getRightExpression());
        }
        if (this.colorTypeCombobox.getSelectedItem() instanceof ProductType) {
            int size = ((ProductType)this.colorTypeCombobox.getSelectedItem()).size();
            Vector<ColorExpression> tempVec1 = this.createPlaceholderVectors(size);
            Vector<ColorExpression> tempVec2 = this.createPlaceholderVectors(size);
            return new Pair((Object)new TupleExpression(tempVec1, (ProductType)this.colorTypeCombobox.getSelectedItem()), (Object)new TupleExpression(tempVec2, (ProductType)this.colorTypeCombobox.getSelectedItem()));
        }
        ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
        return new Pair((Object)new PlaceHolderColorExpression(type), (Object)new PlaceHolderColorExpression(type));
    }

    private void initExprEditPanel() {
        JPanel editPanel = new JPanel(new GridBagLayout());
        editPanel.setBorder(BorderFactory.createTitledBorder("Editing"));
        ButtonGroup editButtonsGroup = new ButtonGroup();
        this.deleteExprSelectionButton = new JButton("Delete Selection");
        this.resetExprButton = new JButton("Reset Expression");
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.editExprButton = new JButton("Edit Expression");
        this.editExprButton.setEnabled(true);
        editButtonsGroup.add(this.deleteExprSelectionButton);
        editButtonsGroup.add(this.resetExprButton);
        editButtonsGroup.add(this.undoButton);
        editButtonsGroup.add(this.redoButton);
        editButtonsGroup.add(this.editExprButton);
        this.deleteExprSelectionButton.addActionListener(actionEvent -> this.deleteSelection());
        this.editExprButton.addActionListener(actionEvent -> {
            if (this.exprField.isEditable()) {
                this.returnFromManualEdit(null);
            } else {
                this.changeToEditMode();
            }
        });
        this.resetExprButton.addActionListener(actionEvent -> {
            if (this.exprField.isEditable()) {
                GuardExpression newExpression = null;
                try {
                    newExpression = GuardExpressionParser.parse(this.exprField.getText(), this.context.network());
                    if (newExpression instanceof OrExpression) {
                        ((OrExpression)newExpression).setSimpleProperty(true);
                    } else if (newExpression instanceof AndExpression) {
                        ((AndExpression)newExpression).setSimpleProperty(true);
                    }
                }
                catch (Throwable ex) {
                    int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "TAPAAL encountered an error trying to parse the specified Expression with the following error: \n\n" + ex.getMessage() + ".\n\nWe recommend using the expression construction buttons unless you are an experienced user.\n\n The specified expression has not been saved. Do you want to edit it again?", "Error Parsing Expression", 0, 0);
                    System.out.println(ex.getMessage());
                    if (choice == 1) {
                        this.returnFromManualEdit(null);
                    }
                    return;
                }
                if (newExpression != null) {
                    ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.newProperty, newExpression);
                    this.returnFromManualEdit(newExpression);
                    this.undoSupport.postEdit(edit);
                } else {
                    this.returnFromManualEdit(null);
                }
            } else {
                PlaceHolderGuardExpression phGuard = new PlaceHolderGuardExpression();
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.newProperty, phGuard);
                this.newProperty = this.newProperty.replace(this.newProperty, phGuard);
                this.updateSelection(phGuard);
                this.undoSupport.postEdit(edit);
            }
        });
        this.undoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToUndo();
            if (edit instanceof ExpressionConstructionEdit) {
                Expression original = ((ExpressionConstructionEdit)edit).getOriginal();
                this.undoManager.undo();
                this.refreshUndoRedo();
                this.updateSelection(original);
            }
        });
        this.redoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToRedo();
            if (edit instanceof ExpressionConstructionEdit) {
                Expression replacement = ((ExpressionConstructionEdit)edit).getReplacement();
                this.undoManager.redo();
                this.refreshUndoRedo();
                this.updateSelection(replacement);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        editPanel.add((Component)this.undoButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        editPanel.add((Component)this.redoButton, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        editPanel.add((Component)this.deleteExprSelectionButton, gbc);
        gbc.gridy = 2;
        editPanel.add((Component)this.resetExprButton, gbc);
        gbc.gridy = 3;
        editPanel.add((Component)this.editExprButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)editPanel, gbc);
    }

    private void initExprField() {
        this.exprField = new JTextPane();
        StyledDocument doc = this.exprField.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontSize(standard, 14);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.exprField.setBackground(Color.white);
        this.exprField.setEditable(false);
        this.exprField.setToolTipText("<html>Click on a part of the query you want to edit.<br />(Queries can also be edited manually by pressing the \"Edit Query\" button.)</html>");
        JScrollPane exprScrollPane = new JScrollPane(this.exprField);
        exprScrollPane.setVerticalScrollBarPolicy(20);
        Dimension d = new Dimension(100, 80);
        exprScrollPane.setPreferredSize(d);
        this.exprField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ColoredTransitionGuardPanel.this.exprField.isEditable()) {
                    ColoredTransitionGuardPanel.this.updateSelection();
                }
            }
        });
        this.exprField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!ColoredTransitionGuardPanel.this.exprField.isEditable()) {
                    if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                        ColoredTransitionGuardPanel.this.deleteSelection();
                    } else if (e.getKeyCode() == 39 || e.getKeyCode() == 37) {
                        e.consume();
                        int position = ColoredTransitionGuardPanel.this.exprField.getSelectionEnd();
                        if (e.getKeyCode() == 37) {
                            position = ColoredTransitionGuardPanel.this.exprField.getSelectionStart();
                        }
                        ColoredTransitionGuardPanel.this.changeToEditMode();
                        ColoredTransitionGuardPanel.this.exprField.setCaretPosition(position);
                    }
                } else if (e.getKeyChar() == '\n') {
                    ColoredTransitionGuardPanel.this.resetExprButton.doClick();
                    e.consume();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        this.add((Component)exprScrollPane, gbc);
    }

    public void initExpr(GuardExpression guard) {
        this.newProperty = new PlaceHolderGuardExpression();
        if (guard != null) {
            this.newProperty = guard.copy();
        }
        ColorType ct = this.newProperty.getColorType();
        this.doColorTypeUndo = false;
        if (this.colorTypeCombobox.getItemCount() > 0) {
            if (ct != null) {
                this.colorTypeCombobox.setSelectedItem(ct);
            } else {
                this.colorTypeCombobox.setSelectedIndex(0);
            }
        }
        this.doColorTypeUndo = true;
        this.updateSelection(this.newProperty);
        this.colorTypeCombobox.setEnabled(this.newProperty instanceof PlaceHolderGuardExpression);
    }

    private void addColor() {
        ColorExpression newExpression;
        ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
        if (type instanceof ProductType) {
            Object selectedElement = this.colorCombobox.getColorTypeComboBoxesArray()[0].getSelectedItem();
            newExpression = selectedElement instanceof String ? new AllExpression(((ProductType)this.colorCombobox.getColorType()).getColorTypes().get(0)) : (selectedElement instanceof Variable ? new VariableExpression((Variable)selectedElement, type) : (selectedElement instanceof PlaceHolderColorExpression ? new PlaceHolderColorExpression(type) : new UserOperatorExpression((dk.aau.cs.model.CPN.Color)selectedElement, type)));
        } else {
            ColorExpression oldExpression = (ColorExpression)this.currentSelection.getObject();
            Object selectedElement = this.colorCombobox.getColorTypeComboBoxesArray()[0].getSelectedItem();
            ColorExpression expr = selectedElement instanceof String ? new AllExpression(this.colorCombobox.getColorType()) : (selectedElement instanceof Variable ? new VariableExpression((Variable)selectedElement) : (selectedElement instanceof PlaceHolderColorExpression ? new PlaceHolderColorExpression(type) : new UserOperatorExpression((dk.aau.cs.model.CPN.Color)selectedElement)));
            if (oldExpression.getParent() instanceof TupleExpression) {
                expr.setParent(oldExpression.getParent());
                expr.setIndex(oldExpression.getIndex());
            }
            newExpression = expr;
        }
        if (this.currentSelection.getObject() instanceof ColorExpression) {
            this.replaceAndAddToUndo(this.currentSelection.getObject(), newExpression);
        }
    }

    private void updateEnabledButtons() {
        if (this.currentSelection == null) {
            this.andButton.setEnabled(false);
            this.orButton.setEnabled(false);
            this.notButton.setEnabled(false);
            this.equalityButton.setEnabled(false);
            this.inequalityButton.setEnabled(false);
            this.greaterThanButton.setEnabled(false);
            this.greaterThanEqButton.setEnabled(false);
            this.lessThanEqButton.setEnabled(false);
            this.lessThanButton.setEnabled(false);
            this.colorTypeCombobox.setEnabled(false);
            this.succButton.setEnabled(false);
            this.predButton.setEnabled(false);
            this.colorCombobox.setEnabled(false);
        } else if (this.currentSelection.getObject() instanceof ColorExpression) {
            this.andButton.setEnabled(false);
            this.orButton.setEnabled(false);
            this.notButton.setEnabled(false);
            this.equalityButton.setEnabled(false);
            this.inequalityButton.setEnabled(false);
            this.greaterThanButton.setEnabled(false);
            this.greaterThanEqButton.setEnabled(false);
            this.lessThanEqButton.setEnabled(false);
            this.lessThanButton.setEnabled(false);
            this.colorTypeCombobox.setEnabled(false);
            this.succButton.setEnabled(true);
            this.predButton.setEnabled(true);
            this.colorCombobox.setEnabled(true);
        } else if (this.currentSelection.getObject() instanceof GuardExpression) {
            this.andButton.setEnabled(true);
            this.orButton.setEnabled(true);
            this.notButton.setEnabled(true);
            this.equalityButton.setEnabled(true);
            this.inequalityButton.setEnabled(true);
            this.greaterThanButton.setEnabled(true);
            this.greaterThanEqButton.setEnabled(true);
            this.lessThanEqButton.setEnabled(true);
            this.lessThanButton.setEnabled(true);
            this.succButton.setEnabled(false);
            this.predButton.setEnabled(false);
            this.colorCombobox.setEnabled(false);
            this.colorTypeCombobox.setEnabled(this.currentSelection.getObject() instanceof LeftRightGuardExpression || this.currentSelection.getObject() instanceof PlaceHolderGuardExpression);
        }
        if (this.colorTypeCombobox.getItemAt(this.colorTypeCombobox.getSelectedIndex()) instanceof ProductType) {
            this.greaterThanButton.setEnabled(false);
            this.greaterThanEqButton.setEnabled(false);
            this.lessThanEqButton.setEnabled(false);
            this.lessThanButton.setEnabled(false);
            this.checkSelectionComparison();
        }
        this.parent.enableOKButton(!this.newProperty.containsPlaceHolder() || this.newProperty instanceof PlaceHolderExpression);
    }

    private void checkSelectionComparison() {
        if (this.currentSelection != null && (this.currentSelection.getObject() instanceof GreaterThanEqExpression || this.currentSelection.getObject() instanceof GreaterThanExpression || this.currentSelection.getObject() instanceof LessThanEqExpression || this.currentSelection.getObject() instanceof LessThanExpression)) {
            this.deleteSelection();
        }
    }

    private void updateSelection(Expression newSelection) {
        ExprStringPosition position;
        this.exprField.setText(this.newProperty.toString());
        if (this.newProperty.containsPlaceHolder()) {
            Expression ge = this.newProperty.findFirstPlaceHolder();
            position = this.newProperty.indexOf(ge);
        } else {
            position = this.newProperty.indexOf(newSelection);
        }
        this.exprField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.updateEnabledButtons();
        this.updateColorTypeSelection();
        this.updateColorSelection();
    }

    private void updateSelection() {
        int index = this.exprField.getCaretPosition();
        ExprStringPosition position = this.newProperty.objectAt(index);
        if (position == null) {
            return;
        }
        position = this.getNonTuplePosition(position, index);
        this.exprField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.updateEnabledButtons();
        this.updateColorTypeSelection();
        this.updateColorSelection();
    }

    private ExprStringPosition getNonTuplePosition(ExprStringPosition position, int index) {
        Expression selection = position.getObject();
        if (selection instanceof SuccessorExpression && ((SuccessorExpression)selection).getSuccessorExpression() instanceof TupleExpression) {
            return this.newProperty.objectAt(this.newProperty.indexOf(((SuccessorExpression)selection).getSuccessorExpression()).getEnd() - 1);
        }
        if (selection instanceof PredecessorExpression && ((PredecessorExpression)selection).getPredecessorExpression() instanceof TupleExpression) {
            return this.newProperty.objectAt(this.newProperty.indexOf(((PredecessorExpression)selection).getPredecessorExpression()).getEnd() - 1);
        }
        if (selection instanceof TupleExpression) {
            return this.newProperty.objectAt(index - 1);
        }
        return position;
    }

    private void updateColorTypeSelection() {
        this.doColorTypeUndo = false;
        if (this.currentSelection.getObject() instanceof ColorExpression) {
            this.colorTypeCombobox.setSelectedItem(((ColorExpression)this.currentSelection.getObject()).getColorType());
        } else if (this.currentSelection.getObject() instanceof LeftRightGuardExpression) {
            this.colorTypeCombobox.setSelectedItem(((GuardExpression)this.currentSelection.getObject()).getColorType());
        }
        this.doColorTypeUndo = true;
    }

    private void updateColorSelection() {
        this.updatingColorSelection = true;
        if (this.currentSelection.getObject() instanceof ColorExpression) {
            ColorType ct = this.colorTypeCombobox.getItemAt(this.colorTypeCombobox.getSelectedIndex());
            if (ct instanceof ProductType && !(this.currentSelection.getObject() instanceof TupleExpression)) {
                int currentIndex = ((ColorExpression)this.currentSelection.getObject()).getIndex();
                ColorType newColorType = currentIndex == -1 ? ((ProductType)ct).getConstituents().firstElement() : ((ProductType)ct).getConstituents().get(((ColorExpression)this.currentSelection.getObject()).getIndex());
                this.colorCombobox.updateColorType(newColorType, this.context, true, true);
            }
            ColorExpression exprToCheck = ((ColorExpression)this.currentSelection.getObject()).getBottomColorExpression();
            this.colorCombobox.updateSelection(exprToCheck);
        }
        this.updatingColorSelection = false;
    }

    private void addColorTypesToCombobox(List<ColorType> types) {
        this.colorTypeCombobox.removeAllItems();
        for (ColorType type : types) {
            this.colorTypeCombobox.addItem(type);
        }
        this.colorTypeCombobox.removeItem(ColorType.COLORTYPE_DOT);
    }

    private void deleteSelection() {
        if (this.currentSelection != null) {
            Expression replacement = null;
            if (this.currentSelection.getObject() instanceof GuardExpression) {
                replacement = new PlaceHolderGuardExpression();
            } else if (this.currentSelection.getObject() instanceof ColorExpression) {
                ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
                replacement = new PlaceHolderColorExpression(type);
            }
            if (replacement != null) {
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.currentSelection.getObject(), replacement);
                this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), replacement);
                this.updateSelection(replacement);
                this.undoSupport.postEdit(edit);
            }
        }
    }

    private void returnFromManualEdit(GuardExpression newExpr) {
        this.setExprFieldEditable(false);
        this.deleteExprSelectionButton.setEnabled(true);
        if (newExpr != null) {
            this.newProperty = newExpr;
        }
        this.updateSelection(this.newProperty);
        this.resetExprButton.setText("Reset Expression");
        this.editExprButton.setText("Edit Expression");
        this.updateEnabledButtons();
    }

    private void changeToEditMode() {
        this.setExprFieldEditable(true);
        this.deleteExprSelectionButton.setEnabled(false);
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.andButton.setEnabled(false);
        this.orButton.setEnabled(false);
        this.notButton.setEnabled(false);
        this.equalityButton.setEnabled(false);
        this.inequalityButton.setEnabled(false);
        this.greaterThanButton.setEnabled(false);
        this.greaterThanEqButton.setEnabled(false);
        this.lessThanEqButton.setEnabled(false);
        this.lessThanButton.setEnabled(false);
        this.succButton.setEnabled(false);
        this.predButton.setEnabled(false);
        this.colorCombobox.setEnabled(false);
        this.colorTypeCombobox.setEnabled(false);
        this.resetExprButton.setText("Parse Expression");
        this.editExprButton.setText("Cancel");
        this.clearSelection();
        this.exprField.setCaretPosition(this.exprField.getText().length());
    }

    private void clearSelection() {
        this.exprField.select(0, 0);
        this.currentSelection = null;
    }

    public GuardExpression getExpression() {
        return this.newProperty;
    }

    private void setExprFieldEditable(boolean isEditable) {
        this.exprField.setEditable(isEditable);
        this.exprField.setFocusable(false);
        this.exprField.setFocusable(true);
        this.exprField.requestFocus(true);
    }

    public void onOK(UndoManager undoManager) {
        SetTransitionExpressionCommand cmd = this.newProperty instanceof PlaceHolderGuardExpression ? new SetTransitionExpressionCommand(this.transition, this.transition.getGuardExpression(), null) : new SetTransitionExpressionCommand(this.transition, this.transition.getGuardExpression(), this.newProperty);
        cmd.redo();
        undoManager.addEdit(cmd);
    }

    private void replaceAndAddToUndo(Expression currentSelection, Expression newExpression) {
        if (currentSelection != null && newExpression != null) {
            ExpressionConstructionEdit edit = new ExpressionConstructionEdit(currentSelection, newExpression);
            this.newProperty = this.newProperty.replace(currentSelection, newExpression);
            this.updateSelection(newExpression);
            this.undoSupport.postEdit(edit);
        }
    }

    private void updateColorType() {
        ColorType ct = this.colorTypeCombobox.getItemAt(this.colorTypeCombobox.getSelectedIndex());
        if (ct != null) {
            this.colorCombobox.updateColorType(ct, this.context, true, true);
        }
        this.updateEnabledButtons();
        if (this.doColorTypeUndo && !(this.currentSelection.getObject() instanceof PlaceHolderGuardExpression)) {
            this.updateExpression();
        }
    }

    private void updateExpression() {
        ColorType ct = this.colorTypeCombobox.getItemAt(this.colorTypeCombobox.getSelectedIndex());
        if (ct == this.getColorType(this.currentSelection.getObject())) {
            return;
        }
        Expression oldProperty = this.currentSelection.getObject();
        if (this.doColorTypeUndo) {
            this.replaceAndAddToUndo(oldProperty, this.getTypeReplacement(ct));
        } else {
            this.newProperty = this.newProperty.replace(oldProperty, this.updateChildren(this.newProperty, ct, this.currentSelection.getObject(), this.currentSelection.getObject().getChildren()));
            this.updateSelection(this.newProperty);
        }
    }

    private Expression getTypeReplacement(ColorType ct) {
        Expression replacement = this.newProperty.copy();
        if ((replacement = this.findCurrentProperty(replacement, replacement)) != null) {
            return this.updateChildren(replacement, ct, replacement, replacement.getChildren());
        }
        return null;
    }

    private Expression findCurrentProperty(Expression original, Expression replacement) {
        if (original == replacement && replacement instanceof LeftRightGuardExpression) {
            return replacement;
        }
        for (ExprStringPosition exprStr : replacement.getChildren()) {
            if (exprStr.getObject() instanceof LeftRightGuardExpression) {
                if (original.indexOf(exprStr.getObject()).getStart() != this.currentSelection.getStart() || original.indexOf(exprStr.getObject()).getEnd() != this.currentSelection.getEnd()) continue;
                return exprStr.getObject().copy();
            }
            Expression expr = this.findCurrentProperty(original, exprStr.getObject());
            if (expr == null) continue;
            return expr;
        }
        return null;
    }

    private Expression updateChildren(Expression replaceProperty, ColorType ct, Expression parent, ExprStringPosition[] children) {
        for (ExprStringPosition child : children) {
            if (child.getObject() instanceof ColorExpression) {
                ColorExpression expr;
                if (ct instanceof ProductType) {
                    expr = new TupleExpression(this.createPlaceholderVectors(ct.size()), ct);
                } else {
                    ColorType type = (ColorType)this.colorTypeCombobox.getSelectedItem();
                    expr = new PlaceHolderColorExpression(type);
                }
                replaceProperty = replaceProperty.replace(child.getObject(), expr);
                continue;
            }
            if (!(parent instanceof GuardExpression) || !(child.getObject() instanceof LeftRightGuardExpression)) continue;
            replaceProperty = this.updateChildren(replaceProperty, ct, child.getObject(), child.getObject().getChildren());
        }
        return replaceProperty;
    }

    private ColorType getColorType(Expression expr) {
        if (expr instanceof ColorExpression) {
            return ((ColorExpression)expr).getColorType();
        }
        if (expr instanceof GuardExpression) {
            return ((GuardExpression)expr).getColorType();
        }
        return null;
    }

    public boolean showGuardPanel() {
        return this.colorTypeCombobox.getItemCount() > 0;
    }

    private void refreshUndoRedo() {
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    private void makeShortcuts() {
        int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ActionMap am = this.getActionMap();
        am.put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredTransitionGuardPanel.this.undoButton.doClick();
            }
        });
        am.put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredTransitionGuardPanel.this.redoButton.doClick();
            }
        });
        InputMap im = this.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(90, shortcutkey), "undo");
        im.put(KeyStroke.getKeyStroke(89, shortcutkey), "redo");
    }

    private static class ExpressionConstructionUndoManager
    extends javax.swing.undo.UndoManager {
        private ExpressionConstructionUndoManager() {
        }

        public UndoableEdit GetNextEditToUndo() {
            return this.editToBeUndone();
        }

        public UndoableEdit GetNextEditToRedo() {
            return this.editToBeRedone();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent arg0) {
            UndoableEdit edit = arg0.getEdit();
            ColoredTransitionGuardPanel.this.undoManager.addEdit(edit);
            ColoredTransitionGuardPanel.this.refreshUndoRedo();
        }
    }

    public class ExpressionConstructionEdit
    extends AbstractUndoableEdit {
        private final Expression original;
        private final ColorType originalColorType;
        private final Expression replacement;
        private final ColorType replacementColorType;

        public Expression getOriginal() {
            return this.original;
        }

        public Expression getReplacement() {
            return this.replacement;
        }

        public ExpressionConstructionEdit(Expression original, Expression replacement) {
            this.original = original;
            this.originalColorType = ColoredTransitionGuardPanel.this.getColorType(original);
            this.replacement = replacement;
            this.replacementColorType = ColoredTransitionGuardPanel.this.colorTypeCombobox.getItemAt(ColoredTransitionGuardPanel.this.colorTypeCombobox.getSelectedIndex());
        }

        @Override
        public void undo() throws CannotUndoException {
            ColoredTransitionGuardPanel.this.newProperty = ColoredTransitionGuardPanel.this.newProperty.replace(this.replacement, this.original);
            if (this.originalColorType != null) {
                ColoredTransitionGuardPanel.this.doColorTypeUndo = false;
                ColoredTransitionGuardPanel.this.colorTypeCombobox.setSelectedItem(this.originalColorType);
                ColoredTransitionGuardPanel.this.doColorTypeUndo = true;
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            ColoredTransitionGuardPanel.this.newProperty = ColoredTransitionGuardPanel.this.newProperty.replace(this.original, this.replacement);
            if (this.replacementColorType != null) {
                ColoredTransitionGuardPanel.this.doColorTypeUndo = false;
                ColoredTransitionGuardPanel.this.colorTypeCombobox.setSelectedItem(this.replacementColorType);
                ColoredTransitionGuardPanel.this.doColorTypeUndo = true;
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }
    }
}

