/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.TransportArc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.swingcomponents.WidthAdjustingComboBox;

public class ColoredTimeInvariantDialogPanel
extends JPanel {
    public static final String INF = Character.toString('\u221e');
    public static final String LEEQ = "<=";
    public static final String LE = "<";
    public static final String[] LEEQ_RELATION = new String[]{"<="};
    public static final String[] LEEQ_LE_RELATION = new String[]{"<=", "<"};
    public static final String[] LE_RELATION = new String[]{"<"};
    private JComboBox<String> invRelationNormal;
    private JComboBox<String> invRelationConstant;
    private CustomJSpinner invariantSpinner;
    private JCheckBox invariantInf;
    private JComboBox<String> invConstantsComboBox;
    private JRadioButton normalInvRadioButton;
    private JRadioButton constantInvRadioButton;
    private final JRootPane rootPane;
    private final Context context;
    private ColoredTimeInvariant oldTimeInvariant;
    private final TimedPlaceComponent place;

    public ColoredTimeInvariantDialogPanel(JRootPane rootPane, Context context, ColoredTimeInvariant cti, TimedPlaceComponent place) {
        this.context = context;
        this.oldTimeInvariant = cti;
        this.place = place;
        this.rootPane = rootPane;
        this.initPanel();
    }

    private void initPanel() {
        this.initInvariantPanel();
        this.setTimeInvariantVariables();
    }

    private void setTimeInvariantVariables() {
        if (this.oldTimeInvariant.upperBound().value() == -1) {
            this.invariantInf.setSelected(true);
            this.invariantCheckedEvent(false);
        } else {
            this.invariantInf.setSelected(false);
            this.invariantSpinner.setValue(this.oldTimeInvariant.upperBound().value());
            this.invariantCheckedEvent(false);
        }
    }

    private void setRelationModelForConstants() {
        int value = this.context.network().getConstantValue(Objects.requireNonNull(this.invConstantsComboBox.getSelectedItem()).toString());
        String selected = Objects.requireNonNull(this.invRelationConstant.getSelectedItem()).toString();
        if (value == 0) {
            this.invRelationConstant.setModel(new DefaultComboBoxModel<String>(LEEQ_RELATION));
        } else {
            this.invRelationConstant.setModel(new DefaultComboBoxModel<String>(LEEQ_LE_RELATION));
        }
        this.invRelationConstant.setSelectedItem(selected);
    }

    private void enableConstantInvariantComponents() {
        this.invRelationConstant.setEnabled(true);
        this.invConstantsComboBox.setEnabled(true);
        this.setRelationModelForConstants();
    }

    private void enableNormalInvariantComponents() {
        this.invRelationNormal.setEnabled(true);
        this.invariantInf.setEnabled(true);
        this.invariantSpinner.setValue(0);
        this.invariantInf.setSelected(true);
        this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LE_RELATION));
    }

    private void disableInvariantComponents() {
        this.invRelationNormal.setEnabled(false);
        this.invRelationConstant.setEnabled(false);
        this.invariantSpinner.setEnabled(false);
        this.invConstantsComboBox.setEnabled(false);
        this.invariantInf.setEnabled(false);
    }

    private boolean isUrgencyOK(boolean fromDialog) {
        for (TransportArc arc : this.context.activeModel().transportArcs()) {
            if (!arc.destination().equals(this.place.underlyingPlace()) || !arc.transition().isUrgent() || !this.place.hasInvariant() && !this.place.hasAnyColorInvariant() && !fromDialog) continue;
            JOptionPane.showMessageDialog(fromDialog ? this.rootPane : TAPAALGUI.getApp(), "Transport arcs going through urgent transitions cannot have an invariant at the destination.", "Error", 0);
            return false;
        }
        if (this.place.underlyingPlace().isShared()) {
            for (Template t : this.context.tabContent().allTemplates()) {
                for (TransportArc arc : t.model().transportArcs()) {
                    if (!arc.destination().equals(this.place.underlyingPlace()) || !arc.transition().isUrgent()) continue;
                    JOptionPane.showMessageDialog(this.rootPane, "Transport arcs going through urgent transitions cannot have an invariant at the destination.", "Error", 0);
                    return false;
                }
            }
        }
        return true;
    }

    private void invariantCheckedEvent(boolean fromDialog) {
        if (!this.isUrgencyOK(fromDialog)) {
            this.invariantInf.setSelected(true);
            return;
        }
        if (!this.invariantInf.isSelected()) {
            this.invRelationNormal.setEnabled(true);
            this.invariantSpinner.setEnabled(true);
            this.invRelationNormal.setSelectedItem(LEEQ);
            if ((Integer)this.invariantSpinner.getValue() < 1) {
                this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_RELATION));
            } else {
                this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_LE_RELATION));
            }
        } else {
            this.invRelationNormal.setEnabled(false);
            this.invariantSpinner.setEnabled(false);
            this.invRelationNormal.setSelectedItem(LE);
            this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LE_RELATION));
        }
    }

    private void initInvariantPanel() {
        JPanel timeInvariantPanel = new JPanel();
        timeInvariantPanel.setLayout(new GridBagLayout());
        timeInvariantPanel.setBorder(BorderFactory.createTitledBorder("Age Invariant"));
        JPanel invariantGroup = new JPanel(new GridBagLayout());
        this.invRelationNormal = new JComboBox<String>(LEEQ_LE_RELATION);
        this.invRelationConstant = new JComboBox<String>(LEEQ_LE_RELATION);
        this.invariantSpinner = new CustomJSpinner(0);
        this.invariantSpinner.addChangeListener(e -> {
            if (!this.invariantInf.isSelected()) {
                if ((Integer)this.invariantSpinner.getValue() < 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_RELATION));
                    this.invRelationNormal.setSelectedItem(LEEQ);
                } else if (this.invRelationNormal.getModel().getSize() == 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_LE_RELATION));
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        invariantGroup.add(this.invRelationNormal, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        invariantGroup.add(this.invRelationConstant, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        invariantGroup.add((Component)this.invariantSpinner, gbc);
        this.invariantInf = new JCheckBox(INF);
        this.invariantInf.addActionListener(arg0 -> this.invariantCheckedEvent(true));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        invariantGroup.add((Component)this.invariantInf, gbc);
        Set<String> constants = this.context.network().getConstantNames();
        String[] constantArray = constants.toArray(new String[0]);
        Arrays.sort(constantArray, String.CASE_INSENSITIVE_ORDER);
        int maxNumberOfPlacesToShowAtOnce = 20;
        this.invConstantsComboBox = new WidthAdjustingComboBox<String>(maxNumberOfPlacesToShowAtOnce);
        this.invConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.invConstantsComboBox.setMaximumRowCount(20);
        this.invConstantsComboBox.setPreferredSize(new Dimension(230, 30));
        this.invConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setRelationModelForConstants();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        invariantGroup.add(this.invConstantsComboBox, gbc);
        this.normalInvRadioButton = new JRadioButton("Normal");
        this.normalInvRadioButton.addActionListener(e -> {
            this.disableInvariantComponents();
            this.enableNormalInvariantComponents();
        });
        this.constantInvRadioButton = new JRadioButton("Constant");
        this.constantInvRadioButton.addActionListener(e -> {
            this.disableInvariantComponents();
            this.enableConstantInvariantComponents();
        });
        if (constants.isEmpty()) {
            this.constantInvRadioButton.setEnabled(false);
        }
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.normalInvRadioButton);
        btnGroup.add(this.constantInvRadioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        invariantGroup.add((Component)this.normalInvRadioButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        invariantGroup.add((Component)this.constantInvRadioButton, gbc);
        this.setInvariant(this.oldTimeInvariant);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        timeInvariantPanel.add((Component)invariantGroup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)timeInvariantPanel, gridBagConstraints);
    }

    public ColoredTimeInvariant getInvariant() {
        ColoredTimeInvariant cti;
        double spinnerValue = ((Integer)this.invariantSpinner.getValue()).intValue();
        IntBound bound = new IntBound((int)spinnerValue);
        if (this.constantInvRadioButton.isSelected()) {
            boolean nonStrict = LEEQ.equals(this.invRelationConstant.getSelectedItem());
            Constant constant = this.context.network().getConstant((String)this.invConstantsComboBox.getSelectedItem());
            cti = new ColoredTimeInvariant(nonStrict, new ConstantBound(constant), this.oldTimeInvariant.getColor());
        } else {
            cti = this.invariantInf.isSelected() ? new ColoredTimeInvariant(false, Bound.Infinity, this.oldTimeInvariant.getColor()) : (LEEQ.equals(this.invRelationNormal.getSelectedItem()) ? new ColoredTimeInvariant(true, bound, this.oldTimeInvariant.getColor()) : new ColoredTimeInvariant(false, bound, this.oldTimeInvariant.getColor()));
        }
        return cti;
    }

    public void setInvariant(ColoredTimeInvariant invariantToSet) {
        this.oldTimeInvariant = invariantToSet;
        if (invariantToSet.isUpperNonstrict()) {
            this.invRelationNormal.setSelectedItem(LEEQ_RELATION);
        } else {
            this.invRelationNormal.setSelectedItem(LE_RELATION);
        }
        if (invariantToSet.upperBound() instanceof Bound.InfBound) {
            this.invariantSpinner.setEnabled(false);
            this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LE_RELATION));
            this.invariantInf.setSelected(true);
            this.invRelationNormal.setSelectedItem(LE);
        }
        this.disableInvariantComponents();
        if (invariantToSet.upperBound() instanceof ConstantBound) {
            this.enableConstantInvariantComponents();
            this.constantInvRadioButton.setSelected(true);
            this.invConstantsComboBox.setSelectedItem(((ConstantBound)invariantToSet.upperBound()).name());
            this.invRelationConstant.setSelectedItem(invariantToSet.isUpperNonstrict() ? LEEQ : LE);
        } else {
            this.enableNormalInvariantComponents();
            this.normalInvRadioButton.setSelected(true);
            if (invariantToSet.upperBound() instanceof IntBound) {
                if ((Integer)this.invariantSpinner.getValue() < 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_RELATION));
                } else {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(LEEQ_LE_RELATION));
                }
                this.invariantSpinner.setValue(invariantToSet.upperBound().value());
                this.invariantSpinner.setEnabled(true);
                this.invRelationNormal.setSelectedItem(invariantToSet.isUpperNonstrict() ? LEEQ : LE);
                this.invariantInf.setSelected(false);
            }
        }
    }
}

