/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.IntBound;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import net.tapaal.gui.petrinet.Context;
import pipe.gui.swingcomponents.WidthAdjustingComboBox;

public class ColoredTimeIntervalDialogPanel
extends JPanel {
    ColoredTimeInterval coloredTimeInterval;
    private final Context context;
    JPanel guardEditPanel;
    JLabel label;
    JComboBox<String> leftDelimiter;
    JComboBox<String> rightDelimiter;
    JCheckBox inf;
    JSpinner secondIntervalNumber;
    JSpinner firstIntervalNumber;
    JCheckBox leftUseConstant;
    JComboBox<String> leftConstantsComboBox;
    JComboBox<String> rightConstantsComboBox;
    JCheckBox rightUseConstant;
    final int maxNumberOfPlacesToShowAtOnce = 20;

    public ColoredTimeIntervalDialogPanel(ColoredTimeInterval cti, Context context) {
        this.coloredTimeInterval = cti;
        this.context = context;
        this.initPanel();
        this.setTimeInterval(cti);
    }

    public ColoredTimeInterval getInterval() {
        return this.composeGuard(this.coloredTimeInterval);
    }

    public void setTimeInterval(ColoredTimeInterval cti) {
        boolean canUseConstants;
        SpinnerNumberModel spinnerModelForSecondNumber;
        String intervalAsString = cti.getInterval();
        this.coloredTimeInterval = cti;
        String[] partedTimeInterval = intervalAsString.split(",");
        String firstNumber = partedTimeInterval[0].substring(1);
        String secondNumber = partedTimeInterval[1].substring(0, partedTimeInterval[1].length() - 1);
        int first = 0;
        int second = 0;
        boolean firstIsNumber = true;
        boolean secondIsNumber = true;
        try {
            first = Integer.parseInt(firstNumber);
        }
        catch (NumberFormatException e) {
            firstIsNumber = false;
        }
        try {
            second = Integer.parseInt(secondNumber);
        }
        catch (NumberFormatException e) {
            secondIsNumber = false;
        }
        SpinnerNumberModel spinnerModelForFirstNumber = new SpinnerNumberModel(first, 0, Integer.MAX_VALUE, 1);
        boolean isInf = secondNumber.equals("inf");
        if (isInf) {
            this.inf.setSelected(true);
            this.secondIntervalNumber.setEnabled(false);
            this.rightDelimiter.setEnabled(false);
            spinnerModelForSecondNumber = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        } else {
            this.inf.setSelected(false);
            this.secondIntervalNumber.setEnabled(true);
            this.rightDelimiter.setEnabled(true);
            spinnerModelForSecondNumber = new SpinnerNumberModel(second, 0, Integer.MAX_VALUE, 1);
        }
        this.firstIntervalNumber.setModel(spinnerModelForFirstNumber);
        this.secondIntervalNumber.setModel(spinnerModelForSecondNumber);
        if (!firstIsNumber) {
            this.leftUseConstant.setSelected(true);
            this.leftConstantsComboBox.setSelectedItem(firstNumber);
            this.updateLeftComponents();
        }
        if (!secondIsNumber && !isInf) {
            this.rightUseConstant.setSelected(true);
            this.rightConstantsComboBox.setSelectedItem(secondNumber);
            this.updateRightComponents();
        }
        if (canUseConstants = this.rightUseConstant.isEnabled()) {
            this.updateRightConstantComboBox();
        }
        this.setDelimiterModels();
        if (intervalAsString.contains("[")) {
            this.leftDelimiter.setSelectedItem("[");
        } else {
            this.leftDelimiter.setSelectedItem("(");
        }
        if (intervalAsString.contains("]")) {
            this.rightDelimiter.setSelectedItem("]");
        } else {
            this.rightDelimiter.setSelectedItem(")");
        }
    }

    private ColoredTimeInterval composeGuard(ColoredTimeInterval oldGuard) {
        Bound rightInterval;
        Bound leftInterval;
        String constantName;
        boolean useConstantLeft = this.leftUseConstant.isSelected();
        boolean useConstantRight = this.rightUseConstant.isSelected();
        String leftDelim = Objects.requireNonNull(this.leftDelimiter.getSelectedItem()).toString();
        String rightDelim = Objects.requireNonNull(this.rightDelimiter.getSelectedItem()).toString();
        if (useConstantLeft) {
            constantName = Objects.requireNonNull(this.leftConstantsComboBox.getSelectedItem()).toString();
            leftInterval = new ConstantBound(this.context.network().getConstant(constantName));
        } else {
            leftInterval = new IntBound((Integer)this.firstIntervalNumber.getValue());
        }
        if (useConstantRight) {
            constantName = Objects.requireNonNull(this.rightConstantsComboBox.getSelectedItem()).toString();
            rightInterval = new ConstantBound(this.context.network().getConstant(constantName));
        } else {
            rightInterval = this.inf.isSelected() ? Bound.Infinity : new IntBound((Integer)this.secondIntervalNumber.getValue());
        }
        if (rightInterval instanceof Bound.InfBound || leftInterval.value() <= rightInterval.value()) {
            return new ColoredTimeInterval(leftDelim.equals("["), leftInterval, rightInterval, rightDelim.equals("]"), this.coloredTimeInterval.getColor());
        }
        return oldGuard;
    }

    private void initPanel() {
        this.guardEditPanel = new JPanel(new GridBagLayout());
        this.guardEditPanel.setBorder(BorderFactory.createTitledBorder("Time Guard"));
        this.label = new JLabel("Time Interval:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.guardEditPanel.add((Component)this.label, gridBagConstraints);
        String[] left = new String[]{"[", "("};
        this.leftDelimiter = new JComboBox();
        Dimension dims = new Dimension(55, 25);
        this.leftDelimiter.setPreferredSize(dims);
        this.leftDelimiter.setMinimumSize(dims);
        this.leftDelimiter.setMaximumSize(dims);
        this.leftDelimiter.setModel(new DefaultComboBoxModel<String>(left));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.leftDelimiter, gridBagConstraints);
        String[] right = new String[]{"]", ")"};
        this.rightDelimiter = new JComboBox();
        this.rightDelimiter.setPreferredSize(dims);
        this.rightDelimiter.setMinimumSize(dims);
        this.rightDelimiter.setMaximumSize(dims);
        this.rightDelimiter.setModel(new DefaultComboBoxModel<String>(right));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.rightDelimiter, gridBagConstraints);
        this.inf = new JCheckBox("inf", true);
        this.inf.addActionListener(evt -> {
            if (this.inf.isSelected()) {
                this.secondIntervalNumber.setEnabled(false);
                this.rightDelimiter.setEnabled(false);
            } else {
                this.secondIntervalNumber.setEnabled(true);
                this.rightDelimiter.setEnabled(true);
            }
            this.setDelimiterModels();
        });
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)this.inf, gridBagConstraints);
        this.initNonColoredTimeIntervalControls();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)this.guardEditPanel, gridBagConstraints);
    }

    private void initNonColoredTimeIntervalControls() {
        Dimension intervalBoxDims = new Dimension(190, 25);
        this.firstIntervalNumber = new JSpinner();
        this.firstIntervalNumber.setPreferredSize(intervalBoxDims);
        this.firstIntervalNumber.addChangeListener(this::firstSpinnerStateChanged);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.guardEditPanel.add((Component)this.firstIntervalNumber, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)new JLabel(" , "), gridBagConstraints);
        this.secondIntervalNumber = new JSpinner();
        this.secondIntervalNumber.setMaximumSize(intervalBoxDims);
        this.secondIntervalNumber.setMinimumSize(intervalBoxDims);
        this.secondIntervalNumber.setPreferredSize(intervalBoxDims);
        this.secondIntervalNumber.addChangeListener(this::secondSpinnerStateChanged);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)this.secondIntervalNumber, gridBagConstraints);
        Set<String> constants = this.context.network().getConstantNames();
        String[] constantArray = constants.toArray(new String[0]);
        Arrays.sort(constantArray, String.CASE_INSENSITIVE_ORDER);
        boolean enableConstantsCheckBoxes = !constants.isEmpty();
        this.leftUseConstant = new JCheckBox("Use Constant                    ");
        this.leftUseConstant.setEnabled(enableConstantsCheckBoxes);
        this.leftUseConstant.addActionListener(e -> {
            this.updateLeftComponents();
            this.updateRightConstantComboBox();
            this.setDelimiterModels();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.guardEditPanel.add((Component)this.leftUseConstant, gridBagConstraints);
        this.leftConstantsComboBox = new WidthAdjustingComboBox<String>(20);
        this.leftConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.leftConstantsComboBox.setMaximumRowCount(20);
        this.leftConstantsComboBox.setVisible(false);
        this.leftConstantsComboBox.setPreferredSize(intervalBoxDims);
        this.leftConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateRightConstantComboBox();
                this.setDelimiterModels();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.guardEditPanel.add(this.leftConstantsComboBox, gridBagConstraints);
        this.rightUseConstant = new JCheckBox("Use Constant                    ");
        this.rightUseConstant.setEnabled(enableConstantsCheckBoxes);
        this.rightUseConstant.addActionListener(e -> {
            this.updateRightComponents();
            this.updateRightConstantComboBox();
            this.setDelimiterModels();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.guardEditPanel.add((Component)this.rightUseConstant, gridBagConstraints);
        this.rightConstantsComboBox = new WidthAdjustingComboBox<String>(20);
        this.rightConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.rightConstantsComboBox.setMaximumRowCount(20);
        this.rightConstantsComboBox.setVisible(false);
        this.rightConstantsComboBox.setPreferredSize(intervalBoxDims);
        gridBagConstraints = new GridBagConstraints();
        this.rightConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setDelimiterModels();
            }
        });
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.guardEditPanel.add(this.rightConstantsComboBox, gridBagConstraints);
    }

    private void setDelimiterModels() {
        int firstValue = this.getFirstValue();
        int secondValue = this.getSecondValue();
        DefaultComboBoxModel<String> modelRightIncludedOnly = new DefaultComboBoxModel<String>(new String[]{"]"});
        DefaultComboBoxModel<String> modelLeftIncludedOnly = new DefaultComboBoxModel<String>(new String[]{"["});
        DefaultComboBoxModel<String> modelRightBoth = new DefaultComboBoxModel<String>(new String[]{"]", ")"});
        DefaultComboBoxModel<String> modelLeftBoth = new DefaultComboBoxModel<String>(new String[]{"[", "("});
        DefaultComboBoxModel<String> modelRightExcludedOnly = new DefaultComboBoxModel<String>(new String[]{")"});
        if (firstValue > secondValue) {
            this.secondIntervalNumber.setValue(firstValue);
            secondValue = firstValue;
        }
        String leftOldDelim = Objects.requireNonNull(this.leftDelimiter.getSelectedItem()).toString();
        String rightOldDelim = Objects.requireNonNull(this.rightDelimiter.getSelectedItem()).toString();
        if (firstValue == secondValue) {
            this.rightDelimiter.setModel(modelRightIncludedOnly);
            this.leftDelimiter.setModel(modelLeftIncludedOnly);
        } else {
            this.leftDelimiter.setModel(modelLeftBoth);
            if (this.inf.isSelected() && !this.rightUseConstant.isSelected()) {
                this.rightDelimiter.setModel(modelRightExcludedOnly);
            } else {
                this.rightDelimiter.setModel(modelRightBoth);
            }
        }
        this.leftDelimiter.setSelectedItem(leftOldDelim);
        if (this.rightUseConstant.isSelected()) {
            this.rightDelimiter.setSelectedItem("]");
        } else {
            this.rightDelimiter.setSelectedItem(rightOldDelim);
        }
    }

    private void secondSpinnerStateChanged(ChangeEvent evt) {
        this.setDelimiterModels();
    }

    private void firstSpinnerStateChanged(ChangeEvent evt) {
        int firstValue = this.getFirstValue();
        int secondValue = this.getSecondValue();
        if (this.rightUseConstant.isSelected() && firstValue > secondValue) {
            this.rightUseConstant.setSelected(false);
            this.updateRightComponents();
        }
        if (firstValue > this.context.network().getLargestConstantValue()) {
            this.rightUseConstant.setEnabled(false);
        } else {
            this.rightUseConstant.setEnabled(true);
            this.updateRightConstantComboBox();
        }
        this.setDelimiterModels();
    }

    private void updateLeftComponents() {
        boolean value = this.leftUseConstant.isSelected();
        this.firstIntervalNumber.setVisible(!value);
        this.leftConstantsComboBox.setVisible(value);
        this.setDelimiterModels();
    }

    private int getSecondValue() {
        int secondValue = this.rightUseConstant.isSelected() ? this.context.network().getConstantValue(Objects.requireNonNull(this.rightConstantsComboBox.getSelectedItem()).toString()) : (this.inf.isSelected() ? Integer.MAX_VALUE : Integer.parseInt(String.valueOf(this.secondIntervalNumber.getValue())));
        return secondValue;
    }

    private int getFirstValue() {
        int firstValue = this.leftUseConstant.isSelected() ? this.context.network().getConstantValue(Objects.requireNonNull(this.leftConstantsComboBox.getSelectedItem()).toString()) : Integer.parseInt(String.valueOf(this.firstIntervalNumber.getValue()));
        return firstValue;
    }

    private void updateRightConstantComboBox() {
        int value = this.getFirstValue();
        String oldRight = this.rightConstantsComboBox.getSelectedItem() != null ? this.rightConstantsComboBox.getSelectedItem().toString() : null;
        this.rightConstantsComboBox.removeAllItems();
        Collection<Constant> constants = this.context.network().constants();
        ArrayList<Constant> constantList = new ArrayList<Constant>(constants);
        constantList.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        for (Constant c : constantList) {
            if (c.value() < value) continue;
            this.rightConstantsComboBox.addItem(c.name());
        }
        this.rightUseConstant.setEnabled(this.rightConstantsComboBox.getItemCount() != 0);
        if (oldRight != null) {
            this.rightConstantsComboBox.setSelectedItem(oldRight);
        }
    }

    private void updateRightComponents() {
        boolean value = this.rightUseConstant.isSelected();
        this.inf.setVisible(!value);
        if (value) {
            this.rightDelimiter.setEnabled(true);
        } else {
            this.rightDelimiter.setEnabled(!this.inf.isSelected());
        }
        this.secondIntervalNumber.setVisible(!value);
        this.rightConstantsComboBox.setVisible(value);
        this.setDelimiterModels();
    }
}

