/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ArcExpressionParser.ArcExpressionParser;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderArcExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderColorExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderExpression;
import dk.aau.cs.model.CPN.Expressions.PredecessorExpression;
import dk.aau.cs.model.CPN.Expressions.ScalarProductExpression;
import dk.aau.cs.model.CPN.Expressions.SubtractExpression;
import dk.aau.cs.model.CPN.Expressions.SuccessorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Expressions.VariableExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TransportArc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.ColorComboboxPanel;
import net.tapaal.gui.petrinet.editor.ColoredTimeIntervalDialogPanel;
import net.tapaal.gui.petrinet.undo.Colored.SetArcExpressionCommand;
import net.tapaal.gui.petrinet.undo.Colored.SetColoredArcIntervalsCommand;
import net.tapaal.gui.petrinet.undo.Colored.SetTransportArcExpressionsCommand;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.petrinet.undo.UndoManager;

public abstract class ColoredArcGuardPanel
extends JPanel {
    final PetriNetObject objectToBeEdited;
    boolean isTransportArc = false;
    boolean isInputTransportArc = false;
    boolean isInputArc = false;
    boolean isInhibitorArc = false;
    private boolean updatingSelection = false;
    final Context context;
    final ExpressionConstructionUndoManager undoManager;
    final UndoableEditSupport undoSupport;
    private final ColorType colorType;
    private ColorType selectedColorType;
    private JPanel regularArcExprPanel;
    JPanel nonDefaultArcColorIntervalPanel;
    DefaultListModel timeConstraintListModel;
    JList timeConstraintList;
    private ExprStringPosition currentSelection = null;
    JSpinner numberExpressionJSpinner;
    private ArcExpression arcExpression;
    private JTextPane exprField;
    JButton allExpressionButton;
    JButton addTimeConstraintButton;
    JButton removeTimeConstraintButton;
    JButton editTimeConstraintButton;
    JButton deleteExprSelectionButton;
    JButton resetExprButton;
    JButton undoButton;
    JButton redoButton;
    JButton editExprButton;
    JButton additionButton;
    JButton subtractionButton;
    JButton scalarButton;
    JSpinner scalarJSpinner;
    ColorComboboxPanel colorIntervalComboboxPanel;
    ColoredTimeIntervalDialogPanel intervalEditorPanel;
    JPanel colorExpressionButtons;
    JButton predButton;
    JButton succButton;
    ColorComboboxPanel colorExpressionComboBoxPanel;
    JPanel numberExprPanel;

    public ColoredArcGuardPanel(PetriNetObject objectToBeEdited, Context context) {
        this.objectToBeEdited = objectToBeEdited;
        if (objectToBeEdited instanceof TimedTransportArcComponent) {
            this.isTransportArc = true;
            if (((TimedTransportArcComponent)objectToBeEdited).getSource() instanceof Place) {
                this.isInputTransportArc = true;
            }
        } else if (objectToBeEdited instanceof TimedInhibitorArcComponent) {
            this.isInhibitorArc = true;
        }
        if (((Arc)objectToBeEdited).getSource() instanceof Place) {
            this.isInputArc = true;
            this.colorType = ((TimedPlaceComponent)((Arc)objectToBeEdited).getSource()).underlyingPlace().getColorType();
        } else {
            this.colorType = this.isTransportArc ? ((TimedTransportArcComponent)objectToBeEdited).underlyingTransportArc().destination().getColorType() : ((TimedOutputArcComponent)objectToBeEdited).underlyingArc().destination().getColorType();
        }
        this.context = context;
        this.selectedColorType = this.colorType;
        this.setLayout(new GridBagLayout());
        this.initPanels();
        this.initExpr();
        this.setTimeConstraints();
        this.hideIrrelevantInformation();
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoManager = new ExpressionConstructionUndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedo();
        this.makeShortcuts();
    }

    public void hideIrrelevantInformation() {
        if (!this.objectToBeEdited.isTimed() && this.isInputArc && this.nonDefaultArcColorIntervalPanel != null) {
            this.nonDefaultArcColorIntervalPanel.setVisible(false);
        }
        if (this.isTransportArc) {
            this.additionButton.setEnabled(false);
            this.subtractionButton.setEnabled(false);
            this.scalarButton.setEnabled(false);
            this.scalarJSpinner.setEnabled(false);
        }
    }

    private void initPanels() {
        this.initRegularArcExpressionPanel();
        if (this.isInputArc && !this.isInhibitorArc) {
            this.initNonDefaultColorIntervalPanel();
        }
    }

    private void initNonDefaultColorIntervalPanel() {
        this.nonDefaultArcColorIntervalPanel = new JPanel(new GridBagLayout());
        JPanel colorIntervalEditPanel = new JPanel(new GridBagLayout());
        this.nonDefaultArcColorIntervalPanel.setBorder(BorderFactory.createTitledBorder("Color specific time intervals"));
        this.colorIntervalComboboxPanel = new ColorComboboxPanel(this.colorType){

            @Override
            public void changedColor(JComboBox[] comboBoxes) {
                ColoredTimeInterval timeConstraint;
                if (!(ColoredArcGuardPanel.this.colorType instanceof ProductType)) {
                    timeConstraint = ColoredTimeInterval.ZERO_INF_DYN_COLOR((dk.aau.cs.model.CPN.Color)comboBoxes[0].getItemAt(comboBoxes[0].getSelectedIndex()));
                } else {
                    Vector<dk.aau.cs.model.CPN.Color> colors = new Vector<dk.aau.cs.model.CPN.Color>();
                    for (JComboBox comboBox : comboBoxes) {
                        colors.add((dk.aau.cs.model.CPN.Color)comboBox.getItemAt(comboBox.getSelectedIndex()));
                    }
                    dk.aau.cs.model.CPN.Color color = new dk.aau.cs.model.CPN.Color(ColoredArcGuardPanel.this.colorType, (Integer)0, colors);
                    timeConstraint = ColoredTimeInterval.ZERO_INF_DYN_COLOR(color);
                }
                boolean alreadyExists = false;
                for (int i = 0; i < ColoredArcGuardPanel.this.timeConstraintListModel.size(); ++i) {
                    if (!timeConstraint.equalsOnlyColor(ColoredArcGuardPanel.this.timeConstraintListModel.get(i))) continue;
                    ColoredArcGuardPanel.this.intervalEditorPanel.setTimeInterval((ColoredTimeInterval)ColoredArcGuardPanel.this.timeConstraintListModel.get(i));
                    ColoredArcGuardPanel.this.addTimeConstraintButton.setText("Modify");
                    alreadyExists = true;
                }
                if (!alreadyExists) {
                    ColoredArcGuardPanel.this.intervalEditorPanel.setTimeInterval(timeConstraint);
                    ColoredArcGuardPanel.this.addTimeConstraintButton.setText("Add");
                }
            }
        };
        this.colorIntervalComboboxPanel.removeScrollPaneBorder();
        this.addTimeConstraintButton = new JButton("Add");
        this.removeTimeConstraintButton = new JButton("Remove");
        Dimension buttonSize = new Dimension(80, 27);
        this.addTimeConstraintButton.setPreferredSize(buttonSize);
        this.removeTimeConstraintButton.setPreferredSize(buttonSize);
        this.timeConstraintListModel = new DefaultListModel();
        this.timeConstraintList = new JList(this.timeConstraintListModel);
        this.timeConstraintList.setSelectionMode(1);
        this.timeConstraintListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                ColoredArcGuardPanel.this.timeConstraintList.setSelectedIndex(arg0.getIndex0());
                ColoredArcGuardPanel.this.timeConstraintList.ensureIndexIsVisible(arg0.getIndex0());
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                ColoredArcGuardPanel.this.timeConstraintList.setSelectedIndex(index);
                ColoredArcGuardPanel.this.timeConstraintList.ensureIndexIsVisible(index);
            }
        });
        this.timeConstraintList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList source = (JList)listSelectionEvent.getSource();
                if (source.getSelectedIndex() >= 0 && source.getModel().getSize() > 0) {
                    ColoredTimeInterval cti = (ColoredTimeInterval)source.getModel().getElementAt(source.getSelectedIndex());
                    this.intervalEditorPanel.setTimeInterval(cti);
                    this.colorIntervalComboboxPanel.updateSelection(cti.getColor());
                    this.addTimeConstraintButton.setText("Modify");
                }
                this.removeTimeConstraintButton.setEnabled(!this.timeConstraintList.isSelectionEmpty());
            }
        });
        JScrollPane timeConstraintScrollPane = new JScrollPane(this.timeConstraintList);
        timeConstraintScrollPane.setViewportView(this.timeConstraintList);
        timeConstraintScrollPane.setVerticalScrollBarPolicy(20);
        timeConstraintScrollPane.setBorder(BorderFactory.createTitledBorder("Time interval for colors"));
        this.addTimeConstraintButton.addActionListener(actionEvent -> {
            ColoredTimeInterval timeConstraint = this.intervalEditorPanel.getInterval();
            boolean alreadyExists = false;
            for (int i = 0; i < this.timeConstraintListModel.size(); ++i) {
                if (!timeConstraint.equalsOnlyColor(this.timeConstraintListModel.get(i))) continue;
                alreadyExists = true;
                this.timeConstraintListModel.setElementAt(timeConstraint, i);
            }
            if (!alreadyExists) {
                this.timeConstraintListModel.addElement(timeConstraint);
            }
        });
        this.removeTimeConstraintButton.addActionListener(actionEvent -> {
            for (Object o : this.timeConstraintList.getSelectedValuesList()) {
                this.timeConstraintListModel.removeElement(o);
            }
            if (this.timeConstraintListModel.isEmpty()) {
                this.addTimeConstraintButton.setText("Add");
            } else {
                this.timeConstraintList.setSelectedIndex(0);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        colorIntervalEditPanel.add((Component)this.colorIntervalComboboxPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.addTimeConstraintButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.removeTimeConstraintButton, gbc);
        ColoredTimeInterval cti = null;
        if (this.isTransportArc) {
            cti = ((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc().getColorTimeIntervals().isEmpty() ? ColoredTimeInterval.ZERO_INF_DYN_COLOR(((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc().source().getColorType().getFirstColor()) : ((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc().getColorTimeIntervals().get(0);
        } else if (this.isInputArc && !this.isInhibitorArc) {
            cti = ((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc().getColorTimeIntervals().isEmpty() ? ColoredTimeInterval.ZERO_INF_DYN_COLOR(((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc().source().getColorType().getFirstColor()) : ((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc().getColorTimeIntervals().get(0);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.intervalEditorPanel = new ColoredTimeIntervalDialogPanel(cti, this.context);
        colorIntervalEditPanel.add((Component)this.intervalEditorPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 13;
        colorIntervalEditPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        this.nonDefaultArcColorIntervalPanel.add((Component)colorIntervalEditPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.nonDefaultArcColorIntervalPanel.add((Component)timeConstraintScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.nonDefaultArcColorIntervalPanel, gbc);
    }

    private void initRegularArcExpressionPanel() {
        this.regularArcExprPanel = new JPanel(new GridBagLayout());
        this.initExprField();
        this.initNumberExpressionsPanel();
        this.initArithmeticPanel();
        this.initEditPanel();
        this.initColorExpressionButtonsPanel();
        this.regularArcExprPanel.setBorder(BorderFactory.createTitledBorder("Arc Expression"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 1;
        gbc.anchor = 17;
        this.add((Component)this.regularArcExprPanel, gbc);
    }

    private void initEditPanel() {
        JPanel editPanel = new JPanel(new GridBagLayout());
        editPanel.setBorder(BorderFactory.createTitledBorder("Editing"));
        editPanel.setPreferredSize(new Dimension(260, 190));
        ButtonGroup editButtonsGroup = new ButtonGroup();
        this.deleteExprSelectionButton = new JButton("Delete Selection");
        this.resetExprButton = new JButton("Reset Expression");
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.editExprButton = new JButton("Edit Expression");
        this.editExprButton.setEnabled(true);
        editButtonsGroup.add(this.deleteExprSelectionButton);
        editButtonsGroup.add(this.resetExprButton);
        editButtonsGroup.add(this.undoButton);
        editButtonsGroup.add(this.redoButton);
        editButtonsGroup.add(this.editExprButton);
        this.editExprButton.addActionListener(actionEvent -> {
            if (this.exprField.isEditable()) {
                this.returnFromManualEdit(null);
            } else {
                this.changeToEditMode();
            }
        });
        this.deleteExprSelectionButton.addActionListener(actionEvent -> this.deleteSelection());
        this.resetExprButton.addActionListener(actionEvent -> {
            if (this.exprField.isEditable()) {
                ArcExpression newExpression = null;
                try {
                    newExpression = !this.isTransportArc ? ArcExpressionParser.parse(this.exprField.getText(), this.colorType, this.context.network()) : ArcExpressionParser.parseNumberOfExpression(this.exprField.getText(), this.colorType, this.context.network());
                }
                catch (Throwable ex) {
                    int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "TAPAAL encountered an error trying to parse the specified expression with the following error: \n\n" + ex.getMessage() + ".\n\nWe recommend using the expression construction buttons unless you are an experienced user.\n\n The specified expression has not been saved. Do you want to edit it again?", "Error Parsing Expression", 0, 0);
                    System.out.println(ex.getMessage());
                    if (choice == 1) {
                        this.returnFromManualEdit(null);
                    }
                    return;
                }
                if (newExpression != null) {
                    ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.arcExpression, newExpression);
                    this.returnFromManualEdit(newExpression);
                    this.undoSupport.postEdit(edit);
                } else {
                    this.returnFromManualEdit(null);
                }
            } else {
                PlaceHolderArcExpression pHExpr = new PlaceHolderArcExpression();
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.arcExpression, pHExpr);
                this.arcExpression = this.arcExpression.replace(this.arcExpression, pHExpr);
                this.updateSelection(pHExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        this.undoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToUndo();
            if (edit instanceof ExpressionConstructionEdit) {
                Expression original = ((ExpressionConstructionEdit)edit).getOriginal();
                this.undoManager.undo();
                this.refreshUndoRedo();
                this.updateSelection(original);
            }
        });
        this.redoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToRedo();
            if (edit instanceof ExpressionConstructionEdit) {
                Expression replacement = ((ExpressionConstructionEdit)edit).getReplacement();
                this.undoManager.redo();
                this.refreshUndoRedo();
                this.updateSelection(replacement);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        editPanel.add((Component)this.undoButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        editPanel.add((Component)this.redoButton, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        editPanel.add((Component)this.deleteExprSelectionButton, gbc);
        gbc.gridy = 2;
        editPanel.add((Component)this.resetExprButton, gbc);
        gbc.gridy = 3;
        editPanel.add((Component)this.editExprButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.regularArcExprPanel.add((Component)editPanel, gbc);
    }

    private void initArithmeticPanel() {
        JPanel arithmeticPanel = new JPanel(new GridBagLayout());
        arithmeticPanel.setBorder(BorderFactory.createTitledBorder("Arithmetic Operators"));
        this.additionButton = new JButton("Addition");
        this.subtractionButton = new JButton("Subtraction");
        this.scalarButton = new JButton("Scalar");
        Integer current = 1;
        Integer min = 1;
        Integer max = 999;
        Integer step = 1;
        SpinnerNumberModel numberModelScalar = new SpinnerNumberModel(current, min, max, step);
        this.scalarJSpinner = new JSpinner(numberModelScalar);
        this.scalarJSpinner.setPreferredSize(new Dimension(50, 27));
        this.scalarJSpinner.setPreferredSize(new Dimension(50, 27));
        this.scalarJSpinner.setPreferredSize(new Dimension(50, 27));
        this.additionButton.setPreferredSize(new Dimension(110, 30));
        this.additionButton.setMinimumSize(new Dimension(110, 30));
        this.additionButton.setMaximumSize(new Dimension(110, 30));
        this.subtractionButton.setPreferredSize(new Dimension(110, 30));
        this.subtractionButton.setMinimumSize(new Dimension(110, 30));
        this.subtractionButton.setMaximumSize(new Dimension(110, 30));
        this.scalarButton.setPreferredSize(new Dimension(110, 30));
        this.scalarButton.setMinimumSize(new Dimension(110, 30));
        this.scalarButton.setMaximumSize(new Dimension(110, 30));
        this.additionButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ArcExpression) {
                ArcExpression selectedExpr = (ArcExpression)this.currentSelection.getObject();
                NumberOfExpression newExpr = new NumberOfExpression(1, this.getPlaceholderVec());
                Vector<ArcExpression> exprArc = new Vector<ArcExpression>();
                exprArc.add(selectedExpr);
                exprArc.add(newExpr);
                AddExpression addExpr = new AddExpression(exprArc);
                selectedExpr.setParent(addExpr);
                newExpr.setParent(addExpr);
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(selectedExpr, addExpr);
                this.arcExpression = this.arcExpression.replace(selectedExpr, addExpr);
                this.updateSelection(newExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        this.subtractionButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ArcExpression) {
                ArcExpression selectedExpr = (ArcExpression)this.currentSelection.getObject();
                NumberOfExpression rightExpr = new NumberOfExpression(1, this.getPlaceholderVec());
                SubtractExpression subExpr = new SubtractExpression(selectedExpr, rightExpr);
                selectedExpr.setParent(subExpr);
                rightExpr.setParent(subExpr);
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(selectedExpr, subExpr);
                this.arcExpression = this.arcExpression.replace(selectedExpr, subExpr);
                this.updateSelection(rightExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        this.scalarButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ArcExpression) {
                ArcExpression selectedExpr = (ArcExpression)this.currentSelection.getObject();
                Integer value = (Integer)this.scalarJSpinner.getValue();
                ScalarProductExpression scalarExpr = new ScalarProductExpression(value, selectedExpr);
                selectedExpr.setParent(scalarExpr);
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(selectedExpr, scalarExpr);
                this.arcExpression = this.arcExpression.replace(selectedExpr, scalarExpr);
                this.updateSelection(scalarExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 17;
        arithmeticPanel.add((Component)this.additionButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(2, 0, 2, 0);
        gbc.fill = 2;
        arithmeticPanel.add((Component)this.subtractionButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        arithmeticPanel.add((Component)this.scalarJSpinner, gbc);
        gbc.gridx = 1;
        arithmeticPanel.add((Component)this.scalarButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        this.regularArcExprPanel.add((Component)arithmeticPanel, gbc);
    }

    private Vector<ColorExpression> getPlaceholderVec() {
        Vector<ColorExpression> vec = new Vector<ColorExpression>();
        ColorExpression c = this.getColorExpression().get(0);
        if (c instanceof TupleExpression) {
            int size = ((TupleExpression)c).getColors().size();
            vec.add(this.createPlaceholderTuple(size));
        } else {
            vec.add(new PlaceHolderColorExpression());
        }
        return vec;
    }

    private TupleExpression createPlaceholderTuple(int size) {
        Vector<ColorExpression> placeholders = new Vector<ColorExpression>();
        for (int i = 0; i < size; ++i) {
            placeholders.add(new PlaceHolderColorExpression());
        }
        return new TupleExpression(placeholders);
    }

    private void initNumberExpressionsPanel() {
        this.numberExprPanel = new JPanel(new GridBagLayout());
        this.numberExprPanel.setBorder(BorderFactory.createTitledBorder("Numerical Expressions"));
        this.colorExpressionComboBoxPanel = new ColorComboboxPanel(this.colorType, !this.isTransportArc){

            @Override
            public void changedColor(JComboBox[] comboBoxes) {
                if (!ColoredArcGuardPanel.this.updatingSelection) {
                    ColoredArcGuardPanel.this.addNumberExpression((Integer)ColoredArcGuardPanel.this.numberExpressionJSpinner.getValue(), ColoredArcGuardPanel.this.getColorExpression());
                }
            }
        };
        this.colorExpressionComboBoxPanel.removeScrollPaneBorder();
        Integer current = 1;
        Integer min = 1;
        Integer max = 999;
        Integer step = 1;
        SpinnerNumberModel numberModelNumber = new SpinnerNumberModel(current, min, max, step);
        this.numberExpressionJSpinner = new JSpinner(numberModelNumber);
        this.numberExpressionJSpinner.setPreferredSize(new Dimension(50, 27));
        this.numberExpressionJSpinner.setMinimumSize(new Dimension(50, 27));
        this.numberExpressionJSpinner.setMaximumSize(new Dimension(50, 27));
        this.numberExpressionJSpinner.addChangeListener(ChangeEvent2 -> this.addNumberExpression((Integer)this.numberExpressionJSpinner.getValue(), this.getColorOfSelection()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 5);
        this.numberExprPanel.add((Component)this.numberExpressionJSpinner, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.numberExprPanel.add((Component)this.colorExpressionComboBoxPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.regularArcExprPanel.add((Component)this.numberExprPanel, gbc);
    }

    private void initExprField() {
        this.exprField = new JTextPane();
        StyledDocument doc = this.exprField.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontSize(standard, 14);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.exprField.setBackground(Color.white);
        this.exprField.setEditable(false);
        this.exprField.setToolTipText("<html>Click on a part of the query you want to edit.<br />(Queries can also be edited manually by pressing the \"Edit Query\" button.)</html>");
        JScrollPane exprScrollPane = new JScrollPane(this.exprField);
        exprScrollPane.setVerticalScrollBarPolicy(20);
        Dimension d = new Dimension(100, 80);
        exprScrollPane.setPreferredSize(d);
        this.exprField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ColoredArcGuardPanel.this.exprField.isEditable()) {
                    ColoredArcGuardPanel.this.updateSelection();
                }
            }
        });
        this.exprField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!ColoredArcGuardPanel.this.exprField.isEditable()) {
                    if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                        ColoredArcGuardPanel.this.deleteSelection();
                    } else if (e.getKeyCode() == 39 || e.getKeyCode() == 37) {
                        e.consume();
                        int position = ColoredArcGuardPanel.this.exprField.getSelectionEnd();
                        if (e.getKeyCode() == 37) {
                            position = ColoredArcGuardPanel.this.exprField.getSelectionStart();
                        }
                        ColoredArcGuardPanel.this.changeToEditMode();
                        ColoredArcGuardPanel.this.exprField.setCaretPosition(position);
                    }
                } else if (e.getKeyChar() == '\n') {
                    ColoredArcGuardPanel.this.resetExprButton.doClick();
                    e.consume();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        this.regularArcExprPanel.add((Component)exprScrollPane, gbc);
    }

    private Vector<ColorExpression> getColorExpression() {
        Vector<ColorExpression> exprVec = new Vector<ColorExpression>();
        if (this.selectedColorType instanceof ProductType) {
            Vector<ColorExpression> tempVec = new Vector<ColorExpression>();
            for (int i = 0; i < this.colorExpressionComboBoxPanel.getColorTypeComboBoxesArray().length; ++i) {
                Object selectedElement = this.colorExpressionComboBoxPanel.getColorTypeComboBoxesArray()[i].getSelectedItem();
                ColorExpression expr = selectedElement instanceof PlaceHolderColorExpression ? new PlaceHolderColorExpression() : (selectedElement instanceof String ? new AllExpression(((ProductType)this.colorExpressionComboBoxPanel.getColorType()).getColorTypes().get(i)) : (selectedElement instanceof Variable ? new VariableExpression((Variable)selectedElement) : new UserOperatorExpression((dk.aau.cs.model.CPN.Color)selectedElement)));
                tempVec.add(expr);
            }
            TupleExpression tupleExpression = new TupleExpression(tempVec);
            exprVec.add(tupleExpression);
        } else {
            ColorExpression expr;
            Object selectedElement = this.colorExpressionComboBoxPanel.getColorTypeComboBoxesArray()[0].getSelectedItem();
            if (selectedElement instanceof PlaceHolderColorExpression) {
                expr = new PlaceHolderColorExpression();
            } else if (selectedElement instanceof String) {
                expr = new AllExpression(this.colorExpressionComboBoxPanel.getColorType());
            } else if (selectedElement instanceof Variable) {
                Vector<ColorExpression> currentColor = this.getColorOfSelection();
                Set<Variable> currentVariables = this.getVariablesOfSelection();
                expr = currentColor.size() > 0 && currentVariables.contains(selectedElement) ? currentColor.get(0) : new VariableExpression((Variable)selectedElement);
            } else {
                Vector<ColorExpression> currentColor = this.getColorOfSelection();
                expr = currentColor.size() > 0 && currentColor.get(0).toString().contains(selectedElement.toString()) && !(currentColor.get(0) instanceof AllExpression) ? currentColor.get(0) : new UserOperatorExpression((dk.aau.cs.model.CPN.Color)selectedElement);
            }
            exprVec.add(expr);
        }
        return exprVec;
    }

    private void addNumberExpression(int value, Vector<ColorExpression> exprVec) {
        ColorExpression colorExpr;
        Expression current = this.currentSelection.getObject();
        if (current instanceof ArcExpression && exprVec.size() > 0) {
            NumberOfExpression numbExpr = new NumberOfExpression(value, exprVec);
            if (!numbExpr.toString().equals(current.toString()) && this.undoSupport != null) {
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(current, numbExpr);
                this.arcExpression = this.arcExpression.replace(current, numbExpr);
                this.updateSelection(numbExpr);
                this.undoSupport.postEdit(edit);
            }
        } else if (exprVec.size() > 0 && !(colorExpr = exprVec.firstElement()).toString().equals(current.toString())) {
            ExpressionConstructionEdit edit = new ExpressionConstructionEdit(current, colorExpr);
            this.arcExpression = this.arcExpression.replace(current, colorExpr);
            this.updateSelection(colorExpr);
            this.undoSupport.postEdit(edit);
        }
    }

    private Vector<ColorExpression> getColorOfSelection() {
        Vector<ColorExpression> colorExpression = new Vector<ColorExpression>();
        Expression current = this.currentSelection.getObject();
        if (current instanceof NumberOfExpression) {
            return ((NumberOfExpression)current).getColor();
        }
        if (current instanceof SuccessorExpression) {
            colorExpression.add((SuccessorExpression)current);
        } else if (current instanceof PredecessorExpression) {
            colorExpression.add((PredecessorExpression)current);
        }
        return colorExpression;
    }

    private Set<Variable> getVariablesOfSelection() {
        HashSet<Variable> variables = new HashSet<Variable>();
        this.currentSelection.getObject().getVariables(variables);
        return variables;
    }

    private void deleteSelection() {
        if (this.currentSelection != null) {
            PlaceHolderArcExpression replacement = null;
            if (this.currentSelection.getObject() instanceof ArcExpression) {
                replacement = new PlaceHolderArcExpression();
            }
            if (replacement != null) {
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.currentSelection.getObject(), replacement);
                this.arcExpression = this.arcExpression.replace(this.currentSelection.getObject(), replacement);
                this.updateSelection(replacement);
                this.undoSupport.postEdit(edit);
            }
        }
    }

    private ArcExpression getSpecificChildOfProperty(int number, Expression property) {
        ExprStringPosition[] children = property.getChildren();
        int count = 0;
        for (ExprStringPosition exprStringPosition : children) {
            Expression child = exprStringPosition.getObject();
            if (child instanceof ArcExpression) {
                ++count;
            }
            if (count != number) continue;
            return (ArcExpression)child;
        }
        return new PlaceHolderArcExpression();
    }

    public void initColorExpressionButtonsPanel() {
        this.colorExpressionButtons = new JPanel(new GridBagLayout());
        ButtonGroup expressionButtonsGroup = new ButtonGroup();
        this.predButton = new JButton("Add Pred");
        this.succButton = new JButton("Add Succ");
        this.predButton.setPreferredSize(new Dimension(130, 27));
        this.predButton.setMinimumSize(new Dimension(130, 27));
        this.predButton.setMaximumSize(new Dimension(130, 27));
        this.succButton.setPreferredSize(new Dimension(130, 27));
        this.succButton.setMinimumSize(new Dimension(130, 27));
        this.succButton.setMaximumSize(new Dimension(130, 27));
        expressionButtonsGroup.add(this.predButton);
        expressionButtonsGroup.add(this.succButton);
        this.predButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ColorExpression) {
                PredecessorExpression predExpr = new PredecessorExpression((ColorExpression)this.currentSelection.getObject());
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.currentSelection.getObject(), predExpr);
                this.arcExpression = this.arcExpression.replace(this.currentSelection.getObject(), predExpr);
                this.updateSelection(predExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        this.succButton.addActionListener(actionEvent -> {
            if (this.currentSelection.getObject() instanceof ColorExpression) {
                SuccessorExpression succExpr = new SuccessorExpression((ColorExpression)this.currentSelection.getObject());
                ExpressionConstructionEdit edit = new ExpressionConstructionEdit(this.currentSelection.getObject(), succExpr);
                this.arcExpression = this.arcExpression.replace(this.currentSelection.getObject(), succExpr);
                this.updateSelection(succExpr);
                this.undoSupport.postEdit(edit);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.colorExpressionButtons.add((Component)this.predButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.colorExpressionButtons.add((Component)this.succButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        this.numberExprPanel.add((Component)this.colorExpressionButtons, gbc);
    }

    private void initExpr() {
        ArcExpression expression;
        this.arcExpression = new PlaceHolderArcExpression();
        if (!this.isTransportArc) {
            expression = this.isInputArc && !this.isInhibitorArc ? ((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc().getArcExpression() : (this.isInhibitorArc ? ((TimedInhibitorArcComponent)this.objectToBeEdited).underlyingTimedInhibitorArc().getArcExpression() : ((TimedOutputArcComponent)this.objectToBeEdited).underlyingArc().getExpression());
        } else {
            TransportArc transportArc = ((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc();
            expression = this.isInputArc ? transportArc.getInputExpression() : transportArc.getOutputExpression();
        }
        if (expression != null) {
            this.arcExpression = expression.deepCopy();
        }
        this.exprField.setText(this.arcExpression.toString());
        this.updateSelection(this.arcExpression);
    }

    private void updateSelection() {
        int index = this.exprField.getCaretPosition();
        ExprStringPosition position = this.arcExpression.objectAt(index);
        this.exprField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.updateSelectedColorType();
        this.updateNumberExpressionsPanel(this.currentSelection.getObject());
        this.toggleEnabledButtons();
    }

    private void updateSelection(Expression newSelection) {
        this.exprField.setText(this.arcExpression.toString());
        ExprStringPosition position = this.arcExpression.indexOf(newSelection);
        this.exprField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.updateSelectedColorType();
        this.updateNumberExpressionsPanel(this.currentSelection.getObject());
        this.toggleEnabledButtons();
    }

    private Expression findParent(Expression child, Expression parent) {
        for (ExprStringPosition childCheck : parent.getChildren()) {
            Expression foundParent;
            if (child == childCheck.getObject()) {
                return parent;
            }
            if (childCheck.getObject() instanceof PlaceHolderExpression || (foundParent = this.findParent(child, childCheck.getObject())) == child) continue;
            return foundParent;
        }
        return child;
    }

    private void updateSelectedColorType() {
        ColorType newSelectedColorType = this.getCurrentSelectionColorType();
        this.selectedColorType = newSelectedColorType != null ? newSelectedColorType : this.colorType;
    }

    private void updateNumberExpressionsPanel(Expression current) {
        this.colorExpressionComboBoxPanel.updateColorType(this.selectedColorType, this.context, true, false);
        this.numberExpressionJSpinner.setVisible(!(current instanceof ColorExpression));
        this.updatingSelection = true;
        if (current instanceof NumberOfExpression) {
            NumberOfExpression numberOfExpression = (NumberOfExpression)current;
            this.numberExpressionJSpinner.setValue(numberOfExpression.getNumber());
            ColorExpression colorExpression = numberOfExpression.getNumberOfExpression().get(0).getBottomColorExpression();
            this.colorExpressionComboBoxPanel.updateSelection(colorExpression);
        } else if (current instanceof ColorExpression) {
            this.colorExpressionComboBoxPanel.updateSelection(((ColorExpression)current).getBottomColorExpression());
        } else if (current instanceof ArcExpression && !(current instanceof PlaceHolderArcExpression)) {
            this.updateNumberExpressionsPanel(this.getSpecificChildOfProperty(1, current));
        }
        this.updatingSelection = false;
    }

    private void toggleEnabledButtons() {
        if (this.currentSelection == null) {
            this.allExpressionButton.setEnabled(false);
            this.numberExpressionJSpinner.setEnabled(false);
            this.colorExpressionComboBoxPanel.setEnabled(false);
            this.additionButton.setEnabled(false);
            this.subtractionButton.setEnabled(false);
            this.scalarButton.setEnabled(false);
            this.succButton.setEnabled(false);
            this.predButton.setEnabled(false);
        }
        if (this.currentSelection.getObject() instanceof ColorExpression) {
            this.numberExpressionJSpinner.setEnabled(true);
            this.colorExpressionComboBoxPanel.setEnabled(true);
            this.additionButton.setEnabled(false);
            this.subtractionButton.setEnabled(false);
            this.scalarButton.setEnabled(false);
            this.succButton.setEnabled(true);
            this.predButton.setEnabled(true);
        } else if (this.currentSelection.getObject() instanceof ArcExpression) {
            this.numberExpressionJSpinner.setEnabled(true);
            this.colorExpressionComboBoxPanel.setEnabled(true);
            if (!this.isTransportArc) {
                this.additionButton.setEnabled(true);
                this.subtractionButton.setEnabled(true);
                this.scalarButton.setEnabled(true);
            }
            this.succButton.setEnabled(false);
            this.predButton.setEnabled(false);
        }
        if (this.arcExpression.containsPlaceHolder()) {
            this.disableOkButton();
        } else {
            this.enableOkButton();
        }
    }

    public void onOkColored(UndoManager undoManager) {
        if (this.isTransportArc) {
            TransportArc transportArc = ((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc();
            if (this.isInputArc) {
                ArcExpression inputExpression = this.arcExpression;
                ArcExpression outputExpression = transportArc.getOutputExpression().deepCopy();
                ((NumberOfExpression)outputExpression).setNumber(((NumberOfExpression)this.arcExpression).getNumber());
                SetTransportArcExpressionsCommand expressionsCommand = new SetTransportArcExpressionsCommand((TimedTransportArcComponent)this.objectToBeEdited, transportArc.getInputExpression(), inputExpression, transportArc.getOutputExpression(), outputExpression);
                expressionsCommand.redo();
                undoManager.addEdit(expressionsCommand);
                SetColoredArcIntervalsCommand cmd = new SetColoredArcIntervalsCommand((TimedTransportArcComponent)this.objectToBeEdited, ((TimedTransportArcComponent)this.objectToBeEdited).getCtiList(), this.getctiList());
                cmd.redo();
                undoManager.addEdit(cmd);
            } else {
                ArcExpression outputExpression = this.arcExpression;
                ArcExpression inputExpression = transportArc.getInputExpression().deepCopy();
                ((NumberOfExpression)inputExpression).setNumber(((NumberOfExpression)this.arcExpression).getNumber());
                SetTransportArcExpressionsCommand expressionsCommand = new SetTransportArcExpressionsCommand((TimedTransportArcComponent)this.objectToBeEdited, transportArc.getInputExpression(), inputExpression, transportArc.getOutputExpression(), outputExpression);
                expressionsCommand.redo();
                undoManager.addEdit(expressionsCommand);
            }
        } else if (!this.isInhibitorArc && this.isInputArc) {
            TimedInputArc inputArc = ((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc();
            Command cmd = new SetArcExpressionCommand((TimedInputArcComponent)this.objectToBeEdited, inputArc.getArcExpression(), this.arcExpression);
            cmd.redo();
            undoManager.addEdit(cmd);
            cmd = new SetColoredArcIntervalsCommand((TimedInputArcComponent)this.objectToBeEdited, inputArc.getColorTimeIntervals(), this.getctiList());
            cmd.redo();
            undoManager.addEdit(cmd);
        } else if (this.isInhibitorArc) {
            TimedInhibitorArc inhibitorArc = ((TimedInhibitorArcComponent)this.objectToBeEdited).underlyingTimedInhibitorArc();
            SetArcExpressionCommand cmd = new SetArcExpressionCommand((TimedInhibitorArcComponent)this.objectToBeEdited, inhibitorArc.getArcExpression(), this.arcExpression);
            cmd.redo();
            undoManager.addEdit(cmd);
        } else {
            TimedOutputArc outputArc = ((TimedOutputArcComponent)this.objectToBeEdited).underlyingArc();
            SetArcExpressionCommand cmd = new SetArcExpressionCommand((TimedOutputArcComponent)this.objectToBeEdited, outputArc.getExpression(), this.arcExpression);
            cmd.redo();
            undoManager.addEdit(cmd);
        }
    }

    private void setTimeConstraints() {
        List<ColoredTimeInterval> timeIntervals;
        if (this.isInputTransportArc) {
            timeIntervals = ((TimedTransportArcComponent)this.objectToBeEdited).underlyingTransportArc().getColorTimeIntervals();
        } else if (this.isInputArc && !this.isInhibitorArc) {
            timeIntervals = ((TimedInputArcComponent)this.objectToBeEdited).underlyingTimedInputArc().getColorTimeIntervals();
        } else {
            return;
        }
        for (ColoredTimeInterval timeInterval : timeIntervals) {
            this.timeConstraintListModel.addElement(timeInterval);
        }
    }

    public DefaultListModel getTimeConstraintModel() {
        return this.timeConstraintListModel;
    }

    private List<ColoredTimeInterval> getctiList() {
        ArrayList<ColoredTimeInterval> ctiList = new ArrayList<ColoredTimeInterval>();
        for (int i = 0; i < this.getTimeConstraintModel().size(); ++i) {
            ctiList.add((ColoredTimeInterval)this.getTimeConstraintModel().get(i));
        }
        return ctiList;
    }

    private ColorType getCurrentSelectionColorType() {
        if (this.currentSelection.getObject() instanceof ColorExpression) {
            ColorExpression current = (ColorExpression)this.currentSelection.getObject();
            ColorType ct = current.getColorType();
            if (ct != null) {
                return ct;
            }
            if (current instanceof TupleExpression) {
                return ((TupleExpression)this.currentSelection.getObject()).getColorType(this.context.network().colorTypes());
            }
            if (current.getParent() instanceof TupleExpression) {
                ExprStringPosition[] children = current.getParent().getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!((ColorExpression)children[i].getObject()).getBottomColorExpression().equals(current.getBottomColorExpression())) continue;
                    return this.colorType.getProductColorTypes().get(i);
                }
            }
        }
        return null;
    }

    private void returnFromManualEdit(ArcExpression newExpr) {
        this.setExprFieldEditable(false);
        this.deleteExprSelectionButton.setEnabled(true);
        if (newExpr != null) {
            this.arcExpression = newExpr;
        }
        this.updateSelection(this.arcExpression);
        this.resetExprButton.setText("Reset Expression");
        this.editExprButton.setText("Edit Expression");
        this.toggleEnabledButtons();
    }

    private void changeToEditMode() {
        this.setExprFieldEditable(true);
        this.deleteExprSelectionButton.setEnabled(false);
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.additionButton.setEnabled(false);
        this.numberExpressionJSpinner.setEnabled(false);
        this.colorExpressionComboBoxPanel.setEnabled(false);
        this.subtractionButton.setEnabled(false);
        this.scalarButton.setEnabled(false);
        this.succButton.setEnabled(false);
        this.predButton.setEnabled(false);
        this.succButton.setEnabled(false);
        this.predButton.setEnabled(false);
        this.resetExprButton.setText("Parse Expression");
        this.editExprButton.setText("Cancel");
        this.clearSelection();
        this.exprField.setCaretPosition(this.exprField.getText().length());
    }

    private void setExprFieldEditable(boolean isEditable) {
        this.exprField.setEditable(isEditable);
        this.exprField.setFocusable(false);
        this.exprField.setFocusable(true);
        this.exprField.requestFocus(true);
    }

    private void clearSelection() {
        this.exprField.select(0, 0);
        this.currentSelection = null;
    }

    public abstract void disableOkButton();

    public abstract void enableOkButton();

    private void refreshUndoRedo() {
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    private void makeShortcuts() {
        int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ActionMap am = this.getActionMap();
        am.put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredArcGuardPanel.this.undoButton.doClick();
            }
        });
        am.put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColoredArcGuardPanel.this.redoButton.doClick();
            }
        });
        InputMap im = this.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(90, shortcutkey), "undo");
        im.put(KeyStroke.getKeyStroke(89, shortcutkey), "redo");
    }

    private static class ExpressionConstructionUndoManager
    extends javax.swing.undo.UndoManager {
        private ExpressionConstructionUndoManager() {
        }

        public UndoableEdit GetNextEditToUndo() {
            return this.editToBeUndone();
        }

        public UndoableEdit GetNextEditToRedo() {
            return this.editToBeRedone();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent arg0) {
            UndoableEdit edit = arg0.getEdit();
            ColoredArcGuardPanel.this.undoManager.addEdit(edit);
            ColoredArcGuardPanel.this.refreshUndoRedo();
        }
    }

    public class ExpressionConstructionEdit
    extends AbstractUndoableEdit {
        private final Expression original;
        private final Expression replacement;

        public Expression getOriginal() {
            return this.original;
        }

        public Expression getReplacement() {
            return this.replacement;
        }

        public ExpressionConstructionEdit(Expression original, Expression replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        @Override
        public void undo() throws CannotUndoException {
            ColoredArcGuardPanel.this.arcExpression = ColoredArcGuardPanel.this.arcExpression.replace(this.replacement, this.original);
        }

        @Override
        public void redo() throws CannotRedoException {
            ColoredArcGuardPanel.this.arcExpression = ColoredArcGuardPanel.this.arcExpression.replace(this.original, this.replacement);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }
    }
}

