/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.PlaceHolderColorExpression;
import dk.aau.cs.model.CPN.Expressions.PredecessorExpression;
import dk.aau.cs.model.CPN.Expressions.SuccessorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Expressions.VariableExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.ColorComboBoxRenderer;

public abstract class ColorComboboxPanel
extends JPanel {
    private ColorType colorType;
    private JPanel colorcomboBoxPanel;
    private JComboBox[] colorTypeComboBoxesArray;
    JScrollPane colorTypesScrollPane;
    JPanel comboBoxPanel;
    final boolean showAllElement;

    public ColorComboboxPanel(ColorType colorType) {
        this(colorType, false);
    }

    public ColorComboboxPanel(ColorType colorType, boolean showAllElement) {
        this.colorType = colorType;
        this.showAllElement = showAllElement;
        this.setLayout(new BorderLayout());
        this.initPanel();
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public JComboBox[] getColorTypeComboBoxesArray() {
        return this.colorTypeComboBoxesArray;
    }

    private void initPanel() {
        this.colorcomboBoxPanel = new JPanel();
        this.colorcomboBoxPanel.setLayout(new GridBagLayout());
        this.comboBoxPanel = new JPanel(new GridBagLayout());
        this.colorTypesScrollPane = new JScrollPane(this.comboBoxPanel);
        this.colorTypesScrollPane.setViewportView(this.comboBoxPanel);
        this.colorTypesScrollPane.setVerticalScrollBarPolicy(20);
        this.colorTypesScrollPane.setBorder(BorderFactory.createTitledBorder("Color Type elements"));
        this.updateColorType(this.colorType);
        this.add((Component)this.colorTypesScrollPane, "Center");
    }

    public void removeScrollPaneBorder() {
        this.colorTypesScrollPane.setBorder(null);
    }

    public abstract void changedColor(JComboBox[] var1);

    public void updateSelection(Color color) {
        if (this.colorType instanceof ProductType) {
            int i = 0;
            for (Color element : color.getTuple()) {
                this.colorTypeComboBoxesArray[i].setSelectedItem(element);
                ++i;
            }
        } else if (this.colorType != null) {
            this.colorTypeComboBoxesArray[0].setSelectedItem(color);
        }
    }

    public void updateSelection(ColorExpression expr) {
        if (expr instanceof TupleExpression) {
            int i = 0;
            for (ColorExpression c : ((TupleExpression)expr).getColors()) {
                this.setIndex(c, i);
                ++i;
            }
        } else {
            this.setIndex(expr, 0);
        }
    }

    private void setIndex(ColorExpression expr, int index) {
        if (expr instanceof AllExpression) {
            this.colorTypeComboBoxesArray[index].setSelectedIndex(this.colorTypeComboBoxesArray[index].getItemCount() - 1);
        } else if (expr instanceof VariableExpression) {
            this.colorTypeComboBoxesArray[index].setSelectedItem(((VariableExpression)expr).getVariable());
        } else if (expr instanceof UserOperatorExpression) {
            this.colorTypeComboBoxesArray[index].setSelectedItem(((UserOperatorExpression)expr).getUserOperator());
        } else if (expr instanceof TupleExpression) {
            this.colorTypeComboBoxesArray[index].setSelectedItem(((TupleExpression)expr).getColors().get(0));
        } else if (expr instanceof PredecessorExpression) {
            this.setIndex(((PredecessorExpression)expr).getPredecessorExpression(), index);
        } else if (expr instanceof SuccessorExpression) {
            this.setIndex(((SuccessorExpression)expr).getSuccessorExpression(), index);
        } else {
            this.colorTypeComboBoxesArray[index].setSelectedItem(expr);
        }
    }

    public void updateColorType(ColorType ct) {
        this.updateColorType(ct, null, false, false);
    }

    public void updateColorType(ColorType ct, Context context, boolean includePlaceHolder, boolean transitionDialog) {
        this.removeOldComboBoxes();
        this.colorType = ct;
        if (this.colorType instanceof ProductType) {
            int numberOfComBoboxes = transitionDialog ? 1 : ((ProductType)this.colorType).getColorTypes().size();
            this.colorTypeComboBoxesArray = new JComboBox[numberOfComBoboxes];
            int i = 0;
            while (i < this.colorTypeComboBoxesArray.length) {
                JComboBox currentComboBox;
                this.colorTypeComboBoxesArray[i] = currentComboBox = this.createColoredCombobox(context, ((ProductType)this.colorType).getColorTypes().get(i), includePlaceHolder);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i++;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(0, 0, 5, 0);
                this.comboBoxPanel.add((Component)currentComboBox, gbc);
            }
        } else if (this.colorType != null) {
            JComboBox currentComboBox;
            this.colorTypeComboBoxesArray = new JComboBox[1];
            this.colorTypeComboBoxesArray[0] = currentComboBox = this.createColoredCombobox(context, ct, includePlaceHolder);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.comboBoxPanel.add((Component)currentComboBox, gbc);
        }
        this.revalidate();
    }

    private JComboBox createColoredCombobox(Context context, ColorType ct, boolean includePlaceHolder) {
        JComboBox<Object> combobox = new JComboBox<Object>();
        combobox.setRenderer(new ColorComboBoxRenderer(combobox, 2));
        combobox.setPreferredSize(new Dimension(200, 25));
        combobox.setMaximumRowCount(20);
        if (includePlaceHolder) {
            combobox.addItem(new PlaceHolderColorExpression());
            combobox.addItem(new JSeparator());
        }
        if (context != null) {
            boolean variableFound = false;
            for (Variable variable : context.network().variables()) {
                if (!variable.getColorType().getName().equals(ct.getName())) continue;
                combobox.addItem(variable);
                variableFound = true;
            }
            if (variableFound) {
                combobox.addItem(new JSeparator());
            }
        }
        for (Color element : ct) {
            if (combobox.getSelectedItem() instanceof JSeparator) {
                combobox.setSelectedIndex(combobox.getSelectedIndex() + 1);
            }
            combobox.addItem(element);
        }
        if (this.showAllElement) {
            combobox.addItem(new JSeparator());
            combobox.addItem("<html><b>.all</b>");
        }
        combobox.addActionListener(e -> {
            if (combobox.getSelectedItem() instanceof JSeparator) {
                combobox.setSelectedIndex(combobox.getSelectedIndex() + 1);
            }
            this.changedColor(this.colorTypeComboBoxesArray);
        });
        ((JLabel)((Object)combobox.getRenderer())).setHorizontalAlignment(0);
        return combobox;
    }

    private void removeOldComboBoxes() {
        this.comboBoxPanel.removeAll();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.colorcomboBoxPanel.setEnabled(enabled);
        if (this.colorTypeComboBoxesArray != null) {
            for (JComboBox combobox : this.colorTypeComboBoxesArray) {
                combobox.setEnabled(enabled);
            }
        }
    }
}

